/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer;

import frost.Core;
import frost.DateFun;
import frost.FileAccess;
import frost.MainFrame;
import frost.Mixed;
import frost.fcp.FcpRequest;
import frost.fileTransfer.upload.FrostUploadItem;
import frost.fileTransfer.upload.UploadModel;
import frost.identities.FrostIdentities;
import java.io.File;
import java.util.ConcurrentModificationException;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GetRequestsThread
extends Thread {
    private UploadModel model;
    private FrostIdentities identities;
    static ResourceBundle LangRes = ResourceBundle.getBundle("res.LangRes");
    private static Logger logger = Logger.getLogger(GetRequestsThread.class.getName());
    private int downloadHtl;
    private String keypool;
    private String destination;
    private String fileSeparator = System.getProperty("file.separator");
    private String date;

    public void run() {
        if (DateFun.getDate().compareTo(this.date) != 0) {
            GetRequestsThread getRequestsThread = new GetRequestsThread(this.downloadHtl, this.keypool, this.model, DateFun.getDate(), this.identities);
            getRequestsThread.start();
            try {
                getRequestsThread.join();
            }
            catch (InterruptedException interruptedException) {
                logger.log(Level.SEVERE, "Exception thrown in run()", interruptedException);
            }
        }
        try {
            int n = (int)(Math.random() * 5000.0);
            Mixed.wait(n);
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeZone(TimeZone.getTimeZone("GMT"));
            String string = this.date;
            this.destination = new StringBuffer().append("requests").append(this.fileSeparator).append(Mixed.makeFilename(this.identities.getMyId().getUniqueName())).toString();
            File file = new File(this.destination);
            if (!file.exists()) {
                logger.info(Thread.currentThread().getName() + ": Creating directory: " + this.destination);
                file.mkdirs();
            }
            if (this.isInterrupted()) {
                return;
            }
            Mixed.wait(60000);
            boolean bl = true;
            block6: while (true) {
                string = this.date;
                if (bl) {
                    bl = false;
                } else {
                    Mixed.wait(900000);
                }
                if (Core.getMyBatches().isEmpty()) continue;
                try {
                    Iterator iterator = Core.getMyBatches().keySet().iterator();
                    block7: while (true) {
                        if (!iterator.hasNext()) continue block6;
                        String string2 = (String)iterator.next();
                        int n2 = 0;
                        int n3 = 0;
                        int n4 = 3;
                        while (true) {
                            if (n3 >= n4) continue block7;
                            String string3 = new StringBuffer().append(this.destination).append(this.fileSeparator).append(string2.trim()).append("-").append(string).append("-").append(n2).append(".req.sha").toString();
                            File file2 = new File(string3);
                            boolean bl2 = false;
                            if (file2.length() > 0L) {
                                ++n2;
                                n3 = 0;
                                continue;
                            }
                            String string4 = new StringBuffer().append("GetRequestsThread.run, file = ").append(file2.getName()).append(", failures = ").append(n3).toString();
                            logger.fine(string4);
                            FcpRequest.getFile("KSK@frost/request/" + MainFrame.frostSettings.getValue("messageBase") + "/" + Mixed.makeFilename(this.identities.getMyId().getUniqueName()) + "-" + file2.getName(), null, file2, this.downloadHtl, false);
                            bl2 = true;
                            if (file2.length() > 0L) {
                                logger.fine(Thread.currentThread().getName() + " Received request " + file2.getName());
                                string4 = FileAccess.readFile(file2).trim();
                                logger.fine("Request content is " + string4);
                                int n5 = this.model.getItemCount();
                                for (int i = 0; i < n5; ++i) {
                                    FrostUploadItem frostUploadItem = (FrostUploadItem)this.model.getItemAt(i);
                                    String string5 = frostUploadItem.getSHA1();
                                    if (string5 == null || !(string5 = string5.trim()).equals(string4)) continue;
                                    logger.fine("content matched!");
                                    File file3 = new File(this.destination + string5 + ".lck");
                                    if (!file3.exists()) {
                                        if (frostUploadItem.getState() != 3 && frostUploadItem.getState() != 4) {
                                            logger.fine("Request matches row " + i);
                                            if (frostUploadItem.getState() == 6) {
                                                frostUploadItem.setNextState(2);
                                                continue;
                                            }
                                            frostUploadItem.setState(2);
                                            continue;
                                        }
                                        logger.fine("file was in state uploading/progress");
                                        continue;
                                    }
                                    logger.info("File with hash " + string5 + " was requested, but already uploaded today");
                                }
                                ++n2;
                                n3 = 0;
                            } else {
                                ++n2;
                                ++n3;
                            }
                            if (this.isInterrupted()) break;
                        }
                    }
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, Thread.currentThread().getName() + ": Oo. EXCEPTION in GetRequestsThread:", throwable);
            return;
        }
    }

    public GetRequestsThread(int n, String string, UploadModel uploadModel, FrostIdentities frostIdentities) {
        this(n, string, uploadModel, DateFun.getDate(1), frostIdentities);
    }

    public GetRequestsThread(int n, String string, UploadModel uploadModel, String string2, FrostIdentities frostIdentities) {
        this.downloadHtl = n;
        this.keypool = string;
        this.model = uploadModel;
        this.date = string2;
        this.identities = frostIdentities;
    }
}

