/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer;

import frost.MainFrame;
import frost.SettingsClass;
import frost.boards.TofTreeModel;
import frost.fileTransfer.GetRequestsThread;
import frost.fileTransfer.Index;
import frost.fileTransfer.download.DownloadManager;
import frost.fileTransfer.search.SearchManager;
import frost.fileTransfer.upload.UploadManager;
import frost.identities.FrostIdentities;
import frost.storage.Savable;
import frost.storage.StorageException;

public class FileTransferManager
implements Savable {
    private SettingsClass settings;
    private MainFrame mainFrame;
    private TofTreeModel tofTreeModel;
    private boolean isOnline;
    private FrostIdentities identities;
    private String keypool;
    private DownloadManager downloadManager;
    private SearchManager searchManager;
    private UploadManager uploadManager;

    public FileTransferManager(SettingsClass settingsClass) {
        this.settings = settingsClass;
    }

    public void initialize() throws StorageException {
        this.getDownloadManager().initialize();
        this.getSearchManager().initialize();
        this.getUploadManager().initialize();
        Index.initialize(this.getDownloadManager().getModel());
        this.mainFrame.setDownloadModel(this.getDownloadManager().getModel());
        this.mainFrame.setUploadPanel(this.getUploadManager().getPanel());
        GetRequestsThread getRequestsThread = new GetRequestsThread(this.settings.getIntValue("tofDownloadHtl"), this.settings.getValue("keypool.dir"), this.getUploadManager().getModel(), this.identities);
        getRequestsThread.start();
    }

    public void setMainFrame(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public void setTofTreeModel(TofTreeModel tofTreeModel) {
        this.tofTreeModel = tofTreeModel;
    }

    public void setFreenetIsOnline(boolean bl) {
        this.isOnline = bl;
    }

    public void setIdentities(FrostIdentities frostIdentities) {
        this.identities = frostIdentities;
    }

    public void setKeypool(String string) {
        this.keypool = string;
    }

    private DownloadManager getDownloadManager() {
        if (this.downloadManager == null) {
            this.downloadManager = new DownloadManager(this.settings);
            this.downloadManager.setMainFrame(this.mainFrame);
            this.downloadManager.setFreenetIsOnline(this.isOnline);
        }
        return this.downloadManager;
    }

    private SearchManager getSearchManager() {
        if (this.searchManager == null) {
            this.searchManager = new SearchManager(this.settings);
            this.searchManager.setMainFrame(this.mainFrame);
            this.searchManager.setDownloadModel(this.getDownloadManager().getModel());
            this.searchManager.setUploadModel(this.getUploadManager().getModel());
            this.searchManager.setTofTreeModel(this.tofTreeModel);
            this.searchManager.setKeypool(this.keypool);
            this.searchManager.setIdentities(this.identities);
        }
        return this.searchManager;
    }

    private UploadManager getUploadManager() {
        if (this.uploadManager == null) {
            this.uploadManager = new UploadManager(this.settings);
            this.uploadManager.setMainFrame(this.mainFrame);
            this.uploadManager.setTofTreeModel(this.tofTreeModel);
            this.uploadManager.setFreenetIsOnline(this.isOnline);
            this.uploadManager.setMyID(this.identities.getMyId());
        }
        return this.uploadManager;
    }

    public void save() throws StorageException {
        this.getDownloadManager().getModel().save();
        this.getUploadManager().getModel().save();
    }
}

