/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp;

import frost.Core;
import frost.fcp.FcpConnection;
import frost.fcp.FcpToolsException;
import frost.fcp.NodeManager;
import java.io.IOException;
import java.util.logging.Logger;

public abstract class MultipleNodeManager
implements NodeManager {
    private static Logger logger = Logger.getLogger(MultipleNodeManager.class.getName());

    protected abstract String selectNode();

    protected abstract void delegateRemove(String var1);

    public synchronized FcpConnection getConnection() throws IOException, FcpToolsException {
        FcpConnection fcpConnection = null;
        if (Core.getNodes().size() == 0) {
            throw new Error("No Freenet nodes available.  You need at least one");
        }
        String string = Core.getNodes().size() == 1 ? (String)Core.getNodes().iterator().next() : this.selectNode();
        String[] stringArray = string.split(":");
        logger.info("using node " + stringArray[0].trim() + " port " + stringArray[1].trim());
        try {
            fcpConnection = new FcpConnection(stringArray[0].trim(), stringArray[1].trim());
        }
        catch (IOException iOException) {
            this.delegateRemove(string);
            throw iOException;
        }
        catch (FcpToolsException fcpToolsException) {
            this.delegateRemove(string);
            throw fcpToolsException;
        }
        return fcpConnection;
    }
}

