/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp;

import freenet.client.ClientCHK;
import freenet.support.ArrayBucket;
import freenet.support.Bucket;
import freenet.support.FileBucket;
import frost.fcp.FecBlock;
import frost.fcp.FecSplitfile;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FecTools {
    private static Logger logger = Logger.getLogger(FecTools.class.getName());

    public static String generateCHK(File file) {
        return FecTools.generateCHK(file, 0L);
    }

    public static String generateCHK(File file, long l) {
        if (file == null || !file.exists() || file.length() == 0L) {
            return null;
        }
        FileBucket fileBucket = new FileBucket(file);
        return FecTools.generateCHK(fileBucket, l);
    }

    public static String generateCHK(byte[] byArray) {
        return FecTools.generateCHK(byArray, 0L);
    }

    public static String generateCHK(byte[] byArray, long l) {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        ArrayBucket arrayBucket = new ArrayBucket(byArray);
        return FecTools.generateCHK(arrayBucket, l);
    }

    public static String generateCHK(Bucket bucket) {
        return FecTools.generateCHK(bucket, 0L);
    }

    public static String generateCHK(Bucket bucket, long l) {
        if (bucket == null || bucket.size() <= 0L) {
            return null;
        }
        try {
            long l2 = bucket.size();
            ClientCHK clientCHK = new ClientCHK();
            byte[] byArray = new byte[(int)clientCHK.getTotalLength(l2)];
            ArrayBucket arrayBucket = new ArrayBucket(byArray);
            String string = null;
            clientCHK.encode(bucket, l, (Bucket)arrayBucket).close();
            string = clientCHK.getURI().toString();
            return string;
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "Exception in FecTools.generateCHK()", throwable);
            return null;
        }
    }

    public static FecSplitfile prepareFECSplitfile(File file) throws Throwable {
        FecBlock fecBlock;
        if (file == null || !file.isFile() || file.length() == 0L) {
            return null;
        }
        FecSplitfile fecSplitfile = new FecSplitfile(file);
        try {
            fecSplitfile.encode();
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "Error while encoding FEC splitfile", throwable);
            return null;
        }
        List list = fecSplitfile.getDataBlocks();
        List list2 = fecSplitfile.getCheckBlocks();
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            fecBlock = (FecBlock)iterator.next();
            logger.finer("data_" + n + ": '" + fecBlock.getChkKey() + "'");
            ++n;
        }
        iterator = list2.iterator();
        n = 0;
        while (iterator.hasNext()) {
            fecBlock = (FecBlock)iterator.next();
            logger.finer("check_" + n + ": '" + fecBlock.getChkKey() + "'");
            ++n;
        }
        return fecSplitfile;
    }
}

