/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp;

import fecimpl.OnionFECBase;
import fecimpl.OnionFECDecoder;
import fecimpl.OnionFECEncoder;
import freenet.support.Bucket;
import freenet.support.BucketFactory;
import freenet.support.RandomAccessFileBucket;
import freenet.support.RandomAccessFileBucket2;
import frost.FileAccess;
import frost.MainFrame;
import frost.SettingsFun;
import frost.fcp.FecBlock;
import frost.fcp.FecTools;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FecSplitfile {
    public static final int MODE_UPLOAD = 1;
    public static final int MODE_DOWNLOAD = 2;
    public static final int MODE_FINISHED = 3;
    private static final String FROST_TRANSFER_INDICATOR = "namespace.frost.transferInProgress";
    private static final String FROST_TRANSFER_FINISHED_INDICATOR = "namespace.frost.transferFinished.";
    private static Logger logger = Logger.getLogger(FecSplitfile.class.getName());
    protected int transferMode;
    protected ArrayList segmentValues;
    protected File dataFile;
    protected long dataFileSize;
    protected File checkBlocksFile;
    protected long checkBlocksFileSize;
    protected File redirectFile;
    protected int fileDataBlockCount;
    protected int fileCheckBlockCount;
    protected File downloadTargetFile;
    protected OnionFECEncoder encoder = null;
    protected FrostFECEncodeBucketFactory fecEncodeFactory = null;
    protected OnionFECDecoder decoder = null;
    protected FrostFECDecodeBucketFactory fecDecodeFactory = null;
    protected ArrayList dataBlocks;
    protected ArrayList checkBlocks;

    public FecSplitfile(File file, File file2) throws IllegalStateException, Exception {
        this.transferMode = 2;
        this.downloadTargetFile = file;
        this.dataFile = new File(this.downloadTargetFile.getPath() + ".data");
        this.redirectFile = file2;
        this.checkBlocksFile = new File(this.downloadTargetFile.getPath() + ".checkblocks");
        this.initFromRedirectFile();
    }

    public FecSplitfile(File file) {
        int n;
        this.transferMode = 1;
        this.dataFile = file;
        this.dataFileSize = file.length();
        this.encoder = new OnionFECEncoder();
        this.fecEncodeFactory = new FrostFECEncodeBucketFactory();
        this.encoder.init(this.dataFileSize, this.fecEncodeFactory);
        this.fillSegmentValues(this.encoder);
        String string = file.getPath();
        if (System.getProperty("os.name").startsWith("Windows") && (n = string.indexOf(":")) > -1) {
            String string2;
            string = string2 = string.substring(0, n) + string.substring(n + 1);
        }
        string = string.replace(System.getProperty("file.separator").charAt(0), '_');
        string = MainFrame.frostSettings.getValue("keypool.dir") + "_" + string;
        logger.fine("DBG-ULFILENAME=" + string);
        this.checkBlocksFile = new File(string + ".checkblocks");
        this.redirectFile = new File(string + ".redirect");
    }

    protected void initFromRedirectFile() throws IllegalStateException, Exception {
        String string;
        String string2;
        int n;
        Object object;
        long l;
        int n2;
        int n3;
        Vector vector = FileAccess.readLines(this.redirectFile);
        if (vector.size() == 0) {
            throw new IllegalStateException("Empty redirect file");
        }
        String string3 = SettingsFun.getValue(vector, "SplitFile.BlockCount");
        String string4 = SettingsFun.getValue(vector, "SplitFile.CheckBlockCount");
        String string5 = SettingsFun.getValue(vector, "SplitFile.Size");
        try {
            n3 = Integer.parseInt(string3, 16);
            n2 = Integer.parseInt(string4, 16);
            l = Long.parseLong(string5, 16);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "ERROR: One of the following 3 values is invalid in received redirect file:\n(SplitFile.BlockCount='" + string3 + "')\n" + "(SplitFile.CheckBlockCount='" + string4 + "')\n" + "(SplitFile.Size='" + string5 + "')", exception);
            throw new IllegalStateException("Could not parse block count from redirect file: " + exception.getMessage());
        }
        if (n3 == 0 || l == 0L) {
            throw new IllegalStateException("Invalid data block count of 0");
        }
        if (this.transferMode == 2) {
            this.dataFileSize = l;
            this.decoder = new OnionFECDecoder();
            this.fecDecodeFactory = new FrostFECDecodeBucketFactory();
            this.decoder.init(this.dataFileSize, this.fecDecodeFactory);
            this.fillSegmentValues(this.decoder);
        } else if (this.transferMode == 1) {
            this.encoder = new OnionFECEncoder();
            this.fecEncodeFactory = new FrostFECEncodeBucketFactory();
            this.encoder.init(this.dataFileSize, this.fecEncodeFactory);
            this.fillSegmentValues(this.encoder);
        } else {
            throw new IllegalStateException("transferMode is invalid");
        }
        if (this.fileDataBlockCount != n3 || this.fileCheckBlockCount != n2) {
            throw new IllegalStateException("Block counts from redirect file and from decoder do not match");
        }
        boolean bl = SettingsFun.getValue(vector, FROST_TRANSFER_INDICATOR).toLowerCase().equals("true");
        if (!bl && this.transferMode == 2) {
            int n4;
            long l2 = 0L;
            for (n4 = 0; n4 < this.getSegmentCount(); ++n4) {
                object = this.getValuesForSegment(n4);
                l2 += (long)(((SingleSegmentValues)object).dataBlockCount * ((SingleSegmentValues)object).dataBlockSize);
            }
            logger.info("First time download, create target files");
            if (!this.dataFile.isFile() || this.dataFileSize != l2) {
                this.dataFile.delete();
                n4 = this.createFileOfLength(this.dataFile, l2) ? 1 : 0;
                if (n4 == 0) {
                    throw new Exception("Could not create the data file");
                }
            }
            if (!this.checkBlocksFile.isFile() || this.checkBlocksFileSize != this.checkBlocksFile.length()) {
                this.checkBlocksFile.delete();
                n4 = this.createFileOfLength(this.checkBlocksFile, this.checkBlocksFileSize) ? 1 : 0;
                if (n4 == 0) {
                    throw new Exception("Could not create the checkblocks file");
                }
            }
        }
        logger.info("Reading CHK keys from redirect file");
        this.buildFecBlocks(false);
        for (n = 0; n < this.fileDataBlockCount; ++n) {
            string2 = "SplitFile.Block." + Integer.toHexString(n + 1);
            String string6 = SettingsFun.getValue(vector, string2);
            if (string6 == null) {
                throw new IllegalStateException("Redirect file contains an invalid CHK for a data block");
            }
            object = (FecBlock)this.dataBlocks.get(n);
            if (object == null || ((FecBlock)object).getIndexInFile() != n) {
                throw new IllegalStateException("Could not find the data block");
            }
            if (string6.length() < 58) {
                ((FecBlock)object).setCurrentState(4);
                if (string6.indexOf("Error") < 0) {
                    logger.warning("Warning: Found invalid key in redirect file: " + string6);
                }
                string6 = null;
            } else if (bl && (string = SettingsFun.getValue(vector, FROST_TRANSFER_FINISHED_INDICATOR + string2)) != null && string.toLowerCase().equals("true")) {
                ((FecBlock)object).setCurrentState(3);
            }
            ((FecBlock)object).setChkKey(string6);
        }
        for (n = 0; n < this.fileCheckBlockCount; ++n) {
            string2 = "SplitFile.CheckBlock." + Integer.toHexString(n + 1);
            String string7 = SettingsFun.getValue(vector, string2);
            if (string7 == null) {
                throw new IllegalStateException("Redirect file contains an invalid CHK for a check block");
            }
            object = (FecBlock)this.checkBlocks.get(n);
            if (object == null || ((FecBlock)object).getIndexInFile() != n) {
                throw new IllegalStateException("Could not find the checkBlock");
            }
            if (string7.length() < 58) {
                ((FecBlock)object).setCurrentState(4);
                if (string7.indexOf("Error") < 0) {
                    logger.warning("Warning: Found invalid key in redirect file: " + string7);
                }
                string7 = null;
            } else if (bl && (string = SettingsFun.getValue(vector, FROST_TRANSFER_FINISHED_INDICATOR + string2)) != null && string.toLowerCase().equals("true")) {
                ((FecBlock)object).setCurrentState(3);
            }
            ((FecBlock)object).setChkKey(string7);
        }
        logger.info("Download prepared");
    }

    public boolean isDecodeable(int n) {
        FecBlock fecBlock;
        int n2;
        SingleSegmentValues singleSegmentValues = (SingleSegmentValues)this.segmentValues.get(n);
        int n3 = singleSegmentValues.dataBlockCount;
        int n4 = 0;
        for (n2 = 0; n2 < this.dataBlocks.size(); ++n2) {
            fecBlock = (FecBlock)this.dataBlocks.get(n2);
            if (fecBlock.getSegmentNo() != n || fecBlock.getCurrentState() != 3) continue;
            ++n4;
        }
        for (n2 = 0; n2 < this.checkBlocks.size(); ++n2) {
            fecBlock = (FecBlock)this.checkBlocks.get(n2);
            if (fecBlock.getSegmentNo() != n || fecBlock.getCurrentState() != 3) continue;
            ++n4;
        }
        return n4 >= n3;
    }

    public void decode(int n) throws Throwable {
        FecBlock fecBlock;
        int n2;
        if (!this.isDecodeable(n)) {
            throw new IllegalStateException("Can't decode the segment, too less blocks provided");
        }
        logger.info("Starting to decode segment " + n);
        SingleSegmentValues singleSegmentValues = (SingleSegmentValues)this.segmentValues.get(n);
        int n3 = singleSegmentValues.dataBlockCount;
        this.decoder.setSegment(n);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<RandomAccessFileBucket> arrayList2 = new ArrayList<RandomAccessFileBucket>();
        for (n2 = 0; n2 < this.dataBlocks.size(); ++n2) {
            fecBlock = (FecBlock)this.dataBlocks.get(n2);
            if (fecBlock.getSegmentNo() != n) continue;
            if (fecBlock.getCurrentState() == 3) {
                this.decoder.putBucket(fecBlock.getRandomAccessFileBucket(true), fecBlock.getIndexInSegment());
                continue;
            }
            arrayList.add(new Integer(fecBlock.getIndexInSegment()));
            arrayList2.add(fecBlock.getRandomAccessFileBucket(false));
        }
        for (n2 = 0; n2 < this.checkBlocks.size(); ++n2) {
            fecBlock = (FecBlock)this.checkBlocks.get(n2);
            if (fecBlock.getSegmentNo() != n || fecBlock.getCurrentState() != 3) continue;
            this.decoder.putBucket(fecBlock.getRandomAccessFileBucket(true), n3 + fecBlock.getIndexInSegment());
        }
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        this.fecDecodeFactory.init(arrayList2);
        Bucket[] bucketArray = new Bucket[nArray.length];
        this.decoder.decode(nArray, bucketArray);
        logger.info("Finished decoding segment " + n);
    }

    public boolean uploadInit() {
        long l;
        Vector vector;
        String string;
        boolean bl = false;
        if (this.redirectFile.isFile() && this.redirectFile.length() > 0L && this.checkBlocksFile.isFile() && this.checkBlocksFile.length() > 0L && (string = SettingsFun.getValue(vector = FileAccess.readLines(this.redirectFile), "SplitFile.Size")).length() > 0 && (l = Long.parseLong(string, 16)) == this.dataFile.length()) {
            bl = true;
            logger.info("Splitfile is already encoded.");
            try {
                this.initFromRedirectFile();
            }
            catch (IllegalStateException illegalStateException) {
                logger.log(Level.SEVERE, "Exception thrown in uploadInit()", illegalStateException);
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "Exception thrown in uploadInit()", exception);
            }
        }
        if (!bl) {
            logger.info("Splitfile needs encoding.");
            this.redirectFile.delete();
            this.checkBlocksFile.delete();
        }
        return bl;
    }

    public void encode() throws Throwable {
        logger.info("Splitfile encode starts ...");
        this.fecEncodeFactory.init(this.checkBlocksFile, this.getCheckBlocksFileSize());
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.dataFile, "r");
        int n = this.getSegmentCount();
        for (int i = 0; i < n; ++i) {
            int n2 = this.getValuesForSegment((int)i).dataBlockCount;
            int n3 = this.getValuesForSegment((int)i).dataBlockSize;
            long l = this.getValuesForSegment((int)i).segmentStartOffset;
            Bucket[] bucketArray = RandomAccessFileBucket2.segment(this.dataFile, n3, l, n2, true, randomAccessFile);
            this.encoder.encode(i, bucketArray, null);
        }
        this.buildFecBlocks(true);
        if (!this.createRedirectFile(true)) {
            String string = "Error: Could not create the redirect file.";
            logger.severe(string);
            throw new Exception(string);
        }
        logger.info("Splitfile encode finished.");
    }

    protected void buildFecBlocks(boolean bl) throws Exception {
        this.dataBlocks = new ArrayList();
        this.checkBlocks = new ArrayList();
        int n = 0;
        int n2 = 0;
        long l = 0L;
        long l2 = 0L;
        int n3 = this.getSegmentCount();
        for (int i = 0; i < n3; ++i) {
            String string;
            Bucket bucket;
            FecBlock fecBlock;
            int n4;
            int n5 = 0;
            int n6 = 0;
            int n7 = this.getValuesForSegment((int)i).dataBlockCount;
            int n8 = this.getValuesForSegment((int)i).dataBlockSize;
            int n9 = this.getValuesForSegment((int)i).checkBlockCount;
            int n10 = this.getValuesForSegment((int)i).checkBlockSize;
            if (bl) {
                logger.info("Creating CHK keys for " + n7 + " blocks...");
            }
            for (n4 = 0; n4 < n7; ++n4) {
                fecBlock = new FecBlock(1, this.dataFile, i, n5, n, n8, l);
                if (bl) {
                    bucket = fecBlock.getPaddedMemoryBucket();
                    string = FecTools.generateCHK(bucket);
                    if (string == null) {
                        String string2 = "ERROR: could NOT generate CHK key of a splitfile data block!!!";
                        logger.severe(string2);
                        throw new Exception(string2);
                    }
                    fecBlock.setChkKey(string);
                }
                l += (long)n8;
                ++n;
                ++n5;
                this.dataBlocks.add(fecBlock);
            }
            if (bl) {
                logger.fine("Creating CHK keys for " + n9 + " check blocks...");
            }
            for (n4 = 0; n4 < n9; ++n4) {
                fecBlock = new FecBlock(2, this.checkBlocksFile, i, n6, n2, n10, l2);
                if (bl) {
                    bucket = fecBlock.getPaddedMemoryBucket();
                    string = FecTools.generateCHK(bucket);
                    if (string == null) {
                        String string3 = "ERROR: could NOT generate CHK key of a splitfile check block!!!";
                        logger.severe(string3);
                        throw new Exception(string3);
                    }
                    fecBlock.setChkKey(string);
                }
                l2 += (long)n10;
                ++n2;
                ++n6;
                this.checkBlocks.add(fecBlock);
            }
        }
    }

    public synchronized boolean createRedirectFile(boolean bl) {
        String string;
        FecBlock fecBlock;
        int n;
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append("Version\n");
        stringBuffer.append("Revision=1\n");
        stringBuffer.append("EndPart\n");
        stringBuffer.append("Document\n");
        if (bl) {
            stringBuffer.append(FROST_TRANSFER_INDICATOR).append("=true\n");
        }
        stringBuffer.append("SplitFile.AlgoName=OnionFEC_a_1_2\n");
        stringBuffer.append("SplitFile.Size=").append(Long.toHexString(this.dataFileSize).toLowerCase()).append("\n");
        stringBuffer.append("SplitFile.BlockCount=").append(Integer.toHexString(this.dataBlocks.size())).append("\n");
        for (n = 0; n < this.dataBlocks.size(); ++n) {
            fecBlock = (FecBlock)this.dataBlocks.get(n);
            string = fecBlock.getChkKey();
            if (string == null) {
                string = "Error";
            }
            stringBuffer.append("SplitFile.Block.").append(Integer.toHexString(n + 1)).append("=").append(string).append("\n");
            if (!bl || fecBlock.getCurrentState() != 3) continue;
            stringBuffer.append(FROST_TRANSFER_FINISHED_INDICATOR).append("SplitFile.Block.").append(Integer.toHexString(n + 1)).append("=true\n");
        }
        stringBuffer.append("SplitFile.CheckBlockCount=").append(Integer.toHexString(this.checkBlocks.size())).append("\n");
        for (n = 0; n < this.checkBlocks.size(); ++n) {
            fecBlock = (FecBlock)this.checkBlocks.get(n);
            string = fecBlock.getChkKey();
            if (string == null) {
                string = "Error";
            }
            stringBuffer.append("SplitFile.CheckBlock.").append(Integer.toHexString(n + 1)).append("=").append(string).append("\n");
            if (!bl || fecBlock.getCurrentState() != 3) continue;
            stringBuffer.append(FROST_TRANSFER_FINISHED_INDICATOR).append("SplitFile.CheckBlock.").append(Integer.toHexString(n + 1)).append("=true\n");
        }
        stringBuffer.append("End\n");
        FileAccess.writeFile(stringBuffer.toString(), this.redirectFile);
        return true;
    }

    protected void fillSegmentValues(OnionFECBase onionFECBase) {
        int n = onionFECBase.getSegmentCount();
        this.segmentValues = new ArrayList(n);
        this.checkBlocksFileSize = 0L;
        this.fileDataBlockCount = 0;
        this.fileCheckBlockCount = 0;
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            SingleSegmentValues singleSegmentValues = new SingleSegmentValues();
            singleSegmentValues.checkBlockSize = onionFECBase.getCheckBlockSize(i);
            singleSegmentValues.checkBlockCount = onionFECBase.getN(i) - onionFECBase.getK(i);
            singleSegmentValues.dataBlockSize = onionFECBase.getBlockSize(i);
            singleSegmentValues.dataBlockCount = onionFECBase.getK(i);
            singleSegmentValues.segmentSize = onionFECBase.getSegmentSize(i);
            singleSegmentValues.segmentStartOffset = l;
            this.segmentValues.add(singleSegmentValues);
            l += singleSegmentValues.segmentSize;
            this.checkBlocksFileSize += (long)(singleSegmentValues.checkBlockSize * singleSegmentValues.checkBlockCount);
            this.fileDataBlockCount += singleSegmentValues.dataBlockCount;
            this.fileCheckBlockCount += singleSegmentValues.checkBlockCount;
        }
    }

    public long getCheckBlocksFileSize() {
        return this.checkBlocksFileSize;
    }

    public SingleSegmentValues getValuesForSegment(int n) {
        if (n < 0 || n > this.segmentValues.size()) {
            return null;
        }
        return (SingleSegmentValues)this.segmentValues.get(n);
    }

    public int getSegmentCount() {
        return this.segmentValues.size();
    }

    public List getCheckBlocks() {
        return this.checkBlocks;
    }

    public List getDataBlocks() {
        return this.dataBlocks;
    }

    public void setCorrectDatafileSize() {
        this.transferMode = 3;
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.dataFile, "rw");
            if (randomAccessFile.length() > this.dataFileSize) {
                randomAccessFile.setLength(this.dataFileSize);
            }
            randomAccessFile.close();
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Exception thrown in setCorrectDatafileSize()", exception);
        }
    }

    public void finishDownload(boolean bl) {
        boolean bl2;
        if (this.transferMode == 3 && !(bl2 = this.dataFile.renameTo(this.downloadTargetFile))) {
            logger.severe("ERROR: Could not move file '" + this.dataFile.getPath() + "' to '" + this.downloadTargetFile.getPath() + "'.\n" + "Maybe the locations are on different filesystems where a move is not allowed.\n" + "Please try change the location of 'temp.dir' in the frost.ini file.");
            this.dataFile = null;
        }
        if (bl) {
            if (this.dataFile != null && !this.dataFile.getPath().equals(this.downloadTargetFile)) {
                this.dataFile.delete();
            }
            this.redirectFile.delete();
            this.checkBlocksFile.delete();
        }
    }

    public void finishUpload(boolean bl) {
        this.transferMode = 3;
        if (bl) {
            this.redirectFile.delete();
            this.checkBlocksFile.delete();
        }
    }

    public long getDataFileSize() {
        return this.dataFileSize;
    }

    public File getRedirectFile() {
        return this.redirectFile;
    }

    protected boolean createFileOfLength(File file, long l) {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            boolean bl = false;
            try {
                randomAccessFile.setLength(l);
                bl = true;
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                String string = iOException.getMessage();
                try {
                    randomAccessFile.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                file.delete();
                if (string.equals("There is not enough space on the disk") || string.equals("An attempt was made to move the file pointer before the beginning of the file")) {
                    logger.severe("ERROR: Could not create the work file: " + string);
                    file.delete();
                    return false;
                }
                logger.warning("Warning: Could not create a work file, error=" + string);
            }
            if (!bl) {
                logger.info("Trying to use a slower creating method, starting ...");
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                for (long i = 0L; i < l; ++i) {
                    bufferedOutputStream.write(0);
                }
                bufferedOutputStream.close();
                logger.info("... finished to create the work file using slower creation method.");
            }
            return true;
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "createFileOfLength(File newfile, long filelength)", exception);
            file.delete();
            logger.severe("ERROR: Could not create the work file " + file.getPath());
            return false;
        }
    }

    public class SingleSegmentValues {
        public long segmentSize;
        public long segmentStartOffset;
        public int dataBlockSize;
        public int dataBlockCount;
        public int checkBlockSize;
        public int checkBlockCount;
    }

    private class FrostFECDecodeBucketFactory
    implements BucketFactory {
        int actualIndexInBucketList;
        List bucketList;

        private FrostFECDecodeBucketFactory() {
        }

        public void init(List list) throws IOException {
            this.bucketList = list;
            this.actualIndexInBucketList = 0;
        }

        public Bucket makeBucket(long l) throws IOException {
            Bucket bucket = (Bucket)this.bucketList.get(this.actualIndexInBucketList);
            ++this.actualIndexInBucketList;
            if (bucket.size() != l) {
                throw new IOException("Bucket size (" + bucket.size() + ") differs of requested size (" + l + ") " + this.actualIndexInBucketList);
            }
            return bucket;
        }

        public void freeBucket(Bucket bucket) throws IOException {
        }
    }

    private class FrostFECEncodeBucketFactory
    implements BucketFactory {
        int checkBlockCounter = 0;
        File checkBlocksFile;
        long actFileOffset = 0L;
        RandomAccessFile raf = null;

        private FrostFECEncodeBucketFactory() {
        }

        public void init(File file, long l) throws IOException {
            this.checkBlocksFile = file;
            if (this.checkBlocksFile.exists() && this.checkBlocksFile.length() == l) {
                return;
            }
            this.checkBlocksFile.delete();
            boolean bl = FecSplitfile.this.createFileOfLength(file, l);
            this.raf = new RandomAccessFile(this.checkBlocksFile, "rw");
        }

        public Bucket makeBucket(long l) throws IOException {
            RandomAccessFileBucket2 randomAccessFileBucket2 = new RandomAccessFileBucket2(this.checkBlocksFile, this.actFileOffset, l, false, this.raf);
            this.actFileOffset += l;
            return randomAccessFileBucket2;
        }

        public void freeBucket(Bucket bucket) throws IOException {
        }
    }
}

