/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp;

import freenet.support.ArrayBucket;
import freenet.support.Bucket;
import freenet.support.RandomAccessFileBucket;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FecBlock {
    public static final int TYPE_DATABLOCK = 1;
    public static final int TYPE_CHECKBLOCK = 2;
    public static final int STATE_TRANSFER_WAITING = 1;
    public static final int STATE_TRANSFER_RUNNING = 2;
    public static final int STATE_TRANSFER_FINISHED = 3;
    public static final int STATE_TRANSFER_INVALID = 4;
    private static Logger logger = Logger.getLogger(FecBlock.class.getName());
    protected int currentState = -1;
    protected int blockType = -1;
    protected String chkKey = null;
    protected File blockFile;
    protected int blockSize = -1;
    protected int segmentNo;
    protected int indexInSegment;
    protected int indexInFile;
    protected long fileOffset;

    public FecBlock(int n, File file, int n2, int n3, int n4, int n5, long l) {
        this.blockType = n;
        this.blockFile = file;
        this.segmentNo = n2;
        this.indexInSegment = n3;
        this.indexInFile = n4;
        this.blockSize = n5;
        this.fileOffset = l;
        this.currentState = 1;
    }

    public RandomAccessFileBucket getRandomAccessFileBucket(boolean bl) {
        RandomAccessFileBucket randomAccessFileBucket = null;
        try {
            randomAccessFileBucket = new RandomAccessFileBucket(this.blockFile, this.getFileOffset(), this.getBlockSize(), bl);
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Exception thrown in getRandomAccessFileBucket(boolean readOnly)", iOException);
            return null;
        }
        return randomAccessFileBucket;
    }

    public Bucket getPaddedMemoryBucket() {
        byte[] byArray = this.getPaddedMemoryArray();
        if (byArray != null) {
            return new ArrayBucket(byArray);
        }
        return null;
    }

    public byte[] getPaddedMemoryArray() {
        byte[] byArray = null;
        try {
            byArray = new byte[this.getBlockSize()];
            long l = this.blockFile.length();
            if (this.fileOffset > l) {
                Arrays.fill(byArray, (byte)0);
            } else {
                RandomAccessFile randomAccessFile = new RandomAccessFile(this.blockFile, "r");
                randomAccessFile.seek(this.fileOffset);
                int n = randomAccessFile.read(byArray);
                randomAccessFile.close();
                if (n < 0) {
                    n = 0;
                }
                if (n < this.blockSize) {
                    Arrays.fill(byArray, n, this.blockSize, (byte)0);
                }
            }
            return byArray;
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Error in FecBlock.getPaddedMemoryArray()", exception);
            return null;
        }
    }

    public int getCurrentState() {
        return this.currentState;
    }

    public int getBlockType() {
        return this.blockType;
    }

    public String getChkKey() {
        return this.chkKey;
    }

    public void setChkKey(String string) {
        this.chkKey = string;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public File getBlockFile() {
        return this.blockFile;
    }

    public long getFileOffset() {
        return this.fileOffset;
    }

    public int getIndexInFile() {
        return this.indexInFile;
    }

    public int getIndexInSegment() {
        return this.indexInSegment;
    }

    public int getSegmentNo() {
        return this.segmentNo;
    }

    public void setCurrentState(int n) {
        this.currentState = n;
    }
}

