/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp;

import frost.FileAccess;
import frost.MainFrame;
import frost.Mixed;
import frost.SettingsFun;
import frost.fcp.DataNotFoundException;
import frost.fcp.FcpConnection;
import frost.fcp.FcpFactory;
import frost.fcp.FcpResults;
import frost.fcp.FcpToolsException;
import frost.fcp.FecBlock;
import frost.fcp.FecSplitfile;
import frost.fileTransfer.download.FrostDownloadItem;
import frost.threads.getKeyThread;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FcpRequest {
    static final boolean DEBUG = true;
    private static Logger logger = Logger.getLogger(FcpRequest.class.getName());

    private static int getActiveThreads(Thread[] threadArray) {
        int n = 0;
        for (int i = 0; i < threadArray.length; ++i) {
            if (threadArray[i] == null || !threadArray[i].isAlive()) continue;
            ++n;
        }
        return n;
    }

    private static boolean getFECSplitFile(File file, File file2, int n, FrostDownloadItem frostDownloadItem) {
        int n2;
        int n3;
        boolean bl = MainFrame.frostSettings.getBoolValue("downloadTryAllSegments");
        boolean bl2 = MainFrame.frostSettings.getBoolValue("downloadDecodeAfterEachSegment");
        FecSplitfile fecSplitfile = null;
        File file3 = new File(file.getPath() + ".redirect");
        if (!file3.exists() || file3.length() == 0L) {
            file3.delete();
            file2.renameTo(file3);
            file2 = new File(file.getPath() + ".redirect");
        } else {
            file2.delete();
            file2 = file3;
        }
        try {
            fecSplitfile = new FecSplitfile(file, file2);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Exception thrown in getFECSplitFile(File, File, int, FrostDownloadItem)", exception);
            return false;
        }
        int n4 = fecSplitfile.getDataBlocks().size();
        int n5 = fecSplitfile.getDataBlocks().size() + fecSplitfile.getCheckBlocks().size();
        int n6 = 0;
        if (frostDownloadItem != null) {
            for (int i = 0; i < fecSplitfile.getSegmentCount(); ++i) {
                FecSplitfile.SingleSegmentValues singleSegmentValues = fecSplitfile.getValuesForSegment(i);
                int n7 = singleSegmentValues.dataBlockCount;
                ArrayList arrayList = FcpRequest.getBlocksInSegmentWithState(fecSplitfile.getDataBlocks(), i, 1);
                arrayList.addAll(FcpRequest.getBlocksInSegmentWithState(fecSplitfile.getCheckBlocks(), i, 1));
                int n8 = arrayList.size();
                ArrayList arrayList2 = FcpRequest.getBlocksInSegmentWithState(fecSplitfile.getDataBlocks(), i, 3);
                arrayList2.addAll(FcpRequest.getBlocksInSegmentWithState(fecSplitfile.getCheckBlocks(), i, 3));
                int n9 = arrayList2.size();
                if (n9 > n7) {
                    n6 += n7;
                    continue;
                }
                n6 += n9;
            }
            frostDownloadItem.setFileSize(new Long(fecSplitfile.getDataFileSize()));
            frostDownloadItem.setDoneBlocks(n6);
            frostDownloadItem.setRequiredBlocks(n4);
            frostDownloadItem.setTotalBlocks(n5);
            frostDownloadItem.setState(6);
        }
        boolean[] blArray = new boolean[fecSplitfile.getSegmentCount()];
        Arrays.fill(blArray, false);
        for (n3 = 0; n3 < fecSplitfile.getSegmentCount(); ++n3) {
            FecSplitfile.SingleSegmentValues singleSegmentValues = fecSplitfile.getValuesForSegment(n3);
            int n10 = singleSegmentValues.dataBlockCount;
            ArrayList arrayList = FcpRequest.getBlocksInSegmentWithState(fecSplitfile.getDataBlocks(), n3, 1);
            arrayList.addAll(FcpRequest.getBlocksInSegmentWithState(fecSplitfile.getCheckBlocks(), n3, 1));
            int n11 = arrayList.size();
            ArrayList arrayList3 = FcpRequest.getBlocksInSegmentWithState(fecSplitfile.getDataBlocks(), n3, 3);
            arrayList3.addAll(FcpRequest.getBlocksInSegmentWithState(fecSplitfile.getCheckBlocks(), n3, 3));
            int n12 = arrayList3.size();
            arrayList3 = null;
            if (n11 == 0) {
                logger.info("Segment " + n3 + " is already decoded.");
                blArray[n3] = true;
                continue;
            }
            int n13 = MainFrame.frostSettings.getIntValue("splitfileDownloadThreads");
            if (n12 < n10) {
                int n14;
                boolean bl3;
                Collections.shuffle(arrayList);
                int n15 = 0;
                Vector<GetKeyThread> vector = new Vector<GetKeyThread>(n13);
                while (n12 < n10 && n15 < arrayList.size()) {
                    bl3 = false;
                    for (n14 = vector.size() - 1; n14 >= 0; --n14) {
                        GetKeyThread getKeyThread2 = (GetKeyThread)vector.get(n14);
                        if (getKeyThread2.isAlive()) continue;
                        if (getKeyThread2.getSuccess()) {
                            if (n12 < n10) {
                                ++n6;
                            }
                            ++n12;
                            if (frostDownloadItem != null) {
                                frostDownloadItem.setDoneBlocks(n6);
                                frostDownloadItem.setRequiredBlocks(n4);
                                frostDownloadItem.setTotalBlocks(n5);
                            }
                        }
                        vector.remove(n14);
                        bl3 = true;
                    }
                    if (bl3) continue;
                    n14 = n10 - n12;
                    int n16 = n13 - vector.size();
                    if (n14 > 0 && n16 > 0) {
                        FecBlock fecBlock = (FecBlock)arrayList.get(n15);
                        ++n15;
                        GetKeyThread getKeyThread3 = new GetKeyThread(fecSplitfile, fecBlock, n);
                        vector.add(getKeyThread3);
                        getKeyThread3.start();
                        Mixed.wait(111);
                        continue;
                    }
                    Mixed.wait(1000);
                }
                while (vector.size() > 0) {
                    bl3 = false;
                    for (n14 = vector.size() - 1; n14 >= 0; --n14) {
                        GetKeyThread getKeyThread4 = (GetKeyThread)vector.get(n14);
                        if (getKeyThread4.isAlive()) continue;
                        if (getKeyThread4.getSuccess()) {
                            if (n12 < n10) {
                                ++n6;
                            }
                            ++n12;
                            if (frostDownloadItem != null) {
                                frostDownloadItem.setDoneBlocks(n6);
                                frostDownloadItem.setRequiredBlocks(n4);
                                frostDownloadItem.setTotalBlocks(n5);
                            }
                        }
                        vector.remove(n14);
                        bl3 = true;
                    }
                    if (bl3) continue;
                    Mixed.wait(1000);
                }
            }
            if (fecSplitfile.isDecodeable(n3)) {
                logger.info("Segment " + n3 + " is decodeable...");
                if (!bl2) {
                    if (frostDownloadItem != null) {
                        frostDownloadItem.setState(8);
                    }
                    try {
                        fecSplitfile.decode(n3);
                    }
                    catch (Throwable throwable) {
                        logger.log(Level.SEVERE, "Exception thrown in getFECSplitFile(File, File, int, FrostDownloadItem)", throwable);
                        blArray[n3] = false;
                        break;
                    }
                    if (frostDownloadItem != null) {
                        frostDownloadItem.setState(6);
                    }
                    FcpRequest.setBlocksInSegmentFinished(fecSplitfile.getDataBlocks(), n3);
                    FcpRequest.setBlocksInSegmentFinished(fecSplitfile.getCheckBlocks(), n3);
                    fecSplitfile.createRedirectFile(true);
                }
                blArray[n3] = true;
                continue;
            }
            logger.warning("Segment " + n3 + " is NOT decodeable...");
            blArray[n3] = false;
            if (!bl) break;
        }
        n3 = 1;
        for (n2 = 0; n2 < blArray.length; ++n2) {
            if (blArray[n2]) continue;
            n3 = 0;
        }
        if (bl2 && n3 == 1) {
            if (frostDownloadItem != null) {
                frostDownloadItem.setState(8);
            }
            for (n2 = 0; n2 < fecSplitfile.getSegmentCount(); ++n2) {
                try {
                    fecSplitfile.decode(n2);
                    continue;
                }
                catch (Throwable throwable) {
                    logger.log(Level.SEVERE, "Exception thrown in getFECSplitFile(File, File, int, FrostDownloadItem)", throwable);
                    n3 = 0;
                    blArray[n2] = false;
                    break;
                }
            }
            if (frostDownloadItem != null) {
                frostDownloadItem.setState(6);
            }
        }
        if (n3 == 1) {
            fecSplitfile.setCorrectDatafileSize();
            if (frostDownloadItem != null) {
                fecSplitfile.finishDownload(false);
            } else {
                fecSplitfile.finishDownload(true);
            }
        } else if (frostDownloadItem == null) {
            fecSplitfile.finishDownload(true);
        }
        return n3 != 0;
    }

    private static ArrayList getBlocksInSegmentWithState(List list, int n, int n2) {
        ArrayList<FecBlock> arrayList = new ArrayList<FecBlock>();
        for (int i = 0; i < list.size(); ++i) {
            FecBlock fecBlock = (FecBlock)list.get(i);
            if (fecBlock.getSegmentNo() != n || fecBlock.getCurrentState() != n2) continue;
            arrayList.add(fecBlock);
        }
        return arrayList;
    }

    private static void setBlocksInSegmentFinished(List list, int n) {
        for (int i = 0; i < list.size(); ++i) {
            FecBlock fecBlock = (FecBlock)list.get(i);
            if (fecBlock.getSegmentNo() != n || fecBlock.getCurrentState() == 3) continue;
            fecBlock.setCurrentState(3);
        }
    }

    public static FcpResults getFile(String string, Long l, File file, int n, boolean bl) {
        return FcpRequest.getFile(string, l, file, n, bl, false, true, null);
    }

    public static FcpResults getFile(String string, Long l, File file, int n, boolean bl, boolean bl2) {
        return FcpRequest.getFile(string, l, file, n, bl, bl2, true, null);
    }

    public static FcpResults getFile(String string, Long l, File file, int n, boolean bl, boolean bl2, boolean bl3, FrostDownloadItem frostDownloadItem) {
        assert (n >= 0);
        File file2 = null;
        if (bl3) {
            try {
                file2 = File.createTempFile("getFile_", ".tmp", new File(MainFrame.frostSettings.getValue("temp.dir")));
            }
            catch (Throwable throwable) {
                logger.log(Level.SEVERE, "Exception thrown in getFile(...)", throwable);
                return null;
            }
        } else {
            file2 = new File(file.getPath() + ".tmp");
        }
        FcpResults fcpResults = null;
        String[] stringArray = null;
        if (frostDownloadItem != null && frostDownloadItem.getRedirect() != null) {
            fcpResults = new FcpResults(frostDownloadItem.getRedirect().getBytes(), frostDownloadItem.getKey());
            logger.info("starting download of an attached redirect");
        } else {
            fcpResults = FcpRequest.getKey(string, file2, n, bl2);
        }
        if (fcpResults != null) {
            stringArray = fcpResults.getMetadataAsLines();
        }
        if (fcpResults != null && (file2.length() > 0L || stringArray != null)) {
            String string2;
            if (stringArray != null && bl && (string2 = FcpRequest.getRedirectCHK(stringArray, string)) != null) {
                logger.info("Redirecting to " + string2);
                fcpResults = null;
                fcpResults = FcpRequest.getKey(string2, file2, n, bl2);
                if (fcpResults == null || file2.length() == 0L) {
                    file2.delete();
                    return null;
                }
            }
            boolean bl4 = false;
            if (stringArray != null) {
                int n2;
                String[] stringArray2 = stringArray;
                String string3 = null;
                for (n2 = 0; n2 < stringArray2.length; ++n2) {
                    if (stringArray2[n2].startsWith("SplitFile.Size")) {
                        bl4 = true;
                    }
                    if (!stringArray2[n2].startsWith("SplitFile.AlgoName")) continue;
                    string3 = stringArray2[n2].substring(stringArray2[n2].indexOf("=") + 1).trim();
                }
                if (bl4) {
                    if (string3 != null && string3.equals("OnionFEC_a_1_2")) {
                        FileAccess.writeFile(fcpResults.getRawMetadata(), file2);
                        n2 = FcpRequest.getFECSplitFile(file, file2, n, frostDownloadItem) ? 1 : 0;
                        if (n2 != 0) {
                            return fcpResults;
                        }
                        return null;
                    }
                    n2 = FcpRequest.getSplitFile(string, file2, n, frostDownloadItem) ? 1 : 0;
                    if (n2 != 0) {
                        if (file.isFile()) {
                            file.delete();
                        }
                        file2.renameTo(file);
                        return fcpResults;
                    }
                    file2.delete();
                    return null;
                }
            }
            if (l == null || l.longValue() == file2.length()) {
                boolean bl5;
                if (file.isFile()) {
                    file.delete();
                }
                if (!(bl5 = file2.renameTo(file))) {
                    logger.severe("ERROR: Could not move file '" + file2.getPath() + "' to '" + file.getPath() + "'.\n" + "Maybe the locations are on different filesystems where a move is not allowed.\n" + "Please try change the location of 'temp.dir' in the frost.ini file," + " and copy the file to a save location by yourself.");
                }
                return fcpResults;
            }
        }
        file2.delete();
        return null;
    }

    private static String getRedirectCHK(String[] stringArray, String string) {
        String string2 = null;
        int n = string.lastIndexOf("/");
        if (n > -1 && (string2 = string.substring(n + 1).trim()).length() == 0) {
            string2 = null;
        }
        if (string2 == null) {
            return null;
        }
        String string3 = null;
        String string4 = null;
        String string5 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string6 = stringArray[i].trim();
            if (string6.length() == 0) continue;
            if (string6.equals("Document")) {
                string3 = null;
                string4 = null;
                continue;
            }
            if (string6.equals("End") || string6.equals("EndPart")) {
                if (string4 == null || string3 == null || !string3.equals(string2)) continue;
                string5 = string4;
                return string5;
            }
            if (string6.startsWith("Name=")) {
                string3 = string6.substring("Name=".length()).trim();
                continue;
            }
            if (!string6.startsWith("Redirect.Target=")) continue;
            string4 = string6.substring("Redirect.Target=".length()).trim();
        }
        return null;
    }

    private static FcpResults getKey(String string, File file, int n, boolean bl) {
        boolean bl2;
        if (string == null || string.length() == 0 || string.startsWith("null")) {
            return null;
        }
        FcpResults fcpResults = null;
        FcpConnection fcpConnection = FcpFactory.getFcpConnectionInstance();
        if (fcpConnection != null) {
            int n2 = 3;
            for (int i = 0; i < n2 || fcpResults != null; ++i) {
                try {
                    fcpResults = fcpConnection.getKeyToFile(string, file.getPath(), n, bl);
                    break;
                }
                catch (ConnectException connectException) {
                    continue;
                }
                catch (DataNotFoundException dataNotFoundException) {
                    logger.log(Level.INFO, "FcpRequest.getKey(1): DataNotFoundException (usual if not found)", dataNotFoundException);
                    break;
                }
                catch (FcpToolsException fcpToolsException) {
                    logger.log(Level.SEVERE, "FcpRequest.getKey(1): FcpToolsException", fcpToolsException);
                    break;
                }
                catch (IOException iOException) {
                    logger.log(Level.SEVERE, "FcpRequest.getKey(1): IOException", iOException);
                    break;
                }
            }
        }
        String string2 = null;
        String string3 = "";
        if (string.indexOf("@") > -1) {
            string3 = string.substring(0, string.indexOf("@") + 1);
        }
        String string4 = "";
        if (string.indexOf("/") > -1) {
            string4 = string.substring(string.indexOf("/"));
        }
        string2 = new StringBuffer().append(string3).append("...").append(string4).toString();
        boolean bl3 = bl2 = fcpResults != null && fcpResults.getRawMetadata() != null && fcpResults.getRawMetadata().length > 0;
        if (fcpResults != null && (file.length() > 0L || bl2)) {
            logger.info("getKey - Success: " + string2);
            return fcpResults;
        }
        file.delete();
        logger.info("getKey - Failed: " + string2);
        return null;
    }

    private static boolean getSplitFile(String string, File file, int n, FrostDownloadItem frostDownloadItem) {
        Object object;
        int n2;
        int n3;
        int n4;
        logger.warning("ATTENTION: Using old, non-FEC download method!\n           This could run, but is'nt really supported any longer.");
        String string2 = SettingsFun.getValue(file.getPath(), "SplitFile.BlockCount");
        String string3 = SettingsFun.getValue(file.getPath(), "SplitFile.Size");
        String string4 = SettingsFun.getValue(file.getPath(), "SplitFile.Blocksize");
        int n5 = 3;
        n5 = MainFrame.frostSettings.getIntValue("splitfileDownloadThreads");
        int n6 = 0;
        try {
            n6 = Integer.parseInt(string2, 16);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        long l = -1L;
        try {
            l = Long.parseLong(string3, 16);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int n7 = -1;
        try {
            n7 = Integer.parseInt(string4, 16);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int[] nArray = new int[n6];
        for (int i = 0; i < n6; ++i) {
            nArray[i] = i + 1;
        }
        Random random = new Random(System.currentTimeMillis());
        for (n4 = 0; n4 < n6; ++n4) {
            int n8 = nArray[n4];
            int n9 = Math.abs(random.nextInt()) % n6;
            nArray[n4] = nArray[n9];
            nArray[n9] = n8;
        }
        if (frostDownloadItem != null) {
            if (frostDownloadItem.getFileSize() == null) {
                frostDownloadItem.setFileSize(new Long(l));
            } else if (frostDownloadItem.getFileSize() != l) {
                logger.warning("WARNING: size of fec splitfile differs from size given from download table. MUST not happen!");
            }
            frostDownloadItem.setDoneBlocks(0);
            frostDownloadItem.setRequiredBlocks(n6);
            frostDownloadItem.setTotalBlocks(n6);
            frostDownloadItem.setState(6);
        }
        n4 = 1;
        boolean[] blArray = new boolean[n6];
        Thread[] threadArray = new Thread[n6];
        for (n3 = 0; n3 < n6; ++n3) {
            int n10;
            int n11;
            n2 = nArray[n3];
            object = SettingsFun.getValue(file.getPath(), "SplitFile.Block." + Integer.toHexString(n2));
            while (FcpRequest.getActiveThreads(threadArray) >= n5) {
                Mixed.wait(5000);
                if (frostDownloadItem == null) continue;
                n11 = 0;
                for (n10 = 0; n10 < n6; ++n10) {
                    if (!blArray[n10]) continue;
                    ++n11;
                }
                frostDownloadItem.setDoneBlocks(n11);
                frostDownloadItem.setRequiredBlocks(n6);
                frostDownloadItem.setTotalBlocks(n6);
            }
            logger.info("Requesting: SplitFile.Block." + Integer.toHexString(n2) + "=" + (String)object);
            n11 = n7;
            if (nArray[n3] == n6 && n7 != -1) {
                n11 = (int)(l - (long)(n7 * (n6 - 1)));
            }
            threadArray[n3] = new getKeyThread((String)object, new File(MainFrame.keypool + file.getName() + "-chunk-" + n2), n, blArray, n3, n11);
            threadArray[n3].start();
            if (frostDownloadItem == null) continue;
            n10 = 0;
            for (int i = 0; i < n6; ++i) {
                if (!blArray[i]) continue;
                ++n10;
            }
            frostDownloadItem.setDoneBlocks(n10);
            frostDownloadItem.setRequiredBlocks(n6);
            frostDownloadItem.setTotalBlocks(n6);
        }
        while (FcpRequest.getActiveThreads(threadArray) > 0) {
            Mixed.wait(5000);
            if (frostDownloadItem == null) continue;
            n3 = 0;
            for (n2 = 0; n2 < n6; ++n2) {
                if (!blArray[n2]) continue;
                ++n3;
            }
            frostDownloadItem.setDoneBlocks(n3);
            frostDownloadItem.setRequiredBlocks(n6);
            frostDownloadItem.setTotalBlocks(n6);
        }
        for (n3 = 0; n3 < n6; ++n3) {
            if (!blArray[n3]) {
                n4 = 0;
                logger.info("NO SUCCESS");
                continue;
            }
            logger.info("SUCCESS");
        }
        if (n4 != 0) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                logger.info("Connecting chunks");
                for (n2 = 1; n2 <= n6; ++n2) {
                    logger.fine("Adding chunk " + n2 + " to " + file.getName());
                    object = new File(MainFrame.keypool + file.getName() + "-chunk-" + n2);
                    fileOutputStream.write(FileAccess.readByteArray((File)object));
                    ((File)object).deleteOnExit();
                    ((File)object).delete();
                }
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                logger.log(Level.SEVERE, "Write Error: " + file.getPath(), iOException);
            }
        } else {
            file.delete();
            logger.warning("!!!!!! Download of " + file.getName() + " failed.");
        }
        return n4 != 0;
    }

    private static class GetKeyThread
    extends Thread {
        FecBlock block;
        int htl;
        boolean success;
        FecSplitfile splitfile;

        public GetKeyThread(FecSplitfile fecSplitfile, FecBlock fecBlock, int n) {
            this.block = fecBlock;
            this.htl = n;
            this.splitfile = fecSplitfile;
        }

        public void run() {
            this.block.setCurrentState(2);
            this.success = false;
            FcpConnection fcpConnection = FcpFactory.getFcpConnectionInstance();
            if (fcpConnection != null) {
                try {
                    this.success = fcpConnection.getKeyToBucket(this.block.getChkKey(), this.block.getRandomAccessFileBucket(false), this.htl);
                }
                catch (FcpToolsException fcpToolsException) {
                    logger.log(Level.WARNING, "Error during request: ", fcpToolsException);
                    this.success = false;
                }
                catch (Throwable throwable) {
                    logger.log(Level.WARNING, "Error during request: ", throwable);
                    this.success = false;
                }
            }
            if (this.success) {
                this.block.setCurrentState(3);
                this.splitfile.createRedirectFile(true);
            } else {
                this.block.setCurrentState(1);
            }
        }

        public boolean getSuccess() {
            return this.success;
        }

        public synchronized FecBlock getBlock() {
            return this.block;
        }
    }
}

