/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public final class FcpKeyword {
    private static Logger logger = Logger.getLogger(FcpKeyword.class.getName());
    public static final int UnknownError = -1;
    public static final int ClientGet = 0;
    public static final int ClientHello = 1;
    public static final int ClientPut = 2;
    public static final int Data = 3;
    public static final int DataChunk = 4;
    public static final int DataFound = 5;
    public static final int DataLength = 6;
    public static final int DataNotFound = 7;
    public static final int EndMessage = 8;
    public static final int FormatError = 9;
    public static final int GenerateCHK = 10;
    public static final int GenerateSVKPair = 11;
    public static final int HopsToLive = 12;
    public static final int KeyCollision = 13;
    public static final int Length = 14;
    public static final int MetadataLength = 15;
    public static final int NodeHello = 16;
    public static final int Node = 17;
    public static final int PrivateKey = 18;
    public static final int Protocol = 19;
    public static final int PublicKey = 20;
    public static final int Reason = 21;
    public static final int Restarted = 22;
    public static final int RouteNotFound = 23;
    public static final int SizeError = 24;
    public static final int Success = 25;
    public static final int URI = 26;
    public static final int URIError = 27;
    public static final int Failed = 28;
    public static final int ClientInfo = 29;
    public static final int Timeout = 30;
    private String fullString;
    private String keyword;
    private long longVal;
    private int kwId;

    public String toString() {
        return this.fullString;
    }

    public FcpKeyword(String string) {
        logger.fine("in " + string);
        this.fullString = string;
        this.keyword = FcpKeyword.getFcpKeyword(string);
        logger.fine("kw " + this.keyword);
        this.kwId = FcpKeyword.getFcpId(string);
        try {
            if (this.keyword != null && this.fullString != null) {
                if (this.keyword.length() < this.fullString.length()) {
                    String string2 = string.substring(this.keyword.length() + 1);
                    logger.fine("Getting longval for *" + string2 + "*");
                    this.longVal = Long.parseLong(string2, 16);
                } else {
                    this.longVal = -1L;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.longVal = -1L;
        }
    }

    private static int getFcpId(String string) {
        if (string.startsWith("ClientGet")) {
            return 0;
        }
        if (string.startsWith("ClientHello")) {
            return 1;
        }
        if (string.startsWith("ClientPut")) {
            return 2;
        }
        if (string.startsWith("DataChunk")) {
            return 4;
        }
        if (string.startsWith("DataFound")) {
            return 5;
        }
        if (string.startsWith("DataLength")) {
            return 6;
        }
        if (string.startsWith("DataNotFound")) {
            return 7;
        }
        if (string.startsWith("Data")) {
            return 3;
        }
        if (string.startsWith("EndMessage")) {
            return 8;
        }
        if (string.startsWith("FormatError")) {
            return 9;
        }
        if (string.startsWith("GenerateCHK")) {
            return 10;
        }
        if (string.startsWith("GenerateSVKPair")) {
            return 11;
        }
        if (string.startsWith("HopsToLive")) {
            return 12;
        }
        if (string.startsWith("KeyCollision")) {
            return 13;
        }
        if (string.startsWith("Length")) {
            return 14;
        }
        if (string.startsWith("MetadataLength")) {
            return 15;
        }
        if (string.startsWith("NodeHello")) {
            return 16;
        }
        if (string.startsWith("Node")) {
            return 17;
        }
        if (string.startsWith("PrivateKey")) {
            return 18;
        }
        if (string.startsWith("Protocol")) {
            return 19;
        }
        if (string.startsWith("PublicKey")) {
            return 20;
        }
        if (string.startsWith("Reason")) {
            return 21;
        }
        if (string.startsWith("Restarted")) {
            return 22;
        }
        if (string.startsWith("RouteNotFound")) {
            return 23;
        }
        if (string.startsWith("SizeError")) {
            return 24;
        }
        if (string.startsWith("Success")) {
            return 25;
        }
        if (string.startsWith("URIError")) {
            return 27;
        }
        if (string.startsWith("URI")) {
            return 26;
        }
        if (string.startsWith("Failed")) {
            return 28;
        }
        if (string.startsWith("ClientInfo")) {
            return 29;
        }
        if (string.startsWith("Timeout")) {
            return 30;
        }
        return -1;
    }

    private static String getFcpKeyword(String string) {
        if (string.startsWith("Timeout")) {
            return "Timeout";
        }
        if (string.startsWith("ClientGet")) {
            return "ClientGet";
        }
        if (string.startsWith("ClientHello")) {
            return "ClientHello";
        }
        if (string.startsWith("ClientPut")) {
            return "ClientPut";
        }
        if (string.startsWith("DataChunk")) {
            return "DataChunk";
        }
        if (string.startsWith("DataFound")) {
            return "DataFound";
        }
        if (string.startsWith("DataLength")) {
            return "DataLength";
        }
        if (string.startsWith("DataNotFound")) {
            return "DataNotFound";
        }
        if (string.startsWith("Data")) {
            return "Data";
        }
        if (string.startsWith("EndMessage")) {
            return "EndMessage";
        }
        if (string.startsWith("FormatError")) {
            return "FormatError";
        }
        if (string.startsWith("GenerateCHK")) {
            return "GenerateCHK";
        }
        if (string.startsWith("GenerateSVKPair")) {
            return "GenerateSVKPair";
        }
        if (string.startsWith("HopsToLive")) {
            return "HopsToLive";
        }
        if (string.startsWith("KeyCollision")) {
            return "KeyCollision";
        }
        if (string.startsWith("Length")) {
            return "Length";
        }
        if (string.startsWith("MetadataLength")) {
            return "MetadataLength";
        }
        if (string.startsWith("NodeHello")) {
            return "NodeHello";
        }
        if (string.startsWith("Node")) {
            return "Node";
        }
        if (string.startsWith("PrivateKey")) {
            return "PrivateKey";
        }
        if (string.startsWith("Protocol")) {
            return "Protocol";
        }
        if (string.startsWith("PublicKey")) {
            return "PublicKey";
        }
        if (string.startsWith("Reason")) {
            return "Reason";
        }
        if (string.startsWith("Restarted")) {
            return "Restarted";
        }
        if (string.startsWith("RouteNotFound")) {
            return "RouteNotFound";
        }
        if (string.startsWith("SizeError")) {
            return "SizeError";
        }
        if (string.startsWith("Success")) {
            return "Success";
        }
        if (string.startsWith("URIError")) {
            return "URIError";
        }
        if (string.startsWith("URI")) {
            return "URI";
        }
        if (string.startsWith("Failed")) {
            return "Failed";
        }
        return null;
    }

    public static FcpKeyword getFcpKeyword(InputStream inputStream) throws IOException {
        int n;
        int n2;
        byte[] byArray = new byte[256];
        for (n2 = 0; (n = inputStream.read()) != 10 && n != -1 && n2 < 256 && n != 0; ++n2) {
            byArray[n2] = (byte)n;
        }
        return new FcpKeyword(new String(byArray, 0, n2));
    }

    public long getLongVal() {
        return this.longVal;
    }

    public int getId() {
        return this.kwId;
    }

    public String getFullString() {
        return this.fullString;
    }

    public String getStringVal() {
        return this.fullString.substring(this.keyword.length());
    }
}

