/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp;

import frost.FileAccess;
import frost.MainFrame;
import frost.Mixed;
import frost.fcp.FcpConnection;
import frost.fcp.FcpFactory;
import frost.fcp.FecBlock;
import frost.fcp.FecSplitfile;
import frost.fileTransfer.upload.FrostUploadItem;
import java.io.File;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class FcpInsert {
    private static Logger logger = Logger.getLogger(FcpInsert.class.getName());
    public static final int smallestChunk = 786432;
    private static String[] keywords = new String[]{"Success", "RouteNotFound", "KeyCollision", "SizeError", "DataNotFound"};

    private static String[] result(String string) {
        String[] stringArray = new String[]{"Error", "Error"};
        logger.info("*** FcpInsert.result: text='" + string + "'");
        for (int i = 0; i < keywords.length; ++i) {
            if (string.indexOf(keywords[i]) == -1) continue;
            stringArray[0] = keywords[i];
        }
        if (string.indexOf("CHK@") != -1) {
            stringArray[1] = string.substring(string.lastIndexOf("CHK@"), string.lastIndexOf("EndMessage"));
            stringArray[1] = stringArray[1].trim();
        } else {
            stringArray[1] = "Error";
        }
        return stringArray;
    }

    public static String[] putFile(String string, File file, int n, boolean bl) {
        return FcpInsert.putFile(string, file, null, n, bl, null);
    }

    public static String[] putFile(String string, File file, byte[] byArray, int n, boolean bl) {
        return FcpInsert.putFile(string, file, byArray, n, bl, null);
    }

    public static String[] putFile(String string, File file, byte[] byArray, int n, boolean bl, FrostUploadItem frostUploadItem) {
        if (file.length() == 0L) {
            logger.log(Level.SEVERE, "Error: Can't upload empty file: " + file.getPath());
            JOptionPane.showMessageDialog(MainFrame.getInstance(), "FcpInsert: File " + file.getPath() + " is empty!", "Warning", 2);
            return new String[]{"Error", "Error"};
        }
        long l = file.length();
        if (byArray != null) {
            l += (long)byArray.length;
        }
        if (l > 32767L && (string.startsWith("KSK@") || string.startsWith("SSK@"))) {
            if (bl) {
                return FcpInsert.putFECSplitFile(string, file, n, frostUploadItem);
            }
            logger.log(Level.SEVERE, "Error: Data too large for direct KSK/SSK key, 32767 allowed: " + l);
            JOptionPane.showMessageDialog(MainFrame.getInstance(), "<html>FcpInsert: Data of file " + file.getPath() + " too large for direct KSK key, 32767 allowed: " + l + "<br>Please report this to a Frost developer!</html>", "Insert Error", 0);
            return new String[]{"Error", "Error"};
        }
        if (file.length() <= 786432L) {
            try {
                FcpConnection fcpConnection = FcpFactory.getFcpConnectionInstance();
                if (fcpConnection == null) {
                    return new String[]{"Error", "Error"};
                }
                String string2 = new String();
                do {
                    if ((string2 = fcpConnection.putKeyFromFile(string, file.getPath(), byArray, n)).length() < 5) {
                        logger.warning("Freenet insert failed, maybe a bug. Trying again...");
                        Mixed.wait(333);
                        continue;
                    }
                    logger.info("output from fcp insert : " + string2);
                } while (string2.length() < 5);
                return FcpInsert.result(string2);
            }
            catch (UnknownHostException unknownHostException) {
                logger.log(Level.SEVERE, "UnknownHostException", unknownHostException);
            }
            catch (Throwable throwable) {
                logger.log(Level.SEVERE, "Throwable", throwable);
            }
            return FcpInsert.result("");
        }
        return FcpInsert.putFECSplitFile(string, file, n, frostUploadItem);
    }

    private static String[] putFECSplitFile(String string, File file, int n, FrostUploadItem frostUploadItem) {
        Object object;
        int n2;
        String[] stringArray = new String[]{"Error", "Error"};
        FecSplitfile fecSplitfile = null;
        fecSplitfile = new FecSplitfile(file);
        boolean bl = fecSplitfile.uploadInit();
        if (!bl) {
            try {
                fecSplitfile.encode();
            }
            catch (Throwable throwable) {
                logger.log(Level.SEVERE, "Encoding failed", throwable);
                return stringArray;
            }
        }
        logger.info("Starting upload of " + file.getName());
        int n3 = fecSplitfile.getDataBlocks().size() + fecSplitfile.getCheckBlocks().size();
        int n4 = 0;
        if (frostUploadItem != null && frostUploadItem.getKey() != null) {
            frostUploadItem.setTotalBlocks(n3);
            frostUploadItem.setDoneBlocks(0);
            frostUploadItem.setState(4);
        }
        LinkedList<FecBlock> linkedList = new LinkedList<FecBlock>();
        for (int i = 0; i < fecSplitfile.getSegmentCount(); ++i) {
            FecSplitfile.SingleSegmentValues singleSegmentValues = fecSplitfile.getValuesForSegment(i);
            ArrayList arrayList = FcpInsert.getBlocksInSegmentWithState(fecSplitfile.getDataBlocks(), i, 1);
            arrayList.addAll(FcpInsert.getBlocksInSegmentWithState(fecSplitfile.getCheckBlocks(), i, 1));
            int n5 = arrayList.size();
            n2 = singleSegmentValues.dataBlockCount + singleSegmentValues.checkBlockCount;
            n4 += n2 - n5;
            if (frostUploadItem != null && frostUploadItem.getKey() != null) {
                frostUploadItem.setDoneBlocks(n4);
            }
            if (n5 == 0) {
                logger.info("Segment " + i + " is already inserted");
                continue;
            }
            linkedList.addAll(arrayList);
        }
        ArrayList<PutKeyThread> arrayList = new ArrayList<PutKeyThread>();
        while (linkedList.size() > 0 || arrayList.size() > 0) {
            int n6;
            boolean bl2 = false;
            for (n6 = arrayList.size() - 1; n6 >= 0; --n6) {
                PutKeyThread putKeyThread = (PutKeyThread)arrayList.get(n6);
                if (putKeyThread.isAlive()) continue;
                if (putKeyThread.getSuccess()) {
                    ++n4;
                    if (frostUploadItem != null && frostUploadItem.getKey() != null) {
                        frostUploadItem.setDoneBlocks(n4);
                    }
                } else {
                    linkedList.addLast(putKeyThread.getBlock());
                }
                arrayList.remove(n6);
                bl2 = true;
            }
            if (bl2) continue;
            n6 = MainFrame.frostSettings.getIntValue("splitfileUploadThreads");
            int n7 = linkedList.size();
            n2 = n6 - arrayList.size();
            if (n7 > 0 && n2 > 0) {
                object = (FecBlock)linkedList.removeFirst();
                PutKeyThread putKeyThread = new PutKeyThread(fecSplitfile, (FecBlock)object, n, string);
                arrayList.add(putKeyThread);
                putKeyThread.start();
                Mixed.wait(1111);
                continue;
            }
            Mixed.wait(2500);
        }
        String string2 = null;
        if (frostUploadItem != null) {
            string2 = frostUploadItem.getKey();
        }
        boolean bl3 = false;
        FcpConnection fcpConnection = FcpFactory.getFcpConnectionInstance();
        if (fcpConnection != null) {
            fecSplitfile.createRedirectFile(false);
            try {
                String string3 = fcpConnection.putKeyFromArray(string, null, FileAccess.readByteArray(fecSplitfile.getRedirectFile()), n);
                object = FcpInsert.result(string3);
                if (string2 != null && object[1].indexOf(string2) < 0) {
                    logger.severe("Error: the CHK keys for redirect file generated by frost and freenet differ:\nFreeNet Key ='" + object[1] + "'\n" + "Frost Key   ='" + string2 + "'");
                    string2 = object[1];
                } else if (string2 == null) {
                    string2 = object[1];
                }
                if (object[0].equals("Success") || object[0].equals("KeyCollision")) {
                    bl3 = true;
                } else {
                    logger.severe("Could not upload redirect file: " + object);
                }
            }
            catch (Throwable throwable) {
                bl3 = false;
                logger.log(Level.SEVERE, "Error uploading redirect file", throwable);
            }
        }
        if (frostUploadItem == null) {
            fecSplitfile.finishUpload(true);
        } else {
            fecSplitfile.finishUpload(false);
        }
        if (bl3) {
            logger.info("Redirect successfully uploaded.");
            return new String[]{"Success", string2};
        }
        return stringArray;
    }

    private static ArrayList getBlocksInSegmentWithState(List list, int n, int n2) {
        ArrayList<FecBlock> arrayList = new ArrayList<FecBlock>();
        for (int i = 0; i < list.size(); ++i) {
            FecBlock fecBlock = (FecBlock)list.get(i);
            if (fecBlock.getSegmentNo() != n || fecBlock.getCurrentState() != n2) continue;
            arrayList.add(fecBlock);
        }
        return arrayList;
    }

    private static class PutKeyThread
    extends Thread {
        FecBlock block;
        int htl;
        boolean success;
        String uri;
        FecSplitfile splitfile;

        public PutKeyThread(FecSplitfile fecSplitfile, FecBlock fecBlock, int n, String string) {
            this.block = fecBlock;
            this.htl = n;
            this.uri = string;
            this.splitfile = fecSplitfile;
        }

        public void run() {
            this.block.setCurrentState(2);
            this.success = false;
            FcpConnection fcpConnection = FcpFactory.getFcpConnectionInstance();
            if (fcpConnection != null) {
                try {
                    String string = fcpConnection.putKeyFromArray(this.uri, this.block.getPaddedMemoryArray(), null, this.htl);
                    if (string.indexOf("Success") > -1 || string.indexOf("KeyCollision") > -1) {
                        this.success = true;
                    }
                }
                catch (Throwable throwable) {
                    logger.log(Level.WARNING, "Error during insert: ", throwable);
                    this.success = false;
                }
            }
            if (this.success) {
                this.block.setCurrentState(3);
                this.splitfile.createRedirectFile(true);
            } else {
                this.block.setCurrentState(1);
            }
        }

        public boolean getSuccess() {
            return this.success;
        }

        public synchronized FecBlock getBlock() {
            return this.block;
        }
    }
}

