/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp;

import frost.Core;
import frost.Mixed;
import frost.fcp.ConnectionException;
import frost.fcp.FcpConnection;
import frost.fcp.FcpToolsException;
import frost.fcp.NodeManager;
import frost.fcp.RandomMultipleNodeManager;
import frost.fcp.SingleNodeManager;
import java.io.IOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.logging.Logger;

public class FcpFactory {
    static NodeManager manager = null;
    private static Logger logger = Logger.getLogger(FcpFactory.class.getName());

    public static FcpConnection getFcpConnectionInstance() {
        int n;
        if (manager == null) {
            manager = Core.getNodes().size() == 1 ? new SingleNodeManager() : new RandomMultipleNodeManager();
            manager.init();
        }
        FcpConnection fcpConnection = null;
        int n2 = 0;
        int n3 = n = Core.getNodes().size() > 1 ? Core.getNodes().size() : 3;
        while (fcpConnection == null && n2 < n) {
            try {
                fcpConnection = manager.getConnection();
            }
            catch (ConnectionException connectionException) {
                logger.warning("FcpConnection.getFcpConnectionInstance: FcpTools.ConnectionException " + connectionException + " , this was try " + (n2 + 1) + "/" + n);
            }
            catch (FcpToolsException fcpToolsException) {
                logger.severe("FcpConnection.getFcpConnectionInstance: FcpToolsException " + fcpToolsException);
                break;
            }
            catch (UnknownHostException unknownHostException) {
                logger.severe("FcpConnection.getFcpConnectionInstance: UnknownHostException " + unknownHostException);
                break;
            }
            catch (ConnectException connectException) {
                logger.warning("FcpConnection.getFcpConnectionInstance: java.net.ConnectException " + connectException + " , this was try " + (n2 + 1) + "/" + n);
            }
            catch (IOException iOException) {
                logger.warning("FcpConnection.getFcpConnectionInstance: IOException " + iOException + " , this was try " + (n2 + 1) + "/" + n);
            }
            Mixed.wait(++n2 * 1250);
        }
        if (fcpConnection == null) {
            logger.warning("ERROR: FcpConnection.getFcpConnectionInstance: Could not connect to node!");
        }
        return fcpConnection;
    }
}

