/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp;

import frost.fcp.FcpFECUtilsSegmentHeader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Vector;
import java.util.logging.Logger;

public class FcpFECUtils {
    static String description = "FEC file inserted by FROST";
    private static Logger logger = Logger.getLogger(FcpFECUtils.class.getName());
    private InetAddress host;
    private int port;
    private Socket fcpSock;
    private BufferedInputStream fcpIn;
    private PrintStream fcpOut;
    private byte[] header = new byte[]{0, 0, 0, 2};

    public String FECMakeMetadata(Vector vector, Vector vector2, Vector vector3, String string) throws UnknownHostException, IOException, SocketException {
        int n;
        Object object;
        String string2 = "";
        String string3 = "";
        this.fcpSock = new Socket(this.host, this.port);
        this.fcpSock.setSoTimeout(10000);
        this.fcpOut = new PrintStream(this.fcpSock.getOutputStream());
        this.fcpIn = new BufferedInputStream(this.fcpSock.getInputStream());
        for (int i = 0; i < vector.size(); ++i) {
            object = (FcpFECUtilsSegmentHeader)vector.get(i);
            string2 = string2 + "SegmentHeader\n";
            string2 = string2 + ((FcpFECUtilsSegmentHeader)object).reconstruct();
            string2 = string2 + "EndMessage\n";
            string2 = string2 + "BlockMap\n";
            String[][] stringArray = (String[][])vector2.get(i);
            for (int j = 0; j < stringArray.length; ++j) {
                logger.fine("chunkMap: " + j + stringArray[j][0] + " " + stringArray[j][1]);
                string2 = string2 + "Block." + Integer.toHexString(j) + "=" + stringArray[j][1] + "\n";
            }
            String[][] stringArray2 = (String[][])vector3.get(i);
            for (n = 0; n < stringArray2.length; ++n) {
                logger.fine("checkMap: " + n + stringArray2[n][0] + " " + stringArray2[n][1]);
                string2 = string2 + "Check." + Integer.toHexString(n) + "=" + stringArray2[n][1] + "\n";
            }
            string2 = string2 + "EndMessage\n";
        }
        this.fcpOut.println("\u0000\u0000\u0000\u0002FECMakeMetadata");
        this.fcpOut.println("Segments=" + Integer.toHexString(vector.size()));
        this.fcpOut.println("Description=" + description);
        this.fcpOut.println("MimeType=Frost/FEC");
        this.fcpOut.println("DataLength=" + Integer.toHexString(string2.length()));
        this.fcpOut.println("Data");
        this.fcpOut.print(string2);
        int n2 = 0;
        int n3 = 0;
        n = 0;
        byte[] byArray = null;
        do {
            object = this.getLine(this.fcpIn).trim();
            logger.fine((String)object);
            if (((String)object).startsWith("DataLength=")) {
                n3 = Integer.parseInt(((String)object).split("=")[1], 16);
                byArray = new byte[n3];
                continue;
            }
            if (((String)object).equals("DataChunk")) continue;
            if (((String)object).startsWith("Length=")) {
                n2 = Integer.parseInt(((String)object).split("=")[1], 16);
                continue;
            }
            if (!((String)object).equals("Data")) continue;
            while (n2 > 0) {
                int n4 = this.fcpIn.read(byArray, n, n2);
                n2 -= n4;
                n += n4;
            }
        } while (((String)object).length() > 0);
        return new String(byArray);
    }

    public Vector FECSegmentFile(String string, long l) throws UnknownHostException, IOException, SocketException {
        String string2;
        FcpFECUtilsSegmentHeader fcpFECUtilsSegmentHeader = null;
        String string3 = "\u0000\u0000\u0000\u0002FECSegmentFile\nAlgoName=" + string + "\nFileLength=" + Long.toHexString(l) + "\nEndMessage\n";
        this.fcpSock = new Socket(this.host, this.port);
        this.fcpSock.setSoTimeout(10000);
        this.fcpOut = new PrintStream(this.fcpSock.getOutputStream());
        this.fcpIn = new BufferedInputStream(this.fcpSock.getInputStream());
        this.fcpOut.print(string3);
        Vector<FcpFECUtilsSegmentHeader> vector = new Vector<FcpFECUtilsSegmentHeader>();
        do {
            if ((string2 = this.getLine(this.fcpIn).trim()).equals("SegmentHeader")) {
                fcpFECUtilsSegmentHeader = new FcpFECUtilsSegmentHeader();
                continue;
            }
            if (string2.equals("EndMessage")) {
                vector.add(fcpFECUtilsSegmentHeader);
                fcpFECUtilsSegmentHeader = null;
            }
            if (fcpFECUtilsSegmentHeader == null) continue;
            fcpFECUtilsSegmentHeader.insertValue(string2);
        } while (string2.length() > 0);
        this.fcpOut.close();
        this.fcpIn.close();
        this.fcpSock.close();
        return vector;
    }

    public String getLine(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[64];
        for (int i = 0; (n = inputStream.read()) != 10 && n != -1 && n != 0 && i < 64; ++i) {
            byArray[i] = (byte)n;
        }
        return new String(byArray).trim();
    }

    public FcpFECUtils(String string, int n) {
        try {
            this.host = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            try {
                this.host = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
            }
            catch (UnknownHostException unknownHostException2) {
                // empty catch block
            }
        }
        this.port = n;
        logger.info("Generated FcpFECUtils host " + this.host.getHostAddress());
    }
}

