/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp;

import freenet.support.Bucket;
import frost.FileAccess;
import frost.fcp.ConnectionException;
import frost.fcp.DataNotFoundException;
import frost.fcp.FcpKeyword;
import frost.fcp.FcpResults;
import frost.fcp.FcpToolsException;
import frost.fcp.FecTools;
import frost.fcp.FreenetKey;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.logging.Logger;

public class FcpConnection {
    private static Logger logger = Logger.getLogger(FcpConnection.class.getName());
    static final int TIMEOUT = 3600000;
    private InetAddress host;
    private int port;
    private Socket fcpSock;
    private BufferedInputStream fcpIn;
    private PrintStream fcpOut;
    private byte[] header = new byte[]{0, 0, 0, 2};

    public FcpConnection() throws UnknownHostException, IOException, FcpToolsException {
        this("127.0.0.1", 8481);
    }

    public FcpConnection(String string, String string2) throws UnknownHostException, IOException, FcpToolsException {
        this(string, Integer.parseInt(string2));
    }

    public FcpConnection(String string, int n) throws UnknownHostException, IOException, FcpToolsException {
        this.host = InetAddress.getByName(string);
        this.port = n;
        this.doHandshake();
    }

    public String[] getInfo() throws IOException, FcpToolsException {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        this.fcpSock = new Socket(this.host, this.port);
        this.fcpSock.setSoTimeout(3600000);
        this.fcpOut = new PrintStream(this.fcpSock.getOutputStream());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.fcpSock.getInputStream()));
        this.fcpOut.write(this.header, 0, this.header.length);
        this.fcpOut.println("ClientInfo");
        this.fcpOut.println("EndMessage");
        while ((string = bufferedReader.readLine()).compareTo("EndMessage") != 0) {
            arrayList.add(string);
            if (string.compareTo("EndMessage") != 0) continue;
        }
        bufferedReader.close();
        this.fcpOut.close();
        this.fcpSock.close();
        if (arrayList.isEmpty()) {
            return null;
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    public boolean getKeyToBucket(String string, Bucket bucket, int n) throws IOException, FcpToolsException, InterruptedIOException {
        string = this.FcpDisconnect(string);
        FreenetKey freenetKey = new FreenetKey(string);
        logger.fine("KeyString = " + string + "\n" + "Key =       " + freenetKey + "\n" + "KeyType =   " + freenetKey.getKeyType() + "\n" + "HTL =       " + n);
        OutputStream outputStream = bucket.getOutputStream();
        this.fcpSock = new Socket(this.host, this.port);
        this.fcpSock.setSoTimeout(3600000);
        this.fcpIn = new BufferedInputStream(this.fcpSock.getInputStream());
        this.fcpOut = new PrintStream(this.fcpSock.getOutputStream());
        this.fcpOut.write(this.header, 0, this.header.length);
        this.fcpOut.println("ClientGet");
        this.fcpOut.println("URI=" + freenetKey);
        this.fcpOut.println("HopsToLive=" + Integer.toHexString(n));
        this.fcpOut.println("EndMessage");
        boolean bl = false;
        long l = 0L;
        long l2 = 0L;
        int n2 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n3 = 0;
        while (!bl && !bl4) {
            int n4;
            int n5;
            if (!bl2) {
                FcpKeyword fcpKeyword = FcpKeyword.getFcpKeyword(this.fcpIn);
                switch (fcpKeyword.getId()) {
                    case 5: {
                        if (!bl3) break;
                        outputStream.close();
                        bucket.resetWrite();
                        outputStream = bucket.getOutputStream();
                        l = 0L;
                        l2 = 0L;
                        n2 = 0;
                        bl3 = false;
                        break;
                    }
                    case 6: {
                        l = fcpKeyword.getLongVal();
                        n3 = (int)l;
                        if (l == bucket.size()) break;
                        throw new IOException("Size of data is bigger than size of provided Bucket");
                    }
                    case 9: {
                        bl4 = true;
                        break;
                    }
                    case 27: {
                        bl4 = true;
                        break;
                    }
                    case 22: {
                        bl3 = true;
                        break;
                    }
                    case 7: {
                        this.fcpIn.close();
                        this.fcpOut.close();
                        this.fcpSock.close();
                        outputStream.close();
                        throw new DataNotFoundException();
                    }
                    case 23: {
                        bl4 = true;
                        break;
                    }
                    case 28: {
                        bl4 = true;
                        break;
                    }
                    case -1: {
                        bl4 = true;
                        break;
                    }
                    case 15: {
                        l2 = fcpKeyword.getLongVal();
                        break;
                    }
                    case 8: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 14: {
                        n2 = (int)fcpKeyword.getLongVal();
                        break;
                    }
                    case 3: {
                        bl2 = true;
                        break;
                    }
                }
                continue;
            }
            logger.fine("Expecting " + n2 + " bytes, " + l + " total.");
            byte[] byArray = new byte[n2];
            for (n4 = 0; n4 < n2 && (n5 = this.fcpIn.read(byArray, n4, n2 - n4)) >= 0; n4 += n5) {
            }
            outputStream.write(byArray);
            bl2 = false;
            if ((l -= (long)n4) > 0L) continue;
            bl = true;
        }
        this.fcpIn.close();
        this.fcpOut.close();
        this.fcpSock.close();
        outputStream.close();
        if (bl) {
            if (l2 > 0L) {
                logger.severe("Unexpected metadata received in getKeyToBucket().");
                return false;
            }
            boolean bl5 = this.checkIntegrity(bucket, n3, string);
            if (!bl5) {
                logger.warning("Invalid bucket received in getKeyToBucket(). Retrying.");
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean checkIntegrity(Bucket bucket, int n, String string) throws IOException {
        int n2;
        InputStream inputStream = bucket.getInputStream();
        byte[] byArray = new byte[n];
        int n3 = 0;
        while ((n2 = inputStream.read(byArray, n3, 262144)) > -1) {
            n3 += n2;
        }
        String string2 = FecTools.generateCHK(byArray);
        return string.equalsIgnoreCase(string2);
    }

    public FcpResults getKeyToFile(String string, String string2, int n) throws IOException, FcpToolsException, InterruptedIOException {
        return this.getKeyToFile(string, string2, n, false);
    }

    public FcpResults getKeyToFile(String string, String string2, int n, boolean bl) throws IOException, FcpToolsException, InterruptedIOException {
        Object object;
        string = this.FcpDisconnect(string);
        FcpResults fcpResults = new FcpResults();
        FreenetKey freenetKey = new FreenetKey(string);
        logger.fine("KeyString = " + string + "\n" + "Key =       " + freenetKey + "\n" + "KeyType =   " + freenetKey.getKeyType() + "\n" + "HTL =       " + n);
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        this.fcpSock = new Socket(this.host, this.port);
        this.fcpSock.setSoTimeout(3600000);
        this.fcpIn = new BufferedInputStream(this.fcpSock.getInputStream());
        this.fcpOut = new PrintStream(this.fcpSock.getOutputStream());
        this.fcpOut.write(this.header, 0, this.header.length);
        this.fcpOut.println("ClientGet");
        this.fcpOut.println("URI=" + freenetKey);
        this.fcpOut.println("HopsToLive=" + Integer.toHexString(n));
        this.fcpOut.println("EndMessage");
        boolean bl2 = false;
        long l = 0L;
        long l2 = 0L;
        int n2 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        while (!bl2) {
            int n3;
            int n4;
            if (!bl3) {
                FcpKeyword fcpKeyword = FcpKeyword.getFcpKeyword(this.fcpIn);
                logger.fine("FcpKeyword: " + fcpKeyword + " for file " + string2);
                switch (fcpKeyword.getId()) {
                    case 5: {
                        if (!bl4) break;
                        fileOutputStream.close();
                        new File(string2).delete();
                        fileOutputStream = new FileOutputStream(string2);
                        l = 0L;
                        l2 = 0L;
                        n2 = 0;
                        bl4 = false;
                        break;
                    }
                    case 6: {
                        l = fcpKeyword.getLongVal();
                        break;
                    }
                    case 9: {
                        bl2 = true;
                        break;
                    }
                    case 27: {
                        bl2 = true;
                        break;
                    }
                    case 22: {
                        bl4 = true;
                        break;
                    }
                    case 7: {
                        this.fcpIn.close();
                        this.fcpOut.close();
                        this.fcpSock.close();
                        fileOutputStream.close();
                        object = new File(string2);
                        if (((File)object).length() == 0L) {
                            ((File)object).delete();
                        }
                        throw new DataNotFoundException();
                    }
                    case 23: {
                        bl2 = true;
                        break;
                    }
                    case 28: {
                        bl2 = true;
                        break;
                    }
                    case -1: {
                        bl2 = true;
                        break;
                    }
                    case 15: {
                        l2 = fcpKeyword.getLongVal();
                        break;
                    }
                    case 8: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 14: {
                        n2 = (int)fcpKeyword.getLongVal();
                        break;
                    }
                    case 3: {
                        bl3 = true;
                        break;
                    }
                    case 30: {
                        if (!bl) break;
                        bl2 = true;
                    }
                }
                continue;
            }
            logger.fine("Expecting " + n2 + " bytes, " + l + " total.");
            object = new byte[n2];
            for (n3 = 0; n3 < n2 && (n4 = this.fcpIn.read((byte[])object, n3, n2 - n3)) >= 0; n3 += n4) {
            }
            fileOutputStream.write((byte[])object);
            bl3 = false;
            if ((l -= (long)n3) > 0L) continue;
            bl2 = true;
        }
        this.fcpIn.close();
        this.fcpOut.close();
        this.fcpSock.close();
        fileOutputStream.flush();
        fileOutputStream.close();
        object = new File(string2);
        if (l2 > 0L && ((File)object).length() > 0L) {
            if (l2 == ((File)object).length()) {
                byte[] byArray = FileAccess.readByteArray((File)object);
                fcpResults.setRawMetadata(byArray);
                ((File)object).delete();
            } else {
                byte[] byArray = FileAccess.readByteArray((File)object);
                byte[] byArray2 = new byte[(int)l2];
                System.arraycopy(byArray, 0, byArray2, 0, (int)l2);
                fcpResults.setRawMetadata(byArray2);
                int n5 = (int)(((File)object).length() - l2);
                byte[] byArray3 = new byte[n5];
                System.arraycopy(byArray, (int)l2, byArray3, 0, n5);
                FileAccess.writeFile(byArray3, (File)object);
            }
        } else if (l2 == 0L && ((File)object).length() == 0L) {
            ((File)object).delete();
        }
        return fcpResults;
    }

    public String putKeyFromArray(String string, byte[] byArray, byte[] byArray2, int n) throws IOException {
        int n2;
        string = this.FcpDisconnect(string);
        this.fcpSock = new Socket(this.host, this.port);
        this.fcpSock.setSoTimeout(3600000);
        this.fcpOut = new PrintStream(this.fcpSock.getOutputStream());
        DataOutputStream dataOutputStream = new DataOutputStream(this.fcpSock.getOutputStream());
        this.fcpIn = new BufferedInputStream(this.fcpSock.getInputStream());
        this.fcpOut.write(this.header, 0, this.header.length);
        this.fcpOut.println("ClientPut");
        this.fcpOut.println("RemoveLocalKey=true");
        this.fcpOut.println("HopsToLive=" + Integer.toHexString(n));
        this.fcpOut.println("URI=" + string);
        int n3 = 0;
        int n4 = 0;
        if (byArray != null) {
            n3 = byArray.length;
        }
        if (byArray2 != null) {
            n4 = byArray2.length;
        }
        this.fcpOut.println("DataLength=" + Integer.toHexString(n3 + n4));
        if (byArray2 != null) {
            this.fcpOut.println("MetadataLength=" + Integer.toHexString(n4));
        }
        this.fcpOut.println("Data");
        this.fcpOut.flush();
        if (byArray2 != null) {
            dataOutputStream.write(byArray2);
        }
        if (byArray != null) {
            dataOutputStream.write(byArray);
        }
        dataOutputStream.flush();
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = this.fcpIn.read()) != -1) {
            stringBuffer.append((char)n2);
            if (stringBuffer.toString().indexOf("EndMessage") == -1) continue;
            stringBuffer.append('\u0000');
            if (stringBuffer.indexOf("Pending") == -1 && stringBuffer.indexOf("Restarted") == -1) break;
            stringBuffer = new StringBuffer();
        }
        dataOutputStream.close();
        this.fcpOut.close();
        this.fcpIn.close();
        this.fcpSock.close();
        return stringBuffer.toString();
    }

    public String putKeyFromFile(String string, String string2, int n) throws IOException {
        byte[] byArray = FileAccess.readByteArray(string2);
        return this.putKeyFromArray(string, byArray, null, n);
    }

    public String putKeyFromFile(String string, String string2, byte[] byArray, int n) throws IOException {
        byte[] byArray2 = FileAccess.readByteArray(string2);
        return this.putKeyFromArray(string, byArray2, byArray, n);
    }

    public void doHandshake() throws IOException, FcpToolsException {
        FcpKeyword fcpKeyword;
        this.fcpSock = new Socket(this.host, this.port);
        this.fcpIn = new BufferedInputStream(this.fcpSock.getInputStream());
        this.fcpOut = new PrintStream(this.fcpSock.getOutputStream());
        this.fcpSock.setSoTimeout(3600000);
        this.fcpOut.write(this.header, 0, this.header.length);
        this.fcpOut.println("ClientHello");
        logger.fine("ClientHello");
        this.fcpOut.println("EndMessage");
        logger.fine("EndMessage");
        int n = 0;
        do {
            fcpKeyword = FcpKeyword.getFcpKeyword(this.fcpIn);
            logger.fine(fcpKeyword.getFullString());
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (fcpKeyword.getId() != 8 && ++n < 32);
        if (n == 32) {
            throw new ConnectionException();
        }
        this.fcpSock.close();
    }

    public String[] getKeyPair() throws IOException {
        int n;
        this.fcpSock = new Socket(this.host, this.port);
        this.fcpSock.setSoTimeout(3600000);
        this.fcpOut = new PrintStream(this.fcpSock.getOutputStream());
        this.fcpIn = new BufferedInputStream(this.fcpSock.getInputStream());
        this.fcpOut.write(this.header, 0, this.header.length);
        this.fcpOut.println("GenerateSVKPair");
        this.fcpOut.println("EndMessage");
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.fcpIn.read()) != -1) {
            stringBuffer.append((char)n);
        }
        logger.fine(stringBuffer.toString());
        this.fcpOut.close();
        this.fcpIn.close();
        this.fcpSock.close();
        String[] stringArray = new String[]{"SSK@", "SSK@"};
        String string = stringBuffer.toString();
        int n2 = string.indexOf("PrivateKey=");
        int n3 = string.indexOf("PublicKey=");
        if (n2 != -1 && n3 != -1) {
            int n4 = string.indexOf(10, n2 += 11);
            int n5 = string.indexOf(10, n3 += 10);
            if (n4 != -1 && n5 != -1) {
                stringArray[0] = stringArray[0] + string.substring(n2, n4);
                stringArray[1] = stringArray[1] + string.substring(n3, n5) + "PAgM";
            }
        }
        return stringArray;
    }

    private String FcpDisconnect(String string) {
        return string;
    }
}

