/*
 * Decompiled with CFR 0.152.
 */
package frost.ext;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class JSysTrayIcon {
    private static int ERR_NO_ERROR = 0;
    private static int ERR_INVALID_PARAM = 1;
    private static int ERR_WINDOW_NOT_FOUND = 2;
    private static int ERR_ICON_NOT_FOUND = 3;
    public static int SHOW_CMD_HIDE = 1;
    public static int SHOW_CMD_SHOW = 2;
    private static boolean libLoaded = false;
    private static Vector iconList = new Vector();
    private int handle = 0;
    private String windowTitle = null;
    private static JSysTrayIcon sysTrayIcon = null;

    private native int nativeShowWindow(String var1, int var2);

    private native int nativeCreateSystrayIcon(int var1, String var2, String var3);

    private native int nativeModifySystrayIcon(int var1, int var2, String var3, String var4);

    private native int nativeDeleteSystrayIcon(int var1);

    public JSysTrayIcon(int n, String string, String string2) throws IOException {
        if (!libLoaded) {
            if (System.getProperty("os.name").startsWith("Windows")) {
                try {
                    System.loadLibrary("exec/JSysTray");
                    libLoaded = true;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    throw new IOException("Could not load JSysTray.dll: " + unsatisfiedLinkError.toString());
                }
            } else {
                throw new IOException("SysTrayIcon is not supported on this system.");
            }
            Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        }
        this.windowTitle = string2;
        this.handle = this.nativeCreateSystrayIcon(n, string, string2);
        if (this.handle == 0) {
            throw new IOException("Systray icon has not been created.");
        }
        iconList.addElement(this);
    }

    public void setIcon(int n) throws IOException {
        if (this.handle == 0) {
            throw new IOException("Systray icon has already been deleted");
        }
        int n2 = this.nativeModifySystrayIcon(this.handle, n, null, null);
        if (n2 == ERR_ICON_NOT_FOUND) {
            throw new IOException("The specified icon has not been found");
        }
        if (n2 == ERR_INVALID_PARAM) {
            throw new IOException("An invalid parameter has been specified");
        }
        if (n2 != ERR_NO_ERROR) {
            throw new IOException("Systray icon has not been modified. rc=" + n2);
        }
    }

    public void setTooltip(String string) throws IOException {
        if (this.handle == 0) {
            throw new IOException("Systray icon has already been deleted");
        }
        int n = this.nativeModifySystrayIcon(this.handle, -1, string, null);
        if (n == ERR_INVALID_PARAM) {
            throw new IOException("An invalid parameter has been specified");
        }
        if (n != ERR_NO_ERROR) {
            throw new IOException("Systray icon has not been modified. rc=" + n);
        }
    }

    public void setWindowTitle(String string) throws IOException {
        if (this.handle == 0) {
            throw new IOException("Systray icon has already been deleted");
        }
        this.windowTitle = string;
        int n = this.nativeModifySystrayIcon(this.handle, -1, null, this.windowTitle);
        if (n == ERR_INVALID_PARAM) {
            throw new IOException("An invalid parameter has been specified");
        }
        if (n != ERR_NO_ERROR) {
            throw new IOException("Systray icon has not been modified. rc=" + n);
        }
    }

    public void delete() throws IOException {
        if (this.handle == 0) {
            throw new IOException("Systray icon has already been deleted");
        }
        int n = this.nativeDeleteSystrayIcon(this.handle);
        if (n == ERR_INVALID_PARAM) {
            throw new IOException("An invalid parameter has been specified");
        }
        if (n != ERR_NO_ERROR) {
            throw new IOException("Systray icon has not been deleted. rc=" + n);
        }
        this.handle = 0;
        this.windowTitle = null;
        iconList.removeElement(this);
    }

    public void showWindow(int n) throws IOException {
        if (this.handle == 0) {
            throw new IOException("Systray icon has already been deleted");
        }
        int n2 = this.nativeShowWindow(this.windowTitle, n);
        if (n2 == ERR_WINDOW_NOT_FOUND) {
            throw new IOException("The specified window has not been found");
        }
        if (n2 == ERR_INVALID_PARAM) {
            throw new IOException("An invalod parameter has been specified");
        }
        if (n2 != ERR_NO_ERROR) {
            throw new IOException("The Window state has not been changed. rc=" + n2);
        }
    }

    public static boolean createInstance(int n, String string, String string2) {
        try {
            sysTrayIcon = new JSysTrayIcon(n, string, string2);
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    public static JSysTrayIcon getInstance() {
        return sysTrayIcon;
    }

    class ShutdownHook
    extends Thread {
        ShutdownHook() {
        }

        public void run() {
            Enumeration enumeration = iconList.elements();
            while (enumeration.hasMoreElements()) {
                JSysTrayIcon jSysTrayIcon = (JSysTrayIcon)enumeration.nextElement();
                try {
                    jSysTrayIcon.delete();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

