/*
 * Decompiled with CFR 0.152.
 */
package frost.crypt;

import frost.Core;
import frost.XMLTools;
import frost.crypt.MetaData;
import frost.identities.Identity;
import frost.identities.LocalIdentity;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SignMetaData
extends MetaData {
    private static Logger logger = Logger.getLogger(SignMetaData.class.getName());
    String sig;

    public SignMetaData() {
        this.person = null;
        this.sig = null;
    }

    public SignMetaData(byte[] byArray, LocalIdentity localIdentity) {
        this.person = localIdentity;
        this.sig = Core.getCrypto().detachedSign(byArray, localIdentity.getPrivKey());
    }

    public SignMetaData(byte[] byArray) throws Throwable {
        Document document = XMLTools.parseXmlContent(byArray, false);
        Element element = document.getDocumentElement();
        if (!element.getTagName().equals("FrostMetaData")) {
            throw new Exception("This is not FrostMetaData XML file.");
        }
        try {
            this.loadXMLElement(element);
        }
        catch (SAXException sAXException) {
            logger.log(Level.SEVERE, "Exception thrown in constructor", sAXException);
            throw sAXException;
        }
    }

    public SignMetaData(Element element) throws SAXException {
        try {
            this.loadXMLElement(element);
        }
        catch (SAXException sAXException) {
            logger.log(Level.SEVERE, "Exception thrown in constructor", sAXException);
            throw sAXException;
        }
    }

    public Element getXMLElement(Document document) {
        Element element = super.getXMLElement(document);
        Element element2 = document.createElement("sig");
        CDATASection cDATASection = document.createCDATASection(this.sig);
        element2.appendChild(cDATASection);
        element.appendChild(element2);
        return element;
    }

    public void loadXMLElement(Element element) throws SAXException {
        Element element2 = (Element)XMLTools.getChildElementsByTagName(element, "MyIdentity").iterator().next();
        this.person = new Identity(element2);
        this.sig = XMLTools.getChildElementsCDATAValue(element, "sig");
        assert (this.person != null && this.sig != null);
    }

    public String getSig() {
        return this.sig;
    }

    public int getType() {
        return 0;
    }
}

