/*
 * Decompiled with CFR 0.152.
 */
package frost.crypt;

import frost.XMLTools;
import frost.XMLizable;
import frost.crypt.EncryptMetaData;
import frost.crypt.SignMetaData;
import frost.identities.Identity;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class MetaData
implements XMLizable {
    private static Logger logger = Logger.getLogger(MetaData.class.getName());
    public static final int SIGN = 0;
    public static final int ENCRYPT = 1;
    Identity person;

    public abstract int getType();

    public Identity getPerson() {
        return this.person;
    }

    public Element getXMLElement(Document document) {
        Element element = document.createElement("FrostMetaData");
        Element element2 = this.person.getSafeXMLElement(document);
        element.appendChild(element2);
        return element;
    }

    public static MetaData getInstance(Element element) {
        if (element == null) {
            logger.log(Level.SEVERE, "MetaData.getInstance(): The provided XML element is null.");
            return null;
        }
        if (!element.getNodeName().equals("FrostMetaData")) {
            logger.log(Level.SEVERE, "MetaData.getInstance(): This is no FrostMetaData XML element.");
            return null;
        }
        try {
            if (XMLTools.getChildElementsByTagName(element, "Recipient").size() == 0) {
                return new SignMetaData(element);
            }
            return new EncryptMetaData(element);
        }
        catch (SAXException sAXException) {
            logger.log(Level.SEVERE, "Exception thrown in getInstance(byte [] body, Element e)", sAXException);
            return null;
        }
    }
}

