/*
 * Decompiled with CFR 0.152.
 */
package frost.crypt;

import frost.crypt.Crypt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.crypto.signers.PSSSigner;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

public final class FrostCrypt
implements Crypt {
    private static Logger logger = Logger.getLogger(FrostCrypt.class.getName());
    private PSSSigner signer;
    private SecureRandom secureRandom;
    private KeyGenerator keyGeneratorAES = null;

    public FrostCrypt() {
        Security.addProvider(new BouncyCastleProvider());
        this.signer = new PSSSigner(new RSAEngine(), new SHA1Digest(), 16);
        this.secureRandom = new SecureRandom();
    }

    public synchronized String[] generateKeys() {
        RSAKeyPairGenerator rSAKeyPairGenerator = new RSAKeyPairGenerator();
        rSAKeyPairGenerator.init(new RSAKeyGenerationParameters(new BigInteger("3490529510847650949147849619903898133417764638493387843990820577"), this.getSecureRandom(), 1024, 80));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = rSAKeyPairGenerator.generateKeyPair();
        RSAKeyParameters rSAKeyParameters = (RSAKeyParameters)asymmetricCipherKeyPair.getPublic();
        RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters = (RSAPrivateCrtKeyParameters)asymmetricCipherKeyPair.getPrivate();
        String[] stringArray = new String[2];
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(new String(Base64.encode(rSAKeyParameters.getExponent().toByteArray())));
        stringBuffer.append(":");
        stringBuffer.append(new String(Base64.encode(rSAKeyParameters.getModulus().toByteArray())));
        stringArray[1] = stringBuffer.toString();
        stringBuffer = new StringBuffer();
        stringBuffer.append(new String(Base64.encode(rSAPrivateCrtKeyParameters.getModulus().toByteArray())));
        stringBuffer.append(":");
        stringBuffer.append(new String(Base64.encode(rSAPrivateCrtKeyParameters.getPublicExponent().toByteArray())));
        stringBuffer.append(":");
        stringBuffer.append(new String(Base64.encode(rSAPrivateCrtKeyParameters.getExponent().toByteArray())));
        stringBuffer.append(":");
        stringBuffer.append(new String(Base64.encode(rSAPrivateCrtKeyParameters.getP().toByteArray())));
        stringBuffer.append(":");
        stringBuffer.append(new String(Base64.encode(rSAPrivateCrtKeyParameters.getQ().toByteArray())));
        stringBuffer.append(":");
        stringBuffer.append(new String(Base64.encode(rSAPrivateCrtKeyParameters.getDP().toByteArray())));
        stringBuffer.append(":");
        stringBuffer.append(new String(Base64.encode(rSAPrivateCrtKeyParameters.getDQ().toByteArray())));
        stringBuffer.append(":");
        stringBuffer.append(new String(Base64.encode(rSAPrivateCrtKeyParameters.getQInv().toByteArray())));
        stringArray[0] = stringBuffer.toString();
        return stringArray;
    }

    public synchronized String digest(String string) {
        SHA1Digest sHA1Digest = new SHA1Digest();
        sHA1Digest.reset();
        byte[] byArray = string.getBytes();
        sHA1Digest.update(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[64];
        sHA1Digest.doFinal(byArray2, 0);
        return new String(Base64.encode(byArray2)).substring(0, 27);
    }

    public synchronized String digest(File file) {
        SHA1Digest sHA1Digest = new SHA1Digest();
        byte[] byArray = new byte[64];
        FileChannel fileChannel = null;
        try {
            fileChannel = new FileInputStream(file).getChannel();
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Exception thrown in digest(File file)", iOException);
        }
        byte[] byArray2 = new byte[32768];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
        try {
            while (true) {
                int n = byteBuffer.position();
                int n2 = fileChannel.read(byteBuffer);
                if (n2 == -1) break;
                sHA1Digest.update(byArray2, n, n2);
                if (byteBuffer.remaining() != 0) continue;
                byteBuffer.position(0);
            }
            fileChannel.close();
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Exception thrown in digest(File file)", iOException);
        }
        sHA1Digest.doFinal(byArray, 0);
        return new String(Base64.encode(byArray)).substring(0, 27);
    }

    public synchronized byte[] encrypt(byte[] byArray, String string) {
        Object object;
        Object object2;
        Object object3;
        byte[] byArray2 = null;
        Cipher cipher = null;
        Cipher cipher2 = null;
        int n = 0;
        int n2 = 0;
        byArray2 = this.generateAESSessionKey();
        if (byArray2 == null) {
            return null;
        }
        cipher = this.buildCipherAES(1, byArray2);
        if (cipher == null) {
            return null;
        }
        try {
            object3 = new StringTokenizer(string, ":");
            object2 = new BigInteger(Base64.decode(((StringTokenizer)object3).nextToken()));
            object = new BigInteger(Base64.decode(((StringTokenizer)object3).nextToken()));
            RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec((BigInteger)object, (BigInteger)object2);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
            PublicKey publicKey = keyFactory.generatePublic(rSAPublicKeySpec);
            cipher2 = Cipher.getInstance("RSA/ECB/PKCS1Padding", "BC");
            cipher2.init(1, publicKey);
            n = cipher2.getBlockSize();
            n2 = cipher2.getOutputSize(n);
            if (n != 117 || n2 != 128) {
                throw new Exception("block size invalid, inSize=" + n + "; outSize=" + n2);
            }
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "Error in encrypt, RSA preparation", throwable);
            return null;
        }
        object3 = null;
        try {
            object2 = new byte[n];
            object = new byte[n - byArray2.length];
            this.getSecureRandom().nextBytes((byte[])object);
            System.arraycopy(byArray2, 0, object2, 0, byArray2.length);
            System.arraycopy(object, 0, object2, byArray2.length, ((Object)object).length);
            object3 = cipher2.doFinal((byte[])object2, 0, ((Object)object2).length);
            if (((Object)object3).length != n2) {
                throw new Exception("RSA out block size invalid: " + ((Object)object3).length);
            }
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "Error in encrypt, RSA encryption", throwable);
            return null;
        }
        object2 = new ByteArrayOutputStream(byArray.length + byArray.length / 10 + ((Object)object3).length);
        try {
            ((OutputStream)object2).write((byte[])object3);
            object = new CipherOutputStream((OutputStream)object2, cipher);
            ((CipherOutputStream)object).write(byArray);
            ((CipherOutputStream)object).close();
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Error in encrypt, AES encryption", iOException);
            return null;
        }
        return ((ByteArrayOutputStream)object2).toByteArray();
    }

    public synchronized byte[] decrypt(byte[] byArray, String string) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Cipher cipher = null;
        Cipher cipher2 = null;
        int n = 0;
        int n2 = 0;
        try {
            object4 = new StringTokenizer(string, ":");
            object3 = new RSAPrivateCrtKeySpec(new BigInteger(Base64.decode(((StringTokenizer)object4).nextToken())), new BigInteger(Base64.decode(((StringTokenizer)object4).nextToken())), new BigInteger(Base64.decode(((StringTokenizer)object4).nextToken())), new BigInteger(Base64.decode(((StringTokenizer)object4).nextToken())), new BigInteger(Base64.decode(((StringTokenizer)object4).nextToken())), new BigInteger(Base64.decode(((StringTokenizer)object4).nextToken())), new BigInteger(Base64.decode(((StringTokenizer)object4).nextToken())), new BigInteger(Base64.decode(((StringTokenizer)object4).nextToken())));
            object2 = KeyFactory.getInstance("RSA", "BC");
            object = ((KeyFactory)object2).generatePrivate((KeySpec)object3);
            cipher2 = Cipher.getInstance("RSA/ECB/PKCS1Padding", "BC");
            cipher2.init(2, (Key)object);
            n = cipher2.getBlockSize();
            n2 = cipher2.getOutputSize(n);
            if (n != 128 || n2 != 117) {
                throw new Exception("RSA decryption block size invalid, inSize=" + n + "; outSize=" + n2);
            }
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "Error in decrypt, RSA preparation", throwable);
            return null;
        }
        object4 = null;
        try {
            object3 = cipher2.doFinal(byArray, 0, n);
            if (object3 == null) {
                throw new Exception("RSA decryption failed, sessionKeyBytes = null");
            }
            if (((Object)object3).length != n2) {
                throw new Exception("RSA decryption failed, sessionKeyBytes.length = " + ((Object)object3).length + ", must be " + n2);
            }
            object4 = new byte[16];
            System.arraycopy(object3, 0, object4, 0, ((Object)object4).length);
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "Error in decrypt, RSA decryption", throwable);
            return null;
        }
        cipher = this.buildCipherAES(2, (byte[])object4);
        if (cipher == null) {
            return null;
        }
        object3 = new ByteArrayOutputStream(byArray.length - n);
        object2 = new ByteArrayInputStream(byArray, n, byArray.length - n);
        object = new CipherInputStream((InputStream)object2, cipher);
        try {
            int n3;
            byte[] byArray2 = new byte[1024];
            while ((n3 = ((CipherInputStream)object).read(byArray2)) >= 0) {
                ((ByteArrayOutputStream)object3).write(byArray2, 0, n3);
            }
            ((CipherInputStream)object).close();
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "Error in decrypt, AES decryption", throwable);
            return null;
        }
        return ((ByteArrayOutputStream)object3).toByteArray();
    }

    public synchronized String detachedSign(String string, String string2) {
        return this.detachedSign(string.getBytes(), string2);
    }

    public synchronized String detachedSign(byte[] byArray, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters = new RSAPrivateCrtKeyParameters(new BigInteger(Base64.decode(stringTokenizer.nextToken())), new BigInteger(Base64.decode(stringTokenizer.nextToken())), new BigInteger(Base64.decode(stringTokenizer.nextToken())), new BigInteger(Base64.decode(stringTokenizer.nextToken())), new BigInteger(Base64.decode(stringTokenizer.nextToken())), new BigInteger(Base64.decode(stringTokenizer.nextToken())), new BigInteger(Base64.decode(stringTokenizer.nextToken())), new BigInteger(Base64.decode(stringTokenizer.nextToken())));
        this.signer.init(true, rSAPrivateCrtKeyParameters);
        this.signer.update(byArray, 0, byArray.length);
        byte[] byArray2 = null;
        try {
            byArray2 = this.signer.generateSignature();
        }
        catch (CryptoException cryptoException) {
            logger.log(Level.SEVERE, "Exception thrown in detachedSign(String message, String key)", cryptoException);
        }
        this.signer.reset();
        String string2 = new String(Base64.encode(byArray2));
        return string2;
    }

    public synchronized boolean detachedVerify(String string, String string2, String string3) {
        return this.detachedVerify(string.getBytes(), string2, string3);
    }

    public synchronized boolean detachedVerify(byte[] byArray, String string, String string2) {
        byte[] byArray2 = Base64.decode(string2.getBytes());
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        BigInteger bigInteger = new BigInteger(Base64.decode(stringTokenizer.nextToken()));
        BigInteger bigInteger2 = new BigInteger(Base64.decode(stringTokenizer.nextToken()));
        this.signer.init(false, new RSAKeyParameters(true, bigInteger2, bigInteger));
        this.signer.update(byArray, 0, byArray.length);
        boolean bl = this.signer.verifySignature(byArray2);
        this.signer.reset();
        return bl;
    }

    private synchronized SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    public String decode64(String string) {
        return new String(Base64.decode(string.getBytes()));
    }

    public String encode64(String string) {
        return new String(Base64.encode(string.getBytes()));
    }

    private byte[] generateAESSessionKey() {
        if (this.keyGeneratorAES == null) {
            try {
                this.keyGeneratorAES = KeyGenerator.getInstance("AES");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                logger.log(Level.SEVERE, "Could not get a KeyGenerator for AES.", noSuchAlgorithmException);
                return null;
            }
            this.keyGeneratorAES.init(128);
        }
        SecretKey secretKey = this.keyGeneratorAES.generateKey();
        byte[] byArray = secretKey.getEncoded();
        return byArray;
    }

    private Cipher buildCipherAES(int n, byte[] byArray) {
        Cipher cipher = null;
        try {
            if (byArray == null) {
                return null;
            }
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
            cipher = Cipher.getInstance("AES", "BC");
            cipher.init(n, secretKeySpec);
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "Error in AES preparation", throwable);
            return null;
        }
        return cipher;
    }
}

