/*
 * Decompiled with CFR 0.152.
 */
package frost.crypt;

import frost.XMLTools;
import frost.crypt.SignMetaData;
import frost.identities.LocalIdentity;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class EncryptMetaData
extends SignMetaData {
    private static Logger logger = Logger.getLogger(EncryptMetaData.class.getName());
    String recipient;

    public EncryptMetaData(Element element) throws SAXException {
        try {
            this.loadXMLElement(element);
        }
        catch (SAXException sAXException) {
            logger.log(Level.SEVERE, "Exception thrown in constructor", sAXException);
            throw sAXException;
        }
    }

    public EncryptMetaData(byte[] byArray, LocalIdentity localIdentity, String string) {
        super(byArray, localIdentity);
        assert (string != null);
        this.recipient = string;
    }

    public Element getXMLElement(Document document) {
        Element element = super.getXMLElement(document);
        if (this.recipient == null) {
            logger.log(Level.SEVERE, "getXMLElement: recipient is null, this is not allowed!");
            return null;
        }
        Element element2 = document.createElement("Recipient");
        CDATASection cDATASection = document.createCDATASection(this.recipient);
        element2.appendChild(cDATASection);
        element.appendChild(element2);
        return element;
    }

    public void loadXMLElement(Element element) throws SAXException {
        super.loadXMLElement(element);
        if (XMLTools.getChildElementsByTagName(element, "Recipient").size() > 0) {
            this.recipient = XMLTools.getChildElementsCDATAValue(element, "Recipient");
        }
        assert (this.recipient != null && this.recipient.length() > 0);
    }

    public String getRecipient() {
        return this.recipient;
    }

    public int getType() {
        return 1;
    }
}

