/*
 * Decompiled with CFR 0.152.
 */
package frost.components.translate;

import frost.components.translate.LanguageFile;
import frost.components.translate.TranslateTableModel;
import frost.components.translate.TranslateTableSorter;
import frost.components.translate.WriteAccess;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;

public class TranslatePanel
extends JPanel {
    static ResourceBundle LangRes = ResourceBundle.getBundle("res.LangRes");
    JFrame parent;
    JPanel contentPanel;
    TranslateTableModel tableModel = new TranslateTableModel();
    JTable table = new JTable(this.tableModel);
    JScrollPane scrollPane = new JScrollPane(this.table);
    JToolBar toolBar = new JToolBar();
    JComboBox comboBox = new JComboBox();
    JButton saveButton = new JButton("Save translation");
    JButton loadButton = new JButton("Load translation from file");

    public TranslatePanel(JFrame jFrame) {
        this.parent = jFrame;
        this.init();
    }

    private void init() {
        TranslateTableSorter.addMouseListenerToHeaderInTable(this.table);
        this.generateComboBox();
        this.comboBox.setMaximumRowCount(25);
        this.toolBar.add(this.comboBox);
        this.toolBar.add(this.saveButton);
        this.toolBar.add(this.loadButton);
        this.contentPanel = this;
        this.contentPanel.setLayout(new BorderLayout());
        this.contentPanel.add((Component)this.toolBar, "North");
        this.contentPanel.add((Component)this.scrollPane, "Center");
        this.generateButtonListeners();
        this.generateComboBoxListeners();
        this.configureTable("en");
        for (int i = 0; i < this.comboBox.getItemCount(); ++i) {
            if (!((String)this.comboBox.getItemAt(i)).equals("English (en)")) continue;
            this.comboBox.setSelectedIndex(i);
            break;
        }
        JOptionPane.showMessageDialog(this.parent, "1. Select the language you want to translate.\n2. Translate each row of the table.\n3. Save your translation\n4. Send us the saved 'LangRes_xx.java'  file in your Frost directory\n   or upload it with frost.\n\nThank you!", "Instructions", -1);
    }

    private void configureTable(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("res.LangRes", new Locale("en"));
        ResourceBundle resourceBundle2 = ResourceBundle.getBundle("res.LangRes", new Locale(this.getSelectedLanguageCode()));
        this.tableModel.setRowCount(0);
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            Object[] objectArray = new String[]{string2, resourceBundle2.getString(string2)};
            this.tableModel.addRow(objectArray);
        }
        TranslateTableSorter.sortByColumn(this.table, 0, true);
    }

    private void generateComboBox() {
        Locale locale = LangRes.getLocale();
        Locale[] localeArray = Locale.getAvailableLocales();
        for (int i = 0; i < localeArray.length; ++i) {
            this.comboBox.addItem(localeArray[i].getDisplayName() + " (" + localeArray[i].getLanguage() + ")");
        }
    }

    private void generateComboBoxListeners() {
        this.comboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                TranslatePanel.this.configureTable((String)TranslatePanel.this.comboBox.getSelectedItem());
            }
        });
    }

    private String getSelectedLanguageCode() {
        String string = (String)this.comboBox.getSelectedItem();
        String string2 = string.substring(string.length() - 3, string.length() - 1);
        return string2;
    }

    private void generateButtonListeners() {
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = TranslatePanel.this.getSelectedLanguageCode();
                String string2 = LanguageFile.generateFile(TranslatePanel.this.tableModel, string);
                if (string.equals("en")) {
                    WriteAccess.writeFile(string2, new File("LangRes.java"));
                } else {
                    WriteAccess.writeFile(string2, new File("LangRes_" + string + ".java"));
                }
            }
        });
        this.loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TranslatePanel.this.loadLanguageFile();
            }
        });
    }

    private void loadLanguageFile() {
        File file;
        JFileChooser jFileChooser = new JFileChooser(new File("."));
        jFileChooser.setDialogTitle("Select " + this.getSelectedLanguageCode() + " language file");
        jFileChooser.setFileHidingEnabled(true);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0 && (file = jFileChooser.getSelectedFile()) != null && !file.isDirectory()) {
            LanguageFile.readLanguageFile(this.tableModel, file);
        }
    }
}

