/*
 * Decompiled with CFR 0.152.
 */
package frost.components.translate;

import frost.components.translate.ReadAccess;
import frost.components.translate.TranslateTableModel;
import java.io.File;
import java.util.logging.Logger;

public class LanguageFile {
    private static Logger logger = Logger.getLogger(LanguageFile.class.getName());

    public static String generateFile(TranslateTableModel translateTableModel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = translateTableModel.getRowCount();
        stringBuffer.append("/**\n");
        stringBuffer.append(" * Language file for Frost\n");
        stringBuffer.append(" *\n");
        stringBuffer.append(" * This file has been created automatically.\n");
        stringBuffer.append(" * Do NOT edit unless you REALLY know what you're doing!\n");
        stringBuffer.append(" *\n");
        stringBuffer.append(" * Language: " + string + "\n");
        stringBuffer.append(" */\n\n");
        stringBuffer.append("package res;\n\n");
        stringBuffer.append("import java.util.ListResourceBundle;\n\n");
        if (string.equals("en")) {
            stringBuffer.append("public class LangRes extends ListResourceBundle {\n\n");
        } else {
            stringBuffer.append("public class LangRes_" + string + " extends ListResourceBundle {\n\n");
        }
        stringBuffer.append("public Object[][] getContents() {\n");
        stringBuffer.append("    return contents;\n");
        stringBuffer.append("}\n\n");
        stringBuffer.append("static final Object[][] contents = {\n");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("{\"" + LanguageFile.replaceSpecialCharacters(new StringBuffer((String)translateTableModel.getValueAt(i, 0))) + "\",");
            stringBuffer.append("\"" + LanguageFile.replaceSpecialCharacters(new StringBuffer((String)translateTableModel.getValueAt(i, 1))) + "\"},");
            stringBuffer.append("\n");
        }
        stringBuffer.append("};\n");
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    private static StringBuffer replaceSpecialCharacters(StringBuffer stringBuffer) {
        int n;
        while (stringBuffer.indexOf("\n") != -1) {
            n = stringBuffer.indexOf("\n");
            stringBuffer.replace(n, n + 1, "\\n");
        }
        while (stringBuffer.indexOf("\r") != -1) {
            n = stringBuffer.indexOf("\r");
            stringBuffer.replace(n, n + 1, "\\r");
        }
        return stringBuffer;
    }

    public static TranslateTableModel readLanguageFile(TranslateTableModel translateTableModel, File file) {
        String string = ReadAccess.readFile(file);
        String string2 = new String();
        String string3 = new String();
        int n = 0;
        int[] nArray = new int[]{0, 0, 0, 0};
        translateTableModel.setRowCount(0);
        while (n != -1) {
            for (int i = 0; i < 4; ++i) {
                nArray[i] = string.indexOf("\"", n + 1);
                n = nArray[i];
                if (n == -1) break;
            }
            if (nArray[0] == -1 || nArray[1] == -1 || nArray[2] == -1 || nArray[3] == -1) continue;
            Object[] objectArray = new String[]{new String(string.substring(nArray[0] + 1, nArray[1])), new String(string.substring(nArray[2] + 1, nArray[3]))};
            translateTableModel.addRow(objectArray);
            logger.info((String)objectArray[0] + " --- " + (String)objectArray[1]);
        }
        return translateTableModel;
    }
}

