/*
 * Decompiled with CFR 0.152.
 */
package frost.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class Browser
extends JPanel {
    private static Logger logger = Logger.getLogger(Browser.class.getName());
    String[] imageExtensions = new String[]{".jpg", ".gif", ".jpeg", ".png", ".bmp"};
    JFrame parent;
    JPanel contentPanel;
    JPanel buttonPanel = new JPanel(new FlowLayout(0));
    JButton backButton = new JButton("<");
    JButton forwardButton = new JButton(">");
    JButton homeButton = new JButton("~");
    JButton addPageButton = new JButton(": )");
    JButton removePageButton = new JButton(": (");
    JEditorPane editorPane = new JEditorPane();
    JComboBox urlComboBox = new JComboBox();
    JComboBox favComboBox = new JComboBox();
    JScrollPane scrollPane = new JScrollPane(this.editorPane);

    private void init() {
        this.urlComboBox.setEditable(true);
        this.editorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                Browser.this.parent.setTitle(hyperlinkEvent.getURL().toString());
                Browser.this.hyperlink_actionPerformed(hyperlinkEvent);
            }
        });
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = Browser.this.urlComboBox.getSelectedIndex();
                if (n > 0) {
                    Browser.this.urlComboBox.setSelectedIndex(--n);
                }
            }
        });
        this.forwardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = Browser.this.urlComboBox.getSelectedIndex();
                if (n < Browser.this.urlComboBox.getItemCount() - 1) {
                    Browser.this.urlComboBox.setSelectedIndex(++n);
                }
            }
        });
        this.homeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Browser.this.editorPane.setText(Browser.this.makeStartPage());
            }
        });
        this.addPageButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = Browser.this.editorPane.getPage().toString();
                boolean bl = false;
                for (int i = 0; i < Browser.this.favComboBox.getItemCount(); ++i) {
                    if (!((String)Browser.this.favComboBox.getItemAt(i)).equals(string)) continue;
                    bl = true;
                    Browser.this.favComboBox.setSelectedItem(string);
                }
                if (!bl) {
                    Browser.this.favComboBox.addItem(string);
                    Browser.this.favComboBox.setSelectedItem(string);
                    Browser.this.writeSettings(new File("browser.ini"));
                }
            }
        });
        this.removePageButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Browser.this.favComboBox.removeItem(Browser.this.editorPane.getPage().toString());
                Browser.this.writeSettings(new File("browser.ini"));
            }
        });
        this.urlComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Browser.this.setPage((String)Browser.this.urlComboBox.getSelectedItem());
            }
        });
        this.favComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Browser.this.setPage((String)Browser.this.favComboBox.getSelectedItem());
            }
        });
        this.contentPanel = this;
        this.contentPanel.setLayout(new BorderLayout());
        this.buttonPanel.add(this.backButton);
        this.buttonPanel.add(this.forwardButton);
        this.buttonPanel.add(this.homeButton);
        this.buttonPanel.add(this.addPageButton);
        this.buttonPanel.add(this.removePageButton);
        this.buttonPanel.add(this.favComboBox);
        this.editorPane.setEditable(false);
        this.contentPanel.add((Component)this.scrollPane, "Center");
        this.contentPanel.add((Component)this.buttonPanel, "North");
        this.contentPanel.add((Component)this.urlComboBox, "South");
        this.readSettings(new File("browser.ini"));
        this.setPage("http://localhost:8888");
    }

    String makeStartPage() {
        String string = new String();
        string = "<html><body>";
        for (int i = 0; i < this.favComboBox.getItemCount(); ++i) {
            string = string + "<a href=\"" + (String)this.favComboBox.getItemAt(i) + "\">" + (String)this.favComboBox.getItemAt(i) + "</a><br>";
        }
        string = string + "</body></html>";
        return string;
    }

    void setPage(String string) {
        if (string != null) {
            int n;
            if (!string.startsWith("http://")) {
                string = "http://" + string;
            }
            boolean bl = false;
            for (n = 0; n < this.urlComboBox.getItemCount(); ++n) {
                if (!((String)this.urlComboBox.getItemAt(n)).equals(string)) continue;
                bl = true;
                this.urlComboBox.setSelectedItem(string);
            }
            if (!bl) {
                n = this.urlComboBox.getSelectedIndex();
                n = n == -1 || this.urlComboBox.getItemCount() == 0 ? 0 : ++n;
                this.urlComboBox.insertItemAt(string, n);
                this.urlComboBox.setSelectedItem(string);
            }
            n = 0;
            for (int i = 0; i < this.imageExtensions.length; ++i) {
                if (!string.endsWith(this.imageExtensions[i])) continue;
                n = 1;
            }
            try {
                if (n != 0) {
                    String string2 = "<html><img src=\"" + string + "\"></html>";
                    this.editorPane.setText(string2);
                } else {
                    this.editorPane.setPage(string);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    void hyperlink_actionPerformed(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.setPage(hyperlinkEvent.getURL().toString());
        }
    }

    void readSettings(File file) {
        Vector vector = this.readLines(file);
        for (int i = 0; i < vector.size(); ++i) {
            this.favComboBox.addItem((String)vector.elementAt(i));
        }
    }

    void writeSettings(File file) {
        String string = new String();
        for (int i = 0; i < this.favComboBox.getItemCount(); ++i) {
            string = string + (String)this.favComboBox.getItemAt(i) + "\r\n";
        }
        this.writeFile(string, file);
    }

    Vector readLines(File file) {
        return this.readLines(file.getPath());
    }

    Vector readLines(String string) {
        String string2 = "";
        Vector<String> vector = new Vector<String>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                vector.add(string2.trim());
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Read Error: " + string, iOException);
        }
        return vector;
    }

    void writeFile(String string, File file) {
        this.writeFile(string, file.getPath());
    }

    void writeFile(String string, String string2) {
        try {
            FileWriter fileWriter = new FileWriter(string2);
            fileWriter.write(string);
            fileWriter.close();
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Write Error: " + string2, iOException);
        }
    }

    public Browser(JFrame jFrame) {
        this.parent = jFrame;
        this.init();
    }
}

