/*
 * Decompiled with CFR 0.152.
 */
package frost.boards;

import frost.Mixed;
import frost.XMLTools;
import frost.boards.TofTree;
import frost.boards.TofTreeModel;
import frost.gui.objects.Board;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TofTreeXmlIO {
    private static Logger logger = Logger.getLogger(TofTreeXmlIO.class.getName());

    public boolean loadBoardTree(TofTree tofTree, TofTreeModel tofTreeModel, String string) {
        Document document = null;
        try {
            document = XMLTools.parseXmlFile(string, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (document == null) {
            logger.severe("Error - loadBoardTree: could'nt parse XML Document.");
            return false;
        }
        Element element = document.getDocumentElement();
        if (!element.getTagName().equals("FrostBoardTree")) {
            logger.severe("Error - boards.xml invalid: does not contain the root tag 'FrostBoardTree'");
            return false;
        }
        ArrayList arrayList = XMLTools.getChildElementsByTagName(element, "FrostBoardTreeEntry");
        if (arrayList.size() != 1) {
            logger.severe("Error - boards.xml invalid: first element must be the one and only root folder (" + arrayList.size() + ")");
            return false;
        }
        Element element2 = (Element)arrayList.get(0);
        String string2 = element2.getTagName();
        if (string2 == null || !string2.equals("FrostBoardTreeEntry")) {
            logger.severe("Error - boards.xml invalid: first element must the root folder");
            return false;
        }
        String string3 = this.getName(element2);
        boolean bl = this.isFolder(element2);
        if (!bl) {
            logger.severe("Error - boards.xml invalid: first element must be a folder (the root folder)");
            return false;
        }
        Board board = new Board(string3, true);
        tofTreeModel.setRoot(board);
        this.loadProcessFolder(element2, board, tofTree, tofTreeModel);
        this.refreshModel(tofTreeModel, board);
        tofTree.updateUI();
        logger.info("Board tree loaded successfully.");
        return true;
    }

    private void loadProcessFolder(Element element, Board board, JTree jTree, DefaultTreeModel defaultTreeModel) {
        ArrayList arrayList = XMLTools.getChildElementsByTagName(element, "FrostBoardTreeEntry");
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object;
            String string = null;
            boolean bl = false;
            Element element2 = (Element)arrayList.get(i);
            string = this.getName(element2);
            if (string == null) continue;
            bl = this.isFolder(element2);
            if (!bl) {
                Text text;
                String string2 = this.getPublicKey(element2);
                object = this.getPrivateKey(element2);
                String string3 = this.getDescription(element2);
                Board board2 = new Board(string, string2, (String)object, string3);
                this.getBoardConfiguration(element2, board2);
                ArrayList arrayList2 = XMLTools.getChildElementsByTagName(element2, "lastUpdateStartedMillis");
                if (arrayList2.size() > 0 && (text = (Text)((Node)arrayList2.get(0)).getFirstChild()) != null) {
                    long l = -1L;
                    try {
                        l = Long.parseLong(text.getData().trim());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (l > 0L) {
                        board2.setLastUpdateStartMillis(l);
                    }
                }
                board.add(board2);
                continue;
            }
            boolean bl2 = this.isExpanded(element2);
            object = new Board(string, true);
            board.add((MutableTreeNode)object);
            this.loadProcessFolder(element2, (Board)object, jTree, defaultTreeModel);
            this.refreshModel(defaultTreeModel, (Board)object);
            if (!bl2) continue;
            jTree.expandPath(new TreePath(defaultTreeModel.getPathToRoot((TreeNode)object)));
        }
    }

    private void getBoardConfiguration(Element element, Board board) {
        ArrayList arrayList = XMLTools.getChildElementsByTagName(element, "config");
        if (arrayList.size() == 0) {
            board.setConfigured(false);
            return;
        }
        board.setConfigured(true);
        element = (Element)arrayList.get(0);
        String string = element.getAttribute("autoUpdate");
        board.setAutoUpdateEnabled(Boolean.valueOf(string));
        string = element.getAttribute("maxMessageDisplay");
        if (string.length() == 0) {
            board.setMaxMessageDays(null);
        } else {
            board.setMaxMessageDays(new Integer(string));
        }
        string = element.getAttribute("showSignedOnly");
        if (string.length() == 0) {
            board.setShowSignedOnly(null);
        } else {
            board.setShowSignedOnly(Boolean.valueOf(string));
        }
        string = element.getAttribute("hideBadMessages");
        if (string.length() == 0) {
            board.setHideBad(null);
        } else {
            board.setHideBad(Boolean.valueOf(string));
        }
        string = element.getAttribute("hideCheckMessages");
        if (string.length() == 0) {
            board.setHideCheck(null);
        } else {
            board.setHideCheck(Boolean.valueOf(string));
        }
        string = element.getAttribute("hideObserveMessages");
        if (string.length() == 0) {
            board.setHideObserve(null);
        } else {
            board.setHideObserve(Boolean.valueOf(string));
        }
    }

    private void refreshModel(DefaultTreeModel defaultTreeModel, Board board) {
        int[] nArray = new int[board.getChildCount()];
        for (int i = 0; i < board.getChildCount(); ++i) {
            nArray[i] = i;
        }
        defaultTreeModel.nodesWereInserted(board, nArray);
    }

    private boolean isFolder(Element element) {
        String string = element.getAttribute("isfolder");
        return string != null && string.toLowerCase().equals("true");
    }

    private boolean isExpanded(Element element) {
        String string = element.getAttribute("isexpanded");
        return string != null && string.toLowerCase().equals("true");
    }

    private String getName(Element element) {
        ArrayList arrayList = XMLTools.getChildElementsByTagName(element, "name");
        if (arrayList.size() != 1) {
            logger.severe("Error - boards.xml invalid: there must be 1 <name> tag for each entry");
            return null;
        }
        Text text = (Text)((Node)arrayList.get(0)).getFirstChild();
        if (text == null) {
            return null;
        }
        return text.getData().trim();
    }

    private String getPublicKey(Element element) {
        ArrayList arrayList = XMLTools.getChildElementsByTagName(element, "publicKey");
        if (arrayList.size() > 1) {
            logger.severe("Error - boards.xml invalid: there should be a maximum of 1 <publicKey> tag for each entry");
            return null;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        Text text = (Text)((Node)arrayList.get(0)).getFirstChild();
        if (text == null) {
            return null;
        }
        return text.getData().trim();
    }

    private String getDescription(Element element) {
        ArrayList arrayList = XMLTools.getChildElementsByTagName(element, "description");
        if (arrayList.size() > 1) {
            logger.severe("Error - boards.xml invalid: there should be a maximum of 1 <description> tag for each entry");
            return null;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        Text text = (Text)((Node)arrayList.get(0)).getFirstChild();
        if (text == null) {
            return null;
        }
        return text.getData().trim();
    }

    private String getPrivateKey(Element element) {
        ArrayList arrayList = XMLTools.getChildElementsByTagName(element, "privateKey");
        if (arrayList.size() > 1) {
            logger.severe("Error - boards.xml invalid: there should be a maximum of 1 <privateKey> tag for each entry");
            return null;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        Text text = (Text)((Node)arrayList.get(0)).getFirstChild();
        if (text == null) {
            return null;
        }
        return text.getData().trim();
    }

    public boolean saveBoardTree(TofTree tofTree, TofTreeModel tofTreeModel, String string) {
        Document document = XMLTools.createDomDocument();
        if (document == null) {
            logger.severe("Error - saveBoardTree: factory could'nt create XML Document.");
            return false;
        }
        Board board = (Board)tofTreeModel.getRoot();
        Element element = document.createElement("FrostBoardTree");
        document.appendChild(element);
        Element element2 = document.createElement("FrostBoardTreeEntry");
        element2.setAttribute("isfolder", "true");
        element2.setAttribute("isexpanded", "true");
        Element element3 = document.createElement("name");
        Text text = document.createTextNode(board.getName());
        element3.appendChild(text);
        element2.appendChild(element3);
        element.appendChild(element2);
        this.saveProcessFolder(element2, board, document, tofTreeModel, tofTree);
        boolean bl = false;
        try {
            bl = XMLTools.writeXmlFile(document, string);
            logger.info("Board tree saved successfully.");
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "Exception - saveBoardTree:\nERROR saving board tree.", throwable);
        }
        return bl;
    }

    private void saveProcessFolder(Element element, Board board, Document document, DefaultTreeModel defaultTreeModel, JTree jTree) {
        for (int i = 0; i < board.getChildCount(); ++i) {
            Board board2 = (Board)board.getChildAt(i);
            if (!board2.isFolder()) {
                this.appendBoard(element, board2, document);
                continue;
            }
            Element element2 = this.appendFolder(element, board2, document, defaultTreeModel, jTree);
            this.saveProcessFolder(element2, board2, document, defaultTreeModel, jTree);
        }
    }

    private void appendBoard(Element element, Board board, Document document) {
        Element element2 = document.createElement("FrostBoardTreeEntry");
        Element element3 = document.createElement("name");
        CDATASection cDATASection = document.createCDATASection(Mixed.makeSafeXML(board.getName()));
        element3.appendChild(cDATASection);
        element2.appendChild(element3);
        if (board.getPublicKey() != null) {
            element3 = document.createElement("publicKey");
            cDATASection = document.createCDATASection(Mixed.makeSafeXML(board.getPublicKey()));
            element3.appendChild(cDATASection);
            element2.appendChild(element3);
        }
        if (board.getPrivateKey() != null) {
            element3 = document.createElement("privateKey");
            cDATASection = document.createCDATASection(Mixed.makeSafeXML(board.getPrivateKey()));
            element3.appendChild(cDATASection);
            element2.appendChild(element3);
        }
        if (board.getDescription() != null) {
            element3 = document.createElement("description");
            cDATASection = document.createCDATASection(Mixed.makeSafeXML(board.getDescription()));
            element3.appendChild(cDATASection);
            element2.appendChild(element3);
        }
        if (board.isConfigured()) {
            element3 = document.createElement("config");
            element3.setAttribute("autoUpdate", "" + board.getAutoUpdateEnabled());
            if (board.getMaxMessageDisplayObj() != null) {
                element3.setAttribute("maxMessageDisplay", "" + board.getMaxMessageDisplay());
            }
            if (board.getShowSignedOnlyObj() != null) {
                element3.setAttribute("showSignedOnly", "" + board.getShowSignedOnly());
            }
            if (board.getHideBadObj() != null) {
                element3.setAttribute("hideBadMessages", "" + board.getHideBad());
            }
            if (board.getHideCheckObj() != null) {
                element3.setAttribute("hideCheckMessages", "" + board.getHideCheck());
            }
            if (board.getHideObserveObj() != null) {
                element3.setAttribute("hideObserveMessages", "" + board.getHideObserve());
            }
            element2.appendChild(element3);
        }
        if (board.getLastUpdateStartMillis() > 0L) {
            element3 = document.createElement("lastUpdateStartedMillis");
            Text text = document.createTextNode("" + board.getLastUpdateStartMillis());
            element3.appendChild(text);
            element2.appendChild(element3);
        }
        element.appendChild(element2);
    }

    private Element appendFolder(Element element, Board board, Document document, DefaultTreeModel defaultTreeModel, JTree jTree) {
        Element element2 = document.createElement("FrostBoardTreeEntry");
        element2.setAttribute("isfolder", "true");
        boolean bl = jTree.isExpanded(new TreePath(defaultTreeModel.getPathToRoot(board)));
        String string = bl ? "true" : "false";
        element2.setAttribute("isexpanded", string);
        Element element3 = document.createElement("name");
        Text text = document.createTextNode(board.getName());
        element3.appendChild(text);
        element2.appendChild(element3);
        element.appendChild(element2);
        return element2;
    }
}

