/*
 * Decompiled with CFR 0.152.
 */
package frost.boards;

import frost.gui.objects.Board;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class TofTreeModel
extends DefaultTreeModel {
    private static Logger logger = Logger.getLogger(TofTreeModel.class.getName());
    private DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();

    public TofTreeModel(TreeNode treeNode) {
        super(treeNode);
    }

    public void addNodeToTree(Board board) {
        Board board2 = this.getSelectedNode();
        if (!board2.isFolder()) {
            board2 = (Board)board2.getParent();
        }
        this.addNodeToTree(board, board2);
    }

    public void addNodeToTree(Board board, Board board2) {
        board2.add(board);
        int[] nArray = new int[]{board2.getChildCount() - 1};
        this.nodesWereInserted(board2, nArray);
    }

    public Vector getAllBoards() {
        Board board = (Board)this.getRoot();
        Vector<Board> vector = new Vector<Board>();
        Enumeration<TreeNode> enumeration = board.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            Board board2 = (Board)enumeration.nextElement();
            if (board2.isFolder()) continue;
            vector.add(board2);
        }
        return vector;
    }

    public Board getBoardByName(String string) {
        Board board = (Board)this.getRoot();
        Enumeration<TreeNode> enumeration = board.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            Board board2 = (Board)enumeration.nextElement();
            if (board2.getName().compareToIgnoreCase(string) != 0) continue;
            return board2;
        }
        return null;
    }

    public Board getSelectedNode() {
        Board board;
        TreePath treePath = this.selectionModel.getSelectionPath();
        if (treePath != null) {
            board = (Board)treePath.getLastPathComponent();
        } else {
            board = (Board)this.getRoot();
            this.selectionModel.setSelectionPath(new TreePath(board));
        }
        return board;
    }

    TreeSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void removeNode(Board board) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)board.getParent();
        if (board != null && defaultMutableTreeNode != null) {
            int[] nArray = new int[]{defaultMutableTreeNode.getIndex(board)};
            Object[] objectArray = new Object[]{board};
            board.removeFromParent();
            TreePath treePath = new TreePath(this.getPathToRoot(defaultMutableTreeNode));
            this.nodesWereRemoved(defaultMutableTreeNode, nArray, objectArray);
            this.selectionModel.setSelectionPath(treePath);
        }
    }
}

