/*
 * Decompiled with CFR 0.152.
 */
package frost.boards;

import frost.Core;
import frost.MainFrame;
import frost.SettingsClass;
import frost.boards.BoardSettingsFrame;
import frost.boards.TOF;
import frost.boards.TofTreeModel;
import frost.boards.TofTreeXmlIO;
import frost.gui.NewBoardDialog;
import frost.gui.objects.Board;
import frost.messaging.MessageHashes;
import frost.storage.Savable;
import frost.storage.StorageException;
import frost.threads.BoardUpdateThread;
import frost.threads.BoardUpdateThreadListener;
import frost.threads.RunningBoardUpdateThreads;
import frost.util.gui.JDragTree;
import frost.util.gui.JSkinnablePopupMenu;
import frost.util.gui.MiscToolkit;
import frost.util.gui.SwingWorker;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TofTree
extends JDragTree
implements Savable {
    private Language language;
    private SettingsClass settings;
    private Core core;
    private MainFrame mainFrame;
    private Listener listener = new Listener();
    private PopupMenuTofTree popupMenuTofTree;
    private static Logger logger = Logger.getLogger(TofTree.class.getName());
    private TofTreeModel model;
    private JButton cutBoardButton = new JButton();
    private JButton pasteBoardButton = new JButton();
    private JButton configBoardButton = new JButton();
    private JMenuItem configBoardMenuItem = new JMenuItem();
    private Board clipboard = null;
    private RunningBoardUpdateThreads runningBoardUpdateThreads = null;
    private MessageHashes messageHashes;

    public TofTree(TofTreeModel tofTreeModel) {
        super(tofTreeModel);
        this.model = tofTreeModel;
    }

    private PopupMenuTofTree getPopupMenuTofTree() {
        if (this.popupMenuTofTree == null) {
            this.popupMenuTofTree = new PopupMenuTofTree();
            this.language.addLanguageListener(this.popupMenuTofTree);
        }
        return this.popupMenuTofTree;
    }

    public void initialize() {
        this.language = Language.getInstance();
        this.language.addLanguageListener(this.listener);
        MiscToolkit miscToolkit = MiscToolkit.getInstance();
        this.cutBoardButton.setIcon(new ImageIcon(this.getClass().getResource("/data/cut.gif")));
        this.pasteBoardButton.setIcon(new ImageIcon(this.getClass().getResource("/data/paste.gif")));
        this.configBoardButton.setIcon(new ImageIcon(this.getClass().getResource("/data/configure.gif")));
        miscToolkit.configureButton(this.cutBoardButton, "/data/cut_rollover.gif");
        miscToolkit.configureButton(this.pasteBoardButton, "/data/paste_rollover.gif");
        miscToolkit.configureButton(this.configBoardButton, "/data/configure_rollover.gif");
        this.configBoardMenuItem.setIcon(miscToolkit.getScaledImage("/data/configure.gif", 16, 16));
        this.refreshLanguage();
        this.pasteBoardButton.setEnabled(false);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setRootVisible(true);
        this.setCellRenderer(new CellRenderer());
        this.setSelectionModel(this.model.getSelectionModel());
        this.getSelectionModel().setSelectionMode(1);
        this.addTreeSelectionListener(this.listener);
        this.addKeyListener(this.listener);
        this.addMouseListener(this.listener);
        this.cutBoardButton.addActionListener(this.listener);
        this.pasteBoardButton.addActionListener(this.listener);
        this.configBoardButton.addActionListener(this.listener);
        this.configBoardMenuItem.addActionListener(this.listener);
        this.loadTree();
        this.runningBoardUpdateThreads = new RunningBoardUpdateThreads(this.mainFrame, this.core.getIdentities(), this.settings);
        this.runningBoardUpdateThreads.setMessageHashes(this.messageHashes);
    }

    public void cutNode(Board board) {
        if (board != null) {
            this.model.removeNode(board);
            this.clipboard = board;
            this.pasteBoardButton.setEnabled(true);
        }
    }

    public void pasteNode(Board board) {
        if (this.clipboard == null) {
            this.pasteBoardButton.setEnabled(false);
            return;
        }
        if (board == null || !board.isFolder()) {
            return;
        }
        board.add(this.clipboard);
        this.clipboard = null;
        this.pasteBoardButton.setEnabled(false);
        int[] nArray = new int[]{board.getChildCount() - 1};
        this.model.nodesWereInserted(board, nArray);
    }

    private void refreshLanguage() {
        this.cutBoardButton.setToolTipText(this.language.getString("Cut board"));
        this.pasteBoardButton.setToolTipText(this.language.getString("Paste board"));
        this.configBoardButton.setToolTipText(this.language.getString("Configure board"));
        this.configBoardMenuItem.setText(this.language.getString("Configure selected board"));
    }

    public void pressedKey(char c) {
        if (!this.isEditing()) {
            if (c == '\u007f') {
                this.removeNode(this.model.getSelectedNode());
            }
            if (c == 'N') {
                this.createNewBoard(this.mainFrame);
            }
            if (c == 'X') {
                this.cutNode(this.model.getSelectedNode());
            }
            if (c == 'V') {
                this.pasteNode(this.model.getSelectedNode());
            }
        }
    }

    private boolean loadTree() {
        TofTreeXmlIO tofTreeXmlIO = new TofTreeXmlIO();
        String string = this.settings.getValue("config.dir") + "boards.xml";
        File file = new File(string);
        if (!file.exists()) {
            logger.warning("boards.xml file not found, reading default file (will be saved to boards.xml on exit).");
            string = this.settings.getValue("config.dir") + "boards.xml.default";
        }
        return tofTreeXmlIO.loadBoardTree(this, this.model, string);
    }

    public void save() throws StorageException {
        TofTreeXmlIO tofTreeXmlIO = new TofTreeXmlIO();
        String string = this.settings.getValue("config.dir") + "boards.xml";
        File file = new File(string);
        if (file.exists()) {
            String string2 = this.settings.getValue("config.dir") + "boards.xml.bak";
            File file2 = new File(string2);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
        }
        if (!tofTreeXmlIO.saveBoardTree(this, this.model, string)) {
            throw new StorageException("Error while saving the TofTree.");
        }
    }

    public void createNewBoard(Frame frame) {
        boolean bl = false;
        while (!bl) {
            NewBoardDialog newBoardDialog = new NewBoardDialog(frame);
            newBoardDialog.setVisible(true);
            if (newBoardDialog.getChoice() == NewBoardDialog.CHOICE_CANCEL) {
                bl = true;
                continue;
            }
            String string = newBoardDialog.getBoardName();
            String string2 = newBoardDialog.getBoardDescription();
            if (this.model.getBoardByName(string) != null) {
                JOptionPane.showMessageDialog(frame, this.language.getString("You already have a board with name") + " '" + string + "'!\n" + this.language.getString("Please choose a new name"));
                continue;
            }
            Board board = new Board(string, string2);
            this.model.addNodeToTree(board);
            TOF.getInstance().initialSearchNewMessages(board);
            bl = true;
        }
    }

    private void addNewBoard(String string, String string2, String string3, String string4) {
        int n;
        if (this.model.getBoardByName(string) != null && (n = JOptionPane.showConfirmDialog(this.getTopLevelAncestor(), this.language.getString("You already have a board with name") + " '" + string + "'!\n" + this.language.getString("Do you really want to overwrite it?") + "" + "\n(" + this.language.getString("This will not delete messages") + ")", this.language.getString("Warning"), 0, 2)) == 1) {
            return;
        }
        Board board = new Board(string, string2, string3, string4);
        this.model.addNodeToTree(board);
        TOF.getInstance().initialSearchNewMessages(board);
    }

    public void addNewBoard(Board board) {
        this.addNewBoard(board.getName(), board.getPublicKey(), board.getPrivateKey(), board.getDescription());
    }

    public void createNewFolder(Frame frame) {
        String string = null;
        do {
            Object object;
            String string2 = string = (object = JOptionPane.showInputDialog(frame, this.language.getString("Please enter a name for the new folder") + ":", this.language.getString("New Folder Name"), 3, null, null, this.language.getString("newfolder"))) == null ? null : object.toString();
            if (string != null) continue;
            return;
        } while (string.length() == 0);
        this.model.addNodeToTree(new Board(string, true));
    }

    public void removeNode(Board board) {
        String string = board.isFolder() ? "Do you really want to delete folder '" + board.getName() + "' ???" + "\nNOTE: Removing it will also remove all boards/folders inside this folder!!!" : "Do you really want to delete board '" + board.getName() + "' ???";
        int n = JOptionPane.showConfirmDialog(this, string, "Delete '" + board.getName() + "'?", 0);
        if (n == 1) {
            return;
        }
        boolean bl = false;
        String string2 = this.settings.getValue("keypool.dir") + board.getBoardFilename();
        if (!board.isFolder()) {
            string = "Do you want to delete also the board directory '" + string2 + "' ?\n" + "This directory contains all received messages and file lists for this board.\n" + "(NOTE: The board MUST not updating to delete it!\n" + "Currently there is no way to stop the updating of a board,\n" + "so please ensure this board is'nt updating right now,\n" + "or you have to live with the consequences ;) )\n\n" + "You can also delete the directory by yourself after shutdown of Frost.";
            n = JOptionPane.showConfirmDialog(this, string, "Delete directory of '" + board.getName() + "'?", 1);
            if (n == 0) {
                bl = true;
            } else if (n == 2) {
                return;
            }
        }
        this.model.removeNode(board);
        if (bl) {
            if (!board.isUpdating()) {
                this.core.deleteDir(string2);
            } else {
                logger.warning("WARNING: Although being warned, you tried to delete a board with is updating! Skipped ...");
            }
        }
    }

    public void setSettings(SettingsClass settingsClass) {
        this.settings = settingsClass;
    }

    public void setCore(Core core) {
        this.core = core;
    }

    public void setMainFrame(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    private void showTofTreePopupMenu(MouseEvent mouseEvent) {
        this.getPopupMenuTofTree().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private void refreshNode(Board board) {
        if (board == null) {
            return;
        }
        if (!board.isFolder()) {
            if (this.isUpdateAllowed(board)) {
                this.updateBoard(board);
            }
        } else {
            Enumeration<TreeNode> enumeration = board.children();
            while (enumeration.hasMoreElements()) {
                this.refreshNode((Board)enumeration.nextElement());
            }
        }
    }

    private void markAllRead(Board board) {
        if (board == null) {
            return;
        }
        if (!board.isFolder()) {
            TOF.getInstance().setAllMessagesRead(board);
        } else {
            Enumeration<TreeNode> enumeration = board.children();
            while (enumeration.hasMoreElements()) {
                this.markAllRead((Board)enumeration.nextElement());
            }
        }
    }

    public boolean isUpdateAllowed(Board board) {
        if (board == null) {
            return false;
        }
        if (board.isFolder()) {
            return false;
        }
        return !board.isSpammed();
    }

    public RunningBoardUpdateThreads getRunningBoardUpdateThreads() {
        return this.runningBoardUpdateThreads;
    }

    private void selectionChanged() {
        Board board = (Board)this.getLastSelectedPathComponent();
        if (board != null && board.isFolder()) {
            if (board.isRoot()) {
                this.cutBoardButton.setEnabled(false);
            } else {
                this.cutBoardButton.setEnabled(true);
            }
        }
    }

    private void configureBoard(Board board) {
        if (board == null) {
            return;
        }
        BoardSettingsFrame boardSettingsFrame = new BoardSettingsFrame(this.mainFrame, board);
        boardSettingsFrame.runDialog();
    }

    public void updateBoard(Board board) {
        if (board == null || board.isFolder()) {
            return;
        }
        boolean bl = false;
        if (!this.getRunningBoardUpdateThreads().isThreadOfTypeRunning(board, 1)) {
            this.getRunningBoardUpdateThreads().startMessageDownloadToday(board, this.settings, this.listener);
            logger.info("Starting update (MSG_TODAY) of " + board.getName());
            bl = true;
        }
        if (!this.settings.getBoolValue("disableRequests") && !this.getRunningBoardUpdateThreads().isThreadOfTypeRunning(board, 3)) {
            this.getRunningBoardUpdateThreads().startBoardFilesUpload(board, this.settings, this.listener);
            logger.info("Starting update (BOARD_UPLOAD) of " + board.getName());
            bl = true;
        }
        if (!this.settings.getBoolValue("disableDownloads") && !this.getRunningBoardUpdateThreads().isThreadOfTypeRunning(board, 5)) {
            this.getRunningBoardUpdateThreads().startBoardFilesDownload(board, this.settings, this.listener);
            logger.info("Starting update (BOARD_DOWNLOAD) of " + board.getName());
            bl = true;
        }
        if (!this.getRunningBoardUpdateThreads().isThreadOfTypeRunning(board, 2)) {
            this.getRunningBoardUpdateThreads().startMessageDownloadBack(board, this.settings, this.listener);
            logger.info("Starting update (MSG_BACKLOAD) of " + board.getName());
            bl = true;
        }
        if (bl) {
            board.setLastUpdateStartMillis(System.currentTimeMillis());
        }
    }

    public void updateTree() {
        Enumeration<TreeNode> enumeration = ((Board)this.model.getRoot()).depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            this.model.nodeChanged((Board)enumeration.nextElement());
        }
    }

    protected JButton getConfigBoardButton() {
        return this.configBoardButton;
    }

    protected JMenuItem getConfigBoardMenuItem() {
        return this.configBoardMenuItem;
    }

    protected JButton getCutBoardButton() {
        return this.cutBoardButton;
    }

    protected JButton getPasteBoardButton() {
        return this.pasteBoardButton;
    }

    public void setMessageHashes(MessageHashes messageHashes) {
        this.messageHashes = messageHashes;
    }

    private class CellRenderer
    extends DefaultTreeCellRenderer {
        ImageIcon writeAccessIcon;
        ImageIcon writeAccessNewIcon;
        ImageIcon readAccessIcon;
        ImageIcon readAccessNewIcon;
        ImageIcon boardIcon;
        ImageIcon boardNewIcon;
        ImageIcon boardSpammedIcon;
        String fileSeparator = System.getProperty("file.separator");
        Font boldFont = null;
        Font normalFont = null;

        public CellRenderer() {
            this.boardIcon = new ImageIcon(this.getClass().getResource("/data/board.gif"));
            this.boardNewIcon = new ImageIcon(this.getClass().getResource("/data/boardnew.gif"));
            this.boardSpammedIcon = new ImageIcon(this.getClass().getResource("/data/boardspam.gif"));
            this.writeAccessIcon = new ImageIcon(this.getClass().getResource("/data/waboard.jpg"));
            this.writeAccessNewIcon = new ImageIcon(this.getClass().getResource("/data/waboardnew.jpg"));
            this.readAccessIcon = new ImageIcon(this.getClass().getResource("/data/raboard.jpg"));
            this.readAccessNewIcon = new ImageIcon(this.getClass().getResource("/data/raboardnew.jpg"));
            this.setLeafIcon(new ImageIcon(this.getClass().getResource("/data/board.gif")));
            this.setClosedIcon(new ImageIcon(this.getClass().getResource("/data/closed.gif")));
            this.setOpenIcon(new ImageIcon(this.getClass().getResource("/data/open.gif")));
            JTable jTable = new JTable();
            this.normalFont = jTable.getFont();
            this.boldFont = this.normalFont.deriveFont(1);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Board board = null;
            if (!(object instanceof Board)) {
                logger.severe("Error - TofTreeCellRenderer: got a tree value wich is no FrostBoardObject:\n   node value='" + object + "'  ;  node class='" + object.getClass() + "'\n" + "This should never happen, please report the error.");
                return this;
            }
            board = (Board)object;
            boolean bl5 = board.containsNewMessages();
            if (board.isFolder()) {
                this.setText(board.getName());
                if (bl5) {
                    this.setFont(this.boldFont);
                } else {
                    this.setFont(this.normalFont);
                }
            } else if (bl5) {
                this.setFont(this.boldFont);
                this.setText(board.getName() + " (" + board.getNewMessageCount() + ")");
            } else {
                this.setFont(this.normalFont);
                this.setText(board.getName());
            }
            if (TofTree.this.settings.getBoolValue("boardUpdateVisualization") && board.isUpdating()) {
                Color color = (Color)TofTree.this.settings.getObjectValue("boardUpdatingNonSelectedBackgroundColor");
                this.setBackgroundNonSelectionColor(color);
                color = (Color)TofTree.this.settings.getObjectValue("boardUpdatingSelectedBackgroundColor");
                this.setBackgroundSelectionColor(color);
            } else {
                this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
                this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
                this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
                this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
            }
            if (bl3) {
                if (board.isPublicBoard()) {
                    if (bl5) {
                        this.setIcon(this.boardNewIcon);
                    } else {
                        this.setIcon(this.boardIcon);
                    }
                } else if (board.isSpammed()) {
                    this.setIcon(this.boardSpammedIcon);
                } else if (board.isWriteAccessBoard()) {
                    if (bl5) {
                        this.setIcon(this.writeAccessNewIcon);
                    } else {
                        this.setIcon(this.writeAccessIcon);
                    }
                } else if (board.isReadAccessBoard()) {
                    if (bl5) {
                        this.setIcon(this.readAccessNewIcon);
                    } else {
                        this.setIcon(this.readAccessIcon);
                    }
                }
            }
            return this;
        }
    }

    private class Listener
    extends MouseAdapter
    implements LanguageListener,
    ActionListener,
    KeyListener,
    TreeSelectionListener,
    BoardUpdateThreadListener {
        private Listener() {
        }

        public void languageChanged(LanguageEvent languageEvent) {
            TofTree.this.refreshLanguage();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == TofTree.this.cutBoardButton) {
                TofTree.this.cutNode(TofTree.this.model.getSelectedNode());
            }
            if (actionEvent.getSource() == TofTree.this.pasteBoardButton) {
                TofTree.this.pasteNode(TofTree.this.model.getSelectedNode());
            }
            if (actionEvent.getSource() == TofTree.this.configBoardButton) {
                TofTree.this.configureBoard(TofTree.this.model.getSelectedNode());
            }
            if (actionEvent.getSource() == TofTree.this.configBoardMenuItem) {
                TofTree.this.configureBoard(TofTree.this.model.getSelectedNode());
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            TofTree.this.pressedKey(c);
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && mouseEvent.getSource() == TofTree.this) {
                TofTree.this.showTofTreePopupMenu(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && mouseEvent.getSource() == TofTree.this) {
                TofTree.this.showTofTreePopupMenu(mouseEvent);
            }
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (treeSelectionEvent.getSource() == TofTree.this) {
                TofTree.this.selectionChanged();
            }
        }

        public void boardUpdateThreadFinished(final BoardUpdateThread boardUpdateThread) {
            int n = TofTree.this.getRunningBoardUpdateThreads().getDownloadThreadsForBoard(boardUpdateThread.getTargetBoard()).size();
            if (n == 0) {
                boardUpdateThread.getTargetBoard().setUpdating(false);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TofTree.this.mainFrame.updateTofTree(boardUpdateThread.getTargetBoard());
                    }
                });
            }
        }

        public void boardUpdateThreadStarted(final BoardUpdateThread boardUpdateThread) {
            boardUpdateThread.getTargetBoard().setUpdating(true);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TofTree.this.mainFrame.updateTofTree(boardUpdateThread.getTargetBoard());
                }
            });
        }
    }

    private class PopupMenuTofTree
    extends JSkinnablePopupMenu
    implements LanguageListener,
    ActionListener {
        private JMenuItem addBoardItem = new JMenuItem();
        private JMenuItem addFolderItem = new JMenuItem();
        private JMenuItem cancelItem = new JMenuItem();
        private JMenuItem configureBoardItem = new JMenuItem();
        private JMenuItem configureFolderItem = new JMenuItem();
        private JMenuItem cutNodeItem = new JMenuItem();
        private JMenuItem descriptionItem = new JMenuItem();
        private JMenuItem pasteNodeItem = new JMenuItem();
        private JMenuItem refreshItem = new JMenuItem();
        private JMenuItem removeNodeItem = new JMenuItem();
        private JMenuItem renameFolderItem = new JMenuItem();
        private JMenuItem markAllReadItem = new JMenuItem();
        private Board selectedTreeNode = null;
        private JMenuItem sortFolderItem = new JMenuItem();

        public PopupMenuTofTree() {
            this.initialize();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            final Object object = actionEvent.getSource();
            SwingWorker swingWorker = new SwingWorker(this){

                protected void doNonUILogic() throws RuntimeException {
                    if (object == PopupMenuTofTree.this.refreshItem) {
                        PopupMenuTofTree.this.refreshSelected();
                    } else if (object == PopupMenuTofTree.this.addBoardItem) {
                        PopupMenuTofTree.this.addBoardSelected();
                    } else if (object == PopupMenuTofTree.this.addFolderItem) {
                        PopupMenuTofTree.this.addFolderSelected();
                    } else if (object == PopupMenuTofTree.this.removeNodeItem) {
                        PopupMenuTofTree.this.removeNodeSelected();
                    } else if (object == PopupMenuTofTree.this.cutNodeItem) {
                        PopupMenuTofTree.this.cutNodeSelected();
                    } else if (object == PopupMenuTofTree.this.pasteNodeItem) {
                        PopupMenuTofTree.this.pasteNodeSelected();
                    } else if (object == PopupMenuTofTree.this.configureBoardItem || object == PopupMenuTofTree.this.configureFolderItem) {
                        PopupMenuTofTree.this.configureBoardSelected();
                    } else if (object == PopupMenuTofTree.this.sortFolderItem) {
                        PopupMenuTofTree.this.sortFolderSelected();
                    } else if (object == PopupMenuTofTree.this.markAllReadItem) {
                        PopupMenuTofTree.this.markAllReadSelected();
                    } else if (object == PopupMenuTofTree.this.renameFolderItem) {
                        PopupMenuTofTree.this.renameFolderSelected();
                    }
                }

                protected void doUIUpdateLogic() throws RuntimeException {
                }
            };
            swingWorker.start();
        }

        private void addBoardSelected() {
            TofTree.this.createNewBoard(TofTree.this.mainFrame);
        }

        private void addFolderSelected() {
            TofTree.this.createNewFolder(TofTree.this.mainFrame);
        }

        private void configureBoardSelected() {
            TofTree.this.configureBoard(this.selectedTreeNode);
        }

        private void cutNodeSelected() {
            TofTree.this.cutNode(this.selectedTreeNode);
        }

        private void initialize() {
            this.refreshLanguage();
            MiscToolkit miscToolkit = MiscToolkit.getInstance();
            this.addBoardItem.setIcon(miscToolkit.getScaledImage("/data/newboard.gif", 16, 16));
            this.addFolderItem.setIcon(miscToolkit.getScaledImage("/data/newfolder.gif", 16, 16));
            this.configureBoardItem.setIcon(miscToolkit.getScaledImage("/data/configure.gif", 16, 16));
            this.configureFolderItem.setIcon(miscToolkit.getScaledImage("/data/configure.gif", 16, 16));
            this.cutNodeItem.setIcon(miscToolkit.getScaledImage("/data/cut.gif", 16, 16));
            this.pasteNodeItem.setIcon(miscToolkit.getScaledImage("/data/paste.gif", 16, 16));
            this.refreshItem.setIcon(miscToolkit.getScaledImage("/data/update.gif", 16, 16));
            this.removeNodeItem.setIcon(miscToolkit.getScaledImage("/data/remove.gif", 16, 16));
            this.sortFolderItem.setIcon(miscToolkit.getScaledImage("/data/sort.gif", 16, 16));
            this.renameFolderItem.setIcon(miscToolkit.getScaledImage("/data/rename.gif", 16, 16));
            this.descriptionItem.setEnabled(false);
            this.refreshItem.addActionListener(this);
            this.addBoardItem.addActionListener(this);
            this.addFolderItem.addActionListener(this);
            this.removeNodeItem.addActionListener(this);
            this.cutNodeItem.addActionListener(this);
            this.pasteNodeItem.addActionListener(this);
            this.configureBoardItem.addActionListener(this);
            this.configureFolderItem.addActionListener(this);
            this.sortFolderItem.addActionListener(this);
            this.markAllReadItem.addActionListener(this);
            this.renameFolderItem.addActionListener(this);
        }

        public void languageChanged(LanguageEvent languageEvent) {
            this.refreshLanguage();
        }

        private void pasteNodeSelected() {
            if (TofTree.this.clipboard != null) {
                TofTree.this.pasteNode(this.selectedTreeNode);
            }
        }

        private void refreshLanguage() {
            this.addBoardItem.setText(TofTree.this.language.getString("Add new board"));
            this.addFolderItem.setText(TofTree.this.language.getString("Add new folder"));
            this.configureBoardItem.setText(TofTree.this.language.getString("Configure selected board"));
            this.configureFolderItem.setText(TofTree.this.language.getString("Configure selected folder"));
            this.cancelItem.setText(TofTree.this.language.getString("Cancel"));
            this.sortFolderItem.setText(TofTree.this.language.getString("Sort folder"));
            this.markAllReadItem.setText(TofTree.this.language.getString("Mark ALL messages read"));
            this.renameFolderItem.setText(TofTree.this.language.getString("Rename folder"));
        }

        private void refreshSelected() {
            TofTree.this.refreshNode(this.selectedTreeNode);
        }

        private void markAllReadSelected() {
            TofTree.this.markAllRead(this.selectedTreeNode);
        }

        private void removeNodeSelected() {
            TofTree.this.removeNode(this.selectedTreeNode);
        }

        public void show(Component component, int n, int n2) {
            int n3 = TofTree.this.getRowForLocation(n, n2);
            if (n3 != -1) {
                this.removeAll();
                TreePath treePath = TofTree.this.getPathForLocation(n, n2);
                this.selectedTreeNode = (Board)treePath.getLastPathComponent();
                String string = this.selectedTreeNode.isFolder() ? TofTree.this.language.getString("Folder") : TofTree.this.language.getString("Board");
                String string2 = this.selectedTreeNode.isFolder() ? TofTree.this.language.getString("folder") : TofTree.this.language.getString("board");
                this.descriptionItem.setText(string + " : " + this.selectedTreeNode.getName());
                this.refreshItem.setText(TofTree.this.language.getString("Refresh") + " " + string2);
                this.removeNodeItem.setText(TofTree.this.language.getString("Remove") + " " + string2);
                this.cutNodeItem.setText(TofTree.this.language.getString("Cut") + " " + string2);
                this.add(this.descriptionItem);
                this.addSeparator();
                this.add(this.refreshItem);
                this.addSeparator();
                this.add(this.markAllReadItem);
                this.addSeparator();
                if (this.selectedTreeNode.isFolder()) {
                    this.add(this.renameFolderItem);
                    this.add(this.configureFolderItem);
                    this.add(this.sortFolderItem);
                } else {
                    this.add(this.configureBoardItem);
                }
                this.addSeparator();
                this.add(this.addBoardItem);
                this.add(this.addFolderItem);
                if (!this.selectedTreeNode.isRoot()) {
                    this.add(this.removeNodeItem);
                }
                this.addSeparator();
                if (!this.selectedTreeNode.isRoot()) {
                    this.add(this.cutNodeItem);
                }
                if (TofTree.this.clipboard != null && this.selectedTreeNode.isFolder()) {
                    String string3 = TofTree.this.clipboard.isFolder() ? TofTree.this.language.getString("folder") : TofTree.this.language.getString("board");
                    this.pasteNodeItem.setText(TofTree.this.language.getString("Paste") + " " + string3 + " '" + TofTree.this.clipboard.getName() + "'");
                    this.add(this.pasteNodeItem);
                }
                this.addSeparator();
                this.add(this.cancelItem);
                super.show(component, n, n2);
            }
        }

        private void sortFolderSelected() {
            this.selectedTreeNode.sortChildren();
            TofTree.this.model.nodeStructureChanged(this.selectedTreeNode);
        }

        private void renameFolderSelected() {
            MainFrame.getInstance().renameNode(this.selectedTreeNode);
        }
    }
}

