/*
 * Decompiled with CFR 0.152.
 */
package frost.boards;

import frost.DateFun;
import frost.FileAccess;
import frost.MainFrame;
import frost.Mixed;
import frost.boards.TofTreeModel;
import frost.gui.model.MessageTableModel;
import frost.gui.model.SortedTableModel;
import frost.gui.objects.Board;
import frost.gui.objects.FrostMessageFactory;
import frost.gui.objects.FrostMessageObject;
import frost.messages.BoardAttachment;
import frost.messages.VerifyableMessageObject;
import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class TOF {
    private static Logger logger = Logger.getLogger(TOF.class.getName());
    private UpdateTofFilesThread updateThread = null;
    private UpdateTofFilesThread nextUpdateThread = null;
    private TofTreeModel tofTreeModel;
    private static boolean initialized = false;
    private static TOF instance = null;

    public static TOF getInstance() {
        return instance;
    }

    private TOF(TofTreeModel tofTreeModel) {
        this.tofTreeModel = tofTreeModel;
    }

    public static void initialize(TofTreeModel tofTreeModel) {
        if (!initialized) {
            initialized = true;
            instance = new TOF(tofTreeModel);
        }
    }

    public FrostMessageObject evalSelection(ListSelectionEvent listSelectionEvent, JTable jTable, Board board) {
        FrostMessageObject frostMessageObject;
        int n;
        MessageTableModel messageTableModel = (MessageTableModel)jTable.getModel();
        if (!listSelectionEvent.getValueIsAdjusting() && !jTable.isEditing() && (n = jTable.getSelectedRow()) != -1 && n < messageTableModel.getRowCount() && (frostMessageObject = (FrostMessageObject)messageTableModel.getRow(n)) != null) {
            if (!frostMessageObject.isMessageNew()) {
                return frostMessageObject;
            }
            frostMessageObject.setMessageNew(false);
            messageTableModel.updateRow(frostMessageObject);
            board.decNewMessageCount();
            MainFrame.getInstance().updateMessageCountLabels(board);
            MainFrame.getInstance().updateTofTree(board);
            return frostMessageObject;
        }
        return null;
    }

    public void setAllMessagesRead(final Board board) {
        Runnable runnable = new Runnable(){

            public void run() {
                Serializable serializable;
                String string = MainFrame.keypool;
                boolean bl = false;
                String string2 = board.getBoardFilename();
                if (MainFrame.getInstance().getTofTreeModel().getSelectedNode() == board) {
                    bl = true;
                    serializable = MainFrame.getInstance().getMessageTableModel();
                    for (int i = 0; i < ((SortedTableModel)serializable).getRowCount(); ++i) {
                        FrostMessageObject frostMessageObject = (FrostMessageObject)((SortedTableModel)serializable).getRow(i);
                        if (frostMessageObject == null || !frostMessageObject.isMessageNew()) continue;
                        frostMessageObject.setMessageNew(false);
                        board.decNewMessageCount();
                        SwingUtilities.invokeLater(new Runnable((MessageTableModel)serializable, frostMessageObject){
                            final /* synthetic */ MessageTableModel val$tableModel;
                            final /* synthetic */ FrostMessageObject val$message;
                            {
                                this.val$tableModel = messageTableModel;
                                this.val$message = frostMessageObject;
                            }

                            public void run() {
                                this.val$tableModel.updateRow(this.val$message);
                            }
                        });
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            MainFrame.getInstance().updateMessageCountLabels(board);
                            MainFrame.getInstance().updateTofTree(board);
                        }
                    });
                }
                if (!((File)(serializable = new File(new StringBuffer().append(string).append(string2).toString()))).isDirectory()) {
                    return;
                }
                ArrayList arrayList = null;
                int n = 0;
                boolean bl2 = false;
                while (!bl2) {
                    n = board.getNewMessageCount();
                    arrayList = FileAccess.getAllEntries((File)serializable, ".xml.lck");
                    if (n != board.getNewMessageCount()) continue;
                    bl2 = true;
                }
                for (File file : arrayList) {
                    file.delete();
                }
                board.setNewMessageCount(board.getNewMessageCount() - n);
                final boolean bl3 = bl;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MainFrame.getInstance().updateMessageCountLabels(board);
                        MainFrame.getInstance().updateTofTree(board);
                        if (MainFrame.getInstance().getTofTreeModel().getSelectedNode() == board && !bl3) {
                            MainFrame.getInstance().tofTree_actionPerformed(null);
                        }
                    }
                });
            }
        };
        new Thread(runnable).start();
    }

    public void addNewMessageToTable(File file, final Board board, boolean bl) {
        final MessageTableModel messageTableModel = MainFrame.getInstance().getMessageTableModel();
        if (file.getName().endsWith(".xml") && file.length() > 0L) {
            FrostMessageObject frostMessageObject;
            try {
                frostMessageObject = FrostMessageFactory.createFrostMessageObject(file);
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "Error: skipping to load file '" + file.getPath() + "', reason:\n" + exception.getMessage(), exception);
                return;
            }
            if (frostMessageObject.isValid() && !this.blocked(frostMessageObject, board)) {
                if (bl) {
                    frostMessageObject.setMessageNew(true);
                    MainFrame.displayNewMessageIcon(true);
                    board.incNewMessageCount();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MainFrame.getInstance().updateTofTree(board);
                        if (TOF.this.tofTreeModel.getSelectedNode().getName().equals(board.getName())) {
                            messageTableModel.addRow(frostMessageObject);
                            MainFrame.getInstance().updateMessageCountLabels(board);
                        }
                    }
                });
            }
        }
    }

    public void updateTofTable(Board board, String string) {
        int n = board.getMaxMessageDisplay();
        MessageTableModel messageTableModel = MainFrame.getInstance().getMessageTableModel();
        if (this.updateThread != null) {
            if (this.updateThread.toString().equals(board)) {
                return;
            }
            this.updateThread.cancel();
        }
        this.nextUpdateThread = new UpdateTofFilesThread(board, string, n, messageTableModel);
        this.nextUpdateThread.start();
    }

    public boolean blocked(VerifyableMessageObject verifyableMessageObject, Board board) {
        String string;
        boolean bl;
        StringTokenizer stringTokenizer;
        Object object;
        int n = verifyableMessageObject.getMsgStatus();
        if (board.getShowSignedOnly() && (n == 6 || n == 5)) {
            return true;
        }
        if (board.getHideBad() && n == 3) {
            return true;
        }
        if (board.getHideCheck() && n == 2) {
            return true;
        }
        if (board.getHideObserve() && n == 4) {
            return true;
        }
        if (n == 6 && verifyableMessageObject.getFrom().indexOf(64) > -1) {
            return true;
        }
        if (MainFrame.frostSettings.getBoolValue("blockMessageChecked")) {
            object = (verifyableMessageObject.getSubject() + verifyableMessageObject.getDate() + verifyableMessageObject.getTime()).toLowerCase();
            stringTokenizer = new StringTokenizer(MainFrame.frostSettings.getValue("blockMessage"), ";");
            bl = false;
            while (stringTokenizer.hasMoreTokens() && !bl) {
                string = stringTokenizer.nextToken().trim();
                if (string.length() <= 0 || ((String)object).indexOf(string) == -1) continue;
                bl = true;
            }
            if (bl) {
                return true;
            }
        }
        if (MainFrame.frostSettings.getBoolValue("blockMessageBodyChecked")) {
            object = verifyableMessageObject.getContent().toLowerCase();
            stringTokenizer = new StringTokenizer(MainFrame.frostSettings.getValue("blockMessageBody"), ";");
            bl = false;
            while (stringTokenizer.hasMoreTokens() && !bl) {
                string = stringTokenizer.nextToken().trim();
                if (string.length() <= 0 || ((String)object).indexOf(string) == -1) continue;
                bl = true;
            }
            if (bl) {
                return true;
            }
        }
        if (MainFrame.frostSettings.getBoolValue("blockMessageBoardChecked")) {
            object = verifyableMessageObject.getAttachmentsOfType(1);
            stringTokenizer = new StringTokenizer(MainFrame.frostSettings.getValue("blockMessageBoard"), ";");
            bl = false;
            while (stringTokenizer.hasMoreTokens() && !bl) {
                string = stringTokenizer.nextToken().trim();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    BoardAttachment boardAttachment = (BoardAttachment)iterator.next();
                    Board board2 = boardAttachment.getBoardObj();
                    if (string.length() <= 0 || !board2.getName().equalsIgnoreCase(string)) continue;
                    bl = true;
                }
            }
            if (bl) {
                return true;
            }
        }
        return false;
    }

    public void initialSearchNewMessages() {
        new SearchAllNewMessages().start();
    }

    public void initialSearchNewMessages(Board board) {
        new SearchNewMessages(board).start();
    }

    private void searchNewMessages(final Board board) {
        String string = MainFrame.keypool;
        int n = board.getMaxMessageDisplay();
        int n2 = board.getNewMessageCount();
        if (board.isFolder()) {
            return;
        }
        String string2 = board.getBoardFilename();
        String string3 = System.getProperty("file.separator");
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTimeZone(TimeZone.getTimeZone("GMT"));
        gregorianCalendar2.set(1, 2001);
        gregorianCalendar2.set(2, 5);
        gregorianCalendar2.set(5, 11);
        int n3 = 0;
        int n4 = 0;
        while (gregorianCalendar.after(gregorianCalendar2) && n3 < n) {
            File[] fileArray;
            String string4 = DateFun.getDateOfCalendar(gregorianCalendar);
            File file = new File(new StringBuffer().append(string).append(string2).append(string3).append(string4).toString());
            ++n3;
            gregorianCalendar.add(5, -1);
            if (!file.isDirectory() || (fileArray = file.listFiles()) == null) continue;
            for (int i = 0; i < fileArray.length; ++i) {
                FrostMessageObject frostMessageObject;
                int n5;
                if (!fileArray[i].getName().endsWith(".xml.lck")) continue;
                String string5 = fileArray[i].getName();
                String string6 = string5.substring(0, string5.length() - 4);
                boolean bl = false;
                for (n5 = 0; n5 < fileArray.length; ++n5) {
                    if (!fileArray[n5].getName().equals(string6) || fileArray[n5].length() <= 0L) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    fileArray[i].delete();
                    continue;
                }
                try {
                    frostMessageObject = FrostMessageFactory.createFrostMessageObject(fileArray[n5]);
                }
                catch (Exception exception) {
                    frostMessageObject = null;
                }
                if (frostMessageObject != null && frostMessageObject.isValid() && !this.blocked(frostMessageObject, board)) {
                    ++n4;
                    continue;
                }
                fileArray[i].delete();
            }
        }
        int n6 = board.getNewMessageCount() - n2;
        if (n6 > 0) {
            n4 += n6;
        }
        board.setNewMessageCount(n4);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainFrame.getInstance().updateTofTree(board);
            }
        });
    }

    private class SearchNewMessages
    extends Thread {
        private Board board;

        public SearchNewMessages(Board board) {
            this.board = board;
        }

        public void run() {
            TOF.this.searchNewMessages(this.board);
        }
    }

    private class SearchAllNewMessages
    extends Thread {
        private SearchAllNewMessages() {
        }

        public void run() {
            Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)TOF.this.tofTreeModel.getRoot()).depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                Board board = (Board)enumeration.nextElement();
                TOF.this.searchNewMessages(board);
            }
        }
    }

    private class UpdateTofFilesThread
    extends Thread {
        Board board;
        String keypool;
        int daysToRead;
        SortedTableModel tableModel;
        boolean isCancelled = false;
        String fileSeparator = System.getProperty("file.separator");

        public UpdateTofFilesThread(Board board, String string, int n, SortedTableModel sortedTableModel) {
            this.board = board;
            this.keypool = string;
            this.daysToRead = n;
            this.tableModel = sortedTableModel;
        }

        public synchronized void cancel() {
            this.isCancelled = true;
        }

        public synchronized boolean isCancel() {
            return this.isCancelled;
        }

        public String toString() {
            return this.board.getName();
        }

        public void run() {
            while (TOF.this.updateThread != null) {
                Mixed.wait(250);
                if (TOF.this.nextUpdateThread == this) continue;
                return;
            }
            if (TOF.this.nextUpdateThread != this) {
                return;
            }
            TOF.this.updateThread = this;
            try {
                this.setPriority(this.getPriority() - 1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            final Board board = this.board;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (!TOF.this.tofTreeModel.getSelectedNode().isFolder() && TOF.this.tofTreeModel.getSelectedNode().getName().equals(board.getName())) {
                        UpdateTofFilesThread.this.tableModel.clearDataModel();
                        MainFrame.getInstance().updateMessageCountLabels(board);
                    }
                }
            });
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeZone(TimeZone.getTimeZone("GMT"));
            GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
            gregorianCalendar2.setTimeZone(TimeZone.getTimeZone("GMT"));
            gregorianCalendar2.set(1, 2001);
            gregorianCalendar2.set(2, 5);
            gregorianCalendar2.set(5, 11);
            int n = 0;
            String string = this.board.getBoardFilename();
            for (int i = 0; gregorianCalendar.after(gregorianCalendar2) && i < this.daysToRead; ++i) {
                File[] fileArray;
                String string2 = DateFun.getDateOfCalendar(gregorianCalendar);
                String string3 = new StringBuffer().append(this.keypool).append(string).append(this.fileSeparator).append(string2).toString();
                File file = new File(string3);
                if (file.isDirectory() && (fileArray = file.listFiles(new FilenameFilter(){

                    public boolean accept(File file, String string) {
                        return string.endsWith(".xml");
                    }
                })) != null) {
                    String string4 = new StringBuffer().append(string2).append("-").append(string).append("-").toString();
                    for (int j = 0; j < fileArray.length; ++j) {
                        if (fileArray[j].length() > 0L && fileArray[j].getName().startsWith(string4)) {
                            FrostMessageObject frostMessageObject;
                            try {
                                frostMessageObject = FrostMessageFactory.createFrostMessageObject(fileArray[j]);
                            }
                            catch (Exception exception) {
                                frostMessageObject = null;
                            }
                            if (frostMessageObject != null && (MainFrame.frostSettings.getBoolValue("showDeletedMessages") || !frostMessageObject.isDeleted()) && frostMessageObject.isValid() && !TOF.this.blocked(frostMessageObject, this.board)) {
                                boolean bl = false;
                                if (++n > 9 && n % 10 == 0) {
                                    bl = true;
                                }
                                final boolean bl2 = bl;
                                final FrostMessageObject frostMessageObject2 = frostMessageObject;
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        if (!TOF.this.tofTreeModel.getSelectedNode().isFolder() && TOF.this.tofTreeModel.getSelectedNode().getName().equals(board.getName())) {
                                            UpdateTofFilesThread.this.tableModel.addRow(frostMessageObject2);
                                            if (bl2) {
                                                MainFrame.getInstance().updateMessageCountLabels(board);
                                                MainFrame.getInstance().updateTofTree(board);
                                            }
                                        }
                                    }
                                });
                            }
                        }
                        if (!this.isCancel()) continue;
                        TOF.this.updateThread = null;
                        return;
                    }
                }
                if (this.isCancel()) {
                    TOF.this.updateThread = null;
                    return;
                }
                gregorianCalendar.add(5, -1);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (!TOF.this.tofTreeModel.getSelectedNode().isFolder() && TOF.this.tofTreeModel.getSelectedNode().getName().equals(board.getName())) {
                        MainFrame.getInstance().updateTofTree(board);
                        MainFrame.getInstance().updateMessageCountLabels(board);
                    }
                }
            });
            TOF.this.updateThread = null;
        }
    }
}

