/*
 * Decompiled with CFR 0.152.
 */
package frost.boards;

import frost.Core;
import frost.MainFrame;
import frost.SettingsClass;
import frost.boards.TOF;
import frost.boards.TofTree;
import frost.boards.TofTreeModel;
import frost.gui.objects.Board;
import frost.messaging.MessageHashes;

public class BoardsManager {
    private TofTree tofTree;
    private TofTreeModel tofTreeModel;
    private MainFrame mainFrame;
    private SettingsClass settings;
    private Core core;
    private MessageHashes messageHashes;

    public BoardsManager(SettingsClass settingsClass) {
        this.settings = settingsClass;
    }

    public void initialize() {
        TOF.initialize(this.getTofTreeModel());
        this.getTofTree().initialize();
        this.mainFrame.setTofTree(this.getTofTree());
        this.mainFrame.setTofTreeModel(this.getTofTreeModel());
        this.mainFrame.addButton(this.getTofTree().getConfigBoardButton(), 1, 0, false);
        this.mainFrame.addButton(this.getTofTree().getCutBoardButton(), 2, 0, false);
        this.mainFrame.addButton(this.getTofTree().getPasteBoardButton(), 2, 1, false);
        this.mainFrame.addMenuItem(this.getTofTree().getConfigBoardMenuItem(), "News", 1, 1, true);
    }

    public TofTree getTofTree() {
        if (this.tofTree == null) {
            this.tofTree = new TofTree(this.getTofTreeModel());
            this.tofTree.setSettings(this.settings);
            this.tofTree.setCore(this.core);
            this.tofTree.setMainFrame(this.mainFrame);
            this.tofTree.setMessageHashes(this.messageHashes);
        }
        return this.tofTree;
    }

    public TofTreeModel getTofTreeModel() {
        if (this.tofTreeModel == null) {
            Board board = new Board("Frost Message System", true);
            this.tofTreeModel = new TofTreeModel(board);
        }
        return this.tofTreeModel;
    }

    public void setMainFrame(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public void setCore(Core core) {
        this.core = core;
    }

    public void setMessageHashes(MessageHashes messageHashes) {
        this.messageHashes = messageHashes;
    }
}

