/*
 * Decompiled with CFR 0.152.
 */
package frost.boards;

import frost.MainFrame;
import frost.boards.TOF;
import frost.fcp.FcpConnection;
import frost.fcp.FcpFactory;
import frost.gui.objects.Board;
import frost.util.gui.TextComponentClipboardMenu;
import frost.util.gui.translation.Language;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class BoardSettingsFrame
extends JDialog {
    private static Logger logger = Logger.getLogger(BoardSettingsFrame.class.getName());
    private Language language;
    private Board board;
    private JFrame parentFrame;
    private Listener listener = new Listener();
    private JCheckBox autoUpdateEnabled = new JCheckBox();
    private JButton cancelButton = new JButton();
    private boolean exitState;
    private JButton generateKeyButton = new JButton();
    private JRadioButton hideBad_default = new JRadioButton();
    private JRadioButton hideBad_false = new JRadioButton();
    private JRadioButton hideBad_true = new JRadioButton();
    private JLabel hideBadMessagesLabel = new JLabel();
    private JRadioButton hideCheck_default = new JRadioButton();
    private JRadioButton hideCheck_false = new JRadioButton();
    private JRadioButton hideCheck_true = new JRadioButton();
    private JLabel hideCheckMessagesLabel = new JLabel();
    private JRadioButton hideObserve_default = new JRadioButton();
    private JRadioButton hideObserve_false = new JRadioButton();
    private JRadioButton hideObserve_true = new JRadioButton();
    private JLabel hideObserveMessagesLabel = new JLabel();
    private JLabel hideUnsignedMessagesLabel = new JLabel();
    private JRadioButton maxMsg_default = new JRadioButton();
    private JRadioButton maxMsg_set = new JRadioButton();
    private JTextField maxMsg_value = new JTextField(6);
    private JLabel messageDisplayDaysLabel = new JLabel();
    private JButton okButton = new JButton();
    private JCheckBox overrideSettingsCheckBox = new JCheckBox();
    private JLabel privateKeyLabel = new JLabel();
    private JTextField privateKeyTextField = new JTextField();
    private JRadioButton publicBoardRadioButton = new JRadioButton();
    private JLabel publicKeyLabel = new JLabel();
    private JTextField publicKeyTextField = new JTextField();
    private JRadioButton secureBoardRadioButton = new JRadioButton();
    private JRadioButton signedOnly_default = new JRadioButton();
    private JRadioButton signedOnly_false = new JRadioButton();
    private JRadioButton signedOnly_true = new JRadioButton();
    JPanel settingsPanel = new JPanel(new GridBagLayout());
    private JLabel descriptionLabel = new JLabel();
    private JTextArea descriptionTextArea = new JTextArea(3, 40);
    private JScrollPane descriptionScrollPane;

    public BoardSettingsFrame(JFrame jFrame, Board board) {
        super(jFrame);
        this.parentFrame = jFrame;
        this.board = board;
        this.language = Language.getInstance();
        this.setModal(true);
        this.enableEvents(64L);
        this.initialize();
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    private void cancel() {
        this.exitState = false;
        this.dispose();
    }

    private void cancelButton_actionPerformed(ActionEvent actionEvent) {
        this.cancel();
    }

    private void generateKeyButton_actionPerformed(ActionEvent actionEvent) {
        FcpConnection fcpConnection = FcpFactory.getFcpConnectionInstance();
        if (fcpConnection == null) {
            return;
        }
        try {
            String[] stringArray = fcpConnection.getKeyPair();
            this.privateKeyTextField.setText(stringArray[0]);
            this.publicKeyTextField.setText(stringArray[1]);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.parentFrame, iOException.toString(), this.language.getString("Warning"), 2);
        }
    }

    private void overrideSettingsCheckBox_actionPerformed(ActionEvent actionEvent) {
        this.setPanelEnabled(this.settingsPanel, this.overrideSettingsCheckBox.isSelected());
    }

    public boolean getExitState() {
        return this.exitState;
    }

    private JPanel getSettingsPanel() {
        this.settingsPanel.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5)));
        this.settingsPanel.setLayout(new GridBagLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.maxMsg_default);
        buttonGroup.add(this.maxMsg_set);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.signedOnly_default);
        buttonGroup2.add(this.signedOnly_false);
        buttonGroup2.add(this.signedOnly_true);
        ButtonGroup buttonGroup3 = new ButtonGroup();
        buttonGroup3.add(this.hideBad_default);
        buttonGroup3.add(this.hideBad_true);
        buttonGroup3.add(this.hideBad_false);
        ButtonGroup buttonGroup4 = new ButtonGroup();
        buttonGroup4.add(this.hideCheck_default);
        buttonGroup4.add(this.hideCheck_true);
        buttonGroup4.add(this.hideCheck_false);
        ButtonGroup buttonGroup5 = new ButtonGroup();
        buttonGroup5.add(this.hideObserve_default);
        buttonGroup5.add(this.hideObserve_true);
        buttonGroup5.add(this.hideObserve_false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 3;
        this.settingsPanel.add((Component)this.overrideSettingsCheckBox, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 25, 0, 5);
        this.settingsPanel.add((Component)this.autoUpdateEnabled, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(3, 25, 0, 5);
        this.settingsPanel.add((Component)this.messageDisplayDaysLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 35, 0, 5);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        this.settingsPanel.add((Component)this.maxMsg_default, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.settingsPanel.add((Component)this.maxMsg_set, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.settingsPanel.add((Component)this.maxMsg_value, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(3, 25, 0, 5);
        this.settingsPanel.add((Component)this.hideUnsignedMessagesLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 35, 0, 5);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridx = 0;
        this.settingsPanel.add((Component)this.signedOnly_default, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.settingsPanel.add((Component)this.signedOnly_true, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.settingsPanel.add((Component)this.signedOnly_false, gridBagConstraints);
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(3, 25, 0, 5);
        this.settingsPanel.add((Component)this.hideBadMessagesLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 35, 0, 5);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridx = 0;
        this.settingsPanel.add((Component)this.hideBad_default, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.settingsPanel.add((Component)this.hideBad_true, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.settingsPanel.add((Component)this.hideBad_false, gridBagConstraints);
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(3, 25, 0, 5);
        this.settingsPanel.add((Component)this.hideCheckMessagesLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 35, 0, 5);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridx = 0;
        this.settingsPanel.add((Component)this.hideCheck_default, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.settingsPanel.add((Component)this.hideCheck_true, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.settingsPanel.add((Component)this.hideCheck_false, gridBagConstraints);
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(3, 25, 0, 5);
        this.settingsPanel.add((Component)this.hideObserveMessagesLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 35, 5, 5);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridx = 0;
        this.settingsPanel.add((Component)this.hideObserve_default, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.settingsPanel.add((Component)this.hideObserve_true, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.settingsPanel.add((Component)this.hideObserve_false, gridBagConstraints);
        this.overrideSettingsCheckBox.addActionListener(this.listener);
        this.setPanelEnabled(this.settingsPanel, this.board.isConfigured());
        return this.settingsPanel;
    }

    private void initialize() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setContentPane(jPanel);
        jPanel.setLayout(new GridBagLayout());
        this.refreshLanguage();
        new TextComponentClipboardMenu(this.maxMsg_value, this.language);
        new TextComponentClipboardMenu(this.privateKeyTextField, this.language);
        new TextComponentClipboardMenu(this.publicKeyTextField, this.language);
        new TextComponentClipboardMenu(this.descriptionTextArea, this.language);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.getKeysPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.descriptionLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.descriptionScrollPane = new JScrollPane(this.descriptionTextArea);
        jPanel.add((Component)this.descriptionScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this.getSettingsPanel(), gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)this.okButton, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)this.cancelButton, gridBagConstraints);
        this.descriptionTextArea.setEditable(false);
        this.publicBoardRadioButton.setSelected(true);
        this.privateKeyTextField.setEnabled(false);
        this.publicKeyTextField.setEnabled(false);
        this.generateKeyButton.setEnabled(false);
        this.okButton.addActionListener(this.listener);
        this.cancelButton.addActionListener(this.listener);
        this.loadKeypair();
        this.loadBoardSettings();
    }

    private JPanel getKeysPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.publicBoardRadioButton);
        buttonGroup.add(this.secureBoardRadioButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.2;
        jPanel.add((Component)this.publicBoardRadioButton, gridBagConstraints);
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.secureBoardRadioButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.generateKeyButton, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.2;
        jPanel.add((Component)this.privateKeyLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.8;
        jPanel.add((Component)this.privateKeyTextField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.2;
        jPanel.add((Component)this.publicKeyLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.8;
        jPanel.add((Component)this.publicKeyTextField, gridBagConstraints);
        this.publicBoardRadioButton.addActionListener(this.listener);
        this.secureBoardRadioButton.addActionListener(this.listener);
        this.generateKeyButton.addActionListener(this.listener);
        return jPanel;
    }

    private void loadBoardSettings() {
        if (this.board.isFolder()) {
            this.descriptionTextArea.setEnabled(false);
            this.overrideSettingsCheckBox.setSelected(false);
        } else {
            if (this.board.getDescription() != null) {
                this.descriptionTextArea.setText(this.board.getDescription());
            }
            this.overrideSettingsCheckBox.setSelected(this.board.isConfigured());
            if (!this.board.isConfigured() || this.board.getMaxMessageDisplayObj() == null) {
                this.maxMsg_default.setSelected(true);
            } else {
                this.maxMsg_set.setSelected(true);
                this.maxMsg_value.setText("" + this.board.getMaxMessageDisplay());
            }
            if (!this.board.isConfigured()) {
                this.autoUpdateEnabled.setSelected(true);
            } else if (this.board.getAutoUpdateEnabled()) {
                this.autoUpdateEnabled.setSelected(true);
            } else {
                this.autoUpdateEnabled.setSelected(false);
            }
            if (!this.board.isConfigured() || this.board.getShowSignedOnlyObj() == null) {
                this.signedOnly_default.setSelected(true);
            } else if (this.board.getShowSignedOnly()) {
                this.signedOnly_true.setSelected(true);
            } else {
                this.signedOnly_false.setSelected(true);
            }
            if (!this.board.isConfigured() || this.board.getHideBadObj() == null) {
                this.hideBad_default.setSelected(true);
            } else if (this.board.getHideBad()) {
                this.hideBad_true.setSelected(true);
            } else {
                this.hideBad_false.setSelected(true);
            }
            if (!this.board.isConfigured() || this.board.getHideCheckObj() == null) {
                this.hideCheck_default.setSelected(true);
            } else if (this.board.getHideCheck()) {
                this.hideCheck_true.setSelected(true);
            } else {
                this.hideCheck_false.setSelected(true);
            }
            if (!this.board.isConfigured() || this.board.getHideObserveObj() == null) {
                this.hideObserve_default.setSelected(true);
            } else if (this.board.getHideObserve()) {
                this.hideObserve_true.setSelected(true);
            } else {
                this.hideObserve_false.setSelected(true);
            }
        }
    }

    private void loadKeypair() {
        if (this.board.isFolder()) {
            this.privateKeyTextField.setEnabled(false);
            this.publicKeyTextField.setEnabled(false);
            this.generateKeyButton.setEnabled(false);
            this.publicBoardRadioButton.setEnabled(false);
            this.secureBoardRadioButton.setEnabled(false);
        } else {
            String string = this.board.getPrivateKey();
            String string2 = this.board.getPublicKey();
            if (string != null) {
                this.privateKeyTextField.setText(string);
            } else {
                this.privateKeyTextField.setText(this.language.getString("Not available"));
            }
            if (string2 != null) {
                this.publicKeyTextField.setText(string2);
            } else {
                this.publicKeyTextField.setText(this.language.getString("Not available"));
            }
            if (this.board.isWriteAccessBoard() || this.board.isReadAccessBoard()) {
                this.privateKeyTextField.setEnabled(true);
                this.publicKeyTextField.setEnabled(true);
                this.generateKeyButton.setEnabled(true);
                this.secureBoardRadioButton.setSelected(true);
            } else {
                this.privateKeyTextField.setEnabled(false);
                this.publicKeyTextField.setEnabled(false);
                this.generateKeyButton.setEnabled(false);
                this.publicBoardRadioButton.setSelected(true);
            }
        }
    }

    private void ok() {
        if (!this.board.isFolder()) {
            int n;
            if (this.publicBoardRadioButton.isSelected() && !this.board.isPublicBoard() && (n = JOptionPane.showConfirmDialog(this, this.language.getString("BoardSettingsFrame.confirmBody"), this.language.getString("BoardSettingsFrame.confirmTitle"), 0, 2)) == 1) {
                return;
            }
            this.applySettingsToBoard();
        } else {
            this.applySettingsToFolder(this.board);
        }
        this.updateBoard(this.board);
        this.exitState = true;
        this.dispose();
    }

    private void applySettingsToFolder(Board board) {
        if (board.isFolder()) {
            for (int i = 0; i < board.getChildCount(); ++i) {
                Board board2 = (Board)board.getChildAt(i);
                this.applySettingsToFolder(board2);
            }
            return;
        }
        if (this.overrideSettingsCheckBox.isSelected()) {
            board.setConfigured(true);
            board.setAutoUpdateEnabled(this.autoUpdateEnabled.isSelected());
            if (this.maxMsg_default.isSelected() || this.maxMsg_set.isSelected()) {
                if (!this.maxMsg_default.isSelected()) {
                    board.setMaxMessageDays(new Integer(this.maxMsg_value.getText()));
                } else {
                    board.setMaxMessageDays(null);
                }
            }
            if (this.signedOnly_default.isSelected() || this.signedOnly_true.isSelected() || this.signedOnly_false.isSelected()) {
                if (!this.signedOnly_default.isSelected()) {
                    board.setShowSignedOnly(this.signedOnly_true.isSelected());
                } else {
                    board.setShowSignedOnly(null);
                }
            }
            if (this.hideBad_default.isSelected() || this.hideBad_true.isSelected() || this.hideBad_false.isSelected()) {
                if (!this.hideBad_default.isSelected()) {
                    board.setHideBad(this.hideBad_true.isSelected());
                } else {
                    board.setHideBad(null);
                }
            }
            if (this.hideCheck_default.isSelected() || this.hideCheck_true.isSelected() || this.hideCheck_false.isSelected()) {
                if (!this.hideCheck_default.isSelected()) {
                    board.setHideCheck(this.hideCheck_true.isSelected());
                } else {
                    board.setHideCheck(null);
                }
            }
            if (this.hideObserve_default.isSelected() || this.hideObserve_true.isSelected() || this.hideObserve_false.isSelected()) {
                if (!this.hideObserve_default.isSelected()) {
                    board.setHideObserve(this.hideObserve_true.isSelected());
                } else {
                    board.setHideObserve(null);
                }
            }
        } else {
            board.setConfigured(false);
        }
    }

    private void applySettingsToBoard() {
        if (this.secureBoardRadioButton.isSelected()) {
            String string = this.privateKeyTextField.getText();
            String string2 = this.publicKeyTextField.getText();
            if (string2.startsWith("SSK@")) {
                this.board.setPublicKey(string2);
            } else {
                this.board.setPublicKey(null);
            }
            if (string.startsWith("SSK@")) {
                this.board.setPrivateKey(string);
            } else {
                this.board.setPrivateKey(null);
            }
        } else {
            this.board.setPublicKey(null);
            this.board.setPrivateKey(null);
        }
        if (this.overrideSettingsCheckBox.isSelected()) {
            this.board.setConfigured(true);
            this.board.setAutoUpdateEnabled(this.autoUpdateEnabled.isSelected());
            if (!this.maxMsg_default.isSelected()) {
                this.board.setMaxMessageDays(new Integer(this.maxMsg_value.getText()));
            } else {
                this.board.setMaxMessageDays(null);
            }
            if (!this.signedOnly_default.isSelected()) {
                this.board.setShowSignedOnly(this.signedOnly_true.isSelected());
            } else {
                this.board.setShowSignedOnly(null);
            }
            if (!this.hideBad_default.isSelected()) {
                this.board.setHideBad(this.hideBad_true.isSelected());
            } else {
                this.board.setHideBad(null);
            }
            if (!this.hideCheck_default.isSelected()) {
                this.board.setHideCheck(this.hideCheck_true.isSelected());
            } else {
                this.board.setHideCheck(null);
            }
            if (!this.hideObserve_default.isSelected()) {
                this.board.setHideObserve(this.hideObserve_true.isSelected());
            } else {
                this.board.setHideObserve(null);
            }
        } else {
            this.board.setConfigured(false);
        }
    }

    private void updateBoard(Board board) {
        if (!board.isFolder()) {
            MainFrame.getInstance().updateTofTree(board);
            TOF.getInstance().initialSearchNewMessages(board);
            if (board == MainFrame.getInstance().getTofTreeModel().getSelectedNode()) {
                MainFrame.getInstance().tofTree_actionPerformed(null);
            }
        } else {
            for (int i = 0; i < board.getChildCount(); ++i) {
                Board board2 = (Board)board.getChildAt(i);
                this.updateBoard(board2);
            }
        }
    }

    private void okButton_actionPerformed(ActionEvent actionEvent) {
        this.ok();
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.dispose();
        }
        super.processWindowEvent(windowEvent);
    }

    private void radioButton_actionPerformed(ActionEvent actionEvent) {
        if (this.publicBoardRadioButton.isSelected()) {
            this.privateKeyTextField.setEnabled(false);
            this.publicKeyTextField.setEnabled(false);
            this.generateKeyButton.setEnabled(false);
        } else {
            this.privateKeyTextField.setEnabled(true);
            this.publicKeyTextField.setEnabled(true);
            this.generateKeyButton.setEnabled(true);
        }
    }

    private void refreshLanguage() {
        if (this.board.isFolder()) {
            this.setTitle("Settings for all boards in folder '" + this.board.getName() + "'");
        } else {
            this.setTitle(this.language.getString("Settings for board") + " '" + this.board.getName() + "'");
        }
        this.publicBoardRadioButton.setText(this.language.getString("Public board"));
        this.secureBoardRadioButton.setText(this.language.getString("Secure board"));
        this.okButton.setText(this.language.getString("OK"));
        this.cancelButton.setText(this.language.getString("Cancel"));
        this.generateKeyButton.setText(this.language.getString("Generate new keypair"));
        this.overrideSettingsCheckBox.setText(this.language.getString("Override default settings"));
        this.maxMsg_default.setText(this.language.getString("Use default"));
        this.maxMsg_set.setText(this.language.getString("Set to") + ":");
        this.signedOnly_default.setText(this.language.getString("Use default"));
        this.signedOnly_true.setText(this.language.getString("Yes"));
        this.signedOnly_false.setText(this.language.getString("No"));
        this.hideBad_default.setText(this.language.getString("Use default"));
        this.hideBad_true.setText(this.language.getString("Yes"));
        this.hideBad_false.setText(this.language.getString("No"));
        this.hideCheck_default.setText(this.language.getString("Use default"));
        this.hideCheck_true.setText(this.language.getString("Yes"));
        this.hideCheck_false.setText(this.language.getString("No"));
        this.hideObserve_default.setText(this.language.getString("Use default"));
        this.hideObserve_true.setText(this.language.getString("Yes"));
        this.hideObserve_false.setText(this.language.getString("No"));
        this.autoUpdateEnabled.setText(this.language.getString("Enable automatic board update"));
        this.publicKeyLabel.setText(this.language.getString("Public key") + " :");
        this.privateKeyLabel.setText(this.language.getString("Private key") + " :");
        this.messageDisplayDaysLabel.setText(this.language.getString("Maximum message display (days)"));
        this.hideUnsignedMessagesLabel.setText(this.language.getString("Hide unsigned messages"));
        this.hideBadMessagesLabel.setText(this.language.getString("Hide messages flagged BAD"));
        this.hideCheckMessagesLabel.setText(this.language.getString("Hide messages flagged CHECK"));
        this.hideObserveMessagesLabel.setText(this.language.getString("Hide messages flagged OBSERVE"));
        this.descriptionLabel.setText(this.language.getString("BoardSettingsFrame.description"));
    }

    public boolean runDialog() {
        this.setModal(true);
        this.setVisible(true);
        return this.exitState;
    }

    private void setPanelEnabled(JPanel jPanel, boolean bl) {
        int n = jPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = jPanel.getComponent(i);
            if (component == this.overrideSettingsCheckBox) continue;
            component.setEnabled(bl);
        }
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == BoardSettingsFrame.this.publicBoardRadioButton) {
                BoardSettingsFrame.this.radioButton_actionPerformed(actionEvent);
            } else if (actionEvent.getSource() == BoardSettingsFrame.this.secureBoardRadioButton) {
                BoardSettingsFrame.this.radioButton_actionPerformed(actionEvent);
            } else if (actionEvent.getSource() == BoardSettingsFrame.this.generateKeyButton) {
                BoardSettingsFrame.this.generateKeyButton_actionPerformed(actionEvent);
            } else if (actionEvent.getSource() == BoardSettingsFrame.this.okButton) {
                BoardSettingsFrame.this.okButton_actionPerformed(actionEvent);
            } else if (actionEvent.getSource() == BoardSettingsFrame.this.cancelButton) {
                BoardSettingsFrame.this.cancelButton_actionPerformed(actionEvent);
            } else if (actionEvent.getSource() == BoardSettingsFrame.this.overrideSettingsCheckBox) {
                BoardSettingsFrame.this.overrideSettingsCheckBox_actionPerformed(actionEvent);
            }
        }
    }
}

