/*
 * Decompiled with CFR 0.152.
 */
package frost.boards;

import frost.DateFun;
import frost.MainFrame;
import frost.boards.TofTree;
import frost.boards.TofTreeModel;
import frost.fileTransfer.Index;
import frost.gui.SortedTable;
import frost.gui.model.BoardInfoTableModel;
import frost.gui.model.SortedTableModel;
import frost.gui.model.TableMember;
import frost.gui.objects.Board;
import frost.messages.FrostIndex;
import frost.threads.BoardUpdateThread;
import frost.threads.BoardUpdateThreadListener;
import frost.util.gui.JSkinnablePopupMenu;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

public class BoardInfoFrame
extends JFrame
implements BoardUpdateThreadListener {
    private TofTree tofTree = null;
    private static boolean isShowing = false;
    private Language language = null;
    private Listener listener = new Listener();
    private static Logger logger = Logger.getLogger(BoardInfoFrame.class.getName());
    private JPanel mainPanel = new JPanel(new BorderLayout());
    private JPanel boardTablePanel = new JPanel(new BorderLayout());
    private JLabel summaryLabel = new JLabel();
    private JButton updateButton = new JButton();
    private JButton updateSelectedBoardButton = new JButton();
    private JButton updateAllBoardsButton = new JButton();
    private JButton Bclose = new JButton();
    private JSkinnablePopupMenu popupMenu = new JSkinnablePopupMenu();
    private JMenuItem MIupdate = new JMenuItem();
    private JMenuItem MIupdateSelectedBoard = new JMenuItem();
    private JMenuItem MIupdateAllBoards = new JMenuItem();
    private BoardInfoTableModel boardTableModel = null;
    private SortedTable boardTable = null;
    private static UpdateBoardInfoTableThread updateBoardInfoTableThread = null;

    private void refreshLanguage() {
        this.setTitle(this.language.getString("BoardInfoFrame.Board information window"));
        this.updateButton.setText(this.language.getString("BoardInfoFrame.Update"));
        this.updateSelectedBoardButton.setText(this.language.getString("BoardInfoFrame.UpdateSelectedBoardButton"));
        this.updateAllBoardsButton.setText(this.language.getString("BoardInfoFrame.Update all boards"));
        this.Bclose.setText(this.language.getString("BoardInfoFrame.Close"));
        this.MIupdate.setText(this.language.getString("BoardInfoFrame.Update"));
        this.MIupdateSelectedBoard.setText(this.language.getString("BoardInfoFrame.UpdateSelectedBoardButton"));
        this.MIupdateAllBoards.setText(this.language.getString("BoardInfoFrame.Update all boards"));
    }

    public BoardInfoFrame(JFrame jFrame, TofTree tofTree) {
        this.language = Language.getInstance();
        this.refreshLanguage();
        this.tofTree = tofTree;
        this.enableEvents(64L);
        try {
            this.Init();
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Exception thrown in constructor", exception);
        }
        this.setSize((int)((double)jFrame.getWidth() * 0.75), (int)((double)jFrame.getHeight() * 0.75));
        this.setLocationRelativeTo(jFrame);
    }

    private void Init() throws Exception {
        this.boardTableModel = new BoardInfoTableModel();
        this.boardTable = new SortedTable(this.boardTableModel);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/data/jtc.jpg"));
        this.setIconImage(imageIcon.getImage());
        this.setSize(new Dimension(300, 200));
        this.setResizable(true);
        this.boardTable.setRowSelectionAllowed(true);
        this.boardTable.setSelectionMode(2);
        BoardInfoTableCellRenderer boardInfoTableCellRenderer = new BoardInfoTableCellRenderer();
        this.boardTable.setDefaultRenderer(Object.class, boardInfoTableCellRenderer);
        this.boardTable.setDefaultRenderer(Number.class, boardInfoTableCellRenderer);
        this.updateSelectedBoardButton.setEnabled(false);
        this.boardTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                BoardInfoFrame.this.boardTableListModel_valueChanged(listSelectionEvent);
            }
        });
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BoardInfoFrame.this.updateButton_actionPerformed(actionEvent);
            }
        };
        this.updateButton.addActionListener(actionListener);
        this.MIupdate.addActionListener(actionListener);
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BoardInfoFrame.this.updateSelectedBoardButton_actionPerformed(actionEvent);
            }
        };
        this.updateSelectedBoardButton.addActionListener(actionListener);
        this.MIupdateSelectedBoard.addActionListener(actionListener);
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BoardInfoFrame.this.updateAllBoardsButton_actionPerformed(actionEvent);
            }
        };
        this.updateAllBoardsButton.addActionListener(actionListener);
        this.MIupdateAllBoards.addActionListener(actionListener);
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BoardInfoFrame.this.closeDialog();
            }
        };
        this.Bclose.addActionListener(actionListener);
        this.getContentPane().add((Component)this.mainPanel, null);
        this.mainPanel.add((Component)this.boardTablePanel, "Center");
        this.boardTablePanel.add((Component)this.updateSelectedBoardButton, "North");
        this.boardTablePanel.add((Component)new JScrollPane(this.boardTable), "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        jPanel.add(this.summaryLabel);
        jPanel.add(Box.createRigidArea(new Dimension(15, 3)));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.updateButton);
        this.boardTablePanel.add((Component)jPanel, "South");
        this.boardTablePanel.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(7, 7, 7, 7)));
        this.boardTablePanel.setBorder(new CompoundBorder(new EmptyBorder(7, 7, 7, 7), this.boardTablePanel.getBorder()));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 7, 7, 7));
        jPanel2.add(this.updateSelectedBoardButton);
        jPanel2.add(Box.createRigidArea(new Dimension(15, 3)));
        jPanel2.add(this.updateAllBoardsButton);
        jPanel2.add(Box.createRigidArea(new Dimension(15, 3)));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(this.Bclose);
        this.mainPanel.add((Component)jPanel2, "South");
        this.boardTable.addMouseListener(this.listener);
        this.popupMenu.add(this.MIupdateSelectedBoard);
        this.popupMenu.add(this.MIupdateAllBoards);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.MIupdate);
        this.updateButton_actionPerformed(null);
    }

    private void boardTableListModel_valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.boardTable.getSelectedRowCount() > 0) {
            this.updateSelectedBoardButton.setEnabled(true);
            this.MIupdateSelectedBoard.setEnabled(true);
        } else {
            this.updateSelectedBoardButton.setEnabled(false);
            this.MIupdateSelectedBoard.setEnabled(false);
        }
    }

    private void updateButton_actionPerformed(ActionEvent actionEvent) {
        if (updateBoardInfoTableThread != null) {
            return;
        }
        ((SortedTableModel)this.boardTable.getModel()).clearDataModel();
        updateBoardInfoTableThread = new UpdateBoardInfoTableThread();
        updateBoardInfoTableThread.start();
        this.updateSelectedBoardButton.setEnabled(false);
        this.MIupdateSelectedBoard.setEnabled(false);
    }

    private void updateAllBoardsButton_actionPerformed(ActionEvent actionEvent) {
        Vector vector = ((TofTreeModel)this.tofTree.getModel()).getAllBoards();
        for (int i = 0; i < vector.size(); ++i) {
            Board board = (Board)vector.elementAt(i);
            if (this.tofTree.isUpdateAllowed(board)) {
                this.tofTree.updateBoard(board);
            }
            this.boardTableModel.fireTableDataChanged();
        }
    }

    private void updateSelectedBoardButton_actionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.boardTable.getSelectedRows();
        if (nArray.length > 0) {
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                if (n >= this.boardTableModel.getRowCount()) continue;
                BoardInfoTableMember boardInfoTableMember = (BoardInfoTableMember)this.boardTableModel.getRow(n);
                if (this.tofTree.isUpdateAllowed(boardInfoTableMember.getBoard())) {
                    this.tofTree.updateBoard(boardInfoTableMember.getBoard());
                }
                this.boardTableModel.fireTableCellUpdated(n, 0);
            }
            this.boardTable.clearSelection();
        }
    }

    public BoardInfoTableMember fillInBoardCounts(Board board, BoardInfoTableMember boardInfoTableMember) {
        File[] fileArray;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string = DateFun.getDate();
        File file = new File(MainFrame.keypool + board.getBoardFilename());
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    boolean bl = fileArray[i].getName().startsWith(string);
                    String[] stringArray = fileArray[i].list();
                    for (int j = 0; j < stringArray.length; ++j) {
                        if (!stringArray[j].endsWith(".xml")) continue;
                        if (bl) {
                            ++n;
                        }
                        ++n2;
                    }
                    continue;
                }
                if (!fileArray[i].getName().endsWith("files.xml")) continue;
                n3 += this.getLineCount(fileArray[i]);
            }
        }
        boardInfoTableMember.setAllMessageCount(n2);
        boardInfoTableMember.setNewMessageCount(n);
        boardInfoTableMember.setFilesCount(n3);
        return boardInfoTableMember;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineCount(File file) {
        Index index;
        FrostIndex frostIndex = null;
        Index index2 = index = Index.getInstance();
        synchronized (index2) {
            frostIndex = index.readKeyFile(file);
        }
        if (frostIndex == null) {
            return 0;
        }
        return frostIndex.getFilesMap().size();
    }

    public void startDialog() {
        this.tofTree.getRunningBoardUpdateThreads().addBoardUpdateThreadListener(this);
        this.language.addLanguageListener(this.listener);
        this.language.addLanguageListener(this.boardTableModel);
        BoardInfoFrame.setDialogShowing(true);
        this.setVisible(true);
    }

    protected void closeDialog() {
        this.tofTree.getRunningBoardUpdateThreads().removeBoardUpdateThreadListener(this);
        this.language.removeLanguageListener(this.listener);
        this.language.removeLanguageListener(this.boardTableModel);
        BoardInfoFrame.setDialogShowing(false);
        this.dispose();
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.closeDialog();
        }
        super.processWindowEvent(windowEvent);
    }

    public void boardUpdateThreadFinished(BoardUpdateThread boardUpdateThread) {
        this.boardTableModel.tableEntriesChanged();
    }

    public void boardUpdateThreadStarted(BoardUpdateThread boardUpdateThread) {
        this.boardTableModel.tableEntriesChanged();
    }

    public static boolean isDialogShowing() {
        return isShowing;
    }

    public static void setDialogShowing(boolean bl) {
        isShowing = bl;
    }

    private class BoardInfoTableCellRenderer
    extends DefaultTableCellRenderer {
        Font boldFont;
        Font origFont;

        public BoardInfoTableCellRenderer() {
            this.origFont = BoardInfoFrame.this.boardTable.getFont();
            this.boldFont = this.origFont.deriveFont(1);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            BoardInfoTableMember boardInfoTableMember = (BoardInfoTableMember)BoardInfoFrame.this.boardTableModel.getRow(n);
            if (boardInfoTableMember.getBoard().isUpdating()) {
                this.setFont(this.boldFont);
            } else {
                this.setFont(this.origFont);
            }
            return this;
        }
    }

    class BoardInfoTableMember
    implements TableMember {
        Board board;
        Integer allmsg;
        Integer newmsg;
        Integer files;

        public BoardInfoTableMember(Board board) {
            this.board = board;
            this.allmsg = null;
            this.newmsg = null;
            this.files = null;
        }

        public Object getValueAt(int n) {
            switch (n) {
                case 0: {
                    return this.board.getName();
                }
                case 1: {
                    return this.board.getStateString();
                }
                case 2: {
                    return this.allmsg;
                }
                case 3: {
                    return this.newmsg;
                }
                case 4: {
                    return this.files;
                }
            }
            return "*ERR*";
        }

        public int compareTo(TableMember tableMember, int n) {
            Comparable comparable = (Comparable)this.getValueAt(n);
            Comparable comparable2 = (Comparable)tableMember.getValueAt(n);
            return comparable.compareTo(comparable2);
        }

        public Board getBoard() {
            return this.board;
        }

        public Integer getFilesCount() {
            return this.files;
        }

        public void setFilesCount(int n) {
            this.files = new Integer(n);
        }

        public Integer getAllMessageCount() {
            return this.allmsg;
        }

        public void setAllMessageCount(int n) {
            this.allmsg = new Integer(n);
        }

        public void setNewMessageCount(int n) {
            this.newmsg = new Integer(n);
        }
    }

    private class UpdateBoardInfoTableThread
    extends Thread {
        private UpdateBoardInfoTableThread() {
        }

        public void run() {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            Vector vector = ((TofTreeModel)BoardInfoFrame.this.tofTree.getModel()).getAllBoards();
            for (int i = 0; i < vector.size(); ++i) {
                Board board = (Board)vector.elementAt(i);
                BoardInfoTableMember boardInfoTableMember = new BoardInfoTableMember(board);
                BoardInfoFrame.this.fillInBoardCounts(board, boardInfoTableMember);
                final BoardInfoTableMember boardInfoTableMember2 = boardInfoTableMember;
                final int n4 = ++n3;
                final int n5 = n += boardInfoTableMember.getAllMessageCount().intValue();
                final int n6 = n2 += boardInfoTableMember.getFilesCount().intValue();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BoardInfoFrame.this.boardTableModel.addRow(boardInfoTableMember2);
                        BoardInfoFrame.this.summaryLabel.setText(BoardInfoFrame.this.language.getString("BoardInfoFrame.Boards") + "   :" + n4 + "    " + BoardInfoFrame.this.language.getString("BoardInfoFrame.Messages") + "  : " + n5 + "    " + BoardInfoFrame.this.language.getString("BoardInfoFrame.Files") + "   :" + n6);
                    }
                });
            }
            BoardInfoFrame.updateBoardInfoTableThread = null;
        }
    }

    private class Listener
    implements MouseListener,
    LanguageListener {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                BoardInfoFrame.this.updateSelectedBoardButton_actionPerformed(null);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                BoardInfoFrame.this.popupMenu.show(BoardInfoFrame.this.boardTable, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void languageChanged(LanguageEvent languageEvent) {
            BoardInfoFrame.this.refreshLanguage();
        }
    }
}

