/*
 * Decompiled with CFR 0.152.
 */
package frost;

import frost.FileAccess;
import frost.MainFrame;
import frost.XMLizable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XMLTools {
    private static Logger logger = Logger.getLogger(XMLTools.class.getName());
    private static DocumentBuilderFactory validatingFactory = DocumentBuilderFactory.newInstance();
    private static DocumentBuilderFactory nonValidatingFactory = DocumentBuilderFactory.newInstance();

    public XMLTools() {
        validatingFactory.setAttribute("http://apache.org/xml/features/disallow-doctype-decl", new Boolean(true));
        validatingFactory.setAttribute("http://xml.org/sax/features/external-general-entities", new Boolean(false));
        validatingFactory.setAttribute("http://xml.org/sax/features/external-parameter-entities", new Boolean(false));
        validatingFactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", new Boolean(false));
        validatingFactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", new Boolean(false));
        validatingFactory.setValidating(true);
        nonValidatingFactory.setAttribute("http://apache.org/xml/features/disallow-doctype-decl", new Boolean(true));
        nonValidatingFactory.setAttribute("http://xml.org/sax/features/external-general-entities", new Boolean(false));
        nonValidatingFactory.setAttribute("http://xml.org/sax/features/external-parameter-entities", new Boolean(false));
        nonValidatingFactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", new Boolean(false));
        nonValidatingFactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", new Boolean(false));
        nonValidatingFactory.setValidating(false);
    }

    public static Document getXMLDocument(XMLizable xMLizable) {
        Document document = XMLTools.createDomDocument();
        document.appendChild(xMLizable.getXMLElement(document));
        return document;
    }

    public static byte[] getRawXMLDocument(XMLizable xMLizable) {
        Document document = XMLTools.getXMLDocument(xMLizable);
        File file = XMLTools.getXmlTempFile();
        byte[] byArray = null;
        try {
            XMLTools.writeXmlFile(document, file.getPath());
            byArray = FileAccess.readByteArray(file);
            file.delete();
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "Exception thrown in getRawXMLDocument(XMLizable element)", throwable);
        }
        return byArray;
    }

    public static Document parseXmlContent(byte[] byArray, boolean bl) {
        File file = XMLTools.getXmlTempFile();
        try {
            FileAccess.writeFile(byArray, file);
            Document document = XMLTools.parseXmlFile(file, bl);
            return document;
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "Exception thrown in parseXmlContent", throwable);
            file.delete();
            return null;
        }
    }

    public static Document parseXmlFile(String string, boolean bl) throws IllegalArgumentException {
        return XMLTools.parseXmlFile(new File(string), bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parseXmlFile(File file, boolean bl) throws IllegalArgumentException {
        try {
            DocumentBuilder documentBuilder;
            if (bl) {
                DocumentBuilderFactory documentBuilderFactory = validatingFactory;
                synchronized (documentBuilderFactory) {
                    documentBuilder = validatingFactory.newDocumentBuilder();
                }
            }
            DocumentBuilderFactory documentBuilderFactory = nonValidatingFactory;
            synchronized (documentBuilderFactory) {
                documentBuilder = nonValidatingFactory.newDocumentBuilder();
            }
            return documentBuilder.parse(file);
        }
        catch (SAXException sAXException) {
            logger.log(Level.SEVERE, "Parsing of xml file failed (send badfile.xml to a dev for analysis) - File name: '" + file.getName() + "'", sAXException);
            file.renameTo(new File("badfile.xml"));
            throw new IllegalArgumentException();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            logger.log(Level.SEVERE, "Exception thrown in parseXmlFile(File file, boolean validating) - File name: '" + file.getName() + "'", parserConfigurationException);
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Exception thrown in parseXmlFile(File file, boolean validating) - File name: '" + file.getName() + "'", iOException);
        }
        return null;
    }

    public static boolean writeXmlFile(Document document, String string) {
        try {
            OutputFormat outputFormat = new OutputFormat(document, "UTF-16", false);
            outputFormat.setLineSeparator("\r\n");
            outputFormat.setLineWidth(0);
            outputFormat.setPreserveSpace(true);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-16");
            XMLSerializer xMLSerializer = new XMLSerializer(outputStreamWriter, outputFormat);
            xMLSerializer.asDOMSerializer();
            xMLSerializer.serialize(document);
            outputStreamWriter.close();
            return true;
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Exception thrown in writeXmlFile(Document doc, String filename)", exception);
            return false;
        }
    }

    public static Document createDomDocument() {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            logger.log(Level.SEVERE, "Exception thrown in createDomDocument()", parserConfigurationException);
            return null;
        }
    }

    public static boolean getBoolValueFromAttribute(Element element, String string, boolean bl) {
        String string2 = element.getAttribute(string);
        if (string2 == null) {
            return bl;
        }
        return string2.toLowerCase().equals("true");
    }

    public static ArrayList getChildElementsByTagName(Element element, String string) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !(element2 = (Element)node).getTagName().equals(string)) continue;
            arrayList.add(element2);
        }
        return arrayList;
    }

    public static String getChildElementsTextValue(Element element, String string) {
        ArrayList arrayList = XMLTools.getChildElementsByTagName(element, string);
        if (arrayList.size() == 0) {
            return null;
        }
        Text text = (Text)((Node)arrayList.get(0)).getFirstChild();
        if (text == null) {
            return null;
        }
        return text.getData().trim();
    }

    public static String getChildElementsCDATAValue(Element element, String string) {
        ArrayList arrayList = XMLTools.getChildElementsByTagName(element, string);
        if (arrayList.size() == 0) {
            return null;
        }
        CDATASection cDATASection = (CDATASection)((Node)arrayList.get(0)).getFirstChild();
        if (cDATASection == null) {
            return null;
        }
        return cDATASection.getData().trim();
    }

    private static File getXmlTempFile() {
        File file = null;
        try {
            file = File.createTempFile("xmltools_", ".tmp", new File(MainFrame.frostSettings.getValue("temp.dir")));
        }
        catch (Exception exception) {
            file = new File("xmltools_" + System.currentTimeMillis());
        }
        if (file != null) {
            file.deleteOnExit();
        }
        return file;
    }
}

