/*
 * Decompiled with CFR 0.152.
 */
package frost;

import frost.SettingsUpdater;
import frost.storage.Savable;
import frost.storage.StorageException;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SettingsClass
implements Savable {
    private File settingsFile;
    private Hashtable settingsHash;
    private Hashtable defaults = null;
    private final String fs = System.getProperty("file.separator");
    private PropertyChangeSupport changeSupport = null;
    private Vector updaters = null;
    private static Logger logger = Logger.getLogger(SettingsClass.class.getName());
    public static final String AUTO_SAVE_INTERVAL = "autoSaveInterval";
    public static final String DISABLE_DOWNLOADS = "disableDownloads";
    public static final String DISABLE_REQUESTS = "disableRequests";
    public static final String DOWNLOADING_ACTIVATED = "downloadingActivated";
    public static final String LOG_FILE_SIZE_LIMIT = "logFileSizeLimit";
    public static final String LOG_LEVEL = "logLevel";
    public static final String LOG_TO_FILE = "logToFile";
    public static final String FILE_LIST_FONT_NAME = "fileListFontName";
    public static final String FILE_LIST_FONT_SIZE = "fileListFontSize";
    public static final String FILE_LIST_FONT_STYLE = "fileListFontStyle";
    public static final String MESSAGE_BODY_FONT_NAME = "messageBodyFontName";
    public static final String MESSAGE_BODY_FONT_SIZE = "messageBodyFontSize";
    public static final String MESSAGE_BODY_FONT_STYLE = "messageBodyFontStyle";
    public static final String MESSAGE_LIST_FONT_NAME = "messageListFontName";
    public static final String MESSAGE_LIST_FONT_SIZE = "messageListFontSize";
    public static final String MESSAGE_LIST_FONT_STYLE = "messageListFontStyle";
    public static final String RESTART_FAILED_UPLOADS = "restartFailedUploads";
    public static final String SEARCH_ALL_BOARDS = "searchAllBoards";
    public static final String SHOW_DELETED_MESSAGES = "showDeletedMessages";
    public static final String SILENTLY_RETRY_MESSAGES = "silentlyRetryMessages";
    public static final String UPLOAD_MAX_RETRIES = "uploadMaxRetries";
    public static final String UPLOAD_RETRIES_WAIT_TIME = "uploadRetriesWaitTime";

    public SettingsClass() {
        this.settingsHash = new Hashtable();
        this.settingsHash.put("config.dir", "config" + this.fs);
        String string = "config" + this.fs + "frost.ini";
        this.settingsFile = new File(string);
        this.loadDefaults();
        if (!this.readSettingsFile()) {
            this.writeSettingsFile();
        }
        this.settingsHash.put("unsent.dir", "localdata" + this.fs + "unsent" + this.fs);
    }

    private String setSystemsFileSeparator(String string) {
        if (this.fs.equals("\\")) {
            string = string.replace('/', File.separatorChar);
        } else if (this.fs.equals("/")) {
            string = string.replace('\\', File.separatorChar);
        }
        if (!string.endsWith(this.fs)) {
            string = string + this.fs;
        }
        return string;
    }

    public String getDefaultValue(String string) {
        String string2 = (String)this.defaults.get(string);
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public boolean readSettingsFile() {
        Object object;
        LineNumberReader lineNumberReader = null;
        if (!this.settingsFile.exists() && ((File)(object = new File("frost.ini"))).exists() && ((File)object).length() > 0L) {
            ((File)object).renameTo(this.settingsFile);
        }
        try {
            lineNumberReader = new LineNumberReader(new FileReader(this.settingsFile));
        }
        catch (Exception exception) {
            logger.warning(this.settingsFile.getName() + " does not exist, will create it");
            return false;
        }
        try {
            String string;
            while ((string = lineNumberReader.readLine()) != null) {
                if ((string = string.trim()).length() == 0 || string.startsWith("#")) continue;
                object = new StringTokenizer(string, "=");
                String string2 = "";
                String string3 = "";
                Object object2 = string3;
                if (((StringTokenizer)object).countTokens() < 2) continue;
                string2 = ((StringTokenizer)object).nextToken().trim();
                string3 = ((StringTokenizer)object).nextToken().trim();
                while (((StringTokenizer)object).hasMoreElements()) {
                    string3 = string3 + "=" + ((StringTokenizer)object).nextToken();
                }
                if (string3.startsWith("type.color(") && string3.endsWith(")")) {
                    String string4 = string3.substring(11, string3.length() - 1);
                    StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
                    if (stringTokenizer.countTokens() == 3) {
                        try {
                            int n = Integer.parseInt(stringTokenizer.nextToken().trim());
                            int n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
                            int n3 = Integer.parseInt(stringTokenizer.nextToken().trim());
                            Color color = new Color(n, n2, n3);
                            object2 = color;
                        }
                        catch (Exception exception) {
                            object2 = null;
                        }
                    } else {
                        object2 = null;
                    }
                } else if (string2.equals("unsent.dir") || string2.equals("temp.dir") || string2.equals("keypool.dir") || string2.equals("archive.dir")) {
                    string3 = this.setSystemsFileSeparator(string3);
                    object2 = string3;
                } else {
                    object2 = string3;
                }
                if (object2 == null) continue;
                this.settingsHash.put(string2, object2);
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Exception thrown in readSettingsFile()", exception);
        }
        try {
            lineNumberReader.close();
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Exception thrown in readSettingsFile()", exception);
        }
        if (this.getValue("messageBase").equals("")) {
            this.setValue("messageBase", "news");
        }
        logger.info("Read user configuration");
        return true;
    }

    private boolean writeSettingsFile() {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(this.settingsFile));
        }
        catch (IOException iOException) {
            try {
                File file = new File("config");
                if (!file.isDirectory()) {
                    file.mkdirs();
                }
                printWriter = new PrintWriter(new FileWriter(this.settingsFile));
            }
            catch (IOException iOException2) {
                logger.log(Level.SEVERE, "Exception thrown in writeSettingsFile()", iOException2);
                return false;
            }
        }
        TreeMap treeMap = new TreeMap(this.settingsHash);
        for (String string : treeMap.keySet()) {
            if (string.equals("config.dir")) continue;
            String string2 = null;
            if (treeMap.get(string) instanceof Color) {
                Color color = (Color)treeMap.get(string);
                string2 = new StringBuffer().append("type.color(").append(color.getRed()).append(",").append(color.getGreen()).append(",").append(color.getBlue()).append(")").toString();
            } else {
                string2 = treeMap.get(string).toString();
            }
            printWriter.println(string + "=" + string2);
        }
        try {
            printWriter.close();
            logger.info("Wrote configuration");
            return true;
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Exception thrown in writeSettingsFile", exception);
            return false;
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void addUpdater(SettingsUpdater settingsUpdater) {
        if (settingsUpdater == null) {
            return;
        }
        if (this.updaters == null) {
            this.updaters = new Vector();
        }
        this.updaters.addElement(settingsUpdater);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removeUpdater(SettingsUpdater settingsUpdater) {
        if (settingsUpdater == null || this.updaters == null) {
            return;
        }
        this.updaters.removeElement(settingsUpdater);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String string) {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners(string);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.firePropertyChange(string, object, object2);
    }

    public String getValue(String string) {
        return (String)this.settingsHash.get(string);
    }

    public Object getObjectValue(String string) {
        return this.settingsHash.get(string);
    }

    public String[] getArrayValue(String string) {
        String string2 = (String)this.settingsHash.get(string);
        if (string2 == null) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    public boolean getBoolValue(String string) {
        String string2 = (String)this.settingsHash.get(string);
        if (string2 == null) {
            return false;
        }
        try {
            if (string2.toLowerCase().equals("false")) {
                return false;
            }
            if (string2.toLowerCase().equals("true")) {
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return this.getBoolValue(this.getDefaultValue(string));
    }

    public int getIntValue(String string) {
        String string2 = (String)this.settingsHash.get(string);
        if (string2 == null) {
            return 0;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return this.getIntValue(this.getDefaultValue(string));
        }
        catch (Exception exception) {
            return 0;
        }
        return n;
    }

    public float getFloatValue(String string) {
        float f = 0.0f;
        String string2 = (String)this.settingsHash.get(string);
        if (string2 == null) {
            return f;
        }
        try {
            f = Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return this.getFloatValue(this.getDefaultValue(string));
        }
        catch (Exception exception) {
            return 0.0f;
        }
        return f;
    }

    public void setValue(String string, String string2) {
        if (string.endsWith(".dir")) {
            string2 = this.setSystemsFileSeparator(string2);
        }
        Object v = this.settingsHash.get(string);
        this.settingsHash.put(string, string2);
        this.firePropertyChange(string, v, string2);
    }

    public void setValue(String string, Integer n) {
        this.setValue(string, String.valueOf(n));
    }

    public void setValue(String string, int n) {
        this.setValue(string, String.valueOf(n));
    }

    public void setValue(String string, Float f) {
        this.setValue(string, String.valueOf(f));
    }

    public void setValue(String string, float f) {
        this.setValue(string, String.valueOf(f));
    }

    public void setValue(String string, Boolean bl) {
        this.setValue(string, String.valueOf(bl));
    }

    public void setValue(String string, boolean bl) {
        this.setValue(string, String.valueOf(bl));
    }

    public void setObjectValue(String string, Object object) {
        Object v = this.settingsHash.get(string);
        this.settingsHash.put(string, object);
        this.firePropertyChange(string, v, object);
    }

    public void loadDefaults() {
        this.defaults = new Hashtable();
        File file = File.listRoots()[0];
        this.defaults.put("keypool.dir", "keypool" + this.fs);
        this.defaults.put("unsent.dir", "localdata" + this.fs + "unsent" + this.fs);
        this.defaults.put("temp.dir", "localdata" + this.fs + "temp" + this.fs);
        this.defaults.put("archive.dir", "archive" + this.fs);
        this.defaults.put("mainframe.showSimpleTitle", "false");
        this.defaults.put("allowEvilBert", "false");
        this.defaults.put("altEdit", file + "path" + this.fs + "to" + this.fs + "editor" + " %f");
        this.defaults.put("automaticUpdate", "true");
        this.defaults.put("automaticUpdate.concurrentBoardUpdates", "6");
        this.defaults.put("automaticUpdate.boardsMinimumUpdateInterval", "45");
        this.defaults.put("boardUpdateVisualization", "true");
        this.defaults.put("doBoardBackoff", "false");
        this.defaults.put("spamTreshold", "5");
        this.defaults.put("sampleInterval", "5");
        this.defaults.put("blockMessage", "");
        this.defaults.put("blockMessageChecked", "false");
        this.defaults.put("blockMessageBody", "");
        this.defaults.put("blockMessageBodyChecked", "false");
        this.defaults.put("blockMessageBoard", "");
        this.defaults.put("blockMessageBoardChecked", "false");
        this.defaults.put("signedOnly", "false");
        this.defaults.put("hideBadMessages", "false");
        this.defaults.put("hideCheckMessages", "false");
        this.defaults.put("hideObserveMessages", "false");
        this.defaults.put("downloadDirectory", "downloads" + this.fs);
        this.defaults.put("downloadThreads", "3");
        this.defaults.put(DOWNLOADING_ACTIVATED, "true");
        this.defaults.put("downloadRestartFailedDownloads", "true");
        this.defaults.put("downloadEnableRequesting", "true");
        this.defaults.put("downloadRequestAfterTries", "5");
        this.defaults.put("downloadMaxRetries", "5");
        this.defaults.put("downloadWaittime", "5");
        this.defaults.put("downloadDecodeAfterEachSegment", "true");
        this.defaults.put("downloadTryAllSegments", "true");
        this.defaults.put(DISABLE_REQUESTS, "false");
        this.defaults.put(DISABLE_DOWNLOADS, "false");
        this.defaults.put("htlUpload", "21");
        this.defaults.put("keyDownloadHtl", "24");
        this.defaults.put("keyUploadHtl", "21");
        this.defaults.put("lastUsedDirectory", "." + this.fs);
        this.defaults.put("maxAge", "5");
        this.defaults.put("maxKeys", "500000");
        this.defaults.put("maxMessageDisplay", "15");
        this.defaults.put("maxMessageDownload", "5");
        this.defaults.put("messageBase", "news");
        this.defaults.put("nodeAddress", "127.0.0.1");
        this.defaults.put("nodePort", "8481");
        this.defaults.put("showSystrayIcon", "true");
        this.defaults.put("removeFinishedDownloads", "false");
        this.defaults.put("reducedBlockCheck", "false");
        this.defaults.put(SEARCH_ALL_BOARDS, "true");
        this.defaults.put("maxSearchResults", "10000");
        this.defaults.put("splitfileDownloadThreads", "30");
        this.defaults.put("splitfileUploadThreads", "15");
        this.defaults.put("tofDownloadHtl", "23");
        this.defaults.put("tofTreeSelectedRow", "0");
        this.defaults.put("tofUploadHtl", "21");
        this.defaults.put("uploadThreads", "3");
        this.defaults.put("uploadBatchSize", "100");
        this.defaults.put("indexFileRedundancy", "1");
        this.defaults.put("uploadingActivated", "true");
        this.defaults.put("automaticIndexing", "true");
        this.defaults.put("shareDownloads", "true");
        this.defaults.put("signUploads", "true");
        this.defaults.put("helpFriends", "true");
        this.defaults.put("hideBadFiles", "true");
        this.defaults.put("hideAnonFiles", "false");
        this.defaults.put("useAltEdit", "false");
        this.defaults.put("userName", "Anonymous");
        this.defaults.put("audioExtension", ".mp3;.ogg;.wav;.mid;.mod");
        this.defaults.put("videoExtension", ".mpeg;.mpg;.avi;.divx;.asf;.wmv;.rm;.ogm");
        this.defaults.put("documentExtension", ".doc;.txt;.tex;.pdf;.dvi");
        this.defaults.put("executableExtension", ".exe;.vbs;.jar;.sh;.bat;.bin");
        this.defaults.put("archiveExtension", ".zip;.rar;.jar;.gz;.arj;.ace;.bz;.tar");
        this.defaults.put("imageExtension", ".jpeg;.jpg;.jfif;.gif;.png;.tif;.tiff;.bmp;.xpm");
        this.defaults.put(AUTO_SAVE_INTERVAL, "15");
        this.defaults.put("messageExpireDays", "30");
        this.defaults.put("messageExpirationMode", "KEEP");
        this.defaults.put("boardUpdatingNonSelectedBackgroundColor", new Color(233, 233, 233));
        this.defaults.put("boardUpdatingSelectedBackgroundColor", new Color(137, 137, 191));
        this.defaults.put("skinsEnabled", "false");
        this.defaults.put("selectedSkin", "none");
        this.defaults.put("locale", "default");
        this.defaults.put("lastFrameWidth", "700");
        this.defaults.put("lastFrameHeight", "500");
        this.defaults.put("lastFramePosX", "50");
        this.defaults.put("lastFramePosY", "50");
        this.defaults.put("lastFrameMaximized", "false");
        this.defaults.put(MESSAGE_BODY_FONT_NAME, "Monospaced");
        this.defaults.put(MESSAGE_BODY_FONT_STYLE, new Integer(0).toString());
        this.defaults.put(MESSAGE_BODY_FONT_SIZE, "12");
        this.defaults.put(MESSAGE_LIST_FONT_NAME, "SansSerif");
        this.defaults.put(MESSAGE_LIST_FONT_STYLE, new Integer(0).toString());
        this.defaults.put(MESSAGE_LIST_FONT_SIZE, "11");
        this.defaults.put(FILE_LIST_FONT_NAME, "SansSerif");
        this.defaults.put(FILE_LIST_FONT_STYLE, new Integer(0).toString());
        this.defaults.put(FILE_LIST_FONT_SIZE, "11");
        this.defaults.put("messageBodyAA", "false");
        this.defaults.put(LOG_TO_FILE, "true");
        this.defaults.put(LOG_LEVEL, "Low");
        this.defaults.put(LOG_FILE_SIZE_LIMIT, "1000");
        this.defaults.put(SILENTLY_RETRY_MESSAGES, "false");
        this.defaults.put(SHOW_DELETED_MESSAGES, "false");
        this.defaults.put(RESTART_FAILED_UPLOADS, "true");
        this.defaults.put(UPLOAD_MAX_RETRIES, "5");
        this.defaults.put(UPLOAD_RETRIES_WAIT_TIME, "5");
        this.defaults.put("oneTimeUpdate.convertSigs.didRun", "false");
        this.defaults.put("oneTimeUpdate.repairIdentities.didRun", "false");
        this.settingsHash.putAll(this.defaults);
    }

    public void save() throws StorageException {
        if (this.updaters != null) {
            Enumeration enumeration = this.updaters.elements();
            while (enumeration.hasMoreElements()) {
                ((SettingsUpdater)enumeration.nextElement()).updateSettings();
            }
        }
        if (!this.writeSettingsFile()) {
            throw new StorageException("Error while saving the settings.");
        }
    }
}

