/*
 * Decompiled with CFR 0.152.
 */
package frost;

import frost.MainFrame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public final class Mixed {
    private static Logger logger = Logger.getLogger(Mixed.class.getName());
    private static char[] invalidChars = new char[]{'/', '\\', '?', '*', '<', '>', '\"', ':', '|', '#'};

    public static void copyFromResource(String string, File file) throws IOException {
        if (!file.isFile()) {
            int n;
            InputStream inputStream = MainFrame.class.getResourceAsStream(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[128];
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            inputStream.close();
            fileOutputStream.close();
        }
    }

    public static void wait(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String makeSafeXML(String string) {
        int n;
        if (string == null) {
            return null;
        }
        while ((n = string.indexOf("]]>")) != -1) {
            string = string.substring(0, n) + "___" + string.substring(n + 3, string.length());
        }
        return string;
    }

    public static String makeFilename(String string) {
        if (string == null) {
            logger.severe("ERROR: mixed.makeFilename() was called with NULL!");
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string.startsWith(".")) {
            stringBuffer.append("_");
        }
        for (int i = 0; i < invalidChars.length; ++i) {
            string = string.replace(invalidChars[i], '_');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String makeASCIIFilename(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "()-!.";
        for (int i = 0; i < string.length(); ++i) {
            int n = Character.getNumericValue(string.charAt(i));
            char c = string.charAt(i);
            if (n >= 0 && n < 36 || string2.indexOf(c) != -1) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append("_");
        }
        return Mixed.makeFilename(stringBuffer.toString());
    }

    public static boolean containsForeign(String string) {
        char[] cArray = string.toCharArray();
        Character c = new Character(cArray[0]);
        return false;
    }

    public static boolean binaryCompare(byte[] byArray, int n, String string) {
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            byte by;
            byte by2 = (byte)string.charAt(i);
            if (by2 == (by = byArray[n + i])) continue;
            return false;
        }
        return true;
    }
}

