/*
 * Decompiled with CFR 0.152.
 */
package frost;

import frost.Core;
import frost.DateFun;
import frost.FileAccess;
import frost.Mixed;
import frost.SettingsClass;
import frost.SettingsUpdater;
import frost.boards.BoardInfoFrame;
import frost.boards.TOF;
import frost.boards.TofTree;
import frost.boards.TofTreeModel;
import frost.components.BrowserFrame;
import frost.components.translate.TranslateFrame;
import frost.ext.JSysTrayIcon;
import frost.fileTransfer.download.DownloadModel;
import frost.fileTransfer.download.FrostDownloadItem;
import frost.fileTransfer.search.FrostSearchItem;
import frost.fileTransfer.upload.UploadPanel;
import frost.gui.AboutBox;
import frost.gui.HelpFrame;
import frost.gui.KnownBoardsFrame;
import frost.gui.MessageFrame;
import frost.gui.MessageTable;
import frost.gui.MessageWindow;
import frost.gui.model.AttachedBoardTableModel;
import frost.gui.model.AttachedFilesTableModel;
import frost.gui.model.MessageTableModel;
import frost.gui.objects.Board;
import frost.gui.objects.FrostMessageObject;
import frost.gui.objects.TargetFolderChooser;
import frost.gui.preferences.OptionsFrame;
import frost.identities.FrostIdentities;
import frost.identities.Identity;
import frost.messages.AttachmentList;
import frost.messages.BoardAttachment;
import frost.messages.FileAttachment;
import frost.messages.MessageObject;
import frost.messages.SharedFileObject;
import frost.storage.StorageException;
import frost.util.gui.AntialiasedTextArea;
import frost.util.gui.JSkinnablePopupMenu;
import frost.util.gui.MiscToolkit;
import frost.util.gui.translation.JTranslatableTabbedPane;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeNode;

public class MainFrame
extends JFrame
implements ClipboardOwner,
SettingsUpdater {
    private static Core core;
    private static String fileSeparator;
    public static SettingsClass frostSettings;
    private static MainFrame instance;
    public static String keypool;
    private static final Comparator lastUpdateStartMillisCmp;
    private static Logger logger;
    private static ImageIcon[] newMessage;
    private final String allMessagesCountPrefix = "Msg: ";
    private JLabel allMessagesCountLabel = new JLabel("Msg: 0");
    private JButton boardInfoButton = null;
    private long counter = 55L;
    private DownloadModel downloadModel = null;
    private JMenuItem fileExitMenuItem = new JMenuItem();
    private JMenu fileMenu = new JMenu();
    private JMenuItem helpAboutMenuItem = new JMenuItem();
    private JMenuItem helpHelpMenuItem = new JMenuItem();
    private JMenu helpMenu = new JMenu();
    private JButton knownBoardsButton = null;
    private JRadioButtonMenuItem languageBulgarianMenuItem = new JRadioButtonMenuItem();
    private JRadioButtonMenuItem languageDefaultMenuItem = new JRadioButtonMenuItem();
    private JRadioButtonMenuItem languageDutchMenuItem = new JRadioButtonMenuItem();
    private JRadioButtonMenuItem languageEnglishMenuItem = new JRadioButtonMenuItem();
    private JRadioButtonMenuItem languageFrenchMenuItem = new JRadioButtonMenuItem();
    private JRadioButtonMenuItem languageGermanMenuItem = new JRadioButtonMenuItem();
    private JRadioButtonMenuItem languageItalianMenuItem = new JRadioButtonMenuItem();
    private JRadioButtonMenuItem languageJapaneseMenuItem = new JRadioButtonMenuItem();
    private JMenu languageMenu = new JMenu();
    private Language language = null;
    private JRadioButtonMenuItem languageSpanishMenuItem = new JRadioButtonMenuItem();
    private Listener listener = new Listener();
    private JMenuBar menuBar;
    private MessagePanel messagePanel = null;
    private MessageTable messageTable = null;
    private MessageTableModel messageTableModel;
    private JScrollPane messageListScrollPane = null;
    private JButton newBoardButton = null;
    private JButton newFolderButton = null;
    private JToolBar buttonToolBar;
    private JPanel extendableStatusPanel;
    private final String newMessagesCountPrefix = "New: ";
    private JLabel newMessagesCountLabel = new JLabel("New: 0");
    private JMenu optionsMenu = new JMenu();
    private JMenuItem optionsPreferencesMenuItem = new JMenuItem();
    private JMenuItem pluginBrowserMenuItem = new JMenuItem();
    private JMenu pluginMenu = new JMenu();
    private JMenuItem pluginTranslateMenuItem = new JMenuItem();
    private JButton removeBoardButton = null;
    private JButton renameFolderButton = null;
    private JLabel statusLabel = null;
    private JLabel statusMessageLabel = null;
    private JButton systemTrayButton = null;
    private JTranslatableTabbedPane tabbedPane;
    private JLabel timeLabel = null;
    private JCheckBoxMenuItem tofAutomaticUpdateMenuItem = new JCheckBoxMenuItem();
    private JMenuItem tofDecreaseFontSizeMenuItem = new JMenuItem();
    private JMenuItem tofDisplayBoardInfoMenuItem = new JMenuItem();
    private JMenuItem tofDisplayKnownBoards = new JMenuItem();
    private JMenuItem tofIncreaseFontSizeMenuItem = new JMenuItem();
    private JMenu tofMenu = new JMenu();
    private TofTree tofTree = null;
    private TofTreeModel tofTreeModel = null;
    private UploadPanel uploadPanel = null;

    public static void displayNewMessageIcon(boolean bl) {
        MainFrame mainFrame = MainFrame.getInstance();
        if (bl) {
            ImageIcon imageIcon = new ImageIcon(MainFrame.class.getResource("/data/newmessage.gif"));
            mainFrame.setIconImage(imageIcon.getImage());
            mainFrame.statusMessageLabel.setIcon(newMessage[0]);
            if (!System.getProperty("os.name").startsWith("Windows")) {
                String string = mainFrame.getTitle();
                if (!(string.equals("*") || string.startsWith("*") && string.endsWith("*"))) {
                    string = "*" + string + "*";
                }
                mainFrame.setTitle(string);
            }
        } else {
            ImageIcon imageIcon = new ImageIcon(MainFrame.class.getResource("/data/jtc.jpg"));
            mainFrame.setIconImage(imageIcon.getImage());
            mainFrame.statusMessageLabel.setIcon(newMessage[1]);
            if (!System.getProperty("os.name").startsWith("Windows")) {
                String string = mainFrame.getTitle();
                if (!string.equals("*") && string.startsWith("*") && string.endsWith("*")) {
                    string = string.substring(1, string.length() - 1);
                }
                mainFrame.setTitle(string);
            }
        }
    }

    public static MainFrame getInstance() {
        return instance;
    }

    public MainFrame(SettingsClass settingsClass, String string) {
        instance = this;
        core = Core.getInstance();
        frostSettings = settingsClass;
        this.language = Language.getInstance();
        keypool = frostSettings.getValue("keypool.dir");
        this.setDefaultCloseOperation(0);
        frostSettings.addUpdater(this);
        this.enableEvents(64L);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/data/jtc.jpg"));
        this.setIconImage(imageIcon.getImage());
        this.setResizable(true);
        this.setTitle(string);
        this.addWindowListener(this.listener);
    }

    public void addPanel(String string, JPanel jPanel) {
        this.getTabbedPane().add(string, jPanel);
    }

    public void addStatusPanel(JPanel jPanel, int n) {
        this.getExtendableStatusPanel().add((Component)jPanel, n);
    }

    public void addButton(JButton jButton, int n, int n2, boolean bl) {
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < this.getButtonToolBar().getComponentCount() && n4 < n; ++n3) {
            Component component = this.getButtonToolBar().getComponentAtIndex(n3);
            if (!(component instanceof JToolBar.Separator)) continue;
            ++n4;
        }
        if (n4 < n) {
            this.getButtonToolBar().addSeparator();
            this.getButtonToolBar().add(jButton);
            return;
        }
        if (bl) {
            this.getButtonToolBar().add((Component)new JToolBar.Separator(), n3);
            this.getButtonToolBar().add((Component)jButton, n3);
            return;
        }
        Component component = this.getButtonToolBar().getComponentAtIndex(n3);
        for (int i = 0; n3 < this.getButtonToolBar().getComponentCount() && !(component instanceof JToolBar.Separator) && i < n2; ++i) {
            component = this.getButtonToolBar().getComponentAtIndex(++n3);
        }
        this.getButtonToolBar().add((Component)jButton, n3);
    }

    public void addMenuItem(JMenuItem jMenuItem, String string, int n, int n2, boolean bl) {
        int n3;
        String string2 = this.language.getString(string);
        JMenu jMenu = null;
        for (n3 = 0; n3 < this.getMainMenuBar().getMenuCount() && jMenu == null; ++n3) {
            JMenu jMenu2 = this.getMainMenuBar().getMenu(n3);
            if (jMenu2 == null || !string2.equals(jMenu2.getText())) continue;
            jMenu = jMenu2;
        }
        if (jMenu == null) {
            jMenu = new JMenu(string2);
            this.getMainMenuBar().add(jMenu);
            jMenu.add(jMenuItem);
            return;
        }
        int n4 = 0;
        for (n3 = 0; n3 < jMenu.getItemCount() && n4 < n; ++n3) {
            JMenuItem jMenuItem2 = jMenu.getItem(n3);
            if (jMenuItem2 != null) continue;
            ++n4;
        }
        if (n4 < n) {
            jMenu.addSeparator();
            jMenu.add(jMenuItem);
            return;
        }
        if (bl) {
            jMenu.insertSeparator(n3);
            jMenu.insert(jMenuItem, n3);
            return;
        }
        JMenuItem jMenuItem3 = jMenu.getItem(n3);
        for (int i = 0; n3 < jMenu.getComponentCount() && jMenuItem3 != null && i < n2; ++i) {
            jMenuItem3 = jMenu.getItem(++n3);
        }
        jMenu.add((Component)jMenuItem, n3);
    }

    private JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTranslatableTabbedPane(this.language);
        }
        return this.tabbedPane;
    }

    private JToolBar getButtonToolBar() {
        if (this.buttonToolBar == null) {
            this.buttonToolBar = new JToolBar();
            this.timeLabel = new JLabel("");
            this.knownBoardsButton = new JButton(new ImageIcon(this.getClass().getResource("/data/knownboards.gif")));
            this.newBoardButton = new JButton(new ImageIcon(this.getClass().getResource("/data/newboard.gif")));
            this.newFolderButton = new JButton(new ImageIcon(this.getClass().getResource("/data/newfolder.gif")));
            this.removeBoardButton = new JButton(new ImageIcon(this.getClass().getResource("/data/remove.gif")));
            this.renameFolderButton = new JButton(new ImageIcon(this.getClass().getResource("/data/rename.gif")));
            this.boardInfoButton = new JButton(new ImageIcon(this.getClass().getResource("/data/info.gif")));
            this.systemTrayButton = new JButton(new ImageIcon(this.getClass().getResource("/data/tray.gif")));
            MiscToolkit miscToolkit = MiscToolkit.getInstance();
            miscToolkit.configureButton(this.newBoardButton, "New board", "/data/newboard_rollover.gif", this.language);
            miscToolkit.configureButton(this.newFolderButton, "New folder", "/data/newfolder_rollover.gif", this.language);
            miscToolkit.configureButton(this.removeBoardButton, "Remove board", "/data/remove_rollover.gif", this.language);
            miscToolkit.configureButton(this.renameFolderButton, "Rename folder", "/data/rename_rollover.gif", this.language);
            miscToolkit.configureButton(this.boardInfoButton, "Board Information Window", "/data/info_rollover.gif", this.language);
            miscToolkit.configureButton(this.systemTrayButton, "Minimize to System Tray", "/data/tray_rollover.gif", this.language);
            miscToolkit.configureButton(this.knownBoardsButton, "Display list of known boards", "/data/knownboards_rollover.gif", this.language);
            this.knownBoardsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.tofDisplayKnownBoardsMenuItem_actionPerformed(actionEvent);
                }
            });
            this.newBoardButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.tofTree.createNewBoard(MainFrame.this);
                }
            });
            this.newFolderButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.tofTree.createNewFolder(MainFrame.this);
                }
            });
            this.renameFolderButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.renameNode(MainFrame.this.tofTreeModel.getSelectedNode());
                }
            });
            this.removeBoardButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.tofTree.removeNode(MainFrame.this.tofTreeModel.getSelectedNode());
                }
            });
            this.systemTrayButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        if (JSysTrayIcon.getInstance() != null) {
                            JSysTrayIcon.getInstance().showWindow(JSysTrayIcon.SHOW_CMD_HIDE);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            this.boardInfoButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.tofDisplayBoardInfoMenuItem_actionPerformed(actionEvent);
                }
            });
            this.buttonToolBar.setRollover(true);
            this.buttonToolBar.setFloatable(false);
            Dimension dimension = new Dimension(3, 3);
            this.buttonToolBar.add(Box.createRigidArea(dimension));
            this.buttonToolBar.add(this.newBoardButton);
            this.buttonToolBar.add(this.newFolderButton);
            this.buttonToolBar.add(Box.createRigidArea(dimension));
            this.buttonToolBar.addSeparator();
            this.buttonToolBar.add(Box.createRigidArea(dimension));
            this.buttonToolBar.add(this.renameFolderButton);
            this.buttonToolBar.add(Box.createRigidArea(dimension));
            this.buttonToolBar.addSeparator();
            this.buttonToolBar.add(Box.createRigidArea(dimension));
            this.buttonToolBar.add(this.removeBoardButton);
            this.buttonToolBar.add(Box.createRigidArea(dimension));
            this.buttonToolBar.addSeparator();
            this.buttonToolBar.add(Box.createRigidArea(dimension));
            this.buttonToolBar.add(this.boardInfoButton);
            this.buttonToolBar.add(this.knownBoardsButton);
            if (JSysTrayIcon.getInstance() != null) {
                this.buttonToolBar.add(Box.createRigidArea(dimension));
                this.buttonToolBar.addSeparator();
                this.buttonToolBar.add(Box.createRigidArea(dimension));
                this.buttonToolBar.add(this.systemTrayButton);
            }
            this.buttonToolBar.add(Box.createHorizontalGlue());
            this.buttonToolBar.add(this.timeLabel);
            this.buttonToolBar.add(Box.createRigidArea(dimension));
        }
        return this.buttonToolBar;
    }

    private JMenuBar getMainMenuBar() {
        if (this.menuBar == null) {
            this.menuBar = new JMenuBar();
            MiscToolkit miscToolkit = MiscToolkit.getInstance();
            this.tofDisplayBoardInfoMenuItem.setIcon(miscToolkit.getScaledImage("/data/info.gif", 16, 16));
            this.tofAutomaticUpdateMenuItem.setSelected(true);
            this.tofDisplayKnownBoards.setIcon(miscToolkit.getScaledImage("/data/knownboards.gif", 16, 16));
            this.fileExitMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.fileExitMenuItem_actionPerformed(actionEvent);
                }
            });
            this.optionsPreferencesMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.optionsPreferencesMenuItem_actionPerformed(actionEvent);
                }
            });
            this.tofIncreaseFontSizeMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = frostSettings.getIntValue("messageBodyFontSize");
                    frostSettings.setValue("messageBodyFontSize", n + 1);
                }
            });
            this.tofDecreaseFontSizeMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = frostSettings.getIntValue("messageBodyFontSize");
                    frostSettings.setValue("messageBodyFontSize", n - 1);
                }
            });
            this.tofDisplayBoardInfoMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.tofDisplayBoardInfoMenuItem_actionPerformed(actionEvent);
                }
            });
            this.tofDisplayKnownBoards.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.tofDisplayKnownBoardsMenuItem_actionPerformed(actionEvent);
                }
            });
            this.pluginBrowserMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BrowserFrame browserFrame = new BrowserFrame(true);
                    browserFrame.setVisible(true);
                }
            });
            this.pluginTranslateMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TranslateFrame translateFrame = new TranslateFrame(true);
                    translateFrame.setVisible(true);
                }
            });
            this.languageDefaultMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ResourceBundle resourceBundle = ResourceBundle.getBundle("res.LangRes");
                    frostSettings.setValue("locale", "default");
                    MainFrame.this.setLanguageResource(resourceBundle);
                }
            });
            this.languageBulgarianMenuItem.setIcon(miscToolkit.getScaledImage("/data/flag_bg.png", 16, 16));
            this.languageGermanMenuItem.setIcon(miscToolkit.getScaledImage("/data/flag_de.png", 16, 16));
            this.languageEnglishMenuItem.setIcon(miscToolkit.getScaledImage("/data/flag_en.png", 16, 16));
            this.languageSpanishMenuItem.setIcon(miscToolkit.getScaledImage("/data/flag_es.png", 16, 16));
            this.languageFrenchMenuItem.setIcon(miscToolkit.getScaledImage("/data/flag_fr.png", 16, 16));
            this.languageItalianMenuItem.setIcon(miscToolkit.getScaledImage("/data/flag_it.png", 16, 16));
            this.languageJapaneseMenuItem.setIcon(miscToolkit.getScaledImage("/data/flag_jp.png", 16, 16));
            this.languageDutchMenuItem.setIcon(miscToolkit.getScaledImage("/data/flag_nl.png", 16, 16));
            this.languageGermanMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ResourceBundle resourceBundle = ResourceBundle.getBundle("res.LangRes", new Locale("de"));
                    frostSettings.setValue("locale", "de");
                    MainFrame.this.setLanguageResource(resourceBundle);
                }
            });
            this.languageEnglishMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ResourceBundle resourceBundle = ResourceBundle.getBundle("res.LangRes", new Locale("en"));
                    frostSettings.setValue("locale", "en");
                    MainFrame.this.setLanguageResource(resourceBundle);
                }
            });
            this.languageDutchMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ResourceBundle resourceBundle = ResourceBundle.getBundle("res.LangRes", new Locale("nl"));
                    frostSettings.setValue("locale", "nl");
                    MainFrame.this.setLanguageResource(resourceBundle);
                }
            });
            this.languageFrenchMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ResourceBundle resourceBundle = ResourceBundle.getBundle("res.LangRes", new Locale("fr"));
                    frostSettings.setValue("locale", "fr");
                    MainFrame.this.setLanguageResource(resourceBundle);
                }
            });
            this.languageJapaneseMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ResourceBundle resourceBundle = ResourceBundle.getBundle("res.LangRes", new Locale("ja"));
                    frostSettings.setValue("locale", "ja");
                    MainFrame.this.setLanguageResource(resourceBundle);
                }
            });
            this.languageItalianMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ResourceBundle resourceBundle = ResourceBundle.getBundle("res.LangRes", new Locale("it"));
                    frostSettings.setValue("locale", "it");
                    MainFrame.this.setLanguageResource(resourceBundle);
                }
            });
            this.languageSpanishMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ResourceBundle resourceBundle = ResourceBundle.getBundle("res.LangRes", new Locale("es"));
                    frostSettings.setValue("locale", "es");
                    MainFrame.this.setLanguageResource(resourceBundle);
                }
            });
            this.languageBulgarianMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ResourceBundle resourceBundle = ResourceBundle.getBundle("res.LangRes", new Locale("bg"));
                    frostSettings.setValue("locale", "bg");
                    MainFrame.this.setLanguageResource(resourceBundle);
                }
            });
            this.helpHelpMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    HelpFrame helpFrame = new HelpFrame(MainFrame.this);
                    helpFrame.setVisible(true);
                }
            });
            this.helpAboutMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainFrame.this.helpAboutMenuItem_actionPerformed(actionEvent);
                }
            });
            this.fileMenu.add(this.fileExitMenuItem);
            this.tofMenu.add(this.tofAutomaticUpdateMenuItem);
            this.tofMenu.addSeparator();
            this.tofMenu.add(this.tofDisplayBoardInfoMenuItem);
            this.tofMenu.add(this.tofDisplayKnownBoards);
            this.optionsMenu.add(this.optionsPreferencesMenuItem);
            this.pluginMenu.add(this.pluginBrowserMenuItem);
            this.pluginMenu.add(this.pluginTranslateMenuItem);
            ButtonGroup buttonGroup = new ButtonGroup();
            this.languageDefaultMenuItem.setSelected(true);
            buttonGroup.add(this.languageDefaultMenuItem);
            buttonGroup.add(this.languageDutchMenuItem);
            buttonGroup.add(this.languageEnglishMenuItem);
            buttonGroup.add(this.languageFrenchMenuItem);
            buttonGroup.add(this.languageGermanMenuItem);
            buttonGroup.add(this.languageItalianMenuItem);
            buttonGroup.add(this.languageJapaneseMenuItem);
            buttonGroup.add(this.languageSpanishMenuItem);
            buttonGroup.add(this.languageBulgarianMenuItem);
            HashMap<String, JRadioButtonMenuItem> hashMap = new HashMap<String, JRadioButtonMenuItem>();
            hashMap.put("default", this.languageDefaultMenuItem);
            hashMap.put("de", this.languageGermanMenuItem);
            hashMap.put("en", this.languageEnglishMenuItem);
            hashMap.put("nl", this.languageDutchMenuItem);
            hashMap.put("fr", this.languageFrenchMenuItem);
            hashMap.put("ja", this.languageJapaneseMenuItem);
            hashMap.put("it", this.languageItalianMenuItem);
            hashMap.put("es", this.languageSpanishMenuItem);
            hashMap.put("bg", this.languageBulgarianMenuItem);
            String string = frostSettings.getValue("locale");
            Object v = hashMap.get(string);
            if (v != null) {
                buttonGroup.setSelected(((JMenuItem)v).getModel(), true);
            }
            this.languageMenu.add(this.languageDefaultMenuItem);
            this.languageMenu.addSeparator();
            this.languageMenu.add(this.languageDutchMenuItem);
            this.languageMenu.add(this.languageEnglishMenuItem);
            this.languageMenu.add(this.languageFrenchMenuItem);
            this.languageMenu.add(this.languageGermanMenuItem);
            this.languageMenu.add(this.languageItalianMenuItem);
            this.languageMenu.add(this.languageJapaneseMenuItem);
            this.languageMenu.add(this.languageSpanishMenuItem);
            this.languageMenu.add(this.languageBulgarianMenuItem);
            this.helpMenu.add(this.helpHelpMenuItem);
            this.helpMenu.add(this.helpAboutMenuItem);
            this.menuBar.add(this.fileMenu);
            this.menuBar.add(this.tofMenu);
            this.menuBar.add(this.optionsMenu);
            this.menuBar.add(this.pluginMenu);
            this.menuBar.add(this.languageMenu);
            this.menuBar.add(this.helpMenu);
            this.translateMainMenu();
        }
        return this.menuBar;
    }

    private JPanel buildStatusBar() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.statusLabel = new JLabel(this.language.getString("Frost by Jantho"));
        this.statusMessageLabel = new JLabel();
        MainFrame.newMessage[0] = new ImageIcon(MainFrame.class.getResource("/data/messagebright.gif"));
        MainFrame.newMessage[1] = new ImageIcon(MainFrame.class.getResource("/data/messagedark.gif"));
        this.statusMessageLabel.setIcon(newMessage[1]);
        jPanel.add((Component)this.getExtendableStatusPanel(), "West");
        jPanel.add((Component)this.statusLabel, "Center");
        jPanel.add((Component)this.statusMessageLabel, "East");
        return jPanel;
    }

    private JPanel getExtendableStatusPanel() {
        if (this.extendableStatusPanel == null) {
            this.extendableStatusPanel = new JPanel(new FlowLayout(0, 5, 0));
        }
        return this.extendableStatusPanel;
    }

    private JPanel buildTofMainPanel() {
        this.getTabbedPane().insertTab("News", null, this.getMessagePanel(), null, 0);
        this.getTabbedPane().setSelectedIndex(0);
        JScrollPane jScrollPane = new JScrollPane(this.tofTree);
        this.tofTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                MainFrame.this.tofTree_actionPerformed(treeSelectionEvent);
            }
        });
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, this.getTabbedPane());
        jSplitPane.setDividerLocation(160);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jSplitPane, "Center");
        return jPanel;
    }

    public boolean doUpdate(Board board) {
        if (!this.tofTree.isUpdateAllowed(board)) {
            return false;
        }
        return !board.isUpdating();
    }

    private void fileExitMenuItem_actionPerformed(ActionEvent actionEvent) {
        if (this.tofTree.getRunningBoardUpdateThreads().getRunningUploadThreadCount() > 0) {
            int n = JOptionPane.showConfirmDialog(this, this.language.getString("UploadsUnderway.body"), this.language.getString("UploadsUnderway.title"), 0, 3);
            if (n == 0) {
                System.exit(0);
            }
        } else {
            System.exit(0);
        }
    }

    private MessagePanel getMessagePanel() {
        if (this.messagePanel == null) {
            this.messagePanel = new MessagePanel(frostSettings);
            this.messagePanel.setParentFrame(this);
            this.messagePanel.setIdentities(core.getIdentities());
            this.messagePanel.initialize();
        }
        return this.messagePanel;
    }

    public MessageTableModel getMessageTableModel() {
        return this.messageTableModel;
    }

    public TofTreeModel getTofTreeModel() {
        return this.tofTreeModel;
    }

    private void helpAboutMenuItem_actionPerformed(ActionEvent actionEvent) {
        AboutBox aboutBox = new AboutBox(this);
        aboutBox.setVisible(true);
    }

    public void initialize() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.getButtonToolBar(), "North");
        jPanel.add((Component)this.buildTofMainPanel(), "Center");
        jPanel.add((Component)this.buildStatusBar(), "South");
        this.setJMenuBar(this.getMainMenuBar());
        TOF.getInstance().initialSearchNewMessages();
        if (core.isFreenetOnline()) {
            this.tofAutomaticUpdateMenuItem.setSelected(frostSettings.getBoolValue("automaticUpdate"));
        } else {
            this.tofAutomaticUpdateMenuItem.setSelected(false);
        }
        if (this.tofTree.getRowCount() > frostSettings.getIntValue("tofTreeSelectedRow")) {
            this.tofTree.setSelectionRow(frostSettings.getIntValue("tofTreeSelectedRow"));
        }
        if (frostSettings.getIntValue("messageBodyFontSize") < 6) {
            frostSettings.setValue("messageBodyFontSize", 6);
        }
        int n = frostSettings.getIntValue("lastFrameHeight");
        int n2 = frostSettings.getIntValue("lastFrameWidth");
        int n3 = frostSettings.getIntValue("lastFramePosX");
        int n4 = frostSettings.getIntValue("lastFramePosY");
        boolean bl = frostSettings.getBoolValue("lastFrameMaximized");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (n2 < 100) {
            n2 = 700;
        }
        if (n2 > dimension.width) {
            n2 = dimension.width;
        }
        if (n < 100) {
            n = 500;
        }
        if (n > dimension.height) {
            n2 = dimension.height;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n3 + n2 > dimension.width) {
            n3 = dimension.width / 10;
            n2 = (int)(dimension.getWidth() / 10.0 * 8.0);
        }
        if (n4 + n > dimension.height) {
            n4 = dimension.height / 10;
            n = (int)(dimension.getHeight() / 10.0 * 8.0);
        }
        this.setBounds(n3, n4, n2, n);
        if (bl) {
            this.setExtendedState(this.getExtendedState() | 6);
        }
        Thread thread = new Thread("tick tack"){

            public void run() {
                while (true) {
                    Mixed.wait(1000);
                    MainFrame.this.timer_actionPerformed();
                }
            }
        };
        thread.start();
        this.validate();
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    private void optionsPreferencesMenuItem_actionPerformed(ActionEvent actionEvent) {
        try {
            frostSettings.save();
        }
        catch (StorageException storageException) {
            logger.log(Level.SEVERE, "Error while saving the settings.", storageException);
        }
        OptionsFrame optionsFrame = new OptionsFrame((Frame)this, frostSettings);
        boolean bl = optionsFrame.runDialog();
        if (bl) {
            if (optionsFrame.shouldReloadMessages()) {
                TOF.getInstance().initialSearchNewMessages();
                this.tofTree_actionPerformed(null);
            }
            this.tofTree.updateTree();
            if (optionsFrame.shouldRemoveDummyReqFiles()) {
                new RemoveDummyRequestFiles().start();
            }
        }
    }

    public void renameNode(Board board) {
        if (board == null) {
            return;
        }
        String string = null;
        do {
            if ((string = JOptionPane.showInputDialog(this, "Please enter the new name:\n", board.getName())) == null) {
                return;
            }
            if (board.isFolder() || this.tofTreeModel.getBoardByName(string) == null) continue;
            JOptionPane.showMessageDialog(this, "You already have a board with name '" + string + "'!\nPlease choose a new name.");
            string = "";
        } while (string.length() == 0);
        board.setName(string);
        this.updateTofTree(board);
    }

    public Board selectNextBoard(Vector vector) {
        Collections.sort(vector, lastUpdateStartMillisCmp);
        Board board = null;
        long l = System.currentTimeMillis();
        int n = frostSettings.getIntValue("automaticUpdate.boardsMinimumUpdateInterval");
        long l2 = n * 60 * 1000;
        for (int i = 0; i < vector.size(); ++i) {
            Board board2 = (Board)vector.get(i);
            if (board != null || !this.doUpdate(board2) || l - l2 <= board2.getLastUpdateStartMillis() || (!board2.isConfigured() || !board2.getAutoUpdateEnabled()) && board2.isConfigured()) continue;
            board = board2;
            break;
        }
        if (board != null) {
            logger.info("*** Automatic board update started for: " + board.getName());
        } else {
            logger.info("*** Automatic board update - min update interval not reached.  waiting...");
        }
        return board;
    }

    private void setLanguageResource(ResourceBundle resourceBundle) {
        this.language.setLanguageResource(resourceBundle);
        this.translateMainMenu();
        this.translateButtons();
    }

    public void setPanelEnabled(String string, boolean bl) {
        int n = this.getTabbedPane().indexOfTab(string);
        if (n != -1) {
            this.getTabbedPane().setEnabledAt(n, bl);
        }
    }

    public void setTofTree(TofTree tofTree) {
        this.tofTree = tofTree;
    }

    public void setTofTreeModel(TofTreeModel tofTreeModel) {
        this.tofTreeModel = tofTreeModel;
    }

    public void timer_actionPerformed() {
        Board board;
        Object object;
        ++this.counter;
        if (this.counter % 15L == 0L && this.isAutomaticBoardUpdateEnabled() && this.tofTree.getRunningBoardUpdateThreads().getUpdatingBoardCount() < frostSettings.getIntValue("automaticUpdate.concurrentBoardUpdates") && ((Vector)(object = this.tofTreeModel.getAllBoards())).size() > 0 && (board = this.selectNextBoard((Vector)object)) != null) {
            this.tofTree.updateBoard(board);
        }
        this.timeLabel.setText(new StringBuffer().append(DateFun.getVisibleExtendedDate()).append(" - ").append(DateFun.getFullExtendedTime()).append(" GMT").toString());
        object = new StringBuffer().append("   " + this.language.getString("TOFUP") + ": ").append(this.tofTree.getRunningBoardUpdateThreads().getUploadingBoardCount()).append("B / ").append(this.tofTree.getRunningBoardUpdateThreads().getRunningUploadThreadCount()).append("T").append("   " + this.language.getString("TOFDO") + ": ").append(this.tofTree.getRunningBoardUpdateThreads().getUpdatingBoardCount()).append("B / ").append(this.tofTree.getRunningBoardUpdateThreads().getRunningDownloadThreadCount()).append("T").append("   " + this.language.getString("Selected board") + ": ").append(this.tofTreeModel.getSelectedNode().getName()).toString();
        this.statusLabel.setText((String)object);
    }

    private void tofDisplayBoardInfoMenuItem_actionPerformed(ActionEvent actionEvent) {
        if (!BoardInfoFrame.isDialogShowing()) {
            BoardInfoFrame boardInfoFrame = new BoardInfoFrame(this, this.tofTree);
            boardInfoFrame.startDialog();
        }
    }

    private void tofDisplayKnownBoardsMenuItem_actionPerformed(ActionEvent actionEvent) {
        KnownBoardsFrame knownBoardsFrame = new KnownBoardsFrame(this, this.tofTree);
        knownBoardsFrame.startDialog();
    }

    private void tofNewMessageButton_actionPerformed(ActionEvent actionEvent) {
        MessageFrame messageFrame = new MessageFrame(frostSettings, this, core.getIdentities().getMyId());
        messageFrame.setTofTree(this.tofTree);
        messageFrame.composeNewMessage(this.tofTreeModel.getSelectedNode(), frostSettings.getValue("userName"), "No subject", "");
    }

    public void tofTree_actionPerformed(TreeSelectionEvent treeSelectionEvent) {
        Board board;
        int[] nArray = this.tofTree.getSelectionRows();
        if (nArray != null && nArray.length > 0) {
            frostSettings.setValue("tofTreeSelectedRow", nArray[0]);
        }
        if ((board = (Board)this.tofTree.getLastSelectedPathComponent()) != null) {
            if (!board.isFolder()) {
                this.removeBoardButton.setEnabled(true);
                this.updateButtons(board);
                logger.info("Board " + board.getName() + " blocked count: " + board.getBlockedCount());
                this.uploadPanel.setAddFilesButtonEnabled(true);
                this.renameFolderButton.setEnabled(false);
                TOF.getInstance().updateTofTable(board, keypool);
                this.messageTable.clearSelection();
            } else {
                this.getMessageTableModel().clearDataModel();
                this.updateMessageCountLabels(board);
                this.uploadPanel.setAddFilesButtonEnabled(false);
                this.renameFolderButton.setEnabled(true);
                if (board.isRoot()) {
                    this.removeBoardButton.setEnabled(false);
                } else {
                    this.removeBoardButton.setEnabled(true);
                }
            }
        }
    }

    private void translateButtons() {
        this.newBoardButton.setToolTipText(this.language.getString("New board"));
        this.systemTrayButton.setToolTipText(this.language.getString("Minimize to System Tray"));
        this.knownBoardsButton.setToolTipText(this.language.getString("Display list of known boards"));
        this.boardInfoButton.setToolTipText(this.language.getString("Board Information Window"));
        this.newFolderButton.setToolTipText(this.language.getString("New folder"));
        this.removeBoardButton.setToolTipText(this.language.getString("Remove board"));
        this.renameFolderButton.setToolTipText(this.language.getString("Rename folder"));
    }

    private void translateMainMenu() {
        this.fileMenu.setText(this.language.getString("File"));
        this.fileExitMenuItem.setText(this.language.getString("Exit"));
        this.tofMenu.setText(this.language.getString("News"));
        this.tofDisplayBoardInfoMenuItem.setText(this.language.getString("Display board information window"));
        this.tofAutomaticUpdateMenuItem.setText(this.language.getString("Automatic message update"));
        this.tofIncreaseFontSizeMenuItem.setText(this.language.getString("Increase Font Size"));
        this.tofDecreaseFontSizeMenuItem.setText(this.language.getString("Decrease Font Size"));
        this.tofDisplayKnownBoards.setText(this.language.getString("Display known boards"));
        this.optionsMenu.setText(this.language.getString("Options"));
        this.optionsPreferencesMenuItem.setText(this.language.getString("Preferences"));
        this.pluginMenu.setText(this.language.getString("Plugins"));
        this.pluginBrowserMenuItem.setText(this.language.getString("Experimental Freenet Browser"));
        this.pluginTranslateMenuItem.setText(this.language.getString("Translate Frost into another language"));
        this.languageMenu.setText(this.language.getString("Language"));
        this.languageDefaultMenuItem.setText(this.language.getString("Default"));
        this.languageDutchMenuItem.setText(this.language.getString("Dutch"));
        this.languageEnglishMenuItem.setText(this.language.getString("English"));
        this.languageFrenchMenuItem.setText(this.language.getString("French"));
        this.languageGermanMenuItem.setText(this.language.getString("German"));
        this.languageItalianMenuItem.setText(this.language.getString("Italian"));
        this.languageJapaneseMenuItem.setText(this.language.getString("Japanese"));
        this.languageSpanishMenuItem.setText(this.language.getString("Spanish"));
        this.languageBulgarianMenuItem.setText(this.language.getString("Bulgarian"));
        this.helpMenu.setText(this.language.getString("Help"));
        this.helpHelpMenuItem.setText(this.language.getString("Help"));
        this.helpAboutMenuItem.setText(this.language.getString("About"));
    }

    private void updateButtons(Board board) {
        if (board.isReadAccessBoard()) {
            this.uploadPanel.setAddFilesButtonEnabled(false);
        } else {
            this.uploadPanel.setAddFilesButtonEnabled(true);
        }
    }

    public void updateMessageCountLabels(Board board) {
        if (board.isFolder()) {
            this.allMessagesCountLabel.setText("");
            this.newMessagesCountLabel.setText("");
            this.messagePanel.nextUnreadMessageButton.setEnabled(false);
        } else {
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.messageTable.getModel();
            int n = defaultTableModel.getRowCount();
            this.allMessagesCountLabel.setText("Msg: " + n);
            int n2 = board.getNewMessageCount();
            this.newMessagesCountLabel.setText("New: " + n2);
            if (n2 > 0) {
                this.messagePanel.nextUnreadMessageButton.setEnabled(true);
            } else {
                this.messagePanel.nextUnreadMessageButton.setEnabled(false);
            }
        }
    }

    public void updateSettings() {
        frostSettings.setValue("automaticUpdate", this.tofAutomaticUpdateMenuItem.isSelected());
    }

    public void updateTofTree(Board board) {
        this.tofTreeModel.nodeChanged(board);
        TreeNode treeNode = (Board)board.getParent();
        if (treeNode != null) {
            this.tofTreeModel.nodeChanged(treeNode);
            treeNode = treeNode.getParent();
        }
        if (board == this.tofTreeModel.getSelectedNode()) {
            this.updateButtons(board);
        }
    }

    public void setDownloadModel(DownloadModel downloadModel) {
        this.downloadModel = downloadModel;
    }

    public void setUploadPanel(UploadPanel uploadPanel) {
        this.uploadPanel = uploadPanel;
    }

    public void setAutomaticBoardUpdateEnabled(boolean bl) {
        this.tofAutomaticUpdateMenuItem.setSelected(bl);
    }

    public boolean isAutomaticBoardUpdateEnabled() {
        return this.tofAutomaticUpdateMenuItem.isSelected();
    }

    static {
        fileSeparator = System.getProperty("file.separator");
        frostSettings = null;
        instance = null;
        keypool = null;
        lastUpdateStartMillisCmp = new Comparator(){

            public int compare(Object object, Object object2) {
                Board board = (Board)object;
                Board board2 = (Board)object2;
                if (board.getLastUpdateStartMillis() > board2.getLastUpdateStartMillis()) {
                    return 1;
                }
                if (board.getLastUpdateStartMillis() < board2.getLastUpdateStartMillis()) {
                    return -1;
                }
                return 0;
            }
        };
        logger = Logger.getLogger(MainFrame.class.getName());
        newMessage = new ImageIcon[2];
    }

    private class RemoveDummyRequestFiles
    extends Thread {
        private RemoveDummyRequestFiles() {
        }

        public void run() {
            for (Board board : MainFrame.this.tofTreeModel.getAllBoards()) {
                String string = new StringBuffer().append(keypool).append(board.getBoardFilename()).append(fileSeparator).append(DateFun.getDate()).append(fileSeparator).toString();
                File file = new File(string);
                if (!file.isDirectory()) continue;
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    File file2 = fileArray[i];
                    if (!file2.getName().endsWith(".req.sha") || FileAccess.readFile(file2).indexOf("ERROR: key collision") <= -1) continue;
                    file2.delete();
                }
            }
        }
    }

    private class MessagePanel
    extends JPanel {
        private Logger logger = Logger.getLogger(MessagePanel.class.getName());
        private SettingsClass settings;
        private Language language;
        private FrostIdentities identities;
        private JFrame parentFrame;
        private boolean initialized = false;
        private Listener listener = new Listener();
        private FrostMessageObject selectedMessage;
        private String lastSelectedMessage;
        private PopupMenuAttachmentBoard popupMenuAttachmentBoard = null;
        private PopupMenuAttachmentTable popupMenuAttachmentTable = null;
        private PopupMenuMessageTable popupMenuMessageTable = null;
        private PopupMenuTofText popupMenuTofText = null;
        private JButton setCheckButton = new JButton(new ImageIcon(this.getClass().getResource("/data/check.gif")));
        private JButton newMessageButton = new JButton(new ImageIcon(this.getClass().getResource("/data/newmessage.gif")));
        private JButton setBadButton = new JButton(new ImageIcon(this.getClass().getResource("/data/nottrust.gif")));
        private JButton setObserveButton = new JButton(new ImageIcon(this.getClass().getResource("/data/observe.gif")));
        private JButton replyButton = new JButton(new ImageIcon(this.getClass().getResource("/data/reply.gif")));
        private JButton saveMessageButton = new JButton(new ImageIcon(this.getClass().getResource("/data/save.gif")));
        protected JButton nextUnreadMessageButton = new JButton(new ImageIcon(this.getClass().getResource("/data/nextunreadmessage.gif")));
        private JButton setGoodButton = new JButton(new ImageIcon(this.getClass().getResource("/data/trust.gif")));
        private JButton updateButton = new JButton(new ImageIcon(this.getClass().getResource("/data/update.gif")));
        private AntialiasedTextArea messageTextArea = null;
        private JSplitPane messageSplitPane = null;
        private JSplitPane attachmentsSplitPane = null;
        private AttachedFilesTableModel attachedFilesModel;
        private AttachedBoardTableModel attachedBoardsModel;
        private JTable filesTable = null;
        private JTable boardsTable = null;
        private JScrollPane filesTableScrollPane;
        private JScrollPane boardsTableScrollPane;

        public MessagePanel(SettingsClass settingsClass) {
            this.settings = settingsClass;
            this.language = Language.getInstance();
            settingsClass.addPropertyChangeListener("messageBodyFontName", this.listener);
            settingsClass.addPropertyChangeListener("messageBodyFontSize", this.listener);
            settingsClass.addPropertyChangeListener("messageBodyFontStyle", this.listener);
            settingsClass.addPropertyChangeListener("messageBodyAA", this.listener);
        }

        public void downloadAttachments() {
            int[] nArray = this.filesTable.getSelectedRows();
            if (nArray.length == 0) {
                for (FileAttachment fileAttachment : this.selectedMessage.getAttachmentsOfType(0)) {
                    SharedFileObject sharedFileObject = fileAttachment.getFileObj();
                    FrostSearchItem frostSearchItem = new FrostSearchItem(MainFrame.this.tofTreeModel.getSelectedNode(), sharedFileObject, 1);
                    FrostDownloadItem frostDownloadItem = new FrostDownloadItem(frostSearchItem);
                    MainFrame.this.downloadModel.addDownloadItem(frostDownloadItem);
                }
            } else {
                AttachmentList attachmentList = this.selectedMessage.getAttachmentsOfType(0);
                for (int i = 0; i < nArray.length; ++i) {
                    FileAttachment fileAttachment = (FileAttachment)attachmentList.get(nArray[i]);
                    SharedFileObject sharedFileObject = fileAttachment.getFileObj();
                    FrostSearchItem frostSearchItem = new FrostSearchItem(MainFrame.this.tofTreeModel.getSelectedNode(), sharedFileObject, 1);
                    FrostDownloadItem frostDownloadItem = new FrostDownloadItem(frostSearchItem);
                    MainFrame.this.downloadModel.addDownloadItem(frostDownloadItem);
                }
            }
        }

        private void downloadBoards(Board board) {
            this.logger.info("adding boards");
            int[] nArray = this.boardsTable.getSelectedRows();
            if (nArray.length == 0) {
                this.boardsTable.selectAll();
                nArray = this.boardsTable.getSelectedRows();
                if (nArray.length == 0) {
                    return;
                }
            }
            AttachmentList attachmentList = this.selectedMessage.getAttachmentsOfType(1);
            for (int i = 0; i < nArray.length; ++i) {
                BoardAttachment boardAttachment = (BoardAttachment)attachmentList.get(nArray[i]);
                Board board2 = boardAttachment.getBoardObj();
                String string = board2.getName();
                Board board3 = MainFrame.this.tofTreeModel.getBoardByName(string);
                if (board3 != null) {
                    if (JOptionPane.showConfirmDialog(this, "You already have a board named " + string + ".\n" + "Are you sure you want to add this one over it?", "Board already exists", 0) != 0) continue;
                    board3.setPublicKey(board2.getPublicKey());
                    board3.setPrivateKey(board2.getPrivateKey());
                    MainFrame.this.updateTofTree(board3);
                    continue;
                }
                if (board == null) {
                    MainFrame.this.tofTreeModel.addNodeToTree(board2);
                    continue;
                }
                MainFrame.this.tofTreeModel.addNodeToTree(board2, board);
            }
        }

        private JToolBar getButtonsToolbar() {
            MiscToolkit miscToolkit = MiscToolkit.getInstance();
            miscToolkit.configureButton(this.newMessageButton, "New message", "/data/newmessage_rollover.gif", this.language);
            miscToolkit.configureButton(this.updateButton, "Update", "/data/update_rollover.gif", this.language);
            miscToolkit.configureButton(this.replyButton, "Reply", "/data/reply_rollover.gif", this.language);
            miscToolkit.configureButton(this.saveMessageButton, "Save message", "/data/save_rollover.gif", this.language);
            miscToolkit.configureButton(this.nextUnreadMessageButton, "Next unread message", "/data/nextunreadmessage_rollover.gif", this.language);
            miscToolkit.configureButton(this.setGoodButton, "Trust", "/data/trust_rollover.gif", this.language);
            miscToolkit.configureButton(this.setBadButton, "Do not trust", "/data/nottrust_rollover.gif", this.language);
            miscToolkit.configureButton(this.setCheckButton, "Set to CHECK", "/data/check_rollover.gif", this.language);
            miscToolkit.configureButton(this.setObserveButton, "Set to OBSERVE", "/data/observe_rollover.gif", this.language);
            this.replyButton.setEnabled(false);
            this.saveMessageButton.setEnabled(false);
            this.setGoodButton.setEnabled(false);
            this.setCheckButton.setEnabled(false);
            this.setBadButton.setEnabled(false);
            this.setObserveButton.setEnabled(false);
            JToolBar jToolBar = new JToolBar();
            jToolBar.setRollover(true);
            jToolBar.setFloatable(false);
            Dimension dimension = new Dimension(3, 3);
            jToolBar.add(Box.createRigidArea(dimension));
            jToolBar.add(this.nextUnreadMessageButton);
            jToolBar.add(Box.createRigidArea(dimension));
            jToolBar.addSeparator();
            jToolBar.add(Box.createRigidArea(dimension));
            jToolBar.add(this.saveMessageButton);
            jToolBar.add(Box.createRigidArea(dimension));
            jToolBar.addSeparator();
            jToolBar.add(Box.createRigidArea(dimension));
            jToolBar.add(this.newMessageButton);
            jToolBar.add(this.replyButton);
            jToolBar.add(Box.createRigidArea(dimension));
            jToolBar.addSeparator();
            jToolBar.add(Box.createRigidArea(dimension));
            jToolBar.add(this.updateButton);
            jToolBar.add(Box.createRigidArea(dimension));
            jToolBar.addSeparator();
            jToolBar.add(Box.createRigidArea(dimension));
            jToolBar.add(this.setGoodButton);
            jToolBar.add(this.setObserveButton);
            jToolBar.add(this.setCheckButton);
            jToolBar.add(this.setBadButton);
            jToolBar.add(Box.createRigidArea(new Dimension(8, 0)));
            jToolBar.add(Box.createHorizontalGlue());
            JLabel jLabel = new JLabel("Msg: 00000");
            jLabel.doLayout();
            Dimension dimension2 = jLabel.getPreferredSize();
            MainFrame.this.allMessagesCountLabel.setPreferredSize(dimension2);
            MainFrame.this.allMessagesCountLabel.setMinimumSize(dimension2);
            MainFrame.this.newMessagesCountLabel.setPreferredSize(dimension2);
            MainFrame.this.newMessagesCountLabel.setMinimumSize(dimension2);
            jToolBar.add(MainFrame.this.allMessagesCountLabel);
            jToolBar.add(Box.createRigidArea(new Dimension(8, 0)));
            jToolBar.add(MainFrame.this.newMessagesCountLabel);
            jToolBar.add(Box.createRigidArea(dimension));
            this.newMessageButton.addActionListener(this.listener);
            this.updateButton.addActionListener(this.listener);
            this.replyButton.addActionListener(this.listener);
            this.saveMessageButton.addActionListener(this.listener);
            this.nextUnreadMessageButton.addActionListener(this.listener);
            this.setGoodButton.addActionListener(this.listener);
            this.setCheckButton.addActionListener(this.listener);
            this.setBadButton.addActionListener(this.listener);
            this.setObserveButton.addActionListener(this.listener);
            return jToolBar;
        }

        private PopupMenuAttachmentBoard getPopupMenuAttachmentBoard() {
            if (this.popupMenuAttachmentBoard == null) {
                this.popupMenuAttachmentBoard = new PopupMenuAttachmentBoard();
                this.language.addLanguageListener(this.popupMenuAttachmentBoard);
            }
            return this.popupMenuAttachmentBoard;
        }

        private PopupMenuAttachmentTable getPopupMenuAttachmentTable() {
            if (this.popupMenuAttachmentTable == null) {
                this.popupMenuAttachmentTable = new PopupMenuAttachmentTable();
                this.language.addLanguageListener(this.popupMenuAttachmentTable);
            }
            return this.popupMenuAttachmentTable;
        }

        private PopupMenuMessageTable getPopupMenuMessageTable() {
            if (this.popupMenuMessageTable == null) {
                this.popupMenuMessageTable = new PopupMenuMessageTable();
                this.language.addLanguageListener(this.popupMenuMessageTable);
            }
            return this.popupMenuMessageTable;
        }

        private PopupMenuTofText getPopupMenuTofText() {
            if (this.popupMenuTofText == null) {
                this.popupMenuTofText = new PopupMenuTofText(this.messageTextArea);
                this.language.addLanguageListener(this.popupMenuTofText);
            }
            return this.popupMenuTofText;
        }

        public void initialize() {
            if (!this.initialized) {
                this.refreshLanguage();
                this.language.addLanguageListener(this.listener);
                MainFrame.this.messageTableModel = new MessageTableModel();
                this.language.addLanguageListener(MainFrame.this.messageTableModel);
                MainFrame.this.messageTable = new MessageTable(MainFrame.this.messageTableModel);
                MainFrame.this.messageTable.setSelectionMode(0);
                MainFrame.this.messageTable.getSelectionModel().addListSelectionListener(this.listener);
                MainFrame.this.messageListScrollPane = new JScrollPane(MainFrame.this.messageTable);
                this.messageTextArea = new AntialiasedTextArea();
                this.messageTextArea.setEditable(false);
                this.messageTextArea.setLineWrap(true);
                this.messageTextArea.setWrapStyleWord(true);
                this.messageTextArea.setAntiAliasEnabled(this.settings.getBoolValue("messageBodyAA"));
                JScrollPane jScrollPane = new JScrollPane(this.messageTextArea);
                this.attachedFilesModel = new AttachedFilesTableModel();
                this.filesTable = new JTable(this.attachedFilesModel);
                this.filesTableScrollPane = new JScrollPane(this.filesTable);
                this.attachedBoardsModel = new AttachedBoardTableModel();
                this.boardsTable = new JTable(this.attachedBoardsModel){
                    DescColumnRenderer descColRenderer;
                    {
                        this.descColRenderer = new DescColumnRenderer();
                    }

                    public TableCellRenderer getCellRenderer(int n, int n2) {
                        if (n2 == 2) {
                            return this.descColRenderer;
                        }
                        return super.getCellRenderer(n, n2);
                    }

                    class DescColumnRenderer
                    extends DefaultTableCellRenderer {
                        DescColumnRenderer() {
                        }

                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                            String string = (String)object;
                            if (string != null && string.length() > 0) {
                                this.setToolTipText(string);
                            } else {
                                this.setToolTipText(null);
                            }
                            return this;
                        }
                    }
                };
                this.boardsTableScrollPane = new JScrollPane(this.boardsTable);
                this.fontChanged();
                this.attachmentsSplitPane = new JSplitPane(0, this.filesTableScrollPane, this.boardsTableScrollPane);
                this.attachmentsSplitPane.setResizeWeight(0.5);
                this.attachmentsSplitPane.setDividerSize(3);
                this.attachmentsSplitPane.setDividerLocation(0.5);
                this.messageSplitPane = new JSplitPane(0, jScrollPane, this.attachmentsSplitPane);
                this.messageSplitPane.setDividerSize(0);
                this.messageSplitPane.setDividerLocation(1.0);
                this.messageSplitPane.setResizeWeight(1.0);
                JSplitPane jSplitPane = new JSplitPane(0, MainFrame.this.messageListScrollPane, this.messageSplitPane);
                jSplitPane.setDividerSize(10);
                jSplitPane.setDividerLocation(160);
                jSplitPane.setResizeWeight(0.5);
                jSplitPane.setMinimumSize(new Dimension(50, 20));
                this.setLayout(new BorderLayout());
                this.add((Component)this.getButtonsToolbar(), "North");
                this.add((Component)jSplitPane, "Center");
                this.messageTextArea.addMouseListener(this.listener);
                this.messageTextArea.addKeyListener(this.listener);
                this.filesTable.addMouseListener(this.listener);
                this.boardsTable.addMouseListener(this.listener);
                MainFrame.this.messageTable.addMouseListener(this.listener);
                MainFrame.this.messageTable.addKeyListener(this.listener);
                MainFrame.this.tofTree.addTreeSelectionListener(this.listener);
                MainFrame.this.tofTree.addKeyListener(this.listener);
                MainFrame.this.tofTreeModel.addTreeModelListener(this.listener);
                if (((TreeNode)MainFrame.this.tofTreeModel.getRoot()).getChildCount() == 0) {
                    this.messageTextArea.setText(this.language.getString("Welcome message"));
                }
                this.initialized = true;
            }
        }

        private void fontChanged() {
            int n;
            int n2;
            String string = this.settings.getValue("messageBodyFontName");
            Font font = new Font(string, n2 = this.settings.getIntValue("messageBodyFontStyle"), n = this.settings.getIntValue("messageBodyFontSize"));
            if (!font.getFamily().equals(string)) {
                this.logger.severe("The selected font was not found in your system\nThat selection will be changed to \"Monospaced\".");
                this.settings.setValue("messageBodyFontName", "Monospaced");
                font = new Font("Monospaced", n2, n);
            }
            this.messageTextArea.setFont(font);
            string = this.settings.getValue("messageListFontName");
            n2 = this.settings.getIntValue("messageListFontStyle");
            n = this.settings.getIntValue("messageListFontSize");
            font = new Font(string, n2, n);
            if (!font.getFamily().equals(string)) {
                this.logger.severe("The selected font was not found in your system\nThat selection will be changed to \"SansSerif\".");
                this.settings.setValue("messageListFontName", "SansSerif");
                font = new Font("SansSerif", n2, n);
            }
            MainFrame.this.messageTable.setFont(font);
        }

        private void messageTable_itemSelected(ListSelectionEvent listSelectionEvent) {
            Board board = MainFrame.this.tofTreeModel.getSelectedNode();
            if (board.isFolder()) {
                this.setGoodButton.setEnabled(false);
                this.setCheckButton.setEnabled(false);
                this.setBadButton.setEnabled(false);
                this.setObserveButton.setEnabled(false);
                this.replyButton.setEnabled(false);
                this.saveMessageButton.setEnabled(false);
                return;
            }
            this.selectedMessage = TOF.getInstance().evalSelection(listSelectionEvent, MainFrame.this.messageTable, board);
            if (this.selectedMessage != null) {
                MainFrame.displayNewMessageIcon(false);
                this.lastSelectedMessage = this.selectedMessage.getSubject();
                if (!board.isReadAccessBoard()) {
                    this.replyButton.setEnabled(true);
                } else {
                    this.replyButton.setEnabled(false);
                }
                if (this.identities.isMySelf(this.selectedMessage.getFrom())) {
                    this.setGoodButton.setEnabled(false);
                    this.setCheckButton.setEnabled(false);
                    this.setBadButton.setEnabled(false);
                    this.setObserveButton.setEnabled(false);
                } else if (this.selectedMessage.getMsgStatus() == 2) {
                    this.setCheckButton.setEnabled(false);
                    this.setGoodButton.setEnabled(true);
                    this.setBadButton.setEnabled(true);
                    this.setObserveButton.setEnabled(true);
                } else if (this.selectedMessage.getMsgStatus() == 1) {
                    this.setGoodButton.setEnabled(false);
                    this.setCheckButton.setEnabled(true);
                    this.setBadButton.setEnabled(true);
                    this.setObserveButton.setEnabled(true);
                } else if (this.selectedMessage.getMsgStatus() == 3) {
                    this.setBadButton.setEnabled(false);
                    this.setGoodButton.setEnabled(true);
                    this.setCheckButton.setEnabled(true);
                    this.setObserveButton.setEnabled(true);
                } else if (this.selectedMessage.getMsgStatus() == 4) {
                    this.setObserveButton.setEnabled(false);
                    this.setGoodButton.setEnabled(true);
                    this.setCheckButton.setEnabled(true);
                    this.setBadButton.setEnabled(true);
                } else {
                    this.setGoodButton.setEnabled(false);
                    this.setCheckButton.setEnabled(false);
                    this.setBadButton.setEnabled(false);
                    this.setObserveButton.setEnabled(false);
                }
                this.messageTextArea.setText(this.selectedMessage.getContent());
                if (this.selectedMessage.getContent().length() > 0) {
                    this.saveMessageButton.setEnabled(true);
                } else {
                    this.saveMessageButton.setEnabled(false);
                }
                AttachmentList attachmentList = this.selectedMessage.getAttachmentsOfType(0);
                AttachmentList attachmentList2 = this.selectedMessage.getAttachmentsOfType(1);
                this.positionDividers(attachmentList.size(), attachmentList2.size());
                this.attachedFilesModel.setData(attachmentList);
                this.attachedBoardsModel.setData(attachmentList2);
            } else {
                this.messageTextArea.setText(this.language.getString("Select a message to view its content."));
                this.replyButton.setEnabled(false);
                this.saveMessageButton.setEnabled(false);
                this.setGoodButton.setEnabled(false);
                this.setCheckButton.setEnabled(false);
                this.setBadButton.setEnabled(false);
                this.setObserveButton.setEnabled(false);
            }
        }

        private void positionDividers(int n, int n2) {
            if (n == 0 && n2 == 0) {
                this.messageSplitPane.setBottomComponent(null);
                this.messageSplitPane.setDividerSize(0);
                return;
            }
            this.messageSplitPane.setDividerSize(3);
            this.messageSplitPane.setDividerLocation(0.75);
            if (n != 0 && n2 == 0) {
                this.messageSplitPane.setBottomComponent(this.filesTableScrollPane);
                return;
            }
            if (n == 0 && n2 != 0) {
                this.messageSplitPane.setBottomComponent(this.boardsTableScrollPane);
                return;
            }
            if (n != 0 && n2 != 0) {
                this.messageSplitPane.setBottomComponent(this.attachmentsSplitPane);
                this.attachmentsSplitPane.setTopComponent(this.filesTableScrollPane);
                this.attachmentsSplitPane.setBottomComponent(this.boardsTableScrollPane);
            }
        }

        private void newMessageButton_actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.tofNewMessageButton_actionPerformed(actionEvent);
        }

        private void setBadButton_actionPerformed(ActionEvent actionEvent) {
            if (this.selectedMessage != null) {
                Identity identity = this.identities.getIdentity(this.selectedMessage.getFrom());
                if (identity == null) {
                    return;
                }
                if (identity.getState() == 1) {
                    if (JOptionPane.showConfirmDialog(this.parentFrame, "Are you sure you want to revoke trust to user " + this.selectedMessage.getFrom().substring(0, this.selectedMessage.getFrom().indexOf("@")) + " ? \n If you choose yes, future messages from this user will be marked BAD", "Revoke trust", 0) != 0) {
                        return;
                    }
                } else {
                    this.setGoodButton.setEnabled(false);
                    this.setCheckButton.setEnabled(false);
                    this.setBadButton.setEnabled(false);
                    this.setObserveButton.setEnabled(false);
                    this.setMessageTrust(4);
                }
            }
        }

        private void setCheckButton_actionPerformed(ActionEvent actionEvent) {
            this.setGoodButton.setEnabled(false);
            this.setCheckButton.setEnabled(false);
            this.setBadButton.setEnabled(false);
            this.setObserveButton.setEnabled(false);
            this.setMessageTrust(2);
        }

        private void setObserveButton_actionPerformed(ActionEvent actionEvent) {
            this.setGoodButton.setEnabled(false);
            this.setCheckButton.setEnabled(false);
            this.setBadButton.setEnabled(false);
            this.setObserveButton.setEnabled(false);
            this.setMessageTrust(3);
        }

        private void setGoodButton_actionPerformed(ActionEvent actionEvent) {
            if (this.selectedMessage != null) {
                Identity identity = this.identities.getIdentity(this.selectedMessage.getFrom());
                if (identity == null) {
                    return;
                }
                if (identity.getState() == 4) {
                    if (JOptionPane.showConfirmDialog(this.parentFrame, "Are you sure you want to grant trust to user " + this.selectedMessage.getFrom().substring(0, this.selectedMessage.getFrom().indexOf("@")) + " ? \n If you choose yes, future messages from this user will be marked GOOD", "Grant trust", 0) != 0) {
                        return;
                    }
                } else {
                    this.setGoodButton.setEnabled(false);
                    this.setCheckButton.setEnabled(false);
                    this.setBadButton.setEnabled(false);
                    this.setObserveButton.setEnabled(false);
                    this.setMessageTrust(1);
                }
            }
        }

        private void refreshLanguage() {
            this.newMessageButton.setToolTipText(this.language.getString("New message"));
            this.replyButton.setToolTipText(this.language.getString("Reply"));
            this.saveMessageButton.setToolTipText(this.language.getString("Save message"));
            this.nextUnreadMessageButton.setToolTipText(this.language.getString("Next unread message"));
            this.setGoodButton.setToolTipText(this.language.getString("Trust"));
            this.setBadButton.setToolTipText(this.language.getString("Do not trust"));
            this.setCheckButton.setToolTipText(this.language.getString("Set to CHECK"));
            this.setObserveButton.setToolTipText("Observe user");
            this.updateButton.setToolTipText(this.language.getString("Update"));
        }

        private void replyButton_actionPerformed(ActionEvent actionEvent) {
            FrostMessageObject frostMessageObject = this.selectedMessage;
            String string = this.lastSelectedMessage;
            if (!string.startsWith("Re:")) {
                string = "Re: " + string;
            }
            MessageFrame messageFrame = new MessageFrame(this.settings, this.parentFrame, this.identities.getMyId());
            messageFrame.setTofTree(MainFrame.this.tofTree);
            if (frostMessageObject.getRecipient() != null && frostMessageObject.getRecipient().equals(this.identities.getMyId().getUniqueName())) {
                if (frostMessageObject.getFromIdentity() == null) {
                    JOptionPane.showMessageDialog(this, "Can't reply encrypted, recipients public key is missing!", "ERROR", 64);
                    return;
                }
                messageFrame.composeEncryptedReply(MainFrame.this.tofTreeModel.getSelectedNode(), this.identities.getMyId().getUniqueName(), string, this.messageTextArea.getText(), frostMessageObject.getFromIdentity());
            } else {
                messageFrame.composeReply(MainFrame.this.tofTreeModel.getSelectedNode(), this.settings.getValue("userName"), string, this.messageTextArea.getText());
            }
        }

        private void saveMessageButton_actionPerformed(ActionEvent actionEvent) {
            FileAccess.saveDialog(this.parentFrame, this.messageTextArea.getText(), this.settings.getValue("lastUsedDirectory"), this.language.getString("Save message to disk"));
        }

        private void showAttachedBoardsPopupMenu(MouseEvent mouseEvent) {
            this.getPopupMenuAttachmentBoard().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }

        private void showAttachedFilesPopupMenu(MouseEvent mouseEvent) {
            this.getPopupMenuAttachmentTable().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }

        private void showMessageTablePopupMenu(MouseEvent mouseEvent) {
            this.getPopupMenuMessageTable().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }

        private void showTofTextAreaPopupMenu(MouseEvent mouseEvent) {
            this.getPopupMenuTofText().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }

        private void showCurrentMessagePopupWindow() {
            if (!this.isCorrectlySelectedMessage()) {
                return;
            }
            this.getMessageWindow(this.selectedMessage, this.getSize()).setVisible(true);
        }

        private MessageWindow getMessageWindow(MessageObject messageObject, Dimension dimension) {
            MessageWindow messageWindow = new MessageWindow(this.settings, MainFrame.getInstance(), messageObject, dimension);
            return messageWindow;
        }

        private void updateButton_actionPerformed(ActionEvent actionEvent) {
            if (MainFrame.this.tofTree.isUpdateAllowed(MainFrame.this.tofTreeModel.getSelectedNode())) {
                MainFrame.this.tofTree.updateBoard(MainFrame.this.tofTreeModel.getSelectedNode());
            }
        }

        private void boardsTree_actionPerformed(TreeSelectionEvent treeSelectionEvent) {
            this.messageSplitPane.setBottomComponent(null);
            this.messageSplitPane.setDividerSize(0);
            if (((TreeNode)MainFrame.this.tofTreeModel.getRoot()).getChildCount() == 0) {
                this.messageTextArea.setText(this.language.getString("Welcome message"));
            } else {
                Board board = (Board)MainFrame.this.tofTree.getLastSelectedPathComponent();
                if (board != null) {
                    if (!board.isFolder()) {
                        this.messageTextArea.setText(this.language.getString("Select a message to view its content."));
                        this.updateButton.setEnabled(true);
                        this.saveMessageButton.setEnabled(false);
                        this.replyButton.setEnabled(false);
                        if (board.isReadAccessBoard()) {
                            this.newMessageButton.setEnabled(false);
                        } else {
                            this.newMessageButton.setEnabled(true);
                        }
                    } else {
                        this.messageTextArea.setText(this.language.getString("Select a board to view its content."));
                        this.newMessageButton.setEnabled(false);
                        this.saveMessageButton.setEnabled(false);
                        this.updateButton.setEnabled(false);
                    }
                }
            }
        }

        private void antialiasing_propertyChanged(PropertyChangeEvent propertyChangeEvent) {
            this.messageTextArea.setAntiAliasEnabled(this.settings.getBoolValue("messageBodyAA"));
        }

        private boolean isCorrectlySelectedMessage() {
            int n = MainFrame.this.messageTable.getSelectedRow();
            return n >= 0 && this.selectedMessage != null && MainFrame.this.tofTreeModel.getSelectedNode() != null && !MainFrame.this.tofTreeModel.getSelectedNode().isFolder();
        }

        private void deleteSelectedMessage() {
            if (!this.isCorrectlySelectedMessage()) {
                return;
            }
            final FrostMessageObject frostMessageObject = this.selectedMessage;
            frostMessageObject.setDeleted(true);
            if (!this.settings.getBoolValue("showDeletedMessages")) {
                MainFrame.this.messageTableModel.deleteRow(this.selectedMessage);
                MainFrame.this.updateMessageCountLabels(MainFrame.this.tofTreeModel.getSelectedNode());
            } else {
                MainFrame.this.getMessageTableModel().updateRow(frostMessageObject);
            }
            Thread thread = new Thread(){

                public void run() {
                    frostMessageObject.save();
                }
            };
            thread.start();
        }

        private void undeleteSelectedMessage() {
            if (!this.isCorrectlySelectedMessage()) {
                return;
            }
            final FrostMessageObject frostMessageObject = this.selectedMessage;
            frostMessageObject.setDeleted(false);
            this.repaint();
            Thread thread = new Thread(){

                public void run() {
                    frostMessageObject.save();
                }
            };
            thread.start();
        }

        public void setIdentities(FrostIdentities frostIdentities) {
            this.identities = frostIdentities;
        }

        public void setParentFrame(JFrame jFrame) {
            this.parentFrame = jFrame;
        }

        public void startTruster(FrostMessageObject frostMessageObject, int n) {
            this.identities.changeTrust(frostMessageObject.getFrom(), n);
        }

        private void markSelectedMessageUnread() {
            int n = MainFrame.this.messageTable.getSelectedRow();
            if (n < 0 || this.selectedMessage == null || MainFrame.this.tofTreeModel.getSelectedNode() == null || MainFrame.this.tofTreeModel.getSelectedNode().isFolder()) {
                return;
            }
            FrostMessageObject frostMessageObject = this.selectedMessage;
            MainFrame.this.messageTable.removeRowSelectionInterval(0, MainFrame.this.messageTable.getRowCount() - 1);
            frostMessageObject.setMessageNew(true);
            MainFrame.this.getMessageTableModel().updateRow(frostMessageObject);
            MainFrame.this.tofTreeModel.getSelectedNode().incNewMessageCount();
            MainFrame.this.updateMessageCountLabels(MainFrame.this.tofTreeModel.getSelectedNode());
            MainFrame.this.updateTofTree(MainFrame.this.tofTreeModel.getSelectedNode());
        }

        private void setMessageTrust(int n) {
            int n2 = MainFrame.this.messageTable.getSelectedRow();
            if (n2 < 0 || this.selectedMessage == null) {
                return;
            }
            if (this.selectedMessage.getSignatureStatus() == 3) {
                this.identities.changeTrust(this.selectedMessage.getFrom(), n);
            }
        }

        private class PopupMenuTofText
        extends JSkinnablePopupMenu
        implements ActionListener,
        LanguageListener,
        ClipboardOwner {
            private Clipboard clipboard;
            private JTextComponent sourceTextComponent;
            private JMenuItem copyItem = new JMenuItem();
            private JMenuItem cancelItem = new JMenuItem();
            private JMenuItem saveMessageItem = new JMenuItem();

            public PopupMenuTofText(JTextComponent jTextComponent) {
                this.sourceTextComponent = jTextComponent;
                this.initialize();
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == this.saveMessageItem) {
                    FileAccess.saveDialog(MessagePanel.this.parentFrame, this.sourceTextComponent.getText(), MessagePanel.this.settings.getValue("lastUsedDirectory"), MessagePanel.this.language.getString("Save message to disk"));
                } else if (actionEvent.getSource() == this.copyItem) {
                    StringSelection stringSelection = new StringSelection(this.sourceTextComponent.getSelectedText());
                    this.clipboard.setContents(stringSelection, this);
                }
            }

            private void initialize() {
                this.refreshLanguage();
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                this.clipboard = toolkit.getSystemClipboard();
                this.copyItem.addActionListener(this);
                this.saveMessageItem.addActionListener(this);
                this.add(this.copyItem);
                this.addSeparator();
                this.add(this.saveMessageItem);
                this.addSeparator();
                this.add(this.cancelItem);
            }

            public void languageChanged(LanguageEvent languageEvent) {
                this.refreshLanguage();
            }

            private void refreshLanguage() {
                this.copyItem.setText(MessagePanel.this.language.getString("Copy"));
                this.saveMessageItem.setText(MessagePanel.this.language.getString("Save message to disk"));
                this.cancelItem.setText(MessagePanel.this.language.getString("Cancel"));
            }

            public void show(Component component, int n, int n2) {
                if (MessagePanel.this.selectedMessage != null && MessagePanel.this.selectedMessage.getContent() != null) {
                    if (this.sourceTextComponent.getSelectedText() != null) {
                        this.copyItem.setEnabled(true);
                    } else {
                        this.copyItem.setEnabled(false);
                    }
                    super.show(component, n, n2);
                }
            }

            public void lostOwnership(Clipboard clipboard, Transferable transferable) {
            }
        }

        private class PopupMenuMessageTable
        extends JSkinnablePopupMenu
        implements ActionListener,
        LanguageListener {
            private JMenuItem cancelItem = new JMenuItem();
            private JMenuItem markAllMessagesReadItem = new JMenuItem();
            private JMenuItem markMessageUnreadItem = new JMenuItem();
            private JMenuItem setBadItem = new JMenuItem();
            private JMenuItem setCheckItem = new JMenuItem();
            private JMenuItem setGoodItem = new JMenuItem();
            private JMenuItem setObserveItem = new JMenuItem();
            private JMenuItem deleteItem = new JMenuItem();
            private JMenuItem undeleteItem = new JMenuItem();

            public PopupMenuMessageTable() {
                this.initialize();
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == this.markMessageUnreadItem) {
                    MessagePanel.this.markSelectedMessageUnread();
                } else if (actionEvent.getSource() == this.markAllMessagesReadItem) {
                    Board board = MainFrame.this.tofTreeModel.getSelectedNode();
                    TOF.getInstance().setAllMessagesRead(board);
                } else if (actionEvent.getSource() == this.setGoodItem) {
                    MessagePanel.this.setMessageTrust(1);
                } else if (actionEvent.getSource() == this.setBadItem) {
                    MessagePanel.this.setMessageTrust(4);
                } else if (actionEvent.getSource() == this.setCheckItem) {
                    MessagePanel.this.setMessageTrust(2);
                } else if (actionEvent.getSource() == this.setObserveItem) {
                    MessagePanel.this.setMessageTrust(3);
                } else if (actionEvent.getSource() == this.deleteItem) {
                    MessagePanel.this.deleteSelectedMessage();
                } else if (actionEvent.getSource() == this.undeleteItem) {
                    MessagePanel.this.undeleteSelectedMessage();
                }
            }

            private void initialize() {
                this.refreshLanguage();
                this.markMessageUnreadItem.addActionListener(this);
                this.markAllMessagesReadItem.addActionListener(this);
                this.setGoodItem.addActionListener(this);
                this.setBadItem.addActionListener(this);
                this.setCheckItem.addActionListener(this);
                this.setObserveItem.addActionListener(this);
                this.deleteItem.addActionListener(this);
                this.undeleteItem.addActionListener(this);
            }

            public void languageChanged(LanguageEvent languageEvent) {
                this.refreshLanguage();
            }

            private void refreshLanguage() {
                this.markMessageUnreadItem.setText(MessagePanel.this.language.getString("Mark message unread"));
                this.markAllMessagesReadItem.setText(MessagePanel.this.language.getString("Mark ALL messages read"));
                this.setGoodItem.setText(MessagePanel.this.language.getString("help user (sets to GOOD)"));
                this.setBadItem.setText(MessagePanel.this.language.getString("block user (sets to BAD)"));
                this.setCheckItem.setText(MessagePanel.this.language.getString("set to neutral (CHECK)"));
                this.setObserveItem.setText(MessagePanel.this.language.getString("observe user (OBSERVE)"));
                this.deleteItem.setText(MessagePanel.this.language.getString("Delete message"));
                this.undeleteItem.setText(MessagePanel.this.language.getString("Undelete message"));
                this.cancelItem.setText(MessagePanel.this.language.getString("Cancel"));
            }

            public void show(Component component, int n, int n2) {
                if (!MainFrame.this.tofTreeModel.getSelectedNode().isFolder()) {
                    this.removeAll();
                    if (MainFrame.this.messageTable.getSelectedRow() > -1) {
                        this.add(this.markMessageUnreadItem);
                    }
                    this.add(this.markAllMessagesReadItem);
                    this.addSeparator();
                    this.add(this.setGoodItem);
                    this.add(this.setObserveItem);
                    this.add(this.setCheckItem);
                    this.add(this.setBadItem);
                    this.setGoodItem.setEnabled(false);
                    this.setObserveItem.setEnabled(false);
                    this.setCheckItem.setEnabled(false);
                    this.setBadItem.setEnabled(false);
                    if (MainFrame.this.messageTable.getSelectedRow() > -1 && MessagePanel.this.selectedMessage != null && !MessagePanel.this.identities.isMySelf(MessagePanel.this.selectedMessage.getFrom())) {
                        if (MessagePanel.this.selectedMessage.getMsgStatus() == 1) {
                            this.setObserveItem.setEnabled(true);
                            this.setCheckItem.setEnabled(true);
                            this.setBadItem.setEnabled(true);
                        } else if (MessagePanel.this.selectedMessage.getMsgStatus() == 2) {
                            this.setObserveItem.setEnabled(true);
                            this.setGoodItem.setEnabled(true);
                            this.setBadItem.setEnabled(true);
                        } else if (MessagePanel.this.selectedMessage.getMsgStatus() == 3) {
                            this.setObserveItem.setEnabled(true);
                            this.setGoodItem.setEnabled(true);
                            this.setCheckItem.setEnabled(true);
                        } else if (MessagePanel.this.selectedMessage.getMsgStatus() == 4) {
                            this.setGoodItem.setEnabled(true);
                            this.setCheckItem.setEnabled(true);
                            this.setBadItem.setEnabled(true);
                        } else if (MessagePanel.this.selectedMessage.getMsgStatus() != 6 && MessagePanel.this.selectedMessage.getMsgStatus() != 5) {
                            MessagePanel.this.logger.warning("invalid message state : " + MessagePanel.this.selectedMessage.getMsgStatus());
                        }
                    }
                    if (MessagePanel.this.selectedMessage != null) {
                        this.addSeparator();
                        this.add(this.deleteItem);
                        this.add(this.undeleteItem);
                        this.deleteItem.setEnabled(false);
                        this.undeleteItem.setEnabled(false);
                        if (MessagePanel.this.selectedMessage.isDeleted()) {
                            this.undeleteItem.setEnabled(true);
                        } else {
                            this.deleteItem.setEnabled(true);
                        }
                    }
                    this.addSeparator();
                    this.add(this.cancelItem);
                    super.show(component, n, n2);
                }
            }
        }

        private class PopupMenuAttachmentTable
        extends JSkinnablePopupMenu
        implements ActionListener,
        LanguageListener {
            private JMenuItem cancelItem = new JMenuItem();
            private JMenuItem saveAttachmentItem = new JMenuItem();
            private JMenuItem saveAttachmentsItem = new JMenuItem();

            public PopupMenuAttachmentTable() throws HeadlessException {
                this.initialize();
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == this.saveAttachmentsItem || actionEvent.getSource() == this.saveAttachmentItem) {
                    MessagePanel.this.downloadAttachments();
                }
            }

            private void initialize() {
                this.refreshLanguage();
                this.saveAttachmentsItem.addActionListener(this);
                this.saveAttachmentItem.addActionListener(this);
            }

            public void languageChanged(LanguageEvent languageEvent) {
                this.refreshLanguage();
            }

            private void refreshLanguage() {
                this.saveAttachmentsItem.setText(MessagePanel.this.language.getString("Download attachment(s)"));
                this.saveAttachmentItem.setText(MessagePanel.this.language.getString("Download selected attachment"));
                this.cancelItem.setText(MessagePanel.this.language.getString("Cancel"));
            }

            public void show(Component component, int n, int n2) {
                this.removeAll();
                if (MessagePanel.this.filesTable.getSelectedRow() == -1) {
                    this.add(this.saveAttachmentsItem);
                } else {
                    this.add(this.saveAttachmentItem);
                }
                this.addSeparator();
                this.add(this.cancelItem);
                super.show(component, n, n2);
            }
        }

        private class PopupMenuAttachmentBoard
        extends JSkinnablePopupMenu
        implements ActionListener,
        LanguageListener {
            private JMenuItem cancelItem = new JMenuItem();
            private JMenuItem saveBoardsItem = new JMenuItem();
            private JMenuItem saveBoardsToFolderItem = new JMenuItem();

            public PopupMenuAttachmentBoard() {
                this.initialize();
            }

            public void actionPerformed(ActionEvent actionEvent) {
                TargetFolderChooser targetFolderChooser;
                Board board;
                if (actionEvent.getSource() == this.saveBoardsItem) {
                    MessagePanel.this.downloadBoards(null);
                } else if (actionEvent.getSource() == this.saveBoardsToFolderItem && (board = (targetFolderChooser = new TargetFolderChooser(MainFrame.this.tofTreeModel)).startDialog()) != null) {
                    MessagePanel.this.downloadBoards(board);
                }
            }

            private void initialize() {
                this.refreshLanguage();
                this.saveBoardsItem.addActionListener(this);
                this.saveBoardsToFolderItem.addActionListener(this);
            }

            public void languageChanged(LanguageEvent languageEvent) {
                this.refreshLanguage();
            }

            private void refreshLanguage() {
                this.saveBoardsItem.setText(MessagePanel.this.language.getString("Add Board(s)"));
                this.saveBoardsToFolderItem.setText(MessagePanel.this.language.getString("Add Board(s) to folder") + " ...");
                this.cancelItem.setText(MessagePanel.this.language.getString("Cancel"));
            }

            public void show(Component component, int n, int n2) {
                this.removeAll();
                this.add(this.saveBoardsItem);
                this.add(this.saveBoardsToFolderItem);
                this.addSeparator();
                this.add(this.cancelItem);
                super.show(component, n, n2);
            }
        }

        private class Listener
        extends MouseAdapter
        implements ActionListener,
        ListSelectionListener,
        PropertyChangeListener,
        TreeSelectionListener,
        TreeModelListener,
        LanguageListener,
        KeyListener {
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == MessagePanel.this.updateButton) {
                    MessagePanel.this.updateButton_actionPerformed(actionEvent);
                } else if (actionEvent.getSource() == MessagePanel.this.newMessageButton) {
                    MessagePanel.this.newMessageButton_actionPerformed(actionEvent);
                } else if (actionEvent.getSource() == MessagePanel.this.replyButton) {
                    MessagePanel.this.replyButton_actionPerformed(actionEvent);
                } else if (actionEvent.getSource() == MessagePanel.this.saveMessageButton) {
                    MessagePanel.this.saveMessageButton_actionPerformed(actionEvent);
                } else if (actionEvent.getSource() == MessagePanel.this.nextUnreadMessageButton) {
                    this.selectNextUnreadMessage();
                } else if (actionEvent.getSource() == MessagePanel.this.setGoodButton) {
                    MessagePanel.this.setGoodButton_actionPerformed(actionEvent);
                } else if (actionEvent.getSource() == MessagePanel.this.setBadButton) {
                    MessagePanel.this.setBadButton_actionPerformed(actionEvent);
                } else if (actionEvent.getSource() == MessagePanel.this.setCheckButton) {
                    MessagePanel.this.setCheckButton_actionPerformed(actionEvent);
                } else if (actionEvent.getSource() == MessagePanel.this.setObserveButton) {
                    MessagePanel.this.setObserveButton_actionPerformed(actionEvent);
                }
            }

            private void maybeShowPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    if (mouseEvent.getComponent() == MessagePanel.this.messageTextArea) {
                        MessagePanel.this.showTofTextAreaPopupMenu(mouseEvent);
                    } else if (mouseEvent.getComponent() == MainFrame.this.messageTable) {
                        MessagePanel.this.showMessageTablePopupMenu(mouseEvent);
                    } else if (mouseEvent.getComponent() == MessagePanel.this.boardsTable) {
                        MessagePanel.this.showAttachedBoardsPopupMenu(mouseEvent);
                    } else if (mouseEvent.getComponent() == MessagePanel.this.filesTable) {
                        MessagePanel.this.showAttachedFilesPopupMenu(mouseEvent);
                    }
                } else if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getID() == 501 && mouseEvent.getClickCount() == 2 && mouseEvent.getComponent() == MainFrame.this.messageTable) {
                    MessagePanel.this.showCurrentMessagePopupWindow();
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            private void maybeDoSomething(KeyEvent keyEvent) {
                if (keyEvent.getSource() == MainFrame.this.messageTable && keyEvent.getKeyChar() == '\u007f') {
                    MessagePanel.this.deleteSelectedMessage();
                }
            }

            private void selectNextUnreadMessage() {
                int n = -1;
                MessageTableModel messageTableModel = MainFrame.getInstance().getMessageTableModel();
                FrostMessageObject frostMessageObject = null;
                for (int i = 0; i < messageTableModel.getRowCount(); ++i) {
                    FrostMessageObject frostMessageObject2 = (FrostMessageObject)messageTableModel.getRow(i);
                    if (!frostMessageObject2.isMessageNew()) continue;
                    if (frostMessageObject == null) {
                        frostMessageObject = frostMessageObject2;
                        n = i;
                        continue;
                    }
                    if (frostMessageObject.getDateAndTime().compareTo(frostMessageObject2.getDateAndTime()) <= 0) continue;
                    frostMessageObject = frostMessageObject2;
                    n = i;
                }
                if (n != -1) {
                    MainFrame.this.messageTable.addRowSelectionInterval(n, n);
                    MainFrame.this.messageListScrollPane.getVerticalScrollBar().setValue(n * MainFrame.this.messageTable.getRowHeight());
                }
            }

            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent == null) {
                    return;
                }
                if ((keyEvent.getSource() == MainFrame.this.messageTable || keyEvent.getSource() == MainFrame.this.tofTree || keyEvent.getSource() == MessagePanel.this.messageTextArea) && keyEvent.getKeyChar() == 'n') {
                    this.selectNextUnreadMessage();
                } else if (keyEvent.getSource() == MainFrame.this.messageTable) {
                    if (MessagePanel.this.selectedMessage == null || MessagePanel.this.selectedMessage.getSignatureStatus() != 3) {
                        return;
                    }
                    if (keyEvent.getKeyChar() == 'b') {
                        MessagePanel.this.setMessageTrust(4);
                    } else if (keyEvent.getKeyChar() == 'g') {
                        MessagePanel.this.setMessageTrust(1);
                    } else if (keyEvent.getKeyChar() == 'c') {
                        MessagePanel.this.setMessageTrust(2);
                    } else if (keyEvent.getKeyChar() == 'o') {
                        MessagePanel.this.setMessageTrust(3);
                    }
                }
            }

            public void keyPressed(KeyEvent keyEvent) {
                this.maybeDoSomething(keyEvent);
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                MessagePanel.this.messageTable_itemSelected(listSelectionEvent);
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("messageBodyAA")) {
                    MessagePanel.this.antialiasing_propertyChanged(propertyChangeEvent);
                } else if (propertyChangeEvent.getPropertyName().equals("messageBodyFontName")) {
                    MessagePanel.this.fontChanged();
                } else if (propertyChangeEvent.getPropertyName().equals("messageBodyFontSize")) {
                    MessagePanel.this.fontChanged();
                } else if (propertyChangeEvent.getPropertyName().equals("messageBodyFontStyle")) {
                    MessagePanel.this.fontChanged();
                }
            }

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                MessagePanel.this.boardsTree_actionPerformed(treeSelectionEvent);
            }

            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            }

            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            }

            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            }

            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            }

            public void languageChanged(LanguageEvent languageEvent) {
                MessagePanel.this.refreshLanguage();
            }
        }
    }

    private class Listener
    extends WindowAdapter {
        private Listener() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Rectangle rectangle = MainFrame.this.getBounds();
            boolean bl = (MainFrame.this.getExtendedState() & 6) != 0;
            frostSettings.setValue("lastFrameMaximized", bl);
            if (!bl) {
                frostSettings.setValue("lastFrameHeight", rectangle.height);
                frostSettings.setValue("lastFrameWidth", rectangle.width);
                frostSettings.setValue("lastFramePosX", rectangle.x);
                frostSettings.setValue("lastFramePosY", rectangle.y);
            }
            MainFrame.this.fileExitMenuItem_actionPerformed(null);
        }
    }
}

