/*
 * Decompiled with CFR 0.152.
 */
package frost;

import frost.SettingsClass;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class Logging {
    private static Logger logger = Logger.getLogger(Logging.class.getName());
    public static final String VERY_LOW = "Very low";
    public static final String LOW = "Low";
    public static final String MEDIUM = "Medium";
    public static final String HIGH = "High";
    public static final String VERY_HIGH = "Very high";
    public static final String DEFAULT = "Low";
    private static final String LOG_FILE_NAME = "frost%g.log";
    private SettingsClass frostSettings = null;
    private Listener listener = new Listener();
    private Logger rootLogger = null;
    private FileHandler fileHandler = null;
    private SimpleFormatter simpleFormatter = new SimpleFormatter();

    public Logging(SettingsClass settingsClass) {
        this.frostSettings = settingsClass;
        this.initialize();
    }

    private void initialize() {
        LogManager logManager = LogManager.getLogManager();
        this.rootLogger = logManager.getLogger("");
        Handler[] handlerArray = this.rootLogger.getHandlers();
        for (int i = 0; i < handlerArray.length; ++i) {
            this.rootLogger.removeHandler(handlerArray[i]);
        }
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        this.logToFileSettingChanged();
        this.frostSettings.addPropertyChangeListener("logToFile", this.listener);
        this.frostSettings.addPropertyChangeListener("logFileSizeLimit", this.listener);
        this.frostSettings.addPropertyChangeListener("logLevel", this.listener);
    }

    private void logLevelSettingChanged() {
        boolean bl = this.setLevel(this.frostSettings.getValue("logLevel"));
        if (!bl) {
            this.setLevel(this.frostSettings.getDefaultValue("logLevel"));
        }
    }

    private boolean setLevel(String string) {
        if (string.equals(VERY_LOW)) {
            this.rootLogger.setLevel(Level.SEVERE);
            return true;
        }
        if (string.equals("Low")) {
            this.rootLogger.setLevel(Level.WARNING);
            return true;
        }
        if (string.equals(MEDIUM)) {
            this.rootLogger.setLevel(Level.INFO);
            return true;
        }
        if (string.equals(HIGH)) {
            this.rootLogger.setLevel(Level.FINER);
            return true;
        }
        if (string.equals(VERY_HIGH)) {
            this.rootLogger.setLevel(Level.FINEST);
            return true;
        }
        return false;
    }

    private void logFileSizeSettingChanged() {
        if (!Level.OFF.equals(this.rootLogger.getLevel())) {
            try {
                int n = this.frostSettings.getIntValue("logFileSizeLimit");
                if (this.fileHandler != null) {
                    this.rootLogger.removeHandler(this.fileHandler);
                    this.fileHandler.close();
                    this.fileHandler = null;
                }
                this.fileHandler = new FileHandler(LOG_FILE_NAME, n * 1024, 2, true);
                this.fileHandler.setEncoding("UTF-8");
                this.fileHandler.setFormatter(this.simpleFormatter);
                this.rootLogger.addHandler(this.fileHandler);
            }
            catch (IOException iOException) {
                logger.log(Level.SEVERE, "There was an error while initializing the logging system.", iOException);
            }
        }
    }

    private void logToFileSettingChanged() {
        if (!Level.OFF.equals(this.rootLogger.getLevel())) {
            if (this.frostSettings.getBoolValue("logToFile")) {
                this.rootLogger.setLevel(null);
                this.logLevelSettingChanged();
                this.logFileSizeSettingChanged();
            } else {
                this.rootLogger.setLevel(Level.OFF);
            }
        }
    }

    private class Listener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("logToFile")) {
                Logging.this.logToFileSettingChanged();
            }
            if (propertyChangeEvent.getPropertyName().equals("logFileSizeLimit")) {
                Logging.this.logFileSizeSettingChanged();
            }
            if (propertyChangeEvent.getPropertyName().equals("logLevel")) {
                Logging.this.logLevelSettingChanged();
            }
        }
    }

    private class ShutdownHook
    extends Thread {
        public void run() {
            Logging.this.frostSettings.removePropertyChangeListener("logToFile", Logging.this.listener);
            Logging.this.frostSettings.removePropertyChangeListener("logFileSizeLimit", Logging.this.listener);
            Logging.this.frostSettings.removePropertyChangeListener("logLevel", Logging.this.listener);
            if (Logging.this.fileHandler != null) {
                Logging.this.rootLogger.removeHandler(Logging.this.fileHandler);
                Logging.this.fileHandler.close();
            }
        }
    }
}

