/*
 * Decompiled with CFR 0.152.
 */
package frost;

import frost.Core;
import frost.util.gui.MiscToolkit;
import frost.util.gui.translation.Language;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIManager;

public class Frost {
    private static Logger logger = Logger.getLogger(Frost.class.getName());
    private static String lookAndFeel = null;

    public static void main(String[] stringArray) {
        System.out.println();
        System.out.println("Frost, Copyright (C) 2005 Jan-Thomas Czornack");
        System.out.println("Frost comes with ABSOLUTELY NO WARRANTY!");
        System.out.println("This is free software, and you are welcome to");
        System.out.println("redistribute it under the GPL conditions.");
        System.out.println("Frost uses code from apache.org (Apache license),");
        System.out.println("bouncycastle.org (BSD license), Onion Networks (BSD license),");
        System.out.println("and L2FProd.com (Apache license).");
        System.out.println();
        Frost.parseCommandLine(stringArray);
        Frost.initializeLookAndFeel();
        new Frost();
    }

    private static void initializeLookAndFeel() {
        try {
            if (lookAndFeel == null) {
                String string = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel(string);
            } else {
                UIManager.setLookAndFeel(lookAndFeel);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            System.out.println("Using the default");
        }
    }

    private static void parseCommandLine(String[] stringArray) {
        int n = 0;
        try {
            while (stringArray.length > n) {
                if (stringArray[n].equals("-?") || stringArray[n].equals("-help") || stringArray[n].equals("--help") || stringArray[n].equals("/?") || stringArray[n].equals("/help")) {
                    Frost.showHelp();
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-lf")) {
                    lookAndFeel = stringArray[n + 1];
                    n += 2;
                    continue;
                }
                if (stringArray[n].equals("-locale")) {
                    Frost.setLocale(stringArray[n + 1]);
                    n += 2;
                    continue;
                }
                Frost.showHelp();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Frost.showHelp();
        }
    }

    private static void setLocale(String string) {
        Locale locale = new Locale(string);
        Locale.setDefault(locale);
        Core.setLocale(locale);
    }

    private static void showHelp() {
        System.out.println("java -jar frost.jar [-lf lookAndFeel] [-locale languageCode]\n");
        System.out.println("-lf     Sets the 'Look and Feel' Frost will use.");
        System.out.println("        (overriden by the skins preferences)\n");
        System.out.println("        These ones are currently available:");
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
            System.out.println("           " + lookAndFeelInfoArray[i].getClassName());
        }
        System.out.println("\n         And this one is used by default:");
        System.out.println("           " + lookAndFeel + "\n");
        System.out.println("-locale  Sets the language Frost will use, if available.");
        System.out.println("         (overrides the setting in the preferences)\n");
        System.out.println("Example:\n");
        System.out.print("java -jar frost.jar ");
        if (lookAndFeelInfoArray.length > 0) {
            System.out.print("-lf " + lookAndFeelInfoArray[0].getClassName() + " ");
        }
        System.out.println("-locale es\n");
        System.out.println("That command line will instruct Frost to use the");
        if (lookAndFeelInfoArray.length > 0) {
            System.out.println(lookAndFeelInfoArray[0].getClassName() + " look and feel and the");
        }
        System.out.println("Spanish language.");
        System.exit(0);
    }

    public Frost() {
        Core core = Core.getInstance();
        if (!this.initializeLockFile(Language.getInstance())) {
            System.exit(1);
        }
        if (!this.checkLibs()) {
            System.exit(3);
        }
        try {
            core.initialize();
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "There was a problem while initializing Frost.", exception);
            System.exit(3);
        }
    }

    private boolean checkLibs() {
        String string = "";
        try {
            string = "xercesImpl.jar";
            Class.forName("org.apache.xerces.dom.DocumentImpl");
            string = "xml-apis.jar";
            Class.forName("org.w3c.dom.Document");
            string = "xercesImpl.jar";
            Class.forName("org.apache.xml.serialize.OutputFormat");
            string = "genChkImpl.jar";
            Class.forName("freenet.client.ClientKey");
            string = "fecImpl.jar";
            Class.forName("fecimpl.FECUtils");
            string = "skinlf.jar";
            Class.forName("com.l2fprod.gui.SkinApplet");
            string = "skinlfFix.jar";
            Class.forName("com.l2fprod.gui.plaf.skin.SkinlfFixMarkerClass");
            string = "mailapi.jar";
            Class.forName("javax.mail.Address");
            string = "smtp.jar";
            Class.forName("com.sun.mail.smtp.SMTPTransport");
        }
        catch (ClassNotFoundException classNotFoundException) {
            MiscToolkit.getInstance().showMessage("Please start Frost using the provided start scripts (frost.bat for Windows, frost.sh for Unix).\nIf Frost was working and you updated just frost.jar, try updating with frost.zip", 0, "ERROR: The jar file " + string + " is missing.");
            return false;
        }
        return true;
    }

    private boolean initializeLockFile(Language language) {
        File file = new File(".frost_run_lock");
        boolean bl = false;
        try {
            bl = file.createNewFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.out);
        }
        if (!bl) {
            MiscToolkit.getInstance().showMessage(language.getString("Frost.lockFileFound") + "'" + file.getAbsolutePath() + "'", 0, "ERROR: Found Frost lock file '.frost_run_lock'.");
            return false;
        }
        file.deleteOnExit();
        return true;
    }
}

