/*
 * Decompiled with CFR 0.152.
 */
package frost;

import frost.MainFrame;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.JFileChooser;

public class FileAccess {
    private static Logger logger = Logger.getLogger(FileAccess.class.getName());

    public static void saveDialog(Component component, String string, String string2, String string3) {
        File file;
        JFileChooser jFileChooser = new JFileChooser(string2);
        jFileChooser.setDialogTitle(string3);
        jFileChooser.setFileHidingEnabled(true);
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showSaveDialog(component);
        if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            MainFrame.frostSettings.setValue("lastUsedDirectory", file.getParent());
            if (!file.isDirectory()) {
                FileAccess.writeFile(string, file, "UTF-8");
            }
        }
    }

    public static byte[] readByteArray(String string) {
        return FileAccess.readByteArray(new File(string));
    }

    public static byte[] readByteArray(File file) {
        try {
            byte[] byArray = new byte[(int)file.length()];
            FileInputStream fileInputStream = new FileInputStream(file);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            dataInputStream.readFully(byArray);
            fileInputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Exception thrown in readByteArray(File file)", iOException);
            return null;
        }
    }

    public static ArrayList getAllEntries(File file, String string) {
        ArrayList arrayList = new ArrayList();
        FileAccess.getAllFiles(file, string, arrayList);
        return arrayList;
    }

    private static void getAllFiles(File file, String string, ArrayList arrayList) {
        if (file != null) {
            File[] fileArray;
            if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    FileAccess.getAllFiles(fileArray[i], string, arrayList);
                }
            }
            if (string.length() == 0 || file.getName().endsWith(string)) {
                arrayList.add(file);
            }
        }
    }

    public static boolean writeZipFile(byte[] byArray, String string, File file) {
        if (byArray == null || byArray.length == 0) {
            Exception exception = new Exception();
            exception.fillInStackTrace();
            logger.log(Level.SEVERE, "Tried to zip an empty file!  Send this output to a dev and describe what you were doing.", exception);
            return false;
        }
        try {
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
            zipOutputStream.setLevel(9);
            ZipEntry zipEntry = new ZipEntry(string);
            zipEntry.setSize(byArray.length);
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(byArray);
            zipOutputStream.flush();
            zipOutputStream.closeEntry();
            zipOutputStream.close();
            return true;
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "Exception thrown in writeZipFile(byte[] content, String entry, File file)", throwable);
            return false;
        }
    }

    public static byte[] readZipFileBinary(File file) {
        if (!file.isFile() || file.length() == 0L) {
            return null;
        }
        ZipInputStream zipInputStream = null;
        try {
            int n;
            zipInputStream = new ZipInputStream(new FileInputStream(file));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            zipInputStream.getNextEntry();
            byte[] byArray = new byte[4096];
            while ((n = zipInputStream.read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            zipInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.log(Level.SEVERE, "Exception thrown in readZipFile(String path)", fileNotFoundException);
        }
        catch (IOException iOException) {
            try {
                if (zipInputStream != null) {
                    zipInputStream.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            logger.log(Level.SEVERE, "Exception thrown in readZipFile(String path) \nOffending file saved as badfile.zip, send to a dev for analysis", iOException);
            FileAccess.copyFile(file.getPath(), "badfile.zip");
        }
        return null;
    }

    public static Vector readLines(File file) {
        return FileAccess.readLines(file.getPath());
    }

    public static Vector readLines(String string) {
        Vector<String> vector = new Vector<String>();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                vector.add(string2.trim());
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Exception thrown in readLines(String path)", iOException);
        }
        return vector;
    }

    public static String readFile(File file) {
        return FileAccess.readFile(file.getPath());
    }

    public static String readFile(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2).append("\n");
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Exception thrown in readFile(String path)", iOException);
        }
        return stringBuffer.toString();
    }

    public static String readFile(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string3;
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(string), string2);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string3).append("\n");
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Exception thrown in readFile(String path, String encoding)", iOException);
        }
        return stringBuffer.toString();
    }

    public static boolean writeFile(String string, String string2) {
        return FileAccess.writeFile(string, new File(string2));
    }

    public static boolean writeFile(String string, String string2, String string3) {
        return FileAccess.writeFile(string, new File(string2), string3);
    }

    public static boolean writeFile(String string, File file) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(string);
            fileWriter.close();
            return true;
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Exception thrown in writeFile(String content, File file)", iOException);
            return false;
        }
    }

    public static boolean writeFile(byte[] byArray, File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
            return true;
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Exception thrown in writeFile(byte[] content, File file)", iOException);
            return false;
        }
    }

    public static boolean writeFile(String string, File file, String string2) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, string2);
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            String string3 = System.getProperty("line.separator");
            String string4 = bufferedReader.readLine();
            while (string4 != null) {
                outputStreamWriter.write(string4 + string3);
                string4 = bufferedReader.readLine();
            }
            outputStreamWriter.close();
            bufferedReader.close();
            return true;
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Exception thrown in writeFile(String content, File file, String encoding)", iOException);
            return false;
        }
    }

    public static boolean deleteDir(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = FileAccess.deleteDir(new File(file, stringArray[i]));
                if (bl) continue;
                return false;
            }
        }
        return file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(String string, String string2) {
        FileChannel fileChannel = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        boolean bl = false;
        try {
            fileChannel = new FileInputStream(string).getChannel();
            abstractInterruptibleChannel = new FileOutputStream(string2).getChannel();
            ((FileChannel)abstractInterruptibleChannel).transferFrom(fileChannel, 0L, fileChannel.size());
            bl = true;
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Exception in copyFile", iOException);
        }
        finally {
            if (fileChannel != null) {
                try {
                    fileChannel.close();
                }
                catch (IOException iOException) {}
            }
            if (abstractInterruptibleChannel != null) {
                try {
                    abstractInterruptibleChannel.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bl;
    }

    public static boolean compareFiles(File file, File file2) {
        try {
            boolean bl;
            BufferedInputStream bufferedInputStream;
            BufferedInputStream bufferedInputStream2;
            block3: {
                int n;
                int n2;
                bufferedInputStream2 = new BufferedInputStream(new FileInputStream(file));
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
                bl = false;
                do {
                    if ((n2 = bufferedInputStream2.read()) == (n = bufferedInputStream.read())) continue;
                    bl = false;
                    break block3;
                } while (n2 >= 0 || n >= 0);
                bl = true;
            }
            bufferedInputStream2.close();
            bufferedInputStream.close();
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

