/*
 * Decompiled with CFR 0.152.
 */
package frost;

import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import frost.CleanUp;
import frost.FileAccess;
import frost.Logging;
import frost.MainFrame;
import frost.SettingsClass;
import frost.Startup;
import frost.XMLTools;
import frost.boards.BoardsManager;
import frost.crypt.Crypt;
import frost.crypt.FrostCrypt;
import frost.events.FrostEvent;
import frost.events.FrostEventDispatcher;
import frost.events.StorageErrorEvent;
import frost.ext.JSysTrayIcon;
import frost.fcp.FcpConnection;
import frost.fcp.FcpFactory;
import frost.fileTransfer.FileTransferManager;
import frost.gui.Splashscreen;
import frost.gui.objects.Board;
import frost.gui.objects.FrostMessageFactory;
import frost.gui.objects.FrostMessageObject;
import frost.identities.FrostIdentities;
import frost.messages.AttachmentList;
import frost.messages.BoardAttachment;
import frost.messages.MessageCreationException;
import frost.messaging.MessagingManager;
import frost.storage.DAOFactory;
import frost.storage.Savable;
import frost.storage.StorageException;
import frost.storage.StorageManager;
import frost.threads.GetFriendsRequestsThread;
import frost.threads.NotifyByEmailThread;
import frost.threads.maintenance.CheckForSpam;
import frost.threads.maintenance.DeleteWholeDirThread;
import frost.threads.maintenance.ResendFailedMessagesThread;
import frost.util.FlexibleObserver;
import frost.util.gui.JDialogWithDetails;
import frost.util.gui.MiscToolkit;
import frost.util.gui.translation.Language;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Core
implements Savable,
FrostEventDispatcher {
    private static Logger logger = Logger.getLogger(Core.class.getName());
    static Hashtable myBatches = new Hashtable();
    private static Core instance = new Core();
    private static Locale locale = null;
    private static Set nodes = new HashSet();
    private static List knownBoards = new ArrayList();
    private static NotifyByEmailThread emailNotifier = null;
    public static SettingsClass frostSettings;
    private static Crypt crypto;
    private EventDispatcher dispatcher = new EventDispatcher();
    private Language language = null;
    private boolean freenetIsOnline = false;
    private boolean freenetIsTransient = false;
    private Timer timer = new Timer(true);
    private MainFrame mainFrame;
    private BoardsManager boardsManager;
    private FileTransferManager fileTransferManager;
    private MessagingManager messagingManager;
    private FrostIdentities identities;
    private String keypool;

    private Core() {
        frostSettings = new SettingsClass();
        this.initializeLanguage();
    }

    private boolean initializeConnectivity() {
        Object object;
        String string = frostSettings.getValue("availableNodes");
        if (string == null) {
            object = new String(frostSettings.getValue("nodeAddress") + ":" + frostSettings.getValue("nodePort"));
            nodes.add(((String)object).trim());
            frostSettings.setValue("availableNodes", ((String)object).trim());
        } else {
            object = string.split(",");
            for (int i = 0; i < ((String[])object).length; ++i) {
                nodes.add(object[i]);
            }
        }
        if (nodes.size() == 0) {
            MiscToolkit.getInstance().showMessage("Not a single Freenet node configured. You need at least one.", 0, "ERROR: No Freenet nodes are available.");
            return false;
        }
        logger.info("Frost will use " + nodes.size() + " Freenet nodes");
        try {
            object = FcpFactory.getFcpConnectionInstance();
            if (object != null) {
                String[] stringArray = ((FcpConnection)object).getInfo();
                this.freenetIsOnline = true;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].startsWith("IsTransient") || stringArray[i].indexOf("true") == -1) continue;
                    this.freenetIsTransient = true;
                }
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Exception thrown in initializeConnectivity", exception);
        }
        if (!this.freenetIsOnline) {
            MiscToolkit.getInstance().showMessage(this.language.getString("Core.init.NodeNotRunningBody"), 2, this.language.getString("Core.init.NodeNotRunningTitle"));
        }
        if (this.isFreenetTransient() && nodes.size() == 1) {
            MiscToolkit.getInstance().showMessage(this.language.getString("Core.init.TransientNodeBody"), 2, this.language.getString("Core.init.TransientNodeTitle"));
        }
        return true;
    }

    public boolean isFreenetOnline() {
        return this.freenetIsOnline;
    }

    public boolean isFreenetTransient() {
        return this.freenetIsTransient;
    }

    private void loadKnownBoards() {
        File file = new File("boards");
        if (file.exists()) {
            this.loadOLDKnownBoards(file);
            this.saveKnownBoards();
            return;
        }
        file = new File("knownboards.xml");
        if (file.exists()) {
            Document document = null;
            try {
                document = XMLTools.parseXmlFile(file, false);
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "Error reading knownboards.xml", exception);
                return;
            }
            Element element = document.getDocumentElement();
            if (!element.getTagName().equals("FrostKnownBoards")) {
                logger.severe("Error - invalid knownboards.xml: does not contain the root tag 'FrostKnownBoards'");
                return;
            }
            AttachmentList attachmentList = new AttachmentList();
            try {
                attachmentList.loadXMLElement(element);
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "Error - knownboards.xml: contains unexpected content.", exception);
                return;
            }
            AttachmentList attachmentList2 = attachmentList.getAllOfType(1);
            knownBoards.addAll(attachmentList2);
            logger.info("Loaded " + knownBoards.size() + " known boards.");
        }
    }

    private void loadOLDKnownBoards(File file) {
        try {
            ArrayList<BoardAttachment> arrayList = new ArrayList<BoardAttachment>();
            String string = FileAccess.readFile(file);
            String[] stringArray = string.split(":");
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].trim();
                if (string2.length() < 13 || string2.indexOf("*") < 3 || string2.indexOf("*") >= string2.lastIndexOf("*")) continue;
                int n = string2.indexOf("*");
                String string3 = string2.substring(0, n).trim();
                int n2 = string2.indexOf("*", n + 1);
                String string4 = string2.substring(n + 1, n2).trim();
                String string5 = string2.substring(n2 + 1).trim();
                if (string4.length() < 10) {
                    string4 = null;
                }
                if (string5.length() < 10) {
                    string5 = null;
                }
                Board board = new Board(string3, string4, string5, null);
                BoardAttachment boardAttachment = new BoardAttachment(board);
                arrayList.add(boardAttachment);
            }
            logger.info("Loaded " + stringArray.length + " OLD known boards (converting).");
            Core.addNewKnownBoards(arrayList);
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "couldn't load/convert OLD known boards", throwable);
        }
        if (!file.renameTo(new File("boards.old"))) {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveKnownBoards() {
        Document document = XMLTools.createDomDocument();
        if (document == null) {
            logger.severe("Error - saveBoardTree: factory couldn't create XML Document.");
            return false;
        }
        Element element = document.createElement("FrostKnownBoards");
        document.appendChild(element);
        List list = Core.getKnownBoards();
        synchronized (list) {
            for (BoardAttachment boardAttachment : Core.getKnownBoards()) {
                Element element2 = boardAttachment.getXMLElement(document);
                element.appendChild(element2);
            }
        }
        boolean bl = false;
        try {
            bl = XMLTools.writeXmlFile(document, "knownboards.xml");
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "Exception while writing knownboards.xml:", throwable);
        }
        if (!bl) {
            logger.severe("Error while writing knownboards.xml, file was not saved");
        } else {
            logger.info("Saved " + Core.getKnownBoards().size() + " known boards.");
        }
        return bl;
    }

    private void loadBatches() {
        File file = new File("batches");
        if (file.exists() && file.length() > 0L) {
            try {
                String string = FileAccess.readFile(file);
                String[] stringArray = string.split("_");
                for (int i = 0; i < stringArray.length; ++i) {
                    myBatches.put(stringArray[i], stringArray[i]);
                }
                logger.info("loaded " + stringArray.length + " batches of shared files");
            }
            catch (Throwable throwable) {
                logger.log(Level.SEVERE, "couldn't load batches:", throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveBatches() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            Serializable serializable = Core.getMyBatches();
            synchronized (serializable) {
                Iterator iterator = Core.getMyBatches().keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if (string.length() > 0) {
                        stringBuffer.append(string);
                        if (!iterator.hasNext()) continue;
                        stringBuffer.append("_");
                        continue;
                    }
                    iterator.remove();
                }
            }
            serializable = new File("batches");
            FileAccess.writeFile(stringBuffer.toString(), (File)serializable);
            return true;
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "Exception thrown in saveBatches():", throwable);
            return false;
        }
    }

    public static Crypt getCrypto() {
        return crypto;
    }

    public static Hashtable getMyBatches() {
        return myBatches;
    }

    protected void resendFailedMessages() {
        ResendFailedMessagesThread resendFailedMessagesThread = new ResendFailedMessagesThread(this.getBoardsManager().getTofTree(), this.getBoardsManager().getTofTreeModel());
        resendFailedMessagesThread.start();
    }

    public void deleteDir(String string) {
        new DeleteWholeDirThread(this, string).start();
    }

    public static void schedule(TimerTask timerTask, long l) {
        Core.getInstance().timer.schedule(timerTask, l);
    }

    public static void schedule(TimerTask timerTask, long l, long l2) {
        Core.getInstance().timer.schedule(timerTask, l, l2);
    }

    public static Set getNodes() {
        return nodes;
    }

    public static List getKnownBoards() {
        return knownBoards;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addNewKnownBoards(List list) {
        if (list == null || list.size() == 0) {
            return;
        }
        for (BoardAttachment boardAttachment : list) {
            String string = boardAttachment.getBoardObj().getName();
            String string2 = boardAttachment.getBoardObj().getPrivateKey();
            String string3 = boardAttachment.getBoardObj().getPublicKey();
            boolean bl = true;
            List list2 = Core.getKnownBoards();
            synchronized (list2) {
                for (BoardAttachment boardAttachment2 : Core.getKnownBoards()) {
                    if (!boardAttachment2.getBoardObj().getName().equalsIgnoreCase(string) || (boardAttachment2.getBoardObj().getPrivateKey() != null || string2 != null) && (boardAttachment2.getBoardObj().getPrivateKey() == null || !boardAttachment2.getBoardObj().getPrivateKey().equals(string2)) || (boardAttachment2.getBoardObj().getPublicKey() != null || string3 != null) && (boardAttachment2.getBoardObj().getPublicKey() == null || !boardAttachment2.getBoardObj().getPublicKey().equals(string3))) continue;
                    bl = false;
                    break;
                }
            }
            if (!bl) continue;
            Core.getKnownBoards().add(boardAttachment);
        }
    }

    public static Core getInstance() {
        return instance;
    }

    private void convertSigIntoXml() {
        ArrayList arrayList = FileAccess.getAllEntries(new File(frostSettings.getValue("keypool.dir")), ".sig");
        logger.info("convertSigIntoXml: Starting to convert " + arrayList.size() + " .sig files.");
        for (int i = 0; i < arrayList.size(); ++i) {
            File file = (File)arrayList.get(i);
            File file2 = new File(file.getPath().substring(0, file.getPath().length() - 4));
            if (file2.getName().equals("files.xml") || file2.getName().equals("new_files.xml")) continue;
            FrostMessageObject frostMessageObject = null;
            try {
                frostMessageObject = FrostMessageFactory.createFrostMessageObject(file2);
            }
            catch (MessageCreationException messageCreationException) {
                if (messageCreationException.isEmpty()) {
                    logger.log(Level.INFO, "A message could not be created. It is empty.", messageCreationException);
                } else {
                    logger.log(Level.WARNING, "A message could not be created.", messageCreationException);
                }
                file.delete();
                continue;
            }
            String string = FileAccess.readFile(file);
            if (string.indexOf("GOOD") >= 0 || string.indexOf("CHECK") >= 0 || string.indexOf("BAD") >= 0) {
                frostMessageObject.setSignatureStatus(3);
            } else if (string.indexOf("NONE") >= 0 || string.indexOf("N/A") >= 0) {
                frostMessageObject.setSignatureStatus(2);
            } else {
                frostMessageObject.setSignatureStatus(1);
            }
            frostMessageObject.save();
            file.delete();
        }
    }

    public void initialize() throws Exception {
        String string;
        File file;
        Splashscreen splashscreen = new Splashscreen();
        splashscreen.setVisible(true);
        this.keypool = frostSettings.getValue("keypool.dir");
        splashscreen.setText(this.language.getString("Initializing Mainframe"));
        splashscreen.setProgress(20);
        new Logging(frostSettings);
        this.initializeSkins();
        DAOFactory.initialize(frostSettings);
        Startup.startupCheck(frostSettings, this.keypool);
        CleanUp.deleteEmptyBoardDateDirs(new File(this.keypool));
        splashscreen.setText(this.language.getString("Hypercube fluctuating!"));
        splashscreen.setProgress(40);
        if (!this.initializeConnectivity()) {
            System.exit(1);
        }
        if (!(file = new File("identities.xml")).exists() || file.length() == 0L) {
            frostSettings.setValue("oneTimeUpdate.convertSigs.didRun", true);
            frostSettings.setValue("oneTimeUpdate.repairIdentities.didRun", true);
        }
        if (!frostSettings.getBoolValue("oneTimeUpdate.convertSigs.didRun")) {
            splashscreen.setText("Convert from old format");
            string = "<html>Frost must now convert the messages, and this could take some time.<br>Afterwards the .sig files are not longer needed and will be deleted.<br><br><b>BACKUP YOUR FROST DIRECTORY BEFORE STARTING!</b><br><br><br>Do you want to start the conversion NOW press yes.</html>";
            int n = JOptionPane.showConfirmDialog(splashscreen, string, "About to start convert process", 1, 0);
            if (n != 0) {
                System.exit(1);
            }
            this.convertSigIntoXml();
            frostSettings.setValue("oneTimeUpdate.convertSigs.didRun", true);
        }
        splashscreen.setText(this.language.getString("Sending IP address to NSA"));
        splashscreen.setProgress(60);
        this.getIdentities().initialize(this.freenetIsOnline);
        string = !frostSettings.getBoolValue("mainframe.showSimpleTitle") ? "Frost - " + this.getIdentities().getMyId().getUniqueName() : "Frost";
        if (frostSettings.getBoolValue("showSystrayIcon") && !JSysTrayIcon.createInstance(0, string, string)) {
            logger.severe("Could not create systray icon.");
        }
        this.mainFrame = new MainFrame(frostSettings, string);
        this.getMessagingManager().initialize();
        this.getBoardsManager().initialize();
        this.getFileTransferManager().initialize();
        splashscreen.setText(this.language.getString("Wasting more time"));
        splashscreen.setProgress(70);
        this.mainFrame.initialize();
        this.loadBatches();
        this.loadKnownBoards();
        if (this.isFreenetOnline()) {
            this.resendFailedMessages();
        }
        splashscreen.setText(this.language.getString("Reaching ridiculous speed..."));
        splashscreen.setProgress(80);
        CleanUp.processExpiredFiles(MainFrame.getInstance().getTofTreeModel().getAllBoards());
        this.initializeTasks(this.mainFrame);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Core.this.mainFrame.setVisible(true);
            }
        });
        splashscreen.closeMe();
    }

    private FileTransferManager getFileTransferManager() {
        if (this.fileTransferManager == null) {
            this.fileTransferManager = new FileTransferManager(frostSettings);
            this.fileTransferManager.setMainFrame(this.mainFrame);
            this.fileTransferManager.setTofTreeModel(this.getBoardsManager().getTofTreeModel());
            this.fileTransferManager.setFreenetIsOnline(this.isFreenetOnline());
            this.fileTransferManager.setIdentities(this.getIdentities());
            this.fileTransferManager.setKeypool(this.keypool);
        }
        return this.fileTransferManager;
    }

    private MessagingManager getMessagingManager() {
        if (this.messagingManager == null) {
            this.messagingManager = new MessagingManager(frostSettings);
        }
        return this.messagingManager;
    }

    private BoardsManager getBoardsManager() {
        if (this.boardsManager == null) {
            this.boardsManager = new BoardsManager(frostSettings);
            this.boardsManager.setMainFrame(this.mainFrame);
            this.boardsManager.setCore(this);
            this.boardsManager.setMessageHashes(this.getMessagingManager().getMessageHashes());
        }
        return this.boardsManager;
    }

    private void initializeTasks(JFrame jFrame) {
        this.timer.schedule((TimerTask)new CheckForSpam(frostSettings, this.getBoardsManager().getTofTree(), this.getBoardsManager().getTofTreeModel()), 3600000L, (long)(frostSettings.getIntValue("sampleInterval") * 60 * 60 * 1000));
        TimerTask timerTask = new TimerTask(){

            public void run() {
                if (frostSettings.getBoolValue("deleteExpiredMessages")) {
                    logger.info("Timer cleaner: Starting to process expired files.");
                    CleanUp.processExpiredFiles(MainFrame.getInstance().getTofTreeModel().getAllBoards());
                }
            }
        };
        this.timer.schedule(timerTask, 21600000L, 21600000L);
        timerTask = null;
        timerTask = new TimerTask(){

            public void run() {
                logger.info("freeing memory");
                System.gc();
            }
        };
        this.timer.schedule(timerTask, 1800000L, 1800000L);
        timerTask = null;
        StorageManager storageManager = new StorageManager(frostSettings, this);
        storageManager.addAutoSavable(this);
        storageManager.addAutoSavable(this.getIdentities());
        storageManager.addAutoSavable(this.getMessagingManager().getMessageHashes());
        storageManager.addAutoSavable(this.getBoardsManager().getTofTree());
        storageManager.addAutoSavable(this.getFileTransferManager());
        storageManager.addExitSavable(this);
        storageManager.addExitSavable(this.getIdentities());
        storageManager.addExitSavable(this.getMessagingManager().getMessageHashes());
        storageManager.addExitSavable(this.getBoardsManager().getTofTree());
        storageManager.addExitSavable(this.getFileTransferManager());
        storageManager.addExitSavable(frostSettings);
        if (frostSettings.getBoolValue("helpFriends")) {
            this.timer.schedule((TimerTask)new GetFriendsRequestsThread(this.identities), 300000L, 21600000L);
        }
    }

    public static FlexibleObserver getEmailNotifier() {
        return emailNotifier;
    }

    public static void setLocale(Locale locale) {
        Core.locale = locale;
    }

    private void initializeSkins() {
        String string;
        String string2 = frostSettings.getValue("skinsEnabled");
        if (string2 != null && string2.equals("true") && (string = frostSettings.getValue("selectedSkin")) != null && !string.equals("none")) {
            try {
                Skin skin = SkinLookAndFeel.loadThemePack(string);
                SkinLookAndFeel.setSkin(skin);
                UIManager.setLookAndFeel(new SkinLookAndFeel());
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                logger.severe("The selected skin is not supported by your system\nSkins will be disabled until you choose another one");
                frostSettings.setValue("skinsEnabled", false);
            }
            catch (Exception exception) {
                logger.severe("There was an error while loading the selected skin\nSkins will be disabled until you choose another one");
                frostSettings.setValue("skinsEnabled", false);
            }
        }
    }

    public FrostIdentities getIdentities() {
        if (this.identities == null) {
            this.identities = new FrostIdentities(frostSettings);
        }
        return this.identities;
    }

    public void save() throws StorageException {
        boolean bl = this.saveBatches();
        if (!(bl &= this.saveKnownBoards())) {
            throw new StorageException("Error while saving the core items.");
        }
    }

    private void initializeLanguage() {
        if (locale != null) {
            Language.initialize("res.LangRes", locale);
        } else {
            String string = frostSettings.getValue("locale");
            if (!string.equals("default")) {
                Language.initialize("res.LangRes", new Locale(string));
            } else {
                Language.initialize("res.LangRes");
            }
        }
        this.language = Language.getInstance();
    }

    public void dispatchEvent(FrostEvent frostEvent) {
        this.dispatcher.dispatchEvent(frostEvent);
    }

    static {
        crypto = new FrostCrypt();
    }

    private class EventDispatcher {
        private EventDispatcher() {
        }

        public void dispatchEvent(FrostEvent frostEvent) {
            switch (frostEvent.getId()) {
                case 0: {
                    this.dispatchStorageErrorEvent((StorageErrorEvent)frostEvent);
                    break;
                }
                default: {
                    logger.severe("Unknown FrostEvent received. Id: '" + frostEvent.getId() + "'");
                }
            }
        }

        public void dispatchStorageErrorEvent(StorageErrorEvent storageErrorEvent) {
            StringWriter stringWriter = new StringWriter();
            storageErrorEvent.getException().printStackTrace(new PrintWriter(stringWriter));
            if (Core.this.mainFrame != null) {
                JDialogWithDetails.showErrorDialog(Core.this.mainFrame, Core.this.language.getString("Saver.AutoTask.title"), storageErrorEvent.getMessage(), stringWriter.toString());
            }
            System.exit(3);
        }
    }
}

