/*
 * Decompiled with CFR 0.152.
 */
package frost;

import frost.Core;
import frost.DateFun;
import frost.FileAccess;
import frost.MainFrame;
import frost.gui.objects.Board;
import java.io.File;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class CleanUp {
    private static Logger logger = Logger.getLogger(CleanUp.class.getName());
    public static final int DELETE_MESSAGES = 1;
    public static final int ARCHIVE_MESSAGES = 2;
    public static final int KEEP_MESSAGES = 3;

    public static void processExpiredFiles(List list) {
        String string = Core.frostSettings.getValue("messageExpirationMode");
        int n = string.toUpperCase().equals("KEEP") ? 3 : (string.toUpperCase().equals("ARCHIVE") ? 2 : (string.toUpperCase().equals("DELETE") ? 1 : 3));
        CleanUp.processExpiredFiles(list, n);
    }

    private static void processExpiredFiles(List list, int n) {
        String string;
        if (n == 2) {
            boolean bl;
            logger.info("Expiration mode is ARCHIVE_MESSAGES.");
            string = Core.frostSettings.getValue("archive.dir");
            if (string == null || string.length() == 0) {
                logger.severe("ERROR: no ARCHIVE DIR specified!");
                return;
            }
            File file = new File(string = string + "messages" + File.separator);
            if (!file.isDirectory() && !(bl = file.mkdirs())) {
                logger.severe("ERROR: could not create archive directory: " + file.getPath());
                return;
            }
        } else if (n == 1) {
            logger.info("Expiration mode is DELETE_MESSAGES.");
            string = null;
        } else if (n == 3) {
            logger.info("Expiration mode is KEEP_MESSAGES.");
            string = null;
        } else {
            logger.severe("ERROR: invalid MODE specified: " + n);
            return;
        }
        CleanUp.deleteExpiredIndicesFiles(list);
        if (n == 3) {
            return;
        }
        int n2 = Core.frostSettings.getIntValue("messageExpireDays") + 1;
        if (n2 < Core.frostSettings.getIntValue("maxMessageDisplay")) {
            n2 = Core.frostSettings.getIntValue("maxMessageDisplay") + 1;
        }
        if (n2 < Core.frostSettings.getIntValue("maxMessageDownload")) {
            n2 = Core.frostSettings.getIntValue("maxMessageDownload") + 1;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n3;
            File file;
            int n4 = n2;
            Board board = (Board)iterator.next();
            if (board.isConfigured() && board.getMaxMessageDisplay() > n4) {
                n4 = board.getMaxMessageDisplay();
            }
            if (!(file = new File(MainFrame.keypool + board.getBoardFilename())).isDirectory()) {
                logger.warning("No board folder for board " + board.getName());
                continue;
            }
            if (n == 1) {
                logger.info("Starting to DELETE all expired files in folder " + board.getBoardFilename() + " older than " + n4 + " days.");
                n3 = CleanUp.processExpiredMessages(file, n4, n, string);
                logger.info("Finished to DELETE expired indices files in folder " + file.getName() + "deleted " + n3 + " files.");
                continue;
            }
            if (n != 2) continue;
            logger.info("Starting to ARCHIVE all expired files in folder " + board.getBoardFilename() + " older than " + n4 + " days into archive folder " + string + ".");
            n3 = CleanUp.processExpiredMessages(file, n4, n, string);
            logger.info("Finished to ARCHIVE expired indices files in folder " + file.getName() + "deleted " + n3 + " files.");
        }
        logger.info("Finished to process expired files.");
    }

    private static int processExpiredMessages(File file, int n, int n2, String string) {
        int n3 = 0;
        String string2 = DateFun.getExtendedDate(n);
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            String string3;
            String string4;
            File file2 = fileArray[i];
            if (!file2.isDirectory() || (string4 = DateFun.buildExtendedDate(string3 = file2.getName())) == null || string4.compareTo(string2) >= 0) continue;
            File[] fileArray2 = file2.listFiles();
            for (int j = 0; j < fileArray2.length; ++j) {
                File file3 = fileArray2[j];
                if (!file3.isFile() || !file3.getName().endsWith(".xml")) continue;
                if (n2 == 2) {
                    String string5 = file3.getPath();
                    String string6 = string + file.getName() + File.separator + file2.getName() + File.separator + file3.getName();
                    File file4 = new File(string6);
                    file4.getParentFile().mkdirs();
                    boolean bl = FileAccess.copyFile(string5, string6);
                    if (!bl) {
                        logger.severe("Copy of file to archive failed, source=" + string5 + "; target=" + string6);
                        logger.severe("Processing stopped.");
                        return n3;
                    }
                }
                if (!file3.delete()) continue;
                ++n3;
            }
        }
        return n3;
    }

    private static void deleteExpiredIndicesFiles(List list) {
        long l = Core.frostSettings.getIntValue("maxMessageDownload") * 2;
        if (l < 10L) {
            l = 10L;
        }
        long l2 = new Date().getTime() - l * 24L * 60L * 60L * 1000L;
        for (Board board : list) {
            logger.info("Starting to delete all expired indices files in folder " + board.getBoardFilename() + " with a modified date older than " + l + " days.");
            File file = new File(MainFrame.keypool + board.getBoardFilename());
            if (!file.isDirectory()) {
                logger.warning("No board folder for board " + board.getName());
                continue;
            }
            int n = 0;
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (!file2.isFile() || !file2.getName().startsWith("indices") || file2.lastModified() >= l2 || !file2.delete()) continue;
                ++n;
            }
            logger.info("Finished to delete expired indices files in folder " + board.getBoardFilename() + ", deleted " + n + " files.");
        }
    }

    public static void deleteEmptyBoardDateDirs(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        logger.info("Starting to delete all empty board date directories.");
        for (int i = 0; i < fileArray.length; ++i) {
            File[] fileArray2;
            if (fileArray[i].isFile() || (fileArray2 = fileArray[i].listFiles()) == null || fileArray2.length == 0) continue;
            for (int j = 0; j < fileArray2.length; ++j) {
                String[] stringArray;
                if (fileArray2[j].isFile() || (stringArray = fileArray2[j].list()) == null || stringArray.length != 0) continue;
                fileArray2[j].delete();
            }
        }
        logger.info("Finished to delete all empty board date directories.");
    }
}

