package freenetmessageboard.schach;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class SchachZug {

  private SchachFigur figur;

  private int neuX;
  private int neuY;
  private int altX;
  private int altY;

  private int ereignis=-1;

  private static char[] zeilenNamen={ '1', '2', '3', '4', '5', '6', '7', '8' };
  private static char[] spaltenNamen = { 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H' };

  private SchachFigur beteiligteFigur;

  public SchachZug(SchachFigur figur, int x, int y) {
    this.figur=figur;
    this.altX=figur.posX;
    this.altY=figur.posY;
    this.neuX=x;
    this.neuY=y;
  }

  void setBesonderesEreignis(int ereignisCode) {
    this.ereignis=ereignisCode;
  }

  void setBeteiligteFigur(SchachFigur figur) {
    this.beteiligteFigur=figur;
  }

  SchachFigur getBeteiligteFigur() {
    return this.beteiligteFigur;
  }

  private static int getZeile(char name) {
    for (int i=0; i<zeilenNamen.length; i++) {
      if (zeilenNamen[i]==name) {
        return i;
      }
    }
    return -1;
  }

  private static int getSpalte(char name) {
    for (int i=0; i<spaltenNamen.length; i++) {
      if (spaltenNamen[i]==name) {
        return i;
      }
    }
    return -1;
  }

  static SchachZug parseShortString(String string, SchachSpiel spiel) throws UngueltigerZugException {
    try {
      int altX = SchachZug.getSpalte(string.charAt(0));
      int altY = SchachZug.getZeile(string.charAt(1));
      int neuX = SchachZug.getSpalte(string.charAt(2));
      int neuY = SchachZug.getZeile(string.charAt(3));
      SchachFigur figur = spiel.getFigurAnPosition(altX, altY);
      SchachZug zug = new SchachZug(figur, neuX, neuY);
      if (string.length()>4) {
        SchachFigur beteiligteFigur=null;
        String figurName = string.substring(5);
        if (figurName.equals(Dame.name)) {
          beteiligteFigur=new Dame(spiel, figur.istWeiss, neuX, neuY);
        }
        if (figurName.equals(Turm.name)) {
          beteiligteFigur=new Turm(spiel, figur.istWeiss, neuX, neuY);
        }
        if (figurName.equals(Laeufer.name)) {
          beteiligteFigur=new Laeufer(spiel, figur.istWeiss, neuX, neuY);
        }
        if (figurName.equals(Springer.name)) {
          beteiligteFigur=new Springer(spiel, figur.istWeiss, neuX, neuY);
        }
        if (beteiligteFigur!=null) {
          zug.setBeteiligteFigur(beteiligteFigur);
        }
      }
      return zug;
    } catch (Throwable t) {
      t.printStackTrace();
      throw new UngueltigerZugException(string+": "+t.getClass().getName()+": "+t.getMessage());
    }
  }

  public String toShortString() {
    StringBuffer buf = new StringBuffer();
    buf.append(this.spaltenNamen[this.altX]);
    buf.append(this.zeilenNamen[this.altY]);
    buf.append(this.spaltenNamen[this.neuX]);
    buf.append(this.zeilenNamen[this.neuY]);
    if (this.beteiligteFigur!=null) {
      buf.append(",");
      buf.append(this.beteiligteFigur.getName());
    }
    return buf.toString();
  }

  public String toString() {
    StringBuffer buf = new StringBuffer();
    buf.append(figur.getName());
    buf.append(" ");
    buf.append(this.spaltenNamen[this.altX]);
    buf.append(this.zeilenNamen[this.altY]);
    buf.append(" - ");
    buf.append(this.spaltenNamen[this.neuX]);
    buf.append(this.zeilenNamen[this.neuY]);
    if (this.ereignis!=-1) {
      if (this.ereignis==BesonderesEreignisException.FIGURUMWANDLUNG) {
        buf.append(" -> ");
        buf.append(this.beteiligteFigur.getName());
      } else {
        buf.append(": ");
        buf.append(BesonderesEreignisException.ereignisStrings[this.ereignis]);
      }
    }
    return buf.toString();
  }

  boolean istRochade() {
    return (figur instanceof Koenig && Math.abs(this.neuX-this.altX)>1);
  }

  boolean istBauernEroeffnung() {
    return (figur instanceof Bauer && Math.abs(this.neuY-this.altY)==2);
  }

  boolean istFigurUmwandlung() {
    if (figur instanceof Bauer) {
      if ((figur.istWeiss && this.neuY==7) || (!figur.istWeiss && this.neuY==0)) {
        return true;
      }
    }
    return false;
  }

  public SchachFigur getFigur() {
    return this.figur;
  }

  public int getAltX() {
    return this.altX;
  }

  public int getAltY() {
    return this.altY;
  }

  public int getZielX() {
    return this.neuX;
  }

  public int getZielY() {
    return this.neuY;
  }

}
