package freenetmessageboard.schach;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class SchachTestFrame extends JFrame {
  JPanel contentPane;
  BorderLayout borderLayout1 = new BorderLayout();

  SchachSpiel spiel;

  public SchachTestFrame(SchachSpiel spiel) {
    this();
    SchachPanel panel = new SchachPanel(spiel);
    panel.schachBrett1.zeigeAnWerDranIst();
    this.spiel=spiel;
    String whiteNick = freenetmessageboard.core.ContactList.instance().getNicknameOfPublicKey(spiel.getWhitePublicKey());
    String blackNick = freenetmessageboard.core.ContactList.instance().getNicknameOfPublicKey(spiel.getBlackPublicKey());
    this.setTitle(whiteNick+" vs "+blackNick);
    this.getContentPane().add(panel, BorderLayout.CENTER);
    this.validate();
    this.repaint();
    this.setVisible(true);
  }
  /**Construct the frame*/
  public SchachTestFrame() {
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }
  /**Component initialization*/
  private void jbInit() throws Exception  {
    //setIconImage(Toolkit.getDefaultToolkit().createImage(SchachTestFrame.class.getResource("[Your Icon]")));
    contentPane = (JPanel) this.getContentPane();
    contentPane.setLayout(borderLayout1);
    this.setSize(new Dimension(570, 470));
    this.setLocation(50,50);
    this.setTitle("Frame Title");
    this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
  }
  /**Overridden so we can exit when window is closed*/
  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
  }
}