package freenetmessageboard.schach;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class SchachSpiel extends javax.swing.AbstractListModel {

  private java.util.List schachFigurenListe = new java.util.LinkedList();

  private String whitePublicKey=new String();
  private String blackPublicKey=new String();
  private String gameId=new String();
  private String beginningDate = freenetmessageboard.core.Message.messageDateFormat.format(new java.util.Date());
  String whiteMessage=new String();
  String blackMessage=new String();


  private java.util.List bisherigeZuegeListe = new java.util.LinkedList();
  private java.util.List bisherigePositionenHashmapListe = new java.util.LinkedList();

  private boolean weissAmZug=true;

  private boolean wurdeSchachGesagt=false;
  private boolean hatWeissSchonSchachGesagt=false;
  private boolean hatSchwarzSchonSchachGesagt=true;

  boolean letzterZugWarBauernEroeffnung=false;

  private boolean warDameVorherImSchach;

  private boolean alteStellungWirdAngezeigt=false;

  public SchachSpiel(SchachSpiel realGame) {
    this.blackPublicKey=realGame.blackPublicKey;
    this.whitePublicKey=realGame.whitePublicKey;
    this.blackMessage=realGame.blackMessage;
    this.whiteMessage=realGame.whiteMessage;
    this.beginningDate=realGame.beginningDate;
    this.gameId=realGame.gameId;
    this.stelleFigurenAuf();
  }

  public SchachSpiel(String blackPublicKey) {
    this.blackPublicKey=blackPublicKey;
    this.whitePublicKey=freenetmessageboard.core.PersonalInfo.instance().getPublicKey();
    java.util.Date now = new java.util.Date();
    this.beginningDate=freenetmessageboard.core.Message.messageDateFormat.format(now);
    this.gameId=this.whitePublicKey+this.blackPublicKey+now.getTime();
    this.stelleFigurenAuf();
  }


  public SchachSpiel(String gameId, String beginningDate, String whitePublicKey, String blackPublicKey, String whiteMessage, String blackMessage) {
    this.gameId=gameId;
    this.beginningDate=beginningDate;
    this.whitePublicKey=whitePublicKey;
    this.blackPublicKey=blackPublicKey;
    this.blackMessage=blackMessage;
    this.whiteMessage=whiteMessage;
    this.stelleFigurenAuf();
  }

  public String getGameId() {
    return this.gameId;
  }

  public String getBeginningDate() {
    return this.beginningDate;
  }

  public String getWhitePublicKey() {
    return this.whitePublicKey;
  }

  public String getBlackMessage() {
    return this.blackMessage;
  }

  public String getWhiteMessage() {
    return this.whiteMessage;
  }

  public String getBlackPublicKey() {
    return this.blackPublicKey;
  }

  public void doMoves(String movesString) {
    try {
      java.io.LineNumberReader lnr = new java.io.LineNumberReader(new java.io.StringReader(movesString));
      String line = lnr.readLine();
      while (line!=null) {
        SchachZug zug = SchachZug.parseShortString(line, this);
        line = lnr.readLine();
        try {
          this.fuehreZugAus(zug);
        } catch (BesonderesEreignisException ex) { }
      }
    } catch (Exception ex) {
      System.err.println("Ungueltiger Zug im moveString:"+ex.getMessage()+"\n"+movesString);
    }
  }

  public int getMoveCount() {
    return this.bisherigeZuegeListe.size();
  }

  public String getMovesString() {
    StringBuffer buf = new StringBuffer();
    java.util.Iterator it = this.bisherigeZuegeListe.iterator();
    while(it.hasNext()) {
      SchachZug zug = (SchachZug)it.next();
      buf.append(zug.toShortString());
      buf.append('\n');
    }
    return buf.toString();
  }


  public int getSize() {
    return this.bisherigeZuegeListe.size();
  }

  public Object getElementAt(int i) {
    if (i%2==0) {
      return (i/2+1)+": "+this.bisherigeZuegeListe.get(i);
    } else {
      return "  "+this.bisherigeZuegeListe.get(i);
    }
  }

 java.awt.Dimension getPreferredScrollableViewportSize() {
  return new java.awt.Dimension(80, this.schachFigurenListe.size()*10);
 }

  private void stelleFigurenAuf() {
    this.schachFigurenListe.add(new Koenig(this, true, 4, 0));
    this.schachFigurenListe.add(new Koenig(this, false, 4, 7));
    this.schachFigurenListe.add(new Dame(this, true, 3,0));
    this.schachFigurenListe.add(new Dame(this, false, 3,7));
    this.schachFigurenListe.add(new Laeufer(this, true, 2,0));
    this.schachFigurenListe.add(new Laeufer(this, true, 5,0));
    this.schachFigurenListe.add(new Laeufer(this, false, 2,7));
    this.schachFigurenListe.add(new Laeufer(this, false, 5,7));
    this.schachFigurenListe.add(new Springer(this, true, 1,0));
    this.schachFigurenListe.add(new Springer(this, true, 6,0));
    this.schachFigurenListe.add(new Springer(this, false, 1,7));
    this.schachFigurenListe.add(new Springer(this, false, 6,7));
    this.schachFigurenListe.add(new Turm(this, true, 0,0));
    this.schachFigurenListe.add(new Turm(this, true, 7,0));
    this.schachFigurenListe.add(new Turm(this, false, 0,7));
    this.schachFigurenListe.add(new Turm(this, false, 7,7));

    for (int i=0; i<8; i++) {
      this.schachFigurenListe.add(new Bauer(this, true, i, 1));
      this.schachFigurenListe.add( new Bauer(this, false, i, 6));
    }
  }

  boolean istFigurBedroht(SchachFigur figur, SchachFigur ignorierteFigur) {
    java.util.Iterator it = this.schachFigurenListe.iterator();
    while(it.hasNext()) {
      SchachFigur andereFigur = (SchachFigur)it.next();
      if (ignorierteFigur!=null) {
        if (andereFigur.equals(ignorierteFigur)) {
          continue;
        }
      }
      if (figur.istWeiss!=andereFigur.istWeiss) {
        try {
          andereFigur.zugMoeglich(figur.posX, figur.posY, false);
        }
        catch (UngueltigerZugException e) {
          continue;
        }
        catch (FigurGeschlagenException ex) {
          return true;
        }
      }
    }
    return false;
  }

  SchachZug getLetztenZug() {
    return (SchachZug)this.bisherigeZuegeListe.get(this.bisherigeZuegeListe.size()-1);
  }

  SchachZug[] getMoeglicheZuege() {
    java.util.List moeglicheZuege = new java.util.LinkedList();
    java.util.Iterator it = new java.util.LinkedList(this.schachFigurenListe).iterator();
    while(it.hasNext()) {
      SchachFigur figur = (SchachFigur)it.next();
      if (figur.istWeiss!=this.weissAmZug) {
        continue;
      }
      for (int x=0; x<8; x++) {
        for (int y=0; y<8; y++) {
          try {
            if (figur.zugMoeglich(x, y, true)) {
              moeglicheZuege.add(new SchachZug(figur, x, y));
            }
          } catch (FigurGeschlagenException ex) {
            moeglicheZuege.add(new SchachZug(figur, x, y));
          }
          catch (UngueltigerZugException ex) {
          }
        }
      }
    }
    return (SchachZug[])moeglicheZuege.toArray(new SchachZug[moeglicheZuege.size()]);
  }

  boolean istKoenigBedroht(boolean sollWeissSein) {
    java.util.Iterator it = this.schachFigurenListe.iterator();
    while(it.hasNext()) {
      SchachFigur figur = (SchachFigur)it.next();
      if (figur.istWeiss==sollWeissSein) {
        if (figur instanceof Koenig) {
          this.wurdeSchachGesagt=this.istFigurBedroht(figur, null);
          if (this.wurdeSchachGesagt) {
            if (this.weissAmZug) {
              this.hatSchwarzSchonSchachGesagt=true;
            } else {
              this.hatWeissSchonSchachGesagt=true;
            }
            return this.wurdeSchachGesagt;
          }
        }
      }
    }
    return false;
  }

  boolean istKoenigBedrohtNachZug(SchachFigur zugFigur, int x, int y, boolean sollWeissSein) {

    SchachFigur geschlageneFigur=null;
    try {
      geschlageneFigur = this.getFigurAnPosition(x, y);
    } catch (KeineFigurAufDiesemFeldException ex) { }

    int altX = zugFigur.posX;
    int altY = zugFigur.posY;
    zugFigur.posX=x;
    zugFigur.posY=y;

    java.util.Iterator it = this.schachFigurenListe.iterator();
    boolean schach=false;

    while(it.hasNext()) {
      SchachFigur figur = (SchachFigur)it.next();
      if (figur.istWeiss==sollWeissSein) {
        if (figur instanceof Koenig) {
          this.wurdeSchachGesagt=this.istFigurBedroht(figur, geschlageneFigur);
          if (this.wurdeSchachGesagt) {
            schach=true;
          }
        }
      }
    }
    zugFigur.posX=altX;
    zugFigur.posY=altY;
    return schach;
  }

  boolean istDameBedroht(boolean sollWeissSein) {
    java.util.Iterator it = this.schachFigurenListe.iterator();
    while(it.hasNext()) {
      SchachFigur figur = (SchachFigur)it.next();
      if (figur.istWeiss==sollWeissSein) {
        if (figur instanceof Dame) {
          return this.istFigurBedroht(figur, null);
        }
      }
    }
    return false;
  }

  boolean istWegFreiNach(SchachFigur figur, int zielX, int zielY) {
    int xIncr=0;
    int yIncr=0;
    if (figur.posX>zielX) {
      xIncr=-1;
    }
    if (figur.posX<zielX) {
      xIncr=1;
    }
    if (figur.posY>zielY) {
      yIncr=-1;
    }
    if (figur.posY<zielY) {
      yIncr=1;
    }
    int posX=figur.posX+xIncr;
    int posY=figur.posY+yIncr;
    while(true) {

      if (posX==zielX && posY==zielY) {
        break;
      }
      if (this.istFigurAufPosition(posX, posY)) {
        return false;
      }
      posX+=xIncr;
      posY+=yIncr;
    }
    return true;
  }

  boolean istWeissAmZug() {
    return this.weissAmZug;
  }

  boolean istFigurAufPosition(int x, int y) {
    try {
      this.getFigurAnPosition(x, y);
      return true;
    } catch (KeineFigurAufDiesemFeldException ex) {
      return false;
    }

  }

  SchachFigur getFigurAnPosition(int x, int y) throws KeineFigurAufDiesemFeldException {
    java.util.Iterator it;
    it = this.schachFigurenListe.iterator();
    while(it.hasNext()) {
      SchachFigur figur = (SchachFigur)it.next();
      if (figur.posX==x && figur.posY==y) {
        return figur;
      }
    }
    throw new KeineFigurAufDiesemFeldException();
  }

  SchachFigur getFigurAnPosition(int x, int y, int zug) throws KeineFigurAufDiesemFeldException {
    java.util.Map alteStellungMap = ((java.util.Map)this.bisherigePositionenHashmapListe.get(zug));
    java.util.Iterator it = alteStellungMap.keySet().iterator();
    while(it.hasNext()) {
      SchachFigur figur = (SchachFigur)it.next();
      int[] pos = (int[])alteStellungMap.get(figur);
      if (pos[0]==x && pos[1]==y) {
        return figur;
      }
    }
    throw new KeineFigurAufDiesemFeldException();
  }

  public boolean binIchAmZug() {
    if (this.whitePublicKey.equals(freenetmessageboard.core.PersonalInfo.instance().getPublicKey())) {
      return this.weissAmZug;
    }
    if (this.blackPublicKey.equals(freenetmessageboard.core.PersonalInfo.instance().getPublicKey())) {
      return !this.weissAmZug;
    }
    return false;
  }

  SchachSpiel getAlteStellung(int zugNr) throws UngueltigerZugException {
    try {
      java.util.List zugListe = this.bisherigeZuegeListe.subList(0, zugNr+1);
      SchachSpiel spiel = new SchachSpiel(this);
      java.util.Iterator it = zugListe.iterator();
      while (it.hasNext()) {
        try {
          SchachZug originalZug = (SchachZug)it.next();
          SchachFigur figur = spiel.getFigurAnPosition(originalZug.getAltX(), originalZug.getAltY());
          SchachZug neuerZug = new SchachZug(figur, originalZug.getZielX(), originalZug.getZielY());
          spiel.fuehreZugAus(neuerZug);
        } catch (BesonderesEreignisException ex) {
          System.err.println(ex.getMessage());
        }
      }
      return spiel;
    } catch (KeineFigurAufDiesemFeldException ex) {
      throw new UngueltigerZugException("bad game state");
    }
  }

  void figurenTausch(SchachZug zug, SchachFigur neue) throws BesonderesEreignisException {
    zug.setBeteiligteFigur(neue);
    this.schachFigurenListe.remove(zug.getFigur());
    this.schachFigurenListe.add(neue);
    this.testeSituation();
  }

  private java.util.Map erzeugeStellungsMap() {
    java.util.Iterator it = this.schachFigurenListe.iterator();
    java.util.Map stellungsMap = new java.util.HashMap();
    while (it.hasNext()) {
      SchachFigur figur = (SchachFigur)it.next();
      stellungsMap.put(figur, new int[] { figur.posX, figur.posY });
    }
    return stellungsMap;
  }

  void fuehreZugAus(SchachZug zug) throws UngueltigerZugException, BesonderesEreignisException {

    this.warDameVorherImSchach=this.istDameBedroht(!this.weissAmZug);

    try {
      if (zug.istRochade()) {
        Turm turm = ((Koenig)zug.getFigur()).getTurmZurRochade(zug.getZielX(), zug.getZielY());
        zug.getFigur().zieheNach(zug.getZielX(), zug.getZielY());
        if (turm.posX<zug.getZielX()) {
          turm.posX=zug.getZielX()+1;
        } else {
          turm.posX=zug.getZielX()-1;
        }
      } else {
        zug.getFigur().zieheNach(zug.getZielX(), zug.getZielY());
        if (zug.istBauernEroeffnung()) {
          this.letzterZugWarBauernEroeffnung=true;
        } else {
          this.letzterZugWarBauernEroeffnung=false;
        }
      }
    } catch (FigurGeschlagenException ex) {
      this.schachFigurenListe.remove(ex.getGeschlageneFigur());
    }

    this.bisherigeZuegeListe.add(zug);

    if (zug.istFigurUmwandlung()) {
      this.weissAmZug=!this.weissAmZug;
      zug.setBesonderesEreignis(BesonderesEreignisException.FIGURUMWANDLUNG);
      if (zug.getBeteiligteFigur()==null) {
        throw new BesonderesEreignisException(BesonderesEreignisException.FIGURUMWANDLUNG, zug);
      } else {
        this.figurenTausch(zug, zug.getBeteiligteFigur());
        return;
      }
    }
    this.weissAmZug=!this.weissAmZug;
    this.testeSituation();

//    this.fireContentsChanged(this, this.bisherigeZuegeListe.size(), this.bisherigeZuegeListe.size());
  }

  void testeSituation() throws BesonderesEreignisException {
    this.bisherigePositionenHashmapListe.add(this.erzeugeStellungsMap());
    this.fireIntervalAdded(this,this.bisherigeZuegeListe.size(), this.bisherigeZuegeListe.size());
    if (this.istKoenigBedroht(this.weissAmZug)) {
      SchachZug[] moeglicheZuege = this.getMoeglicheZuege();
      System.err.println("es gibt noch "+moeglicheZuege.length+" moegliche zuege");
      if (moeglicheZuege.length==0) {
        this.getLetztenZug().setBesonderesEreignis(BesonderesEreignisException.SCHACHMATT);
        throw new BesonderesEreignisException(BesonderesEreignisException.SCHACHMATT, this.getLetztenZug());
      }
      this.getLetztenZug().setBesonderesEreignis(BesonderesEreignisException.SCHACH);
      throw new BesonderesEreignisException(BesonderesEreignisException.SCHACH, this.getLetztenZug());
    } else {
      if (this.getMoeglicheZuege().length==0) {
        this.getLetztenZug().setBesonderesEreignis(BesonderesEreignisException.PATT);
        throw new BesonderesEreignisException(BesonderesEreignisException.PATT, this.getLetztenZug());
      }
    }
    if (this.istDameBedroht(this.weissAmZug) && this.warDameVorherImSchach==false) {
      this.getLetztenZug().setBesonderesEreignis(BesonderesEreignisException.GARDEZ);
      throw new BesonderesEreignisException(BesonderesEreignisException.GARDEZ, this.getLetztenZug());
    }

  }
}