package freenetmessageboard.schach;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class SchachPanel extends JPanel {
  BorderLayout mainBorderLayout = new BorderLayout();
  JScrollPane bisherigeZuegeScrollPane = new JScrollPane();
  JList bisherigeZuegeList;
  JLabel statusLabel = new JLabel();
  JPanel mainPanel = new JPanel();
  SchachBrett schachBrett1 = new SchachBrett();
  BorderLayout mainPanelBorderLayout = new BorderLayout();
  JPanel blackMessagePanel = new JPanel();
  BorderLayout blackMessagePanelBorderLayout = new BorderLayout();
  JLabel blackNickLabel = new JLabel();
  JTextField blackMessageTextField = new JTextField();
  JPanel whiteMessagePanel = new JPanel();
  BorderLayout whiteMessagePanelBorderLayout = new BorderLayout();
  JTextField whiteMessageTextField = new JTextField();
  JLabel whiteNickLabel = new JLabel();

  public SchachPanel(SchachSpiel spiel) {
    this.schachBrett1=new SchachBrett(spiel);
 /*   schachBrett1.setMaximumSize(new Dimension(200, 200));
    schachBrett1.setMinimumSize(new Dimension(200, 200));
    schachBrett1.setPreferredSize(new Dimension(200, 200));*/

    this.bisherigeZuegeList = new javax.swing.JList(spiel);
    this.bisherigeZuegeScrollPane=new JScrollPane(this.bisherigeZuegeList);
    this.bisherigeZuegeList.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
      public void valueChanged(javax.swing.event.ListSelectionEvent e)  {
        SchachPanel.this.bisherigeZuegeList_valueChanged(e);
      }

    });
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }

  }

  private void bisherigeZuegeList_valueChanged(javax.swing.event.ListSelectionEvent e)  {
    int index = this.bisherigeZuegeList.getSelectedIndex();

    if (index!=-1) {
      this.schachBrett1.zeigeAlteStellungAn(index);
      this.schachBrett1.repaint();
    }
  }

  public SchachPanel() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  public void valide() {
    super.validate();
    this.bisherigeZuegeList.setVisibleRowCount(5);
  }

  private void jbInit() throws Exception {
    this.setLayout(mainBorderLayout);
    bisherigeZuegeScrollPane.setPreferredSize(new java.awt.Dimension(190,50));
  //  bisherigeZuegeScrollPane.getViewport().setPreferredSize(bisherigeZuegeList.getPreferredScrollableViewportSize() );
    statusLabel.setText("");
    mainPanel.setLayout(mainPanelBorderLayout);
    blackMessagePanel.setLayout(blackMessagePanelBorderLayout);
    blackNickLabel.setBackground(Color.black);
    blackNickLabel.setForeground(Color.white);
    blackNickLabel.setOpaque(true);
    blackNickLabel.setText(this.schachBrett1.blackNick+": ");
    blackMessageTextField.setBackground(Color.black);
    blackMessageTextField.setForeground(Color.white);
    blackMessageTextField.setEditable(false);
    blackMessageTextField.setText(this.schachBrett1.getSchachSpiel().blackMessage);
    whiteMessageTextField.setText(this.schachBrett1.getSchachSpiel().whiteMessage);
    whiteMessagePanel.setLayout(whiteMessagePanelBorderLayout);
    whiteMessageTextField.setBackground(Color.white);
    whiteMessageTextField.setEditable(false);
    whiteNickLabel.setBackground(Color.white);
    whiteNickLabel.setForeground(Color.darkGray);
    whiteNickLabel.setOpaque(true);
    whiteNickLabel.setText(this.schachBrett1.whiteNick+": ");

    this.add(bisherigeZuegeScrollPane, BorderLayout.EAST);
    this.add(statusLabel,  BorderLayout.SOUTH);
    this.add(mainPanel,  BorderLayout.CENTER);
    mainPanel.add(schachBrett1, BorderLayout.CENTER);
    if (this.schachBrett1.getSchachSpiel().getBlackPublicKey().equals(freenetmessageboard.core.PersonalInfo.instance().getPublicKey())) {
      mainPanel.add(blackMessagePanel, BorderLayout.SOUTH);
      blackMessageTextField.setEditable(true);
      this.schachBrett1.reverseView();
    } else {
      mainPanel.add(blackMessagePanel, BorderLayout.NORTH);
      whiteMessageTextField.setEditable(true);
    }
    blackMessagePanel.add(blackMessageTextField,  BorderLayout.CENTER);
    blackMessagePanel.add(blackNickLabel, BorderLayout.WEST);
    if (this.schachBrett1.getSchachSpiel().getBlackPublicKey().equals(freenetmessageboard.core.PersonalInfo.instance().getPublicKey())) {
      mainPanel.add(whiteMessagePanel,  BorderLayout.NORTH);
    } else {
      mainPanel.add(whiteMessagePanel,  BorderLayout.SOUTH);
    }
    whiteMessagePanel.add(whiteMessageTextField,  BorderLayout.CENTER);
    whiteMessagePanel.add(whiteNickLabel,  BorderLayout.WEST);
  }


}