package freenetmessageboard.schach;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public abstract class SchachFigur {

  protected int posX;
  protected int posY;

  protected static int iconSize = 40;

  protected SchachSpiel schachSpiel;

  protected boolean wurdeBereitsBewegt=false;
  protected boolean istWeiss;

  public SchachFigur(SchachSpiel spiel, boolean istWeiss, int x, int y) {
    this.posX=x;
    this.posY=y;
    this.schachSpiel=spiel;
    this.istWeiss=istWeiss;
  }

  public String toString() {
    return this.getName();
  }

  public abstract String getName();

  public boolean hatGleicheFarbeWie(SchachFigur s) {
    return (this.istWeiss==s.istWeiss);
  }

  public void paint(java.awt.Graphics g, java.awt.Point p) {
    if (this.istWeiss) {
      g.setColor(java.awt.Color.white);
    } else {
      g.setColor(java.awt.Color.black);
    }
    g.setFont(new java.awt.Font("SansSerif", java.awt.Font.BOLD, 14));
  //  g.fillRect(p.x-5, p.y-5, 10, 10);
//    g.drawString(this.getKuerzel(), p.x-5, p.y+5);
  }

  public abstract java.awt.Image getImage();

  public boolean kannZiehen() {
    if (this.istWeiss!=this.schachSpiel.istWeissAmZug()) {
      return false;
    }
    return true;
  }

  public abstract String getKuerzel();

  public boolean zugMoeglich(int x, int y, boolean testeObSchachEnsteht) throws UngueltigerZugException, FigurGeschlagenException {

    try {
      SchachFigur figurAufZielFeld = this.schachSpiel.getFigurAnPosition(x, y);
      if (this.hatGleicheFarbeWie(figurAufZielFeld)) {
        throw new UngueltigerZugException("you mustn't move to a field occupied by your "+figurAufZielFeld.getName());
      }
      if (testeObSchachEnsteht) {
        if (this.testeObSchachEntstehenWrde(x, y)==true) {
          throw new UngueltigerZugException("this move would result in a checkmate");
        }
      }
      throw new FigurGeschlagenException(figurAufZielFeld);
    } catch (KeineFigurAufDiesemFeldException ex) {
      if (testeObSchachEnsteht) {
        if (this.testeObSchachEntstehenWrde(x, y)==true) {
          throw new UngueltigerZugException("this move would result in a checkmate");
        }
      }
      return true;
    }
  }

  private boolean testeObSchachEntstehenWrde(int x, int y) {
    return this.schachSpiel.istKoenigBedrohtNachZug(this, x, y, this.schachSpiel.istWeissAmZug());
  }

  public void zieheNach(int x, int y) throws UngueltigerZugException, FigurGeschlagenException {
    try {
      if (this.zugMoeglich(x, y, true)) {
        this.posX=x;
        this.posY=y;
        this.wurdeBereitsBewegt=true;
      }
    } catch (FigurGeschlagenException ex) {
      this.posX=x;
      this.posY=y;
      this.wurdeBereitsBewegt=true;
      throw ex;
    }
  }
}

class Koenig extends SchachFigur {

  private static java.awt.Image weissesIcon = new javax.swing.ImageIcon(Bauer.class.getResource("koenigweiss.gif")).getImage().getScaledInstance(SchachFigur.iconSize, SchachFigur.iconSize, java.awt.Image.SCALE_SMOOTH);
  private static java.awt.Image schwarzesIcon = new javax.swing.ImageIcon(Bauer.class.getResource("koenigschwarz.gif")).getImage().getScaledInstance(SchachFigur.iconSize, SchachFigur.iconSize, java.awt.Image.SCALE_SMOOTH);

  static String name = "King";

  public Koenig(SchachSpiel spiel, boolean istWeiss, int x, int y) {
    super(spiel, istWeiss, x, y);
  }
  public String getName() {
    return Koenig.name;
  }
  public String getKuerzel() {
    return "K";
  }

  public java.awt.Image getImage() {
    if (this.istWeiss) {
      return this.weissesIcon;
    } else {
      return this.schwarzesIcon;
    }
  }

  Turm getTurmZurRochade(int x, int y) throws UngueltigerZugException {
    if (this.wurdeBereitsBewegt) {
      throw new UngueltigerZugException("Castling is only possible if the king hasn't moved before");
    }

    if ((x!=2 && x!=6)) {
      throw new UngueltigerZugException("Castling is only possible to certain positions");
    }
    if (this.schachSpiel.istKoenigBedroht(this.istWeiss) || this.schachSpiel.istKoenigBedrohtNachZug(this, posX+(x-posX)/2, y, this.istWeiss)) {
      throw new UngueltigerZugException("Castline is not possible in check situations.");
    }
    int turmX;
    int turmY;
    if (this.istWeiss) {
      turmY=0;
      if (x==2) {
        turmX=0;
      } else {
        turmX=7;
      }
    } else {
      turmY=7;
      if (x==2) {
        turmX=0;
      } else {
        turmX=7;
      }
    }
    try {
      SchachFigur turm = this.schachSpiel.getFigurAnPosition(turmX, turmY);
      if (turm.wurdeBereitsBewegt || (turm instanceof Turm == false)) {
        throw new UngueltigerZugException("Castling is only possible if the Rook's haven't moved");
      }
      if (this.schachSpiel.istWegFreiNach(this, turm.posX, turm.posY)==false) {
        throw new UngueltigerZugException("Castling is only possible if there is nothing in between");
      }
      return (Turm)turm;
    } catch (KeineFigurAufDiesemFeldException ex) {
      throw new UngueltigerZugException("Castling is only possible if the Rook's haven't moved");
    }
  }

  public boolean zugMoeglich(int x, int y, boolean testeObSchachEnsteht) throws UngueltigerZugException, FigurGeschlagenException{
    if (Math.abs(posX-x)>1 && Math.abs(posY-y)==0) {
      try {
        Turm turm = this.getTurmZurRochade(x, y);
        return super.zugMoeglich(x, y, testeObSchachEnsteht);
      } catch (UngueltigerZugException ex) {
        throw ex;
      }
    }

    if (Math.abs(posX-x)>1 || Math.abs(posY-y)>1) {
      throw new UngueltigerZugException("the king mustn't move more than one field in any direction");
    }
    return super.zugMoeglich(x, y, testeObSchachEnsteht);
  }
}

class Dame extends SchachFigur {

  static String name = "Queen";

  private static java.awt.Image weissesIcon = new javax.swing.ImageIcon(Bauer.class.getResource("dameweiss.gif")).getImage().getScaledInstance(SchachFigur.iconSize, SchachFigur.iconSize, java.awt.Image.SCALE_SMOOTH);
  private static java.awt.Image schwarzesIcon = new javax.swing.ImageIcon(Bauer.class.getResource("dameschwarz.gif")).getImage().getScaledInstance(SchachFigur.iconSize, SchachFigur.iconSize, java.awt.Image.SCALE_SMOOTH);

  public Dame(SchachSpiel spiel, boolean istWeiss, int x, int y) {
    super(spiel, istWeiss, x, y);
  }
  public String getName() {
    return Dame.name;
  }
  public String getKuerzel() {
    return "Q";
  }

  public java.awt.Image getImage() {
    if (this.istWeiss) {
      return this.weissesIcon;
    } else {
      return this.schwarzesIcon;
    }
  }

  public boolean zugMoeglich(int x, int y, boolean testeObSchachEnsteht) throws UngueltigerZugException, FigurGeschlagenException{
    int diffX=Math.abs(posX-x);
    int diffY=Math.abs(posY-y);
    if (diffX!=0 && diffY!=0 && diffX!=diffY) {
      throw new UngueltigerZugException("the queen can only goe straight line.");
    }
    if (this.schachSpiel.istWegFreiNach(this, x, y)==false) {
      throw new UngueltigerZugException("the are occupied fiels in between.");
    }
    return super.zugMoeglich(x, y, testeObSchachEnsteht);
  }
}

class Turm extends SchachFigur {

  static String name = "Rook";

  static java.awt.Image weissesIcon = new javax.swing.ImageIcon(Bauer.class.getResource("turmweiss.gif")).getImage().getScaledInstance(SchachFigur.iconSize, SchachFigur.iconSize, java.awt.Image.SCALE_SMOOTH);
  static java.awt.Image schwarzesIcon = new javax.swing.ImageIcon(Bauer.class.getResource("turmschwarz.gif")).getImage().getScaledInstance(SchachFigur.iconSize, SchachFigur.iconSize, java.awt.Image.SCALE_SMOOTH);


  public Turm(SchachSpiel spiel, boolean istWeiss, int x, int y) {
    super(spiel, istWeiss, x, y);
  }
  public String getName() {
    return Turm.name;
  }
  public String getKuerzel() {
    return "R";
  }

  public java.awt.Image getImage() {
    if (this.istWeiss) {
      return this.weissesIcon;
    } else {
      return this.schwarzesIcon;
    }
  }
  public boolean zugMoeglich(int x, int y, boolean testeObSchachEnsteht) throws UngueltigerZugException, FigurGeschlagenException{
    int diffX=Math.abs(posX-x);
    int diffY=Math.abs(posY-y);
    if (diffX!=0 && diffY!=0) {
      throw new UngueltigerZugException("the rook can only move on a horizontal or verical line.");
    }
    if (this.schachSpiel.istWegFreiNach(this, x, y)==false) {
      throw new UngueltigerZugException("the are occupied fiels in between.");
    }
    return super.zugMoeglich(x, y, testeObSchachEnsteht);
  }
}


class Laeufer extends SchachFigur {

  static String name = "Bishop";

  private static java.awt.Image weissesIcon = new javax.swing.ImageIcon(Bauer.class.getResource("laeuferweiss.gif")).getImage().getScaledInstance(SchachFigur.iconSize, SchachFigur.iconSize, java.awt.Image.SCALE_SMOOTH);
  private static java.awt.Image schwarzesIcon = new javax.swing.ImageIcon(Bauer.class.getResource("laeuferschwarz.gif")).getImage().getScaledInstance(SchachFigur.iconSize, SchachFigur.iconSize, java.awt.Image.SCALE_SMOOTH);


  public Laeufer(SchachSpiel spiel, boolean istWeiss, int x, int y) {
    super(spiel, istWeiss, x, y);
  }
  public String getName() {
    return Laeufer.name;
  }
  public String getKuerzel() {
    return "B";
  }

  public java.awt.Image getImage() {
    if (this.istWeiss) {
      return this.weissesIcon;
    } else {
      return this.schwarzesIcon;
    }
  }

  public boolean zugMoeglich(int x, int y, boolean testeObSchachEnsteht) throws UngueltigerZugException, FigurGeschlagenException{
    int diffX=Math.abs(posX-x);
    int diffY=Math.abs(posY-y);
    if (diffX==0 || diffY==0 || diffX!=diffY) {
      throw new UngueltigerZugException("the bishop can only move on a diagonal line.");
    }
    if (this.schachSpiel.istWegFreiNach(this, x, y)==false) {
      throw new UngueltigerZugException("the are occupied fiels in between.");
    }
    return super.zugMoeglich(x, y, testeObSchachEnsteht);
  }
}

class Bauer extends SchachFigur {

  static String name = "Pawn";

  boolean istAlsLetztesZweiZuegeGegangen=false;

  private static java.awt.Image weissesIcon = new javax.swing.ImageIcon(Bauer.class.getResource("bauerweiss.gif")).getImage().getScaledInstance(SchachFigur.iconSize, SchachFigur.iconSize, java.awt.Image.SCALE_SMOOTH);
  private static java.awt.Image schwarzesIcon = new javax.swing.ImageIcon(Bauer.class.getResource("bauerschwarz.gif")).getImage().getScaledInstance(SchachFigur.iconSize, SchachFigur.iconSize, java.awt.Image.SCALE_SMOOTH);
  public Bauer(SchachSpiel spiel, boolean istWeiss, int x, int y) {
    super(spiel, istWeiss, x, y);
  }
  public String getName() {
    return Bauer.name;
  }

  public java.awt.Image getImage() {
    if (this.istWeiss) {
      return this.weissesIcon;
    } else {
      return this.schwarzesIcon;
    }
  }
/*  public void paint(SchachBrett brett, java.awt.Point p) {
    if (this.istWeiss) {
     brett.getGraphics().drawImage(Bauer.weissesIcon.getImage(), p.x, p.y, null);
    } else {
     brett.getGraphics().drawImage(Bauer.schwarzesIcon.getImage(), p.x, p.y, null);
    }
  }*/
  public String getKuerzel() {
    return "P";
  }

  public void zieheNach(int x, int y) throws UngueltigerZugException, FigurGeschlagenException {
    int altY=this.posY;
    super.zieheNach(x, y);
    if (Math.abs(altY-y)==2) {
      this.istAlsLetztesZweiZuegeGegangen=true;
    } else {
     this.istAlsLetztesZweiZuegeGegangen=false;
    }
  }
  public boolean zugMoeglich(int x, int y, boolean testeObSchachEnsteht) throws UngueltigerZugException, FigurGeschlagenException{
    int diffY=(y-this.posY);
    int diffX=(x-this.posX);
    if ((this.istWeiss && diffY<=0) || (this.istWeiss==false && diffY>=0)) {
      throw new UngueltigerZugException("the pawn can only move forward");
    }
    if (Math.abs(diffX)>=2 || Math.abs(diffY)>2) {
      throw new UngueltigerZugException("the pawn cannot move so far");
    }
    if (Math.abs(diffY)==2 && (this.wurdeBereitsBewegt || Math.abs(diffX)!=0)) {
       throw new UngueltigerZugException("the pawn can only move two steps ahead on his first move...");
    }
    if (diffX==0) {
      if (this.schachSpiel.istFigurAufPosition(x, y)) {
        throw new UngueltigerZugException("the pawn cannot take a piece straight ahead");
      }
    } else {
      if (this.schachSpiel.istFigurAufPosition(x, y)==false) {
        try {
          SchachFigur figur = this.schachSpiel.getFigurAnPosition(x, this.posY);
          if (figur instanceof Bauer) {
            if (((Bauer)figur).istAlsLetztesZweiZuegeGegangen==false) {
              throw new UngueltigerZugException("cannot take en passante, the pawn didn't move two fields to get there");
            }
            if (this.schachSpiel.getLetztenZug().getFigur().equals(figur)==false) {
              throw new UngueltigerZugException("cannot take en passante, only possible instantly");
            }
          }
        } catch (KeineFigurAufDiesemFeldException ex) {
          throw new UngueltigerZugException("the pawn can only go that way when taking a piece.");
        }
      }
    }
    return super.zugMoeglich(x, y, testeObSchachEnsteht);
  }
}

class Springer extends SchachFigur {

  static String name = "Knight";

  private static java.awt.Image weissesIcon = new javax.swing.ImageIcon(Bauer.class.getResource("pferdweiss.gif")).getImage().getScaledInstance(SchachFigur.iconSize, SchachFigur.iconSize, java.awt.Image.SCALE_SMOOTH);
  private static java.awt.Image schwarzesIcon = new javax.swing.ImageIcon(Bauer.class.getResource("pferdschwarz.gif")).getImage().getScaledInstance(SchachFigur.iconSize, SchachFigur.iconSize, java.awt.Image.SCALE_SMOOTH);


  public Springer(SchachSpiel spiel, boolean istWeiss, int x, int y) {
    super(spiel, istWeiss, x, y);
  }
  public String getName() {
    return Springer.name;
  }
  public String getKuerzel() {
    return "N";
  }

    public java.awt.Image getImage() {
    if (this.istWeiss) {
      return this.weissesIcon;
    } else {
      return this.schwarzesIcon;
    }
  }

  public boolean zugMoeglich(int x, int y, boolean testeObSchachEnsteht) throws UngueltigerZugException, FigurGeschlagenException{
    int diffY=Math.abs(y-this.posY);
    int diffX=Math.abs(x-this.posX);
    if (((diffY==2 && diffX==1) || (diffY==1 && diffX==2))==false) {
      throw new UngueltigerZugException("the knight cannot jump there.");
    }
    return super.zugMoeglich(x, y, testeObSchachEnsteht);
  }
}