package freenetmessageboard.schach;

import java.awt.event.*;
import javax.swing.*;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class SchachBrett extends javax.swing.JPanel {

  private SchachSpiel spiel;
  private int zeilenHoehe;
  private int spaltenBreite;
  private boolean umgekehrteSicht=false;

  private static java.awt.Color ausgewaehlteFarbe = new java.awt.Color(188, 188, 245);
  private static java.awt.Color gueltigerZugFarbe = new java.awt.Color(187, 247, 201);
  private static java.awt.Color ungueltigerZugFarbe = new java.awt.Color(243, 119, 105);

  private boolean figurAusgewaehlt=false;
  private boolean zielAusgewaehlt=false;
  private boolean zielMoeglich=false;

  private boolean zeigeAlteStellungAn=false;
  private int indexDerAltenStellung;

  String whiteNick;
  String blackNick;

  private int zielX;
  private int zielY;
  private SchachFigur ausgewaehlteFigur;
  private int ausgewaehltesY=-1;

  public SchachBrett(SchachSpiel spiel) {
    this();
    this.spiel=spiel;
    this.whiteNick = freenetmessageboard.core.ContactList.instance().getNicknameOfPublicKey(this.spiel.getWhitePublicKey());
    this.blackNick = freenetmessageboard.core.ContactList.instance().getNicknameOfPublicKey(this.spiel.getBlackPublicKey());
  }

  void reverseView() {
    this.umgekehrteSicht=!this.umgekehrteSicht;
  }

  private java.awt.Point getSpielFeldPosition(int zeile, int spalte) {
    if (umgekehrteSicht==false) {
      return new java.awt.Point(spalte*spaltenBreite, (7-zeile)*zeilenHoehe);
    } else {
      return new java.awt.Point((7-spalte)*spaltenBreite, zeile*zeilenHoehe);
    }
  }

  private int[] getIndicesVon(java.awt.Point p) {
    if (umgekehrteSicht==false) {
      return new int[] { p.x/spaltenBreite, 7-p.y/zeilenHoehe };
    } else {
      return new int[] { 7-(p.x/spaltenBreite), (p.y/zeilenHoehe) };
    }
  }

  public void paint(java.awt.Graphics g) {
    super.paint(g);
    this.zeilenHoehe=this.getSize().height/8;
    this.spaltenBreite=this.getSize().width/8;
    if (this.zeilenHoehe>this.spaltenBreite) {
      this.zeilenHoehe=this.spaltenBreite;
    } else {
      this.spaltenBreite=this.zeilenHoehe;
    }
    SchachSpiel spiel=this.spiel;

    for (int zeile=0; zeile<8; zeile++) {
      for (int spalte=0; spalte<8; spalte++) {
       // System.err.println("painting... "+spalte+", "+zeile);
        java.awt.Point p = this.getSpielFeldPosition(zeile, spalte);
        if ((zeile+spalte)%2==0) {
          g.setColor(java.awt.Color.lightGray );
        } else {
          g.setColor(java.awt.Color.gray);
        }
        if (this.figurAusgewaehlt) {
          if (spalte==this.ausgewaehlteFigur.posX && zeile==this.ausgewaehlteFigur.posY) {
            g.setColor(SchachBrett.ausgewaehlteFarbe);
          }
        }
        if (this.zielAusgewaehlt && this.zielX==spalte && this.zielY==zeile) {
          if (this.zielMoeglich) {
            g.setColor(SchachBrett.gueltigerZugFarbe);
          } else {
            g.setColor(SchachBrett.ungueltigerZugFarbe);
          }
        }
        g.fillRect(p.x, p.y, spaltenBreite, zeilenHoehe);
        if (this.spiel!=null) {
          try {
            SchachFigur figur;
            if (this.zeigeAlteStellungAn) {
              figur = spiel.getFigurAnPosition(spalte, zeile, this.indexDerAltenStellung);
            } else {
              figur =spiel.getFigurAnPosition(spalte, zeile);
            }
            if (figur.istWeiss) {
              g.setColor(java.awt.Color.white );
            } else {
              g.setColor(java.awt.Color.black);
            }
            g.drawImage(figur.getImage(), p.x+this.spaltenBreite/2-SchachFigur.iconSize/2, p.y+this.zeilenHoehe/2-SchachFigur.iconSize/2, this);
     //       figur.paint(this.getGraphics(), new java.awt.Point(p.x+this.spaltenBreite/2, p.y+this.zeilenHoehe/2));
          } catch (KeineFigurAufDiesemFeldException ex) {

          }
        }
      }
    }
/*    if (this.zeigeAlteStellungAn) {
      SchachZug letzterZug = spiel.getLetztenZug();
      java.awt.Point startP = this.getSpielFeldPosition(letzterZug.getAltY(), letzterZug.getAltX());
      java.awt.Point endP = this.getSpielFeldPosition(letzterZug.getZielY(), letzterZug.getZielX());

      g.setColor(java.awt.Color.yellow);
      g.drawLine(startP.x+this.spaltenBreite/2, startP.y+this.zeilenHoehe/2, endP.x+this.spaltenBreite/2, endP.y+this.spaltenBreite/2);
    }*/
  }

  public SchachBrett() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }
  private void jbInit() throws Exception {
    this.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
      public void mouseDragged(MouseEvent e) {
        this_mouseDragged(e);
      }
    });
    this.addMouseListener(new java.awt.event.MouseAdapter() {
      public void mousePressed(MouseEvent e) {
        this_mousePressed(e);
      }
      public void mouseReleased(MouseEvent e) {
        this_mouseReleased(e);
      }
    });
  }

  void this_mousePressed(MouseEvent e) {



    if (this.zeigeAlteStellungAn) {
      this.zeigeAktuelleStellungAn();
      return;
    }

    if (this.spiel.binIchAmZug()==false) {
      return;
    }

    int[] gewaehltesFeld = this.getIndicesVon(e.getPoint());
    int x = gewaehltesFeld[0];
    int y = gewaehltesFeld[1];
    if (x<0 || x>7 || y<0 || y>7) {
      this.figurAusgewaehlt=false;
    }
    try {
      this.ausgewaehlteFigur = this.spiel.getFigurAnPosition(x, y);
      if (this.ausgewaehlteFigur.kannZiehen()) {
        this.setCursor(java.awt.Cursor.getPredefinedCursor(java.awt.Cursor.MOVE_CURSOR));
        this.figurAusgewaehlt=true;
        this.repaint();
      }
    }  catch (KeineFigurAufDiesemFeldException ex) {
      System.err.println("keine figur auf feld "+x+", "+y);
    }
  }

  private void zeigeBesonderesEreignisAn(BesonderesEreignisException ex) {
    if (ex.getEreignis()==BesonderesEreignisException.SCHACH) {
        this.getSchachPanel().statusLabel.setText("check!");
    }
    if (ex.getEreignis()==BesonderesEreignisException.SCHACHMATT) {
      this.getSchachPanel().statusLabel.setText("checkmate");
    }
    if (ex.getEreignis()==BesonderesEreignisException.GARDEZ) {
      this.getSchachPanel().statusLabel.setText("gardez!");
    }
  }

  SchachSpiel getSchachSpiel() {
    return this.spiel;
  }

  private void sendMove() {
    this.spiel.whiteMessage=this.getSchachPanel().whiteMessageTextField.getText();
    this.spiel.blackMessage=this.getSchachPanel().blackMessageTextField.getText();
    freenetmessageboard.core.ChessMessage msg = new freenetmessageboard.core.ChessMessage(this.spiel);
    freenetmessageboard.core.MessageGateway.instance().sendMessageOnPersonalChannel(msg);
  }

  void this_mouseReleased(MouseEvent e) {

    if (this.spiel.binIchAmZug()==false) {
      return;
    }

    int[] gewaehltesFeld = this.getIndicesVon(e.getPoint());
    int x = gewaehltesFeld[0];
    int y = gewaehltesFeld[1];
    if (x<0 || x>7 || y<0 || y>7) {
      this.figurAusgewaehlt=false;
    }
    SchachZug schachZug = new SchachZug(this.ausgewaehlteFigur, x, y);
    if (this.figurAusgewaehlt && this.zielAusgewaehlt) {
      try {
        this.spiel.fuehreZugAus(schachZug);
        if (spiel.istWeissAmZug()) {
          this.getSchachPanel().statusLabel.setText("it's "+whiteNick+"'s turn now, waiting for his next move...");
        } else {
          this.getSchachPanel().statusLabel.setText("it's "+blackNick+"'s turn, waiting for his next move...");
        }
        this.sendMove();
      }
      catch (UngueltigerZugException ex) {
        this.getSchachPanel().statusLabel.setText(ex.getMessage());
      } catch (BesonderesEreignisException ex) {
        if (ex.getEreignis()==ex.FIGURUMWANDLUNG) {
          try {
            this.waehleNeueFigur(ex.getSpielZug());
          } catch (BesonderesEreignisException ex2) {
            this.zeigeBesonderesEreignisAn(ex2);
          }
        }
        this.zeigeBesonderesEreignisAn(ex);
        this.sendMove();
      }

    }
    this.setCursor(java.awt.Cursor.getDefaultCursor());
    this.figurAusgewaehlt=false;
    this.zielAusgewaehlt=false;
    this.repaint();
  }

  void zeigeAlteStellungAn(int zugNr) {
  //  System.err.println("zeige ab jetzt die alte stellung nummer "+zugNr+" an");
    this.getSchachPanel().statusLabel.setText("viewing old gamestate, click board to continue playing...");
    this.zeigeAlteStellungAn=true;
    this.indexDerAltenStellung=zugNr;
  }

  void zeigeAktuelleStellungAn() {
  //  System.err.println("zeige ab jetzt die aktuelle stellung an");
    this.zeigeAlteStellungAn=false;
    this.zeigeAnWerDranIst();

//    this.getSchachPanel().bisherigeZuegeList.setSelectedIndex(-1);
    this.getSchachPanel().bisherigeZuegeList.setSelectedIndices(new int[0]);
  }

  void zeigeAnWerDranIst() {
    if (this.spiel.binIchAmZug()) {
      this.getSchachPanel().statusLabel.setText("it's your turn, now...");
    } else {
        if (spiel.istWeissAmZug()) {
        this.getSchachPanel().statusLabel.setText("it's "+whiteNick+"'s turn now, waiting for his next move...");
      } else {
        this.getSchachPanel().statusLabel.setText("it's "+blackNick+"'s turn, waiting for his next move...");
      }
    }
  }

  private SchachPanel getSchachPanel() {
    java.awt.Container parent = this.getParent();
    while (parent instanceof SchachPanel==false) {
      parent=parent.getParent();
    }
    return (SchachPanel)parent;
  }

  void autoPlay() {
    int zuegeGespielt=0;
    while(true) {
      SchachZug[] zuege = this.spiel.getMoeglicheZuege();
      if (zuege.length==0 || zuegeGespielt==250) break;
      zuegeGespielt++;
      int index = (int)(Math.random()*zuege.length);

      try {
        this.spiel.fuehreZugAus(zuege[index]);
      }
      catch (UngueltigerZugException ex) {
        this.getSchachPanel().statusLabel.setText(ex.getMessage());
      } catch (BesonderesEreignisException ex) {
        if (ex.getEreignis()==ex.FIGURUMWANDLUNG) {
          try {
            int a = (int)(Math.random()*4);
            this.spiel.figurenTausch(zuege[index], this.getMoeglicheFigurenZumTausch(zuege[index])[a]);
          } catch (BesonderesEreignisException ex2) {
            this.zeigeBesonderesEreignisAn(ex2);
          }
        }
      }

      this.getSchachPanel().repaint();

    }
    try {
      freenetmessageboard.core.ChessMessage msg = new freenetmessageboard.core.ChessMessage(this.getSchachSpiel());
      msg.setOriginalUri("SSK@"+freenetmessageboard.core.PersonalInfo.instance().getPublicKey()+"/chess");
      String msgString = msg.getString();
      freenetmessageboard.core.ChessMessage msgCopy = new freenetmessageboard.core.ChessMessage(msgString);
      SchachSpiel spielCopy = msgCopy.getSchachSpiel();
      javax.swing.JFrame frame = new javax.swing.JFrame("game copy");
      SchachPanel schachPanel = new SchachPanel(spielCopy);
      frame.getContentPane().add(schachPanel, java.awt.BorderLayout.CENTER);
      frame.setSize(545,450);
      frame.setVisible(true);
    } catch (Throwable t) {
      t.printStackTrace();
    }
  }

  private SchachFigur[] getMoeglicheFigurenZumTausch(SchachZug zug) {
    SchachFigur[] auswahl = new SchachFigur[4];
    auswahl[0]=new Dame(this.spiel, zug.getFigur().istWeiss, zug.getFigur().posX, zug.getFigur().posY);
    auswahl[1]=new Turm(this.spiel, zug.getFigur().istWeiss, zug.getFigur().posX, zug.getFigur().posY);
    auswahl[2]=new Laeufer(this.spiel, zug.getFigur().istWeiss, zug.getFigur().posX, zug.getFigur().posY);
    auswahl[3]=new Springer(this.spiel, zug.getFigur().istWeiss, zug.getFigur().posX, zug.getFigur().posY);
    return auswahl;
  }

  private void waehleNeueFigur(SchachZug zug) throws BesonderesEreignisException {
    SchachFigur[] auswahl=this.getMoeglicheFigurenZumTausch(zug);
    int i=javax.swing.JOptionPane.showOptionDialog(this, "choose the piece you want to get", "choose", javax.swing.JOptionPane.DEFAULT_OPTION, javax.swing.JOptionPane.QUESTION_MESSAGE, new javax.swing.ImageIcon(this.getClass().getResource("dameweiss.gif")), auswahl, auswahl[0]);
    this.spiel.figurenTausch(zug, auswahl[i]);
  }

  void this_mouseDragged(MouseEvent e) {
    if (this.spiel.binIchAmZug()==false) {

      return;
    }
    if (this.figurAusgewaehlt) {
      int[] gewaehltesFeld = this.getIndicesVon(e.getPoint());
      int x = gewaehltesFeld[0];
      int y = gewaehltesFeld[1];
      if (x<0 || x>7 || y<0 || y>7) {
        this.figurAusgewaehlt=false;
      }
      if (this.ausgewaehlteFigur.posX!=x || this.ausgewaehlteFigur.posY!=y) {
        this.zielX=x;
        this.zielY=y;
        this.zielAusgewaehlt=true;
        try {
          this.zielMoeglich=this.ausgewaehlteFigur.zugMoeglich(x, y, true);
        } catch (UngueltigerZugException ex1) {
          this.zielMoeglich=false;
        } catch (FigurGeschlagenException ex2) {
          this.zielMoeglich=true;
        }
      } else {
        this.zielAusgewaehlt=false;
      }
      this.repaint();
    }
  }
}