package freenetmessageboard.gui;

import java.awt.*;
import javax.swing.*;
import javax.swing.border.Border;
import java.awt.event.*;
/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */



public class UserMessagePanel extends JPanel {
  BorderLayout personalInfoPanelBorderLayout = new BorderLayout();
  JPanel buttonPanel = new JPanel();
  JPanel mainPanel = new JPanel();
  BorderLayout buttonPanelBorderLayout = new BorderLayout();
  BorderLayout mainPanelBorderLayout = new BorderLayout();
  JPanel shortInfosPanel = new JPanel();
  BorderLayout shortInfosPanelBorderLayout = new BorderLayout();
  JPanel shortInfosCaptionPanel = new JPanel();
  GridLayout shortInfosCaptionPanelGridLayout = new GridLayout();
  JPanel shortInfosValuePanel = new JPanel();
  GridLayout shortInfosValuePanelGridLayout = new GridLayout();
  JLabel publicKeyCaptionLabel = new JLabel();
  JLabel nickCaptionLabel = new JLabel();
  JLabel nameCaptionLabel = new JLabel();
  JLabel freesiteUriCaptionLabel = new JLabel();
  JLabel interestsCaptionLabel = new JLabel();
  public JTextField publicKeyTextField = new JTextField();
  public JTextField nickTextField = new JTextField();
  public JTextField nameTextField = new JTextField();
  public JTextField freesiteUriTextField = new JTextField();
  public JTextField interestsTextField = new JTextField();
  JPanel longInfosPanel = new JPanel();
  BorderLayout longInfosPanelBorderLayout = new BorderLayout();
  JPanel longInfosCaptionPanel = new JPanel();
  JPanel longInfosValuePanel = new JPanel();
  GridLayout longInfosValuePanelGridLayout = new GridLayout();
  GridLayout longInfosCaptionPanelGridLayout = new GridLayout();
  public JTextPane descriptionTextArea = new JTextPane();
  public JTextPane messageTextArea = new JTextPane();
  JLabel descriptionCaptionLabel = new JLabel();
  JLabel messageCaptionLabel = new JLabel();

  JScrollPane descriptionScrollPane = new JScrollPane();
  JScrollPane messageScrollPane = new JScrollPane();
  JLabel sourceCaptionLabel = new JLabel();
  JButton sendAnnouncementButton = new JButton();
  JPanel sourcePanel = new JPanel();
  JTextField sourceTextField = new JTextField();
  BorderLayout sourcePanelBorderLayout = new BorderLayout();
  JButton getOriginalButton = new JButton();

  freenetmessageboard.core.UserMessage userMsg;


  public UserMessagePanel(freenetmessageboard.core.UserMessage msg) {
    this();
    this.publicKeyTextField.setText(msg.getPublicKey());
    this.nickTextField.setText(msg.getNickName());
    this.nameTextField.setText(msg.getName());
    this.descriptionTextArea.setText(msg.getDescription());
    this.interestsTextField.setText(msg.getInterests());
    this.freesiteUriTextField.setText(msg.getFreesiteUri());
    this.messageTextArea.setText(msg.getMessage());
    this.sourceTextField.setText(freenetmessageboard.core.ContactList.instance().getNicknameOfPublicKey(msg.getSourceKey())+" ("+msg.getSourceUri()+")");
    this.userMsg=msg;
    if (msg.getOriginalPublicKey().equals(msg.getSourceKey())) {
      this.getOriginalButton.setEnabled(false);
    } else {
      this.getOriginalButton.setEnabled(true);
    }
    if (msg.getOriginalPublicKey().equals(freenetmessageboard.core.PersonalInfo.instance().getPublicKey())) {
      this.makeEditable();
    }
  }

  void makeEditable() {
    this.nickTextField.setEditable(true);
    this.nameTextField.setEditable(true);
    this.descriptionTextArea.setEditable(true);
    this.interestsTextField.setEditable(true);
    this.freesiteUriTextField.setEditable(true);
    this.messageTextArea.setEditable(true);
    this.sendAnnouncementButton.setEnabled(true);

  }

  public UserMessagePanel() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    this.setLayout(personalInfoPanelBorderLayout);
    buttonPanel.setLayout(buttonPanelBorderLayout);
    mainPanel.setLayout(mainPanelBorderLayout);
    shortInfosPanel.setLayout(shortInfosPanelBorderLayout);
    shortInfosCaptionPanel.setLayout(shortInfosCaptionPanelGridLayout);
    shortInfosValuePanel.setLayout(shortInfosValuePanelGridLayout);
    publicKeyCaptionLabel.setHorizontalAlignment(SwingConstants.CENTER);
    publicKeyCaptionLabel.setText("public key:");
    shortInfosCaptionPanelGridLayout.setRows(6);
    shortInfosCaptionPanelGridLayout.setColumns(1);
    nickCaptionLabel.setHorizontalAlignment(SwingConstants.CENTER);
    nickCaptionLabel.setText("nick:");
    nameCaptionLabel.setToolTipText("");
    nameCaptionLabel.setHorizontalAlignment(SwingConstants.CENTER);
    nameCaptionLabel.setText("name:");
    freesiteUriCaptionLabel.setHorizontalAlignment(SwingConstants.CENTER);
    freesiteUriCaptionLabel.setText("freesite uri:");
    interestsCaptionLabel.setHorizontalAlignment(SwingConstants.CENTER);
    interestsCaptionLabel.setText("interests:");
    shortInfosValuePanelGridLayout.setRows(6);
    shortInfosValuePanelGridLayout.setColumns(1);
    longInfosPanel.setLayout(longInfosPanelBorderLayout);
    longInfosValuePanel.setLayout(longInfosValuePanelGridLayout);
    longInfosCaptionPanel.setLayout(longInfosCaptionPanelGridLayout);
    longInfosCaptionPanelGridLayout.setRows(2);
    longInfosCaptionPanelGridLayout.setColumns(1);
    longInfosValuePanelGridLayout.setRows(2);
    longInfosValuePanelGridLayout.setColumns(1);
    descriptionTextArea.setBorder(BorderFactory.createLineBorder(Color.black));
    descriptionTextArea.setEditable(false);
    messageTextArea.setBorder(BorderFactory.createLineBorder(Color.black));
    messageTextArea.setEditable(false);
    descriptionCaptionLabel.setHorizontalAlignment(SwingConstants.CENTER);
    descriptionCaptionLabel.setText("description:");
    messageCaptionLabel.setHorizontalAlignment(SwingConstants.CENTER);
    messageCaptionLabel.setText("message:");
    shortInfosCaptionPanel.setMinimumSize(new Dimension(80, 120));
    shortInfosCaptionPanel.setPreferredSize(new Dimension(80, 120));
    longInfosCaptionPanel.setMinimumSize(new Dimension(80, 120));
    longInfosCaptionPanel.setPreferredSize(new Dimension(80, 120));
    interestsTextField.setEditable(false);
    freesiteUriTextField.setEditable(false);
    nameTextField.setEditable(false);
    nickTextField.setEditable(false);
    publicKeyTextField.setEditable(false);
    sourceCaptionLabel.setHorizontalAlignment(SwingConstants.CENTER);
    sourceCaptionLabel.setText("source:");
    longInfosPanel.setMinimumSize(new Dimension(103, 40));
    longInfosPanel.setPreferredSize(new Dimension(85, 80));
    sendAnnouncementButton.setEnabled(false);
    sendAnnouncementButton.setFont(new java.awt.Font("Dialog", 0, 9));
    sendAnnouncementButton.setText("send changes on on your personal channel");
    sendAnnouncementButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        sendAnnouncementButton_actionPerformed(e);
      }
    });
    this.setFont(new java.awt.Font("Dialog", 0, 9));
    sourceTextField.setEditable(false);
    sourcePanel.setLayout(sourcePanelBorderLayout);
    getOriginalButton.setEnabled(false);
    getOriginalButton.setFont(new java.awt.Font("Dialog", 0, 9));
    getOriginalButton.setForeground(Color.red);
    getOriginalButton.setText("verify");
    getOriginalButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        getOriginalButton_actionPerformed(e);
      }
    });
    this.add(buttonPanel, BorderLayout.SOUTH);
    buttonPanel.add(sendAnnouncementButton, BorderLayout.CENTER);
    this.add(mainPanel, BorderLayout.CENTER);
    mainPanel.add(shortInfosPanel,  BorderLayout.NORTH);
    shortInfosPanel.add(shortInfosCaptionPanel, BorderLayout.WEST);
    shortInfosPanel.add(shortInfosValuePanel, BorderLayout.CENTER);
    shortInfosCaptionPanel.add(publicKeyCaptionLabel, null);
    shortInfosCaptionPanel.add(nickCaptionLabel, null);
    shortInfosCaptionPanel.add(nameCaptionLabel, null);
    shortInfosCaptionPanel.add(freesiteUriCaptionLabel, null);
    shortInfosCaptionPanel.add(interestsCaptionLabel, null);
    shortInfosCaptionPanel.add(sourceCaptionLabel, null);
    shortInfosValuePanel.add(publicKeyTextField, null);
    shortInfosValuePanel.add(nickTextField, null);
    shortInfosValuePanel.add(nameTextField, null);
    shortInfosValuePanel.add(freesiteUriTextField, null);
    shortInfosValuePanel.add(interestsTextField, null);
    mainPanel.add(longInfosPanel, BorderLayout.CENTER);
    longInfosPanel.add(longInfosCaptionPanel,  BorderLayout.WEST);
    longInfosPanel.add(longInfosValuePanel, BorderLayout.CENTER);
    longInfosValuePanel.add(descriptionScrollPane, null);
    descriptionScrollPane.getViewport().add(descriptionTextArea, null);
    longInfosCaptionPanel.add(descriptionCaptionLabel, null);
    longInfosCaptionPanel.add(messageCaptionLabel, null);
    longInfosValuePanel.add(messageScrollPane, null);
    messageScrollPane.getViewport().add(messageTextArea, null);
    shortInfosValuePanel.add(sourcePanel, null);
    sourcePanel.add(sourceTextField, BorderLayout.CENTER);
    sourcePanel.add(getOriginalButton,  BorderLayout.EAST);
  }

  void sendAnnouncementButton_actionPerformed(ActionEvent e) {
    freenetmessageboard.core.UserMessage userMessage = new freenetmessageboard.core.UserMessage(this.publicKeyTextField.getText(), this.nickTextField.getText(), this.nameTextField.getText(), this.interestsTextField.getText(), this.descriptionTextArea.getText(), this.freesiteUriTextField.getText(), "noicon", this.messageTextArea.getText());
    freenetmessageboard.core.MessageGateway.instance().sendMessageOnPersonalChannel(userMessage);
    freenetmessageboard.core.PersonalInfo.instance().updateInfoFromUserMessage(userMessage);
    try {
      freenetmessageboard.core.PersonalInfo.instance().saveToDisk();
    } catch (java.io.IOException ex) {
      freenetmessageboard.core.CoreLogger.log("failed to save updated personal info to disk", freenetmessageboard.core.CoreLogger.LOG_ERROR);
    }
  }

  void getOriginalButton_actionPerformed(ActionEvent e) {
    BetaGUI.instance().verifyMessage(this.userMsg);
  }


}