package freenetmessageboard.gui;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class UserCommentMessagePanel extends JPanel {
  BorderLayout mainBorderLayout = new BorderLayout();
  JPanel buttonPanel = new JPanel();
  JPanel commentPanel = new JPanel();
  BorderLayout commentPanelBorderLayout = new BorderLayout();
  JPanel commentCaptionsPanel = new JPanel();
  JPanel commentValuesPanel = new JPanel();
  GridLayout commentCaptionsPanelGridLayout = new GridLayout();
  GridLayout commentValuesPanelGridLayout = new GridLayout();
  JLabel publicKeyCaptionLabel = new JLabel();
  JLabel ratingCaptionLabel = new JLabel();
  JLabel commentCaption = new JLabel();
  JTextField publicKeyTextField = new JTextField();
  JPanel ratingPanel = new JPanel();
  GridLayout ratingPanelGridLayout = new GridLayout();
  JLabel reasonCaptionLabel = new JLabel();
  JTextField reasonTextField = new JTextField();
  JButton sendCommentButton = new JButton();
  BorderLayout buttonPanelBorderLayout = new BorderLayout();

  private String commentedPublicKey;
  JLabel dateCaptionLabel = new JLabel();
  JLabel sourceCaptionLabel = new JLabel();
  JComboBox ratingComboBox = new JComboBox();
  JLabel ratingLabel = new JLabel();
  JScrollPane commentScrollPane = new JScrollPane();
  JTextPane commentTextPane = new JTextPane();
  JPanel sourcePanel = new JPanel();
  JTextField sourceTextfield = new JTextField();
  JTextField dateTextField = new JTextField();
  BorderLayout sourcePanelBorderLayout = new BorderLayout();
  JButton getOriginalButton = new JButton();

  private freenetmessageboard.core.UserCommentMessage userCommentMessage;

  public UserCommentMessagePanel(freenetmessageboard.core.UserCommentMessage msg) {
    this();
    this.userCommentMessage=msg;
    if (this.userCommentMessage!=null) {
      if (this.userCommentMessage.getOriginalPublicKey().equals(this.userCommentMessage.getSourceKey())) {
        this.getOriginalButton.setEnabled(false);
      } else {
        this.getOriginalButton.setEnabled(true);
      }
    }
    this.publicKeyTextField.setText(msg.getOriginalPublicKey());
    this.commentedPublicKey=msg.getUserPublicKey();
    this.ratingLabel.setText(msg.getRating());
    this.ratingLabel.setBackground(ColorsAndIcons.getColorOfRating(msg.getRating()));
    this.reasonTextField.setText(msg.getReason());
    this.commentTextPane.setText(msg.getComment());
    this.dateTextField.setText(msg.getDate());
    this.sourceTextfield.setText(msg.getSourceUri());

  }

  public UserCommentMessagePanel(freenetmessageboard.core.UserCommentMessage msg, boolean editable) {
    this(msg);
    this.commentedPublicKey=msg.getUserPublicKey();
    if (editable) {
      this.makePanelEditable();
    }
    this.ratingComboBox.setSelectedItem(msg.getRating());
  }

  private void makePanelEditable() {
    this.reasonTextField.setEditable(true);
    this.commentTextPane.setEditable(true);
    this.ratingComboBox.setEnabled(true);
    this.sendCommentButton.setEnabled(true);
    this.publicKeyTextField.setText(freenetmessageboard.core.PersonalInfo.instance().getPublicKey());
    this.ratingComboBox.addItem("GOOD");
    this.ratingComboBox.addItem("NEUTRAL");
    this.ratingComboBox.addItem("EVIL");
    this.ratingComboBox.validate();
  }

  public UserCommentMessagePanel(String commentedPublicKey, boolean editable) {
    this();
    this.commentedPublicKey=commentedPublicKey;
    if (editable) {
      this.makePanelEditable();
    }
  }

  public UserCommentMessagePanel() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }
  private void jbInit() throws Exception {
    this.setLayout(mainBorderLayout);
    commentPanel.setLayout(commentPanelBorderLayout);
    commentCaptionsPanel.setLayout(commentCaptionsPanelGridLayout);
    commentValuesPanel.setLayout(commentValuesPanelGridLayout);
    commentCaptionsPanelGridLayout.setRows(6);
    commentCaptionsPanelGridLayout.setColumns(1);
    commentValuesPanelGridLayout.setRows(6);
    commentValuesPanelGridLayout.setColumns(1);
    publicKeyCaptionLabel.setMaximumSize(new Dimension(100, 17));
    publicKeyCaptionLabel.setPreferredSize(new Dimension(100, 17));
    publicKeyCaptionLabel.setHorizontalAlignment(SwingConstants.CENTER);
    publicKeyCaptionLabel.setText("public key:");
    ratingCaptionLabel.setMaximumSize(new Dimension(100, 17));
    ratingCaptionLabel.setMinimumSize(new Dimension(60, 17));
    ratingCaptionLabel.setPreferredSize(new Dimension(100, 17));
    ratingCaptionLabel.setHorizontalAlignment(SwingConstants.CENTER);
    ratingCaptionLabel.setText("rating:");
    commentCaptionsPanel.setPreferredSize(new Dimension(100, 38));
    commentPanel.setMinimumSize(new Dimension(337, 90));
    commentPanel.setPreferredSize(new Dimension(60, 120));
    commentCaption.setMaximumSize(new Dimension(100, 17));
    commentCaption.setPreferredSize(new Dimension(100, 17));
    commentCaption.setHorizontalAlignment(SwingConstants.CENTER);
    commentCaption.setText("your comment:");
    ratingPanel.setLayout(ratingPanelGridLayout);
    ratingPanelGridLayout.setColumns(2);
    publicKeyTextField.setMinimumSize(new Dimension(25, 20));
    publicKeyTextField.setPreferredSize(new Dimension(25, 20));
    publicKeyTextField.setEditable(false);
    reasonCaptionLabel.setHorizontalAlignment(SwingConstants.CENTER);
    reasonCaptionLabel.setText("reason:");
    reasonTextField.setMinimumSize(new Dimension(25, 20));
    reasonTextField.setPreferredSize(new Dimension(25, 20));
    reasonTextField.setEditable(false);
    sendCommentButton.setEnabled(false);
    sendCommentButton.setFont(new java.awt.Font("Dialog", 0, 10));
    sendCommentButton.setMinimumSize(new Dimension(225, 15));
    sendCommentButton.setPreferredSize(new Dimension(225, 15));
    sendCommentButton.setText("send comment on your personal channel");
    sendCommentButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        sendCommentButton_actionPerformed(e);
      }
    });
    buttonPanel.setLayout(buttonPanelBorderLayout);
    buttonPanel.setPreferredSize(new Dimension(225, 15));
    dateCaptionLabel.setHorizontalAlignment(SwingConstants.CENTER);
    dateCaptionLabel.setText("date:");
    sourceCaptionLabel.setHorizontalAlignment(SwingConstants.CENTER);
    sourceCaptionLabel.setText("source:");
    ratingComboBox.setEnabled(false);
    ratingComboBox.addItemListener(new java.awt.event.ItemListener() {
      public void itemStateChanged(ItemEvent e) {
        ratingComboBox_itemStateChanged(e);
      }
    });
    ratingLabel.setBackground(Color.red);
    ratingLabel.setForeground(Color.white);
    ratingLabel.setMinimumSize(new Dimension(25, 20));
    ratingLabel.setOpaque(true);
    ratingLabel.setPreferredSize(new Dimension(25, 20));
    ratingLabel.setHorizontalAlignment(SwingConstants.CENTER);
    sourceTextfield.setEditable(false);
    dateTextField.setEditable(false);
    sourcePanel.setLayout(sourcePanelBorderLayout);
    getOriginalButton.setEnabled(false);
    getOriginalButton.setFont(new java.awt.Font("Dialog", 0, 9));
    getOriginalButton.setForeground(Color.red);
    getOriginalButton.setText("verify");
    getOriginalButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        getOriginalButton_actionPerformed(e);
      }
    });
    this.add(buttonPanel,  BorderLayout.SOUTH);
    buttonPanel.add(sendCommentButton, BorderLayout.CENTER);
    this.add(commentPanel, BorderLayout.NORTH);
    commentPanel.add(commentCaptionsPanel, BorderLayout.WEST);
    commentPanel.add(commentValuesPanel, BorderLayout.CENTER);
    commentValuesPanel.add(publicKeyTextField, null);
    commentValuesPanel.add(dateTextField, null);
    commentValuesPanel.add(sourcePanel, null);
    sourcePanel.add(sourceTextfield, BorderLayout.CENTER);
    commentValuesPanel.add(ratingPanel, null);
    commentCaptionsPanel.add(publicKeyCaptionLabel, null);
    commentCaptionsPanel.add(dateCaptionLabel, null);
    commentCaptionsPanel.add(sourceCaptionLabel, null);
    commentCaptionsPanel.add(ratingCaptionLabel, null);
    commentCaptionsPanel.add(reasonCaptionLabel, null);
    this.add(commentScrollPane,  BorderLayout.CENTER);
    commentCaptionsPanel.add(commentCaption, null);
    commentValuesPanel.add(reasonTextField, null);
    ratingPanel.add(ratingLabel, null);
    ratingPanel.add(ratingComboBox, null);
    commentScrollPane.getViewport().add(commentTextPane, null);
    sourcePanel.add(getOriginalButton, BorderLayout.EAST);
  }

  void ratingComboBox_itemStateChanged(ItemEvent e) {
    if (e.getStateChange()==ItemEvent.SELECTED) {
      String ratingString = (String)this.ratingComboBox.getSelectedItem();
      this.ratingLabel.setText(ratingString);
      this.ratingLabel.setBackground(ColorsAndIcons.getColorOfRating(ratingString));
    }
  }

  void sendCommentButton_actionPerformed(ActionEvent e) {
    freenetmessageboard.core.UserCommentMessage newUserComment = new freenetmessageboard.core.UserCommentMessage(this.commentedPublicKey, this.ratingLabel.getText(), this.reasonTextField.getText(), this.commentTextPane.getText(), "no message");
    try {
      freenetmessageboard.core.UserMessage userMessage = freenetmessageboard.core.ContactList.instance().getLatestUserMessageFromPublicKey(this.commentedPublicKey);
      freenetmessageboard.core.MessageGateway.instance().sendMessageOnPersonalChannel(userMessage);
    } catch (freenetmessageboard.core.MessageNotReceivedException ex) {
      freenetmessageboard.core.CoreLogger.log("couldn't find the user message you commented in the message pool!", freenetmessageboard.core.CoreLogger.LOG_ERROR);
    }
    freenetmessageboard.core.MessageGateway.instance().sendMessageOnPersonalChannel(newUserComment);
    Container container = this.getParent();
    while(container!=null) {
      if (container instanceof ContactInformationPanel) {
        ((ContactInformationPanel)container).updateInformation();
      }
      container=container.getParent();
    }
  }

  void getOriginalButton_actionPerformed(ActionEvent e) {
    MessageVerificationPanel panel = new MessageVerificationPanel(this.userCommentMessage);
    String nick1 =  freenetmessageboard.core.ContactList.instance().getNicknameOfPublicKey(this.userCommentMessage.getOriginalPublicKey());
    String nick2 = freenetmessageboard.core.ContactList.instance().getNicknameOfPublicKey(this.userCommentMessage.getUserPublicKey());
    BetaGUI.instance().verifyMessage(this.userCommentMessage);

  }
}