package freenetmessageboard.gui;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;


/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class SimpleBoardContentPanel extends JPanel {
  JScrollPane tableScrollPane = new JScrollPane();
  BorderLayout mainBorderLayout = new BorderLayout();
  JButton newMessageButton = new JButton();
  JTable postsTable = new JTable();

  boolean isMouseDown=false;
  int lastSelectedMsg=-1;

  public SimpleBoardContentPanel(String noReason) {
    this();
    this.postsTable.setModel(freenetmessageboard.core.BoardContent.instance());
    this.postsTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
  }

  public SimpleBoardContentPanel() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    this.setLayout(mainBorderLayout);
    newMessageButton.setText("create new message");
    newMessageButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        newMessageButton_actionPerformed(e);
      }
    });
    postsTable.addMouseListener(new java.awt.event.MouseAdapter() {
      public void mouseReleased(MouseEvent e) {
        postsTable_mouseReleased(e);
      }
      public void mousePressed(MouseEvent e) {
        postsTable_mousePressed(e);
      }
    });
    this.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
      public void mouseMoved(MouseEvent e) {
        this_mouseMoved(e);
      }
      public void mouseDragged(MouseEvent e) {
        this_mouseDragged(e);
      }
    });
    this.add(tableScrollPane,  BorderLayout.CENTER);
    tableScrollPane.getViewport().add(postsTable, null);
    this.add(newMessageButton, BorderLayout.SOUTH);
  }

  void newMessageButton_actionPerformed(ActionEvent e) {
    PostMessagePanel panel = new PostMessagePanel();
    panel.setEditable(true);
    BetaGUI.instance().newFrame("create new message", panel);
  }

  void postsTable_mouseReleased(MouseEvent e) {
    this.isMouseDown=false;
    this.showSelectedMessage();
  }

  void showSelectedMessage() {
    int row = this.postsTable.getSelectedRow();
    if (row!=this.lastSelectedMsg) {
      this.lastSelectedMsg=row;
      if (row<0 || row>=this.postsTable.getModel().getRowCount()) return;
      BetaGUI.instance().showPostMessage(freenetmessageboard.core.BoardContent.instance().getMessageAtRow(row));
    }
  }

  void postsTable_mousePressed(MouseEvent e) {
    this.isMouseDown=true;
    this.showSelectedMessage();
  }


  void this_mouseMoved(MouseEvent e) {
     this.showSelectedMessage();
  }

  void this_mouseDragged(MouseEvent e) {
    this.showSelectedMessage();
  }
}