package freenetmessageboard.gui;

import javax.swing.JPanel;
import java.awt.*;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class RatingPanel extends JPanel {

  private int[] values;
  private java.awt.Color[] colors;

  private static int[] defaultValues = { 1, 2, 3};
  private static Color[] defaultColors = { Color.red, Color.yellow, Color.green };

  public RatingPanel() {
    this(RatingPanel.defaultValues, RatingPanel.defaultColors);
  }

  public void update(int[] values) {
    this.values=values;
  }

  public RatingPanel(int[] values, java.awt.Color[] colors) {
    this.values=values;
    this.colors=colors;
  }

  public void paint(Graphics g) {
    super.paint(g);
    Dimension size = this.getSize();
    int valueSum = 0;
    for (int i=0; i<values.length; i++) {
      valueSum+=values[i];
    }
    int currentLine=0;
    if (valueSum==0) return;
    for (int i=0; i<values.length; i++) {
      int height = (int)(((float)values[i]/valueSum)*size.height+0.5f);
      g.setColor(this.colors[i]);
      g.fillRect(0, currentLine, size.width, height);
      currentLine+=height;
    }
  }
}