package freenetmessageboard.gui;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

import freenetmessageboard.core.CoreLogger;
/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class PostMessagePanel extends JPanel {
  BorderLayout mainBorderLayout = new BorderLayout();
  JPanel topPanel = new JPanel();
  JPanel mainPanel = new JPanel();
  JPanel bottomPanel = new JPanel();
  BorderLayout topPanelBorderLayout = new BorderLayout();
  JPanel messageHeaderCaptionsPanel = new JPanel();
  JPanel messageHeaderValuesPanel = new JPanel();
  GridLayout messageHeaderValuesPanelGridLayout = new GridLayout();
  GridLayout messageHeaderCaptionsPanelGridLayout = new GridLayout();
  JLabel dateCaptionLabel = new JLabel();
  JLabel newsgroupCaptionLabel = new JLabel();
  JLabel replyToCaptionLabel = new JLabel();
  JLabel subjectCaptionLabel = new JLabel();
  JTextField dateTextField = new JTextField();
  JTextField fromTextField = new JTextField();
  JTextField newsgroupTextField = new JTextField();
  JTextField replyToTextField = new JTextField();
  JScrollPane messageTextScrollPane1 = new JScrollPane();
  BorderLayout mainPanelBorderLayout1 = new BorderLayout();
  JTextPane messageTextTextPane = new JTextPane();
  JLabel fromCaptionLabel = new JLabel();
  JTextField subjectTextField = new JTextField();
  JButton sendButton = new JButton();
  BorderLayout bottomPanelBorderLayout = new BorderLayout();

  private boolean isEditable=false;
  JLabel sourceCaptionLabel = new JLabel();

  freenetmessageboard.core.PostMessage replyToMessage;
  freenetmessageboard.core.PostMessage myPostMessage;

  String replyToUniqueId=new String();
  String myUniqueId=new String();
  JPanel sourcePanel = new JPanel();
  JTextField sourceTextField = new JTextField();
  BorderLayout sourcePanelBorderLayout = new BorderLayout();
  JButton getOriginalButton = new JButton();

  public PostMessagePanel(freenetmessageboard.core.PostMessage postMessage, boolean isReplyTo) {
    this();
    if (isReplyTo==false) {
      this.myPostMessage=postMessage;
      this.replyToMessage=null;
      this.updateInformationFrom(postMessage);
    } else {
      this.replyToMessage=postMessage;
      this.replyToUniqueId=postMessage.getUniqueId();
      this.myPostMessage=null;
      this.setEditable(true);
      String replyNick=freenetmessageboard.core.ContactList.instance().getNicknameOfPublicKey(postMessage.getOriginalPublicKey());
      this.replyToTextField.setText("'"+postMessage.getSubject()+"' from "+replyNick+" ("+postMessage.getOriginalPublicKey()+")");
      this.newsgroupTextField.setText(postMessage.getKeywords());
    }
  }

  void updateInformationFrom(freenetmessageboard.core.PostMessage postMessage) {
    this.myPostMessage=postMessage;
    this.replyToMessage=null;
    this.dateTextField.setText(postMessage.getDate());
    this.subjectTextField.setText(postMessage.getSubject());
    this.messageTextTextPane.setText(postMessage.getMessage());
    this.newsgroupTextField.setText(postMessage.getKeywords());
    this.fromTextField.setText(freenetmessageboard.core.ContactList.instance().getNicknameOfPublicKey(postMessage.getOriginalPublicKey())+" ("+postMessage.getOriginalPublicKey()+")");
    this.sourceTextField.setText(freenetmessageboard.core.ContactList.instance().getNicknameOfPublicKey(postMessage.getSourceKey())+" ("+postMessage.getSourceKey()+")");
    if (postMessage.getOriginalPublicKey().equals(postMessage.getSourceKey())) {
      this.getOriginalButton.setEnabled(false);
    } else {
      this.getOriginalButton.setEnabled(true);
    }
    this.myUniqueId=postMessage.getUniqueId();
    if (postMessage.getReplyToUniqueId().length()>0) {
      this.replyToUniqueId=postMessage.getReplyToUniqueId();
      try {
        freenetmessageboard.core.PostMessage replyingPost = freenetmessageboard.core.MessagePool.instance().getPostMessage(postMessage.getReplyToUniqueId());
        String replySubject=replyingPost.getSubject();
        String replyNickname=freenetmessageboard.core.ContactList.instance().getNicknameOfPublicKey(replyingPost.getOriginalPublicKey());
        this.replyToTextField.setText("'"+replySubject+"' from "+replyNickname+" ("+replyingPost.getOriginalPublicKey()+")");
      } catch (freenetmessageboard.core.MessageNotReceivedException ex) {
        this.replyToTextField.setText("(a message that has not yet been received)");
      }
    } else {
       this.replyToUniqueId=new String();
       this.replyToTextField.setText("");
    }
  }

  public PostMessagePanel() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  void setEditable(boolean editable) {
    this.isEditable=editable;

    this.dateTextField.setText(freenetmessageboard.core.Message.messageDateFormat.format(new java.util.Date()));
    String yourPublicKey = freenetmessageboard.core.PersonalInfo.instance().getPublicKey();
    this.fromTextField.setText(freenetmessageboard.core.PersonalInfo.instance().getNickname()+" ("+yourPublicKey+")");
    this.subjectTextField.setEditable(editable);
    this.newsgroupTextField.setEditable(editable);
    this.messageTextTextPane.setEditable(editable);
    if (editable) {
      this.sendButton.setText("send this message on your personal channel");
    } else {
      this.sendButton.setText("reply to this message");
    }
  }


  private void jbInit() throws Exception {
    this.setLayout(mainBorderLayout);
    topPanel.setLayout(topPanelBorderLayout);
    messageHeaderValuesPanel.setLayout(messageHeaderValuesPanelGridLayout);
    messageHeaderCaptionsPanel.setLayout(messageHeaderCaptionsPanelGridLayout);
    messageHeaderCaptionsPanelGridLayout.setRows(6);
    messageHeaderCaptionsPanelGridLayout.setColumns(1);
    messageHeaderValuesPanelGridLayout.setRows(6);
    messageHeaderValuesPanelGridLayout.setColumns(1);
    dateCaptionLabel.setHorizontalAlignment(SwingConstants.RIGHT);
    dateCaptionLabel.setText("date:");
    newsgroupCaptionLabel.setHorizontalAlignment(SwingConstants.RIGHT);
    newsgroupCaptionLabel.setText("newsgroup:");
    replyToCaptionLabel.setHorizontalAlignment(SwingConstants.RIGHT);
    replyToCaptionLabel.setText("reply to:");
    subjectCaptionLabel.setHorizontalAlignment(SwingConstants.RIGHT);
    subjectCaptionLabel.setText("subject:");
    mainPanel.setLayout(mainPanelBorderLayout1);
    fromCaptionLabel.setHorizontalAlignment(SwingConstants.RIGHT);
    fromCaptionLabel.setText("from:");
    sendButton.setText("reply to this message");
    sendButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        sendButton_actionPerformed(e);
      }
    });
    bottomPanel.setLayout(bottomPanelBorderLayout);
    messageTextTextPane.setEditable(false);
    subjectTextField.setEditable(false);
    replyToTextField.setEditable(false);
    newsgroupTextField.setEditable(false);
    dateTextField.setEditable(false);
    fromTextField.setEditable(false);
    sourceCaptionLabel.setHorizontalAlignment(SwingConstants.RIGHT);
    sourceCaptionLabel.setText("source:");
    sourceTextField.setEditable(false);
    sourcePanel.setLayout(sourcePanelBorderLayout);
    getOriginalButton.setFont(new java.awt.Font("Dialog", 0, 9));
    getOriginalButton.setForeground(Color.red);
    getOriginalButton.setToolTipText("");
    getOriginalButton.setText("verify");
    getOriginalButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        getOriginalButton_actionPerformed(e);
      }
    });
    this.add(topPanel, BorderLayout.NORTH);
    this.add(mainPanel, BorderLayout.CENTER);
    this.add(bottomPanel,  BorderLayout.SOUTH);
    topPanel.add(messageHeaderCaptionsPanel, BorderLayout.WEST);
    topPanel.add(messageHeaderValuesPanel, BorderLayout.CENTER);
    messageHeaderCaptionsPanel.add(fromCaptionLabel, null);
    messageHeaderCaptionsPanel.add(sourceCaptionLabel, null);
    messageHeaderCaptionsPanel.add(dateCaptionLabel, null);
    messageHeaderCaptionsPanel.add(newsgroupCaptionLabel, null);
    messageHeaderCaptionsPanel.add(replyToCaptionLabel, null);
    messageHeaderCaptionsPanel.add(subjectCaptionLabel, null);
    messageHeaderValuesPanel.add(fromTextField, null);
    messageHeaderValuesPanel.add(sourcePanel, null);
    sourcePanel.add(sourceTextField, BorderLayout.CENTER);
    messageHeaderValuesPanel.add(dateTextField, null);
    messageHeaderValuesPanel.add(newsgroupTextField, null);
    messageHeaderValuesPanel.add(replyToTextField, null);
    messageHeaderValuesPanel.add(subjectTextField, null);
    mainPanel.add(messageTextScrollPane1,  BorderLayout.CENTER);
    messageTextScrollPane1.getViewport().add(messageTextTextPane, null);
    bottomPanel.add(sendButton, BorderLayout.CENTER);
    sourcePanel.add(getOriginalButton, BorderLayout.EAST);
  }


  void sendButton_actionPerformed(ActionEvent e) {
    if (this.isEditable) {
      freenetmessageboard.core.PostMessage postMessage = new freenetmessageboard.core.PostMessage(this.subjectTextField.getText(), this.replyToUniqueId, this.newsgroupTextField.getText(), this.messageTextTextPane.getText());
      if (this.replyToMessage!=null) {
        CoreLogger.log("looking for the prev messages of the reply...", CoreLogger.LOG_NORMAL);
        java.util.List prevMessages = new java.util.LinkedList();
        freenetmessageboard.core.PostMessage currentReplyMsg = this.replyToMessage;
        while(true) {
          prevMessages.add(0, currentReplyMsg);
          CoreLogger.log("adding prev msg "+currentReplyMsg.toShortString(), CoreLogger.LOG_NORMAL);
          if (currentReplyMsg.getReplyToUniqueId().length()==0) {
            break;
          }
          try {
            currentReplyMsg=freenetmessageboard.core.MessagePool.instance().getPostMessage(currentReplyMsg.getReplyToUniqueId());
          } catch (freenetmessageboard.core.MessageNotReceivedException ex) {
            break;
          }
        }
       CoreLogger.log("sending all msgs...", CoreLogger.LOG_NORMAL);
        java.util.Iterator it = prevMessages.iterator();
        while(it.hasNext()) {
          freenetmessageboard.core.PostMessage msg = (freenetmessageboard.core.PostMessage)it.next();
          CoreLogger.log("sending message "+msg.toShortString(), CoreLogger.LOG_NORMAL);
          freenetmessageboard.core.MessageGateway.instance().sendMessageOnPersonalChannel(msg);
        }

      }
      freenetmessageboard.core.MessageGateway.instance().sendMessageOnPersonalChannel(postMessage);
      Container parent = this.getParent();
      while (parent instanceof JFrame == false) {
        parent=parent.getParent();
      }
      BetaGUI.instance().defaultFrameSize=parent.getSize();
      BetaGUI.instance().defaultFrameLocation=parent.getLocation();
      parent.setVisible(false);
    } else {
      PostMessagePanel panel = new PostMessagePanel(this.myPostMessage, true);
      BetaGUI.instance().newFrame("create reply to "+this.subjectTextField.getText(), panel);
    }
  }

  void getOriginalButton_actionPerformed(ActionEvent e) {
    MessageVerificationPanel panel = new MessageVerificationPanel(this.myPostMessage);
    BetaGUI.instance().verifyMessage(this.myPostMessage);
//    BetaGUI.instance().newFrame("message verification window for \""+this.myPostMessage.getSubject()+"\"", panel);
  }
}