package freenetmessageboard.gui;

import java.awt.*;
import javax.swing.*;
import javax.swing.border.Border;
import java.awt.event.*;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class PersonalInfoDialog extends JDialog {
  BorderLayout personalInfoPanelBorderLayout = new BorderLayout();
  JPanel buttonPanel = new JPanel();
  JPanel mainPanel = new JPanel();
  BorderLayout buttonPanelBorderLayout = new BorderLayout();
  BorderLayout mainPanelBorderLayout = new BorderLayout();
  JPanel shortInfosPanel = new JPanel();
  BorderLayout shortInfosPanelBorderLayout = new BorderLayout();
  JPanel shortInfosCaptionPanel = new JPanel();
  GridLayout shortInfosCaptionPanelGridLayout = new GridLayout();
  JPanel shortInfosValuePanel = new JPanel();
  GridLayout shortInfosValuePanelGridLayout = new GridLayout();
  JLabel publicKeyCaptionLabel = new JLabel();
  JLabel privateKeyCaptionLabel = new JLabel();
  JLabel nickCaptionLabel = new JLabel();
  JLabel nameCaptionLabel = new JLabel();
  JLabel freesiteUriCaptionLabel = new JLabel();
  JLabel interestsCaptionLabel = new JLabel();
  public JTextField publicKeyTextField = new JTextField();
  public JTextField privateKeyTextField = new JTextField();
  public JTextField nickTextField = new JTextField();
  public JTextField nameTextField = new JTextField();
  public JTextField freesiteUriTextField = new JTextField();
  public JTextField interestsTextField = new JTextField();
  JPanel longInfosPanel = new JPanel();
  BorderLayout longInfosPanelBorderLayout = new BorderLayout();
  JPanel longInfosCaptionPanel = new JPanel();
  JPanel longInfosValuePanel = new JPanel();
  GridLayout longInfosValuePanelGridLayout = new GridLayout();
  GridLayout longInfosCaptionPanelGridLayout = new GridLayout();
  public JTextPane descriptionTextArea = new JTextPane();
  public JTextPane messageTextArea = new JTextPane();
  JLabel descriptionCaptionLabel = new JLabel();
  JLabel messageCaptionLabel = new JLabel();
  JButton cancelButton = new JButton();
  JButton sendButton = new JButton();

  private boolean appliyChanges=false;

  public PersonalInfoDialog(Frame owner) {
    super(owner, "enter your personal information", true);
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }
  private void jbInit() throws Exception {
    this.getContentPane().setLayout(personalInfoPanelBorderLayout);
    buttonPanel.setLayout(buttonPanelBorderLayout);
    mainPanel.setLayout(mainPanelBorderLayout);
    shortInfosPanel.setLayout(shortInfosPanelBorderLayout);
    shortInfosCaptionPanel.setLayout(shortInfosCaptionPanelGridLayout);
    shortInfosValuePanel.setLayout(shortInfosValuePanelGridLayout);
    publicKeyCaptionLabel.setHorizontalAlignment(SwingConstants.CENTER);
    publicKeyCaptionLabel.setText("public key:");
    privateKeyCaptionLabel.setHorizontalAlignment(SwingConstants.CENTER);
    privateKeyCaptionLabel.setText("private key:");
    shortInfosCaptionPanelGridLayout.setRows(6);
    shortInfosCaptionPanelGridLayout.setColumns(1);
    nickCaptionLabel.setHorizontalAlignment(SwingConstants.CENTER);
    nickCaptionLabel.setText("nick:");
    nameCaptionLabel.setToolTipText("");
    nameCaptionLabel.setHorizontalAlignment(SwingConstants.CENTER);
    nameCaptionLabel.setText("name:");
    freesiteUriCaptionLabel.setHorizontalAlignment(SwingConstants.CENTER);
    freesiteUriCaptionLabel.setText("freesite uri:");
    interestsCaptionLabel.setHorizontalAlignment(SwingConstants.CENTER);
    interestsCaptionLabel.setText("interests:");
    shortInfosValuePanelGridLayout.setRows(6);
    shortInfosValuePanelGridLayout.setColumns(1);
    longInfosPanel.setLayout(longInfosPanelBorderLayout);
    longInfosValuePanel.setLayout(longInfosValuePanelGridLayout);
    longInfosCaptionPanel.setLayout(longInfosCaptionPanelGridLayout);
    longInfosCaptionPanelGridLayout.setRows(2);
    longInfosCaptionPanelGridLayout.setColumns(1);
    longInfosValuePanelGridLayout.setRows(2);
    longInfosValuePanelGridLayout.setColumns(1);
    descriptionTextArea.setBorder(BorderFactory.createLineBorder(Color.black));
    messageTextArea.setBorder(BorderFactory.createLineBorder(Color.black));
    descriptionCaptionLabel.setHorizontalAlignment(SwingConstants.CENTER);
    descriptionCaptionLabel.setText("description:");
    messageCaptionLabel.setHorizontalAlignment(SwingConstants.CENTER);
    messageCaptionLabel.setText("message:");
    shortInfosCaptionPanel.setMinimumSize(new Dimension(80, 120));
    shortInfosCaptionPanel.setPreferredSize(new Dimension(80, 120));
    longInfosCaptionPanel.setMinimumSize(new Dimension(80, 120));
    longInfosCaptionPanel.setPreferredSize(new Dimension(80, 120));
    cancelButton.setPreferredSize(new Dimension(80, 27));
    cancelButton.setText("cancel");
    cancelButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        cancelButton_actionPerformed(e);
      }
    });
    sendButton.setText("announce with this information");
    sendButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        sendButton_actionPerformed(e);
      }
    });
    this.getContentPane().add(buttonPanel, BorderLayout.SOUTH);
    this.getContentPane().add(mainPanel, BorderLayout.CENTER);
    mainPanel.add(shortInfosPanel,  BorderLayout.NORTH);
    shortInfosPanel.add(shortInfosCaptionPanel, BorderLayout.WEST);
    shortInfosPanel.add(shortInfosValuePanel, BorderLayout.CENTER);
    shortInfosCaptionPanel.add(publicKeyCaptionLabel, null);
    shortInfosCaptionPanel.add(privateKeyCaptionLabel, null);
    shortInfosCaptionPanel.add(nickCaptionLabel, null);
    shortInfosCaptionPanel.add(nameCaptionLabel, null);
    shortInfosCaptionPanel.add(freesiteUriCaptionLabel, null);
    shortInfosCaptionPanel.add(interestsCaptionLabel, null);
    shortInfosValuePanel.add(publicKeyTextField, null);
    shortInfosValuePanel.add(privateKeyTextField, null);
    shortInfosValuePanel.add(nickTextField, null);
    shortInfosValuePanel.add(nameTextField, null);
    shortInfosValuePanel.add(freesiteUriTextField, null);
    shortInfosValuePanel.add(interestsTextField, null);
    mainPanel.add(longInfosPanel, BorderLayout.CENTER);
    longInfosPanel.add(longInfosCaptionPanel,  BorderLayout.WEST);
    longInfosPanel.add(longInfosValuePanel, BorderLayout.CENTER);
    longInfosValuePanel.add(descriptionTextArea, null);
    longInfosValuePanel.add(messageTextArea, null);
    longInfosCaptionPanel.add(descriptionCaptionLabel, null);
    longInfosCaptionPanel.add(messageCaptionLabel, null);
    buttonPanel.add(cancelButton, BorderLayout.WEST);
    buttonPanel.add(sendButton, BorderLayout.CENTER);
    this.setSize(400,450);
 //   this.setLocation(BetaGUI.instance().getMainFrame().getX()+100, BetaGUI.instance().getMainFrame().getY()+75 );
  }

  public boolean wasCancelled() {
    return (this.appliyChanges==false);
  }

  void sendButton_actionPerformed(ActionEvent e) {
    this.appliyChanges=true;
    this.dispose();
  }

  void cancelButton_actionPerformed(ActionEvent e) {
    this.appliyChanges=false;
    this.dispose();
  }
}