package freenetmessageboard.gui;

import javax.swing.*;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class NewsgroupPostTreeCellRenderer implements javax.swing.tree.TreeCellRenderer {


  private static java.awt.Font plainFont = new java.awt.Font("SansSerif", java.awt.Font.PLAIN, 12);
  private static java.awt.Font unreadFont = new java.awt.Font("SansSerif", java.awt.Font.BOLD, 12);

  private static java.awt.Color bgColor = new java.awt.Color(200,200,255);
  private static java.awt.Color unreadRepliesColor = new java.awt.Color(100,100,100);

  public NewsgroupPostTreeCellRenderer() {
  }

  public java.awt.Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf,  int row, boolean hasFocus) {
    freenetmessageboard.core.NewsgroupPost post = (freenetmessageboard.core.NewsgroupPost)value;
    Icon icon = post.getIcon();
    JLabel label = new JLabel(value.toString(), icon, JLabel.LEADING);
    label.setForeground(java.awt.Color.black);
    if (selected) {
      label.setBackground(this.bgColor);
      label.setOpaque(true);
    }
    if (post.isUnread() || post.getUnreadChildCount()>0) {
      label.setFont(this.unreadFont);
      if (post.isUnread()==false) {
        label.setForeground(unreadRepliesColor);
      }
    } else {
      label.setFont(this.plainFont);
    }
    return label;
  }
}