package freenetmessageboard.gui;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

import freenetmessageboard.core.CoreLogger;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

class MessageVerificationPanel extends JPanel implements freenetmessageboard.fcpinterface.FCPRequestCallback {
  BorderLayout mainBorderLayout = new BorderLayout();
  JPanel topPanel = new JPanel();
  JLabel jLabel1 = new JLabel();
  JTabbedPane jTabbedPane1 = new JTabbedPane();
  JButton requestOriginalButton = new JButton();
  private freenetmessageboard.core.Message existingMsg;
  private java.util.Map newCopiesMap = new java.util.HashMap();
  private java.util.Map allPanels = new java.util.HashMap();
 // private freenetmessageboard.core.Message newMsg;
  private freenetmessageboard.core.Message originalMsg;

  public MessageVerificationPanel() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  public MessageVerificationPanel(freenetmessageboard.core.Message existingMsg, freenetmessageboard.core.Message newMsg) {
    this();
    this.addExistingMessage(existingMsg);
    this.addNewMessage(newMsg);
    Thread thread = new Thread() {
      public void run() {
        try {
          Thread.sleep(1000);
        }
        catch (InterruptedException ex) {
        }
        MessageVerificationPanel.this.requestOriginalVersion();
      }
    };
    thread.setName("MsgVerification");
    thread.start();
    this.validate();
    this.repaint();
  }

  public MessageVerificationPanel(freenetmessageboard.core.Message existingMsg) {
    this();
    this.jLabel1.setText("trying to request the original version...");
    this.addExistingMessage(existingMsg);
    this.requestOriginalVersion();
    this.validate();
    this.repaint();
  }

  private void addNewMessage(freenetmessageboard.core.Message newMsg) {
 //   this.newMsg=newMsg;
    if (this.newCopiesMap.containsKey(newMsg.getSourceUri())) {
      return;
    }
    this.newCopiesMap.put(newMsg.getSourceUri(), newMsg);
    MessagePanel msgPanel1 = new MessagePanel(newMsg);
    String nick1 = freenetmessageboard.core.ContactList.instance().getNicknameOfPublicKey(newMsg.getSourceKey());
    String source1;
    String source2;
    if (newMsg.getOriginalUri().equals(newMsg.getSourceUri())) {
      source1 = "new original from "+nick1;
    } else {
      if (newMsg.getSourceKey().equals(newMsg.getOriginalPublicKey())) {
        source1 = "new signed copy from "+nick1;
      } else {
        source1 = "new copy from "+nick1;
      }
    }
    this.jTabbedPane1.add(source1, msgPanel1);
    this.allPanels.put(newMsg.getSourceUri(), msgPanel1);
    this.compareToOriginalMessage();
  }

  private void addExistingMessage(freenetmessageboard.core.Message existingMsg) {
    this.existingMsg=existingMsg;
    MessagePanel msgPanel1 = new MessagePanel(existingMsg);
    String nick1 = freenetmessageboard.core.ContactList.instance().getNicknameOfPublicKey(existingMsg.getSourceKey());
    String source1;
    String source2;
    if (existingMsg.getOriginalUri().equals(existingMsg.getSourceUri())) {
      source1 = "existing original from "+nick1;
    } else {
      if (existingMsg.getSourceKey().equals(existingMsg.getOriginalPublicKey())) {
        source1 = "existing signed copy from "+nick1;
      } else {
        source1 = "existing copy from "+nick1;
      }
    }
    this.jTabbedPane1.add(source1, msgPanel1);
    this.allPanels.put(existingMsg.getSourceUri(), msgPanel1);
  }

  private void compareToOriginalMessage() {
    if (this.originalMsg==null) return;

    MessagePanel existingPanel = (MessagePanel)this.jTabbedPane1.getComponent(0);
    MessagePanel originalPanel = (MessagePanel)this.allPanels.get(this.originalMsg.getSourceUri());
    this.jTabbedPane1.setIconAt(this.jTabbedPane1.indexOfComponent(originalPanel), ColorsAndIcons.getIconForRating("GOOD"));
    if (this.newCopiesMap.size()==0) {
      if (this.existingMsg.equals(this.originalMsg)) {
        this.jLabel1.setText("the copy of the message equals the original message!");
        this.jLabel1.setForeground(Color.green);
        this.jTabbedPane1.setIconAt(this.jTabbedPane1.indexOfComponent(existingPanel), ColorsAndIcons.getIconForRating("GOOD"));
        BetaGUI.instance().setVerifyingRating(this.originalMsg, "GOOD");
      } else {
        this.jLabel1.setText("the copy of the message is different from the original one!");
        this.jLabel1.setForeground(Color.red);
        this.jTabbedPane1.setIconAt(this.jTabbedPane1.indexOfComponent(existingPanel), ColorsAndIcons.getIconForRating("EVIL"));
        BetaGUI.instance().setVerifyingRating(this.originalMsg, "EVIL");
      }
    } else {
      java.util.List fakedSources = new java.util.LinkedList();
      java.util.Iterator it = this.newCopiesMap.keySet().iterator();
      while(it.hasNext()) {
        String copySourceUri = (String)it.next();
        freenetmessageboard.core.Message msgCopy = (freenetmessageboard.core.Message)this.newCopiesMap.get(copySourceUri);
        MessagePanel msgPanel = (MessagePanel)this.allPanels.get(msgCopy.getSourceUri());
        if (msgCopy.equals(this.originalMsg)==false) {
          fakedSources.add(copySourceUri);
          this.jTabbedPane1.setIconAt(this.jTabbedPane1.indexOfComponent(msgPanel), ColorsAndIcons.getIconForRating("EVIL"));
        }
      }
      if (this.existingMsg.equals(this.originalMsg)) {
        this.jTabbedPane1.setIconAt(this.jTabbedPane1.indexOfComponent(existingPanel), ColorsAndIcons.getIconForRating("GOOD"));
        if (fakedSources.size()==0) {
          this.jLabel1.setText("all copies seem to be correct");
          this.jLabel1.setForeground(Color.green);
          BetaGUI.instance().setVerifyingRating(this.originalMsg, "GOOD");
        } else {
          this.jLabel1.setText("you're existing copy is correct, some of the new copies aren't!");
          this.jLabel1.setForeground(Color.red);
          BetaGUI.instance().setVerifyingRating(this.originalMsg, "EVIL");
        }
      } else {
         this.jTabbedPane1.setIconAt(this.jTabbedPane1.indexOfComponent(existingPanel), ColorsAndIcons.getIconForRating("EVIL"));
         if (fakedSources.size()==0) {
           this.jLabel1.setText("you're existing copy is incorrect, the new ones are");
           this.jLabel1.setForeground(Color.red);
           BetaGUI.instance().setVerifyingRating(this.originalMsg, "EVIL");
         } else {
           this.jLabel1.setText("neither your existing copy nor the new ones are correct");
           this.jLabel1.setForeground(Color.red);
           BetaGUI.instance().setVerifyingRating(this.originalMsg, "EVIL");
         }
      }
    }
 //   freenetmessageboard.core.MessagePool.instance().replaceMessage(this.originalMsg, this.originalMsg.getSourceUri());
  }

  public void requestSuccesfull(String uri, freenetmessageboard.fcpinterface.RequestedData data) {
    freenetmessageboard.core.Message[] msgs = freenetmessageboard.core.Message.parseMultipleMessageString(freenetmessageboard.core.Message.getStringFromBytes(data.getDataBytes()));
    if (msgs.length==0) {
      this.requestOriginalButton.setText("there were invalid messages found at "+uri+"!");
      return;
    }
    this.requestOriginalButton.setText("requesting of"+this.existingMsg.getOriginalUri()+" was succesful.");
    boolean msgFound=false;
    for (int i=0; i<msgs.length; i++) {
      msgs[i].setSource(uri);
      if (msgs[i].getUniqueId().equals(this.existingMsg.getUniqueId())) {
        this.requestOriginalButton.setText("the original version was found and added to your message box! click here to remove this tab");
        this.requestOriginalButton.setEnabled(true);
        String nickOrig = freenetmessageboard.core.ContactList.instance().getNicknameOfPublicKey(msgs[i].getOriginalPublicKey());
        MessagePanel origPanel = new MessagePanel(msgs[i]);
        this.jTabbedPane1.add("original version from "+nickOrig, origPanel);
        this.allPanels.put(msgs[i].getSourceUri(), origPanel);
        msgFound=true;
        this.originalMsg=msgs[i];
        this.compareToOriginalMessage();
      }
      freenetmessageboard.core.MessagePool.instance().addMessage(uri, msgs[i]);
    }
    if (msgFound==false) {
      this.jLabel1.setText("there is no such message at "+uri+"! the copy is faked!");
      this.jLabel1.setForeground(Color.red);
      BetaGUI.instance().setVerifyingRating(this.existingMsg, "EVIL");
    }
  }

  public void requestFailedWithRouteNotFound(String uri) {
    this.requestOriginalButton.setText("request failed with route not found, retrying...");
    this.requestOriginalVersion();

  }
  public void requestFailedWithDataNotFound(String uri) {
    this.requestOriginalButton.setText("request failed with data not found, click here to retry again");
    this.jLabel1.setText("the original message wasn't found! be careful, perhaps there is no such message!");
    this.jLabel1.setForeground(Color.yellow);
    BetaGUI.instance().setVerifyingRating(this.existingMsg, "YELLOW");
    this.requestOriginalButton.setEnabled(true);
  }
  public void requestFailedBadly(String uri, String info) {
    if (info.length()>30) { info=info.substring(0,30)+"..."; }
    this.requestOriginalButton.setText("request failed: "+info+", click to try again");
    this.requestOriginalButton.setEnabled(true);
    BetaGUI.instance().setVerifyingRating(this.existingMsg, "YELLOW");
  }
  public void requestStarted(String uri) {
    this.requestOriginalButton.setText("requesting "+this.existingMsg.getOriginalUri()+"...");
  }

  private void jbInit() throws Exception {
    this.setLayout(mainBorderLayout);
    jLabel1.setForeground(Color.red);
    jLabel1.setText("these two messages are not equal. please check if one of them is " +
    "faked:");
    requestOriginalButton.setFont(new java.awt.Font("Dialog", 0, 10));
    requestOriginalButton.setForeground(Color.red);
    requestOriginalButton.setText("request original version");
    requestOriginalButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        requestOriginalButton_actionPerformed(e);
      }
    });
    this.add(topPanel, BorderLayout.NORTH);
    topPanel.add(jLabel1, null);
    this.add(jTabbedPane1,  BorderLayout.CENTER);
    this.add(requestOriginalButton,  BorderLayout.SOUTH);
  }

  private void requestOriginalVersion() {
    freenetmessageboard.fcpinterface.FCPFacade.instance().startFreenetRequest(this, this.existingMsg.getOriginalUri(), 50, false);
    this.requestOriginalButton.setText("request of "+this.existingMsg.getOriginalUri()+" is queued...");
    this.requestOriginalButton.setEnabled(false);
  }

  void requestOriginalButton_actionPerformed(ActionEvent e) {
    if (this.originalMsg!=null) {
      BetaGUI.instance().removeVerification(this.originalMsg);
      return;
    }
    if (this.newCopiesMap.size()==0) {
      this.jLabel1.setText("requesting the original version to verify the copy...");
    } else {
      this.jLabel1.setText("requesting the original version to decide which copy is correct...");
    }
    BetaGUI.instance().setVerifyingRating(this.existingMsg, "WHITE");
    this.requestOriginalVersion();
  }
}